/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.exception;

import java.util.Objects;
import kd.bos.bundle.Resources;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;

public interface Exceptions {
    public static final String projectName = "bos-flydb-core";
    public static final Optimize optimize = new Optimize();
    public static final UnParse unParse = new UnParse();

    public static String loadLanguageReason(ErrorCode error, Object ... arg) {
        return Resources.get((String)projectName, (String)("C" + error.vendorCode), (String)error.reason, (Object[])arg);
    }

    public static String end(String ... statement) {
        return String.join((CharSequence)"", statement) + '.';
    }

    public static CoreException of(ErrorCode error, Object ... arg) {
        return new CoreException(error.vendorCode, Exceptions.end(Exceptions.loadLanguageReason(error, arg)));
    }

    public static CoreException of(ErrorCode error, SqlParserPosition position, Object ... arg) {
        String reason = Exceptions.loadLanguageReason(error, arg);
        String posDesc = Exceptions.loadLanguageReason(ErrorCode.BASIC_POSITION, position.getLine(), position.getColumn());
        return new CoreException(error.vendorCode, Exceptions.end(reason, posDesc));
    }

    public static class UnParse {
        public <E extends Enum<E>> Error unexpected(E value) {
            return new AssertionError((Object)("Was not expecting value '" + value + "' for enumeration '" + value.getDeclaringClass().getName() + "' in this context."));
        }

        public RuntimeException throwAsRuntime(Throwable throwable) {
            Throwable cause = throwable.getCause();
            throwable = cause != null ? cause : throwable;
            Objects.requireNonNull(throwable, "throwable is null");
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static class Optimize {
        public RuntimeException unexpected(String message) {
            return new RuntimeException(message);
        }
    }
}

