/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.util;

import kd.bos.flydb.common.util.JedisClientResource;
import kd.bos.flydb.common.util.RedisKeyFormat;

public class RedisCounter {
    private final String key;

    public RedisCounter(String className, String id) {
        this.key = RedisKeyFormat.getStringKey(className, id);
    }

    public long incrementAndGet() {
        try (JedisClientResource resource = JedisClientResource.create();){
            long l = resource.getClient().incr(this.key);
            return l;
        }
    }

    public long decrementAndGet() {
        try (JedisClientResource resource = JedisClientResource.create();){
            long l = resource.getClient().decr(this.key);
            return l;
        }
    }

    public long get() {
        try (JedisClientResource resource = JedisClientResource.create();){
            if (!resource.getClient().exists(this.key).booleanValue()) {
                this.set(0L);
                long l = 0L;
                return l;
            }
            long l = Long.parseLong(resource.getClient().get(this.key));
            return l;
        }
    }

    public void set(long value) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().set(this.key, String.valueOf(value));
        }
    }

    public void release() {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().del(this.key);
        }
    }

    public void expire(long seconds) {
        try (JedisClientResource resource = JedisClientResource.create();){
            if (resource.getClient().exists(this.key).booleanValue()) {
                resource.getClient().expire(this.key, seconds);
            }
        }
    }
}

