/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.util;

import java.util.Set;
import kd.bos.flydb.common.util.JedisClientResource;
import kd.bos.flydb.common.util.RedisKeyFormat;

public class RedisMap {
    private final String mapKey;
    private final String allKey;

    public RedisMap(String className, String id) {
        String baseKey = RedisKeyFormat.getStringKey(className, id);
        this.mapKey = baseKey + ":map";
        this.allKey = baseKey + ":keys";
    }

    public RedisMap(String className, String fieldName, String id) {
        String baseKey = RedisKeyFormat.getStringKey(className, fieldName, id);
        this.mapKey = baseKey + ":map";
        this.allKey = baseKey + ":keys";
    }

    public void put(String key, String value) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().sadd(this.allKey, new String[]{key});
            resource.getClient().set(this.mapKey + ':' + key, value);
        }
    }

    public String get(String key) {
        try (JedisClientResource resource = JedisClientResource.create();){
            String string = resource.getClient().get(this.mapKey + ':' + key);
            return string;
        }
    }

    public void remove(String key) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().del(this.mapKey + ':' + key);
            resource.getClient().srem(this.allKey, new String[]{key});
        }
    }

    public Set<String> keys() {
        try (JedisClientResource resource = JedisClientResource.create();){
            Set set = resource.getClient().smembers(this.allKey);
            return set;
        }
    }

    public void release() {
        Set<String> keys = this.keys();
        try (JedisClientResource resource = JedisClientResource.create();){
            for (String key : keys) {
                resource.getClient().del(this.mapKey + ':' + key);
            }
            resource.getClient().del(this.allKey);
        }
    }

    public void expire(long seconds) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().expire(this.allKey, seconds);
            Set<String> keys = this.keys();
            for (String key : keys) {
                resource.getClient().expire(this.mapKey + ':' + key, seconds);
            }
        }
    }
}

