/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.common.util;

import java.util.Set;
import kd.bos.flydb.common.util.JedisClientResource;
import kd.bos.flydb.common.util.RedisKeyFormat;

public class RedisSet {
    private final String key;

    public RedisSet(String className, String id) {
        this.key = RedisKeyFormat.getStringKey(className, id);
    }

    public RedisSet(String className, String fieldName, String id) {
        this.key = RedisKeyFormat.getStringKey(className, fieldName, id);
    }

    public void add(String value) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().sadd(this.key, new String[]{value});
        }
    }

    public void remove(String value) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().srem(this.key, new String[]{value});
        }
    }

    public Set<String> list() {
        try (JedisClientResource resource = JedisClientResource.create();){
            Set set = resource.getClient().smembers(this.key);
            return set;
        }
    }

    public boolean exist(String value) {
        try (JedisClientResource resource = JedisClientResource.create();){
            boolean bl = resource.getClient().sismember(this.key, value);
            return bl;
        }
    }

    public void release() {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().del(this.key);
        }
    }

    public void expire(long seconds) {
        try (JedisClientResource resource = JedisClientResource.create();){
            resource.getClient().expire(this.key, seconds);
        }
    }
}

