/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;

public class SqlParserPosition
implements Serializable {
    public static final SqlParserPosition ZERO = new SqlParserPosition(0, 0, 0, 0);
    private final int line;
    private final int column;
    private final int endLine;
    private final int endColumn;

    public SqlParserPosition(int line, int column, int endLine, int endColumn) {
        this.line = line;
        this.column = column;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public SqlParserPosition(int line, int column) {
        this(line, column, line, column);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlParserPosition that = (SqlParserPosition)o;
        if (this.line != that.line) {
            return false;
        }
        if (this.column != that.column) {
            return false;
        }
        if (this.endLine != that.endLine) {
            return false;
        }
        return this.endColumn == that.endColumn;
    }

    public String toString() {
        String template = "line {0,number,#}, column {1,number,#}";
        return MessageFormat.format(template, this.line, this.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column, this.endLine, this.endColumn);
    }
}

