/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class AddrPreConfigImportPlugin
extends BatchImportPlugin {
    private static final String ADDRESS_CONFIG_META = "cts_addressconfig";
    private static final String IMPORT_TYPE = "importtype";
    private static final String ADMIN_LEVEL = "adminlevel";
    private static final String IS_CONTAIN_ADMIN = "iscontainadmin";
    private static final String ADMIN_DIVISION_ID = "admindivisionid";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String STRUCT_PRE_CONFIG_ID = "structpreconfigid";
    private static final String STRUCT_USER_DEFINE_TAG = "structuserdefinetag";
    private static final String FORMAT_ENTRY_ENTITY = "formatentryentity";
    private static final String FORMAT_PRE_CONFIG_ID = "formatpreconfigid";
    private static final String FORMAT_REPLACE_ATTR = "formatreplaceattr";
    private static final String IS_DEFAULT = "isdefault";
    private static final String COUNTRY = "country";
    private static final String NUMBER = "number";
    private static final String ROW_NUM = "rowNum";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            int index = billData.getStartIndex();
            JSONObject jsonObject = billData.getData();
            String number = jsonObject.getString(NUMBER);
            Map option = this.ctx.getOption();
            Object importType = option.get(IMPORT_TYPE);
            if ("new".equals(importType)) {
                if (this.validateNumber(number)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u3010\u7f16\u7801\u3011\u4e0d\u5141\u8bb8\u91cd\u590d\uff01", (String)"AddrPreConfigImportPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
                    iterator.remove();
                    return super.save(rowdatas, logger);
                }
            } else if (this.validateAddressByNumber(number)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u7684\u5730\u5740\u683c\u5f0f\u5df2\u5b58\u5728\u5730\u5740\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\uff01", (String)"AddrPreConfigImportPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return super.save(rowdatas, logger);
            }
            if (jsonObject.getInteger(ADMIN_LEVEL) > 0 && !jsonObject.getBoolean(IS_CONTAIN_ADMIN).booleanValue()) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u3010\u5305\u542b\u884c\u653f\u533a\u5212\u3011\u5b58\u5728\u5305\u542b\u7ea7\u6b21, \u8bf7\u9009\u62e9\u5305\u542b\u884c\u653f\u533a\u5212\uff01", (String)"AddrPreConfigImportPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
                iterator.remove();
                return super.save(rowdatas, logger);
            }
            if (this.validateDefaultFormat(jsonObject, index, logger).booleanValue()) {
                iterator.remove();
                return super.save(rowdatas, logger);
            }
            boolean structEntry = this.validateStructEntry(jsonObject, logger, index);
            boolean formatEntry = this.validateFormatEntry(jsonObject, logger);
            if (!structEntry && !formatEntry) continue;
            iterator.remove();
            return super.save(rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    private Boolean validateDefaultFormat(JSONObject jsonObject, final int index, final ImportLogger logger) {
        if (!jsonObject.getBoolean(IS_DEFAULT).booleanValue()) {
            return Boolean.FALSE;
        }
        JSONObject country = (JSONObject)jsonObject.get((Object)COUNTRY);
        String[] numbers = country.getString(NUMBER).split(",");
        int length = numbers.length;
        Object[] objects = new Object[1 + length];
        objects[0] = Lang.get().getLocale().toString();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT c.fid, COUNTRY.fnumber, cl.fname FROM t_cts_addressconfig c ");
        builder.append("LEFT JOIN t_cts_addressconfig_l cl ON c.fid = cl.fid ");
        builder.append("LEFT JOIN t_cts_addrconfigcountry cn ON c.fid = cn.fid ");
        builder.append("LEFT JOIN t_bd_country country ON cn.fbasedataid = country.fid ");
        builder.append("WHERE cl.flocaleid = ? AND c.fisdefault = '1' AND country.fnumber IN ( ");
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                builder.append("? )");
            } else {
                builder.append("?, ");
            }
            objects[i + 1] = numbers[i];
        }
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)builder.toString(), (Object[])objects, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet resultSet) throws Exception {
                ArrayList<String> list = new ArrayList<String>();
                while (resultSet.next()) {
                    list.add(resultSet.getString(2));
                }
                if (list.size() > 0) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5df2\u5b58\u5728\u9ed8\u8ba4\u683c\u5f0f\u3002", (String)"AddrPreConfigImportPlugin_3", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private boolean validateNumber(String number) {
        if (StringUtils.isBlank((String)number)) {
            return false;
        }
        ORM orm = ORM.create();
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        return orm.exists(ADDRESS_CONFIG_META, new QFilter[]{numberFilter});
    }

    private boolean validateAddressByNumber(String number) {
        String sql = "SELECT m.fid FROM t_cts_address m LEFT JOIN t_cts_addressconfig n ON m.fconfigid = n.fid WHERE n.fnumber = ?";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{number}, ResultSet::next);
    }

    private boolean validateStructEntry(JSONObject jsonObject, ImportLogger logger, int index) {
        boolean flag = false;
        int adminLevel = jsonObject.getIntValue(ADMIN_LEVEL);
        int actualLevel = 0;
        JSONArray structEntry = (JSONArray)jsonObject.get((Object)STRUCT_ENTRY_ENTITY);
        for (Object json : structEntry) {
            JSONObject struct = (JSONObject)json;
            JSONObject structPreConfigId = (JSONObject)struct.getObject(STRUCT_PRE_CONFIG_ID, JSONObject.class);
            String number = structPreConfigId.getString(NUMBER);
            actualLevel += number.startsWith(ADMIN_DIVISION_ID) ? 1 : 0;
            if (!number.startsWith(ADMIN_DIVISION_ID) || !StringUtil.isNotEmpty((CharSequence)struct.getString(STRUCT_USER_DEFINE_TAG))) continue;
            logger.log(struct.getInteger(ROW_NUM), ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u5b57\u6bb5\u4e0d\u80fd\u6dfb\u52a0\u201c\u81ea\u5b9a\u4e49\u6807\u7b7e\u201d", (String)"AddrPreConfigImportPlugin_4", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
            flag = true;
        }
        if (adminLevel < actualLevel) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u5305\u542b\u7ea7\u6b21\u201d\u5b57\u6bb5\u4e0e\u5b9e\u9645\u884c\u653f\u533a\u5212\u5b57\u6bb5\u6570\u76ee\u4e0d\u4e00\u81f4\u3002", (String)"AddrPreConfigImportPlugin_5", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
            flag = true;
        }
        return flag;
    }

    private boolean validateFormatEntry(JSONObject jsonObject, ImportLogger logger) {
        boolean flag = false;
        JSONArray formatEntry = (JSONArray)jsonObject.get((Object)FORMAT_ENTRY_ENTITY);
        for (Object json : formatEntry) {
            JSONObject format = (JSONObject)json;
            JSONObject formatPreConfigId = (JSONObject)format.getObject(FORMAT_PRE_CONFIG_ID, JSONObject.class);
            String number = formatPreConfigId.getString(NUMBER);
            boolean valid = !number.startsWith(ADMIN_DIVISION_ID) && !number.startsWith(COUNTRY) && StringUtils.isNotEmpty((String)format.getString(FORMAT_REPLACE_ATTR));
            if (!valid) continue;
            logger.log(format.getInteger(ROW_NUM), ResManager.loadKDString((String)"\u975e\u884c\u653f\u533a\u5212\u53ca\u56fd\u5bb6\u6216\u5730\u533a\u5b57\u6bb5\u4e0d\u80fd\u6dfb\u52a0\u201c\u4f7f\u7528\u5c5e\u6027\u66ff\u4ee3\u201d", (String)"AddrPreConfigImportPlugin_6", (String)"bos-address-formplugin", (Object[])new Object[0])).fail();
            flag = true;
        }
        return flag;
    }
}

