/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AddressConfigConvertPlugin
extends AbstractFormPlugin {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String SOURCE = "source";
    private static final String CONFIGID = "configid";
    private static final String COUNTRYID = "countryid";
    private static final String STRUCTISSHOW = "structisshow";
    private static final String STRUCTPRECONFIGID = "structpreconfigid";
    private static final String CREATETIME = "createtime";
    private static final String CREATORID = "creatorid";
    private static final String queryFields = "source,countryid,name,";
    private static final String OPT_SAVE = "opt_save";
    private static final String OPT_CANCLE = "opt_cancle";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String OPERATOR = "operator";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String STRUCTENTRYENTITY = "structentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OPT_SAVE, OPT_CANCLE});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if (key.equals(OPT_SAVE)) {
            this.convertFormat();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u6210\u529f", (String)"AddressConfigConvertPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            this.getView().close();
        }
    }

    private void convertFormat() {
        Object fromConfigId;
        Object toConfigId = this.getModel().getValue(TO);
        if (toConfigId.equals(fromConfigId = this.getModel().getValue(FROM))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e90\u683c\u5f0f\u548c\u76ee\u6807\u683c\u5f0f\u8bf7\u4fdd\u6301\u4e0d\u4e00\u81f4", (String)"AddressConfigConvertPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return;
        }
        Object operator = this.getModel().getValue(OPERATOR);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)toConfigId.toString(), (String)CTS_ADDRESSCONFIG);
        DynamicObjectCollection structentryentity = dynamicObject.getDynamicObjectCollection(STRUCTENTRYENTITY);
        ArrayList<String> preConfigNumbers = new ArrayList<String>(20);
        for (DynamicObject dyn : structentryentity) {
            Boolean isshow = dyn.getBoolean(STRUCTISSHOW);
            if (!isshow.booleanValue()) continue;
            String number = dyn.getDynamicObject(STRUCTPRECONFIGID).getString(NUMBER);
            preConfigNumbers.add(number);
        }
        QFilter fromConfigFilter = new QFilter(CONFIGID, "=", (Object)Long.valueOf(fromConfigId.toString()));
        DynamicObject[] cts_addresses = BusinessDataServiceHelper.load((String)CTS_ADDRESS, (String)(queryFields + String.join((CharSequence)",", preConfigNumbers)), (QFilter[])new QFilter[]{fromConfigFilter});
        DynamicObject[] newAddress = new DynamicObject[cts_addresses.length];
        ArrayList<DynamicObject> oldAddresses = new ArrayList<DynamicObject>(10);
        Object[] deleteIds = new Long[cts_addresses.length];
        for (int j = 0; j < cts_addresses.length; ++j) {
            DynamicObject addressDyn = BusinessDataServiceHelper.newDynamicObject((String)CTS_ADDRESS);
            if (operator.equals("0")) {
                addressDyn.set(ID, cts_addresses[j].getPkValue());
                oldAddresses.add(cts_addresses[j]);
            }
            if (operator.equals("1")) {
                deleteIds[j] = cts_addresses[j].getLong(ID);
            }
            for (int i = 0; i < preConfigNumbers.size(); ++i) {
                String number = (String)preConfigNumbers.get(i);
                addressDyn.set(number, cts_addresses[j].get(number));
            }
            addressDyn.set(SOURCE, cts_addresses[j].get(SOURCE));
            addressDyn.set(NAME, cts_addresses[j].get(NAME));
            addressDyn.set(CONFIGID, toConfigId);
            addressDyn.set(COUNTRYID, cts_addresses[j].get(COUNTRYID));
            addressDyn.set(CREATETIME, (Object)new Date());
            addressDyn.set(CREATORID, (Object)RequestContext.get().getUid());
            newAddress[j] = addressDyn;
        }
        String sql = "update t_cts_address set fid = ? where fid = ? ";
        for (int i = 0; i < oldAddresses.size(); ++i) {
            DynamicObject oldD = (DynamicObject)oldAddresses.get(i);
            DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{DB.genLongId((String)""), oldD.getPkValue()});
        }
        if (operator.equals("1")) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)CTS_ADDRESS), (Object[])deleteIds);
        }
        SaveServiceHelper.save((DynamicObject[])newAddress);
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit from = (ComboEdit)this.getControl(FROM);
        ComboEdit to = (ComboEdit)this.getControl(TO);
        DynamicObject[] addressConfigs = BusinessDataServiceHelper.load((String)CTS_ADDRESSCONFIG, (String)NAME, null);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(addressConfigs.length);
        for (DynamicObject dyo : addressConfigs) {
            Object pkValue = dyo.getPkValue();
            ILocaleString localeString = dyo.getLocaleString(NAME);
            LocaleString name = new LocaleString(localeString.getLocaleValue());
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(pkValue.toString());
            comboItem.setCaption(name);
            comboItemList.add(comboItem);
        }
        to.setComboItems(comboItemList);
        from.setComboItems(comboItemList);
    }
}

