/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.address.util.AddressConfigUtil;
import kd.bos.address.util.AddressUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class AddressConfigFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String ID = "id";
    private static final String SEQ = "seq";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String COUNTRY = "country";
    private static final String ADMIN_LEVEL = "adminlevel";
    private static final String FIELD_COUNTRYID = "countryid";
    private static final String BASE_DATA_ID = "fbasedataid_id";
    private static final String IS_CONTAIN_ADMIN = "iscontainadmin";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String FORMAT_ENTRY_ENTITY = "formatentryentity";
    private static final String STRUCT_PRE_CONFIG_ID = "structpreconfigid";
    private static final String FORMAT_PRE_CONFIG_ID = "formatpreconfigid";
    private static final String STRUCT_USER_DEFINE_TAG = "structuserdefinetag";
    private static final String STRUCT_IS_REQUIRED = "structisrequired";
    private static final String STRUCT_IS_NEWLINE = "structisnewline";
    private static final String STRUCT_ISSHOW = "structisshow";
    private static final String STRUCT_LENGTH_SPEC = "structlengthspec";
    private static final String FORMAT_PREFIX = "formatprefix";
    private static final String FORMAT_SUFFIX = "formatsuffix";
    private static final String CONTAIN_BLANK = "containblank";
    private static final String FORMAT_IS_INCLUDE = "formatisinclude";
    private static final String FORMAT_IS_NEWLINE = "formatisnewline";
    private static final String FORMAT_REPLACE_ATTR = "formatreplaceattr";
    private static final String CONFIG_PRE_ADMIN_LEVEL_NUMBER = "admindivisionid";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TRUE = "true";
    private static final String IS_TIPS_FORMAT_TAB = "is_tips_format_tab";
    private static final String TAB_AP = "tabap";
    private static final String SELECTED_STRUCT_LIST = "selectedStructList";
    private static final String SELECTED_FORMAT_LIST = "selectedFormatList";
    private static final String TYPE = "type";
    private static final String ADMIN_DIVISION = "admindivision";
    private static final String BD_ADMIN_DIVISION = "bd_admindivision";
    private static final String BASE_TYPE = "basetype";
    private static final String BD_COUNTRY = "bd_country";
    private static final String OPT_SAVE = "btn_save";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String CONFIG_ID = "configid";
    private static final List<String> structFields = new ArrayList<String>(10);
    private static final List<String> formatFields = new ArrayList<String>(10);
    private static final String FORMAT_PREVIEW = "formatpreview";
    private static final String STRUCT_PREVIEW = "structpreview";
    private static final String SELECT_STRUCT_COUNTRY = "select_struct_country";
    private static final String SELECT_FORMAT_COUNTRY = "select_format_country";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(FORMAT_REPLACE_ATTR);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tabEdit = (Tab)this.getControl(TAB_AP);
        tabEdit.addClickListener((ClickListener)this);
        tabEdit.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        boolean isEditStatus;
        String status;
        super.afterBindData(e);
        this.initEntryEntity();
        this.controlEntryEntity();
        boolean isReferenced = this.isConfigReferenced();
        if (isReferenced) {
            this.getPageCache().put("isReferenced", TRUE);
        }
        if (!this.getModel().getDataEntity().getBoolean(IS_CONTAIN_ADMIN)) {
            this.getView().getModel().setValue(ADMIN_LEVEL, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{ADMIN_LEVEL});
        }
        if ("ADDNEW".equals(status = this.getView().getFormShowParameter().getStatus().toString())) {
            DynamicObjectCollection formatColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(FORMAT_ENTRY_ENTITY);
            int i = 0;
            for (DynamicObject format : formatColl) {
                Long formatId = (Long)format.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue();
                if (1028973702068313088L == formatId) {
                    this.getModel().setValue(FORMAT_IS_INCLUDE, (Object)Boolean.TRUE, i);
                }
                ++i;
            }
        }
        if (isEditStatus = AddressConfigUtil.isEditStatus(this)) {
            AddressConfigUtil.controlAdminInEditStatus(this, false);
            AddressConfigUtil.controlEntryEntityInEditStatus(this);
        }
        this.getModel().setDataChanged(false);
    }

    private boolean isConfigReferenced() {
        Long addrConfigId = (Long)this.getModel().getDataEntity().getPkValue();
        if (addrConfigId != null && addrConfigId != 0L) {
            QFilter configF = new QFilter(CONFIG_ID, "=", (Object)addrConfigId);
            return QueryServiceHelper.exists((String)CTS_ADDRESS, (QFilter[])new QFilter[]{configF});
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs operationEventArgs) {
        super.beforeDoOperation(operationEventArgs);
        String operateKey = ((AbstractOperate)operationEventArgs.getSource()).getOperateKey();
        if (STRUCT_PREVIEW.equals(operateKey)) {
            operationEventArgs.setCancel(true);
            AddressConfigUtil.addressConfigPreviewSelectCountry(this.getView(), this.getModel(), (IFormPlugin)this, SELECT_STRUCT_COUNTRY);
            return;
        }
        if (FORMAT_PREVIEW.equals(operateKey)) {
            operationEventArgs.setCancel(true);
            AddressConfigUtil.addressConfigPreviewSelectCountry(this.getView(), this.getModel(), (IFormPlugin)this, SELECT_FORMAT_COUNTRY);
            return;
        }
        if (OPT_SAVE.equals(operateKey)) {
            if (!AddressConfigUtil.checkAddrConfigErrorInfo(this.getView(), this.getModel()).booleanValue()) {
                operationEventArgs.setCancel(true);
                return;
            }
            Object adminLevel = this.getModel().getValue(ADMIN_LEVEL);
            if (null == adminLevel) {
                this.getModel().setValue(ADMIN_LEVEL, (Object)0);
            }
            this.checkEntryFields();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (OPT_SAVE.equals(afterDoOperationEventArgs.getOperateKey())) {
            super.afterDoOperation(afterDoOperationEventArgs);
            if (this.getView().getParentView() instanceof ListView) {
                ((ListView)this.getView().getParentView()).refresh();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        switch (e.getActionId()) {
            case "select_struct_country": {
                if (e.getReturnData() == null) break;
                AddressConfigUtil.addressConfigStructPreview(this.getView(), this.getModel(), e.getReturnData().toString());
                break;
            }
            case "select_format_country": {
                if (e.getReturnData() == null) break;
                AddressConfigUtil.addressConfigFormatPreview(this.getView(), this.getModel(), e.getReturnData().toString());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (propName) {
            case "country": {
                DynamicObjectCollection country = (DynamicObjectCollection)newValue;
                Boolean enable = country.size() == 0 ? Boolean.FALSE : Boolean.TRUE;
                this.getView().setEnable(enable, new String[]{IS_CONTAIN_ADMIN});
                this.getModel().setValue(IS_CONTAIN_ADMIN, (Object)enable);
                this.reduceAdminLevelEntry();
                break;
            }
            case "iscontainadmin": {
                Boolean contain = (Boolean)newValue;
                this.getView().setEnable(contain, new String[]{ADMIN_LEVEL});
                FieldEdit fieldEdit = (FieldEdit)this.getControl(ADMIN_LEVEL);
                fieldEdit.setMustInput(contain.booleanValue());
                if (!contain.booleanValue()) {
                    this.getModel().setValue(ADMIN_LEVEL, null);
                }
                this.reduceAdminLevelEntry();
                break;
            }
            case "adminlevel": {
                this.reduceAdminLevelEntry();
                break;
            }
            case "structisshow": {
                this.isShowChangedEvent(e);
                break;
            }
            case "formatisinclude": {
                this.isIncludeChangedEvent(e);
                break;
            }
        }
    }

    private Set<String> getAdminLevelNumbers() {
        String admin;
        HashSet<String> adminLevelNumbers = new HashSet<String>(16);
        Object isContainAdminObj = this.getModel().getValue(IS_CONTAIN_ADMIN);
        Object adminObj = this.getModel().getValue(ADMIN_LEVEL);
        if (isContainAdminObj == null) {
            return adminLevelNumbers;
        }
        int factLevel = 0;
        int adminVal = 0;
        if (adminObj != null && StringUtils.isNotEmpty((String)(admin = adminObj.toString()))) {
            adminVal = Integer.parseInt(admin);
        }
        DynamicObjectCollection countryArr = (DynamicObjectCollection)this.getModel().getValue(COUNTRY);
        int maxCountryAdminLevel = 0;
        ArrayList countryIds = new ArrayList(10);
        if (CollectionUtils.isEmpty((Collection)countryArr)) {
            return adminLevelNumbers;
        }
        countryIds = (ArrayList)countryArr.stream().map(dynamicObject -> dynamicObject.getLong(BASE_DATA_ID)).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)countryIds)) {
            maxCountryAdminLevel = AddressUtil.getMaxAdminLevelByCountryIds(countryIds);
        }
        if ((factLevel = maxCountryAdminLevel < adminVal ? maxCountryAdminLevel : adminVal) > 6) {
            factLevel = 6;
        }
        while (factLevel > 0) {
            adminLevelNumbers.add(CONFIG_PRE_ADMIN_LEVEL_NUMBER + factLevel);
            --factLevel;
        }
        return adminLevelNumbers;
    }

    private void reduceAdminLevelEntry() {
        EntryGrid structGrid = (EntryGrid)this.getControl(STRUCT_ENTRY_ENTITY);
        EntryGrid formatGrid = (EntryGrid)this.getControl(FORMAT_ENTRY_ENTITY);
        Set<String> adminLevelNumbers = this.getAdminLevelNumbers();
        this.adminLevelConfig(STRUCT_ENTRY_ENTITY, structGrid, adminLevelNumbers);
        this.adminLevelConfig(FORMAT_ENTRY_ENTITY, formatGrid, adminLevelNumbers);
        this.controlEntryEntity();
    }

    private void adminLevelConfig(String entryEntityKey, EntryGrid grid, Set<String> adminLevelNumbers) {
        boolean isEditStatus = AddressConfigUtil.isEditStatus(this);
        BaseModel model = (BaseModel)grid.getModel();
        List<Map<String, Object>> levelMaps = AddressUtil.getAdminLevelPreConfigList();
        List<String> levelConfigIds = levelMaps.stream().map(levelMap -> levelMap.get(ID).toString()).distinct().collect(Collectors.toList());
        DynamicObject[] list = grid.getEntryData().getDataEntitys();
        ArrayList<Integer> delRows = new ArrayList<Integer>(10);
        List<Object> cannotAddNumberList = new ArrayList();
        if (!isEditStatus) {
            this.isNotEdit(list, levelConfigIds, entryEntityKey, delRows);
        } else {
            cannotAddNumberList = this.deleteRowsInEditStatus(entryEntityKey, list, delRows, levelMaps, levelConfigIds);
        }
        if (!CollectionUtils.isEmpty(delRows)) {
            model.deleteEntryRows(entryEntityKey, delRows.stream().mapToInt(Integer::valueOf).toArray());
        }
        if (CollectionUtils.isEmpty(adminLevelNumbers)) {
            return;
        }
        List<Object> filterMaps = new ArrayList();
        if (!isEditStatus) {
            filterMaps = levelMaps.stream().filter(map -> adminLevelNumbers.contains(map.get(NUMBER).toString())).collect(Collectors.toList());
        } else {
            ArrayList cannotAddNumberConstList = new ArrayList(cannotAddNumberList);
            filterMaps = levelMaps.stream().filter(map -> adminLevelNumbers.contains(map.get(NUMBER).toString()) && !cannotAddNumberConstList.contains(map.get(NUMBER).toString())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(filterMaps)) {
            this.levelInsert(filterMaps, entryEntityKey, model);
        }
    }

    private void isNotEdit(DynamicObject[] list, List<String> levelConfigIds, String entryEntityKey, List<Integer> delRows) {
        for (DynamicObject dyObj : list) {
            if (entryEntityKey.equals(STRUCT_ENTRY_ENTITY) && levelConfigIds.contains(dyObj.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue().toString())) {
                delRows.add(dyObj.getInt(SEQ) - 1);
                continue;
            }
            if (!entryEntityKey.equals(FORMAT_ENTRY_ENTITY) || !levelConfigIds.contains(dyObj.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue().toString())) continue;
            delRows.add(dyObj.getInt(SEQ) - 1);
        }
    }

    private void levelInsert(List<Map<String, Object>> filterMaps, String entryEntityKey, BaseModel model) {
        for (int i = 0; i < filterMaps.size(); ++i) {
            Map<String, Object> dy = filterMaps.get(i);
            int rowIndex = i;
            if (entryEntityKey.equals(STRUCT_ENTRY_ENTITY)) {
                model.insertEntryRow(entryEntityKey, rowIndex);
                model.setItemValueByNumber(STRUCT_PRE_CONFIG_ID, dy.get(NUMBER).toString(), rowIndex);
                continue;
            }
            if (!entryEntityKey.equals(FORMAT_ENTRY_ENTITY)) continue;
            model.insertEntryRow(entryEntityKey, ++rowIndex);
            model.setItemValueByNumber(FORMAT_PRE_CONFIG_ID, dy.get(NUMBER).toString(), rowIndex);
        }
    }

    private List<String> deleteRowsInEditStatus(String entryEntityKey, DynamicObject[] list, List<Integer> delRows, List<Map<String, Object>> levelMaps, List<String> levelConfigIds) {
        List<String> cannotAddNumberList = this.structHandle(entryEntityKey, list, levelConfigIds, delRows, levelMaps);
        if (entryEntityKey.equals(FORMAT_ENTRY_ENTITY)) {
            String selectedFormatListStr = this.getPageCache().get(SELECTED_FORMAT_LIST);
            List selectedFormatList = new ArrayList();
            if (StringUtils.isNotNull((String)selectedFormatListStr)) {
                selectedFormatList = (List)SerializationUtils.deSerializeFromBase64((String)selectedFormatListStr);
            }
            for (DynamicObject dyObj : list) {
                Long formatPreConfigId = (Long)dyObj.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue();
                if (!levelConfigIds.contains(formatPreConfigId.toString()) || selectedFormatList.contains(formatPreConfigId)) continue;
                delRows.add(dyObj.getInt(SEQ) - 1);
            }
            for (Map map : levelMaps) {
                if (!selectedFormatList.contains(map.get(ID))) continue;
                cannotAddNumberList.add(map.get(NUMBER).toString());
            }
        }
        return cannotAddNumberList;
    }

    private List<String> structHandle(String entryEntityKey, DynamicObject[] list, List<String> levelConfigIds, List<Integer> delRows, List<Map<String, Object>> levelMaps) {
        ArrayList<String> cannotAddNumberList = new ArrayList<String>();
        if (entryEntityKey.equals(STRUCT_ENTRY_ENTITY)) {
            String selectedStructListStr = this.getPageCache().get(SELECTED_STRUCT_LIST);
            List selectedStructList = new ArrayList();
            if (StringUtils.isNotNull((String)selectedStructListStr)) {
                selectedStructList = (List)SerializationUtils.deSerializeFromBase64((String)selectedStructListStr);
            }
            for (DynamicObject dyObj : list) {
                Long structPreConfigId = (Long)dyObj.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue();
                if (!levelConfigIds.contains(structPreConfigId.toString()) || selectedStructList.contains(structPreConfigId)) continue;
                delRows.add(dyObj.getInt(SEQ) - 1);
            }
            for (Map map : levelMaps) {
                if (!selectedStructList.contains(map.get(ID))) continue;
                cannotAddNumberList.add(map.get(NUMBER).toString());
            }
        }
        return cannotAddNumberList;
    }

    private void initEntryEntity() {
        EntryGrid structGrid = (EntryGrid)this.getControl(STRUCT_ENTRY_ENTITY);
        EntryGrid formatGrid = (EntryGrid)this.getControl(FORMAT_ENTRY_ENTITY);
        DynamicObject[] structList = structGrid.getEntryData().getDataEntitys();
        DynamicObject[] formatList = formatGrid.getEntryData().getDataEntitys();
        HashSet<String> structConfigIdSet = new HashSet<String>(16);
        for (DynamicObject dy : structList) {
            structConfigIdSet.add(dy.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue().toString());
        }
        HashSet<String> formatConfigIdSet = new HashSet<String>(16);
        for (DynamicObject dy : formatList) {
            formatConfigIdSet.add(dy.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue().toString());
        }
        this.perfectConfig(STRUCT_ENTRY_ENTITY, structConfigIdSet, structGrid);
        this.perfectConfig(FORMAT_ENTRY_ENTITY, formatConfigIdSet, formatGrid);
    }

    private void perfectConfig(String entryEntityKey, Set<String> configFieldIdSet, EntryGrid grid) {
        BaseModel model = (BaseModel)grid.getModel();
        List<Map<String, Object>> preConfigFieldList = AddressUtil.getPreConfigList();
        if (configFieldIdSet.size() == preConfigFieldList.size()) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List<Map<String, Object>> filteredPreConfigFieldList = preConfigFieldList.stream().filter(map -> {
            String field = (String)map.get(NUMBER);
            String number = field.substring(field.length() - 1);
            if (status == OperationStatus.ADDNEW) {
                return !field.contains(CONFIG_PRE_ADMIN_LEVEL_NUMBER) || Integer.parseInt(number) <= 3;
            }
            return !field.contains(CONFIG_PRE_ADMIN_LEVEL_NUMBER);
        }).collect(Collectors.toList());
        List<String> numberList = this.numberList(entryEntityKey, filteredPreConfigFieldList, configFieldIdSet);
        if (numberList.size() == 0) {
            return;
        }
        this.insertEntry(status, entryEntityKey, numberList, model);
    }

    private List<String> numberList(String entryEntityKey, List<Map<String, Object>> filteredPreConfigFieldList, Set<String> configFieldIdSet) {
        ArrayList<String> numberList = new ArrayList<String>(10);
        for (Map<String, Object> map : filteredPreConfigFieldList) {
            if (configFieldIdSet.contains(map.get(ID).toString()) || STRUCT_ENTRY_ENTITY.equals(entryEntityKey) && map.get(NUMBER).toString().contains(COUNTRY)) continue;
            numberList.add(map.get(NUMBER).toString());
        }
        return numberList;
    }

    private void insertEntry(OperationStatus status, String entryEntityKey, List<String> numberList, BaseModel model) {
        if (status == OperationStatus.ADDNEW) {
            int originCount = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntityKey).size();
            this.getModel().batchCreateNewEntryRow(entryEntityKey, numberList.size());
            for (int i = 0; i < numberList.size(); ++i) {
                String number = numberList.get(i);
                if (STRUCT_ENTRY_ENTITY.equals(entryEntityKey)) {
                    model.setItemValueByNumber(STRUCT_PRE_CONFIG_ID, number, i + originCount);
                    continue;
                }
                if (!FORMAT_ENTRY_ENTITY.equals(entryEntityKey)) continue;
                model.setItemValueByNumber(FORMAT_PRE_CONFIG_ID, number, i + originCount);
            }
        }
        if (status != OperationStatus.ADDNEW) {
            for (String number : numberList) {
                int rowCount = model.getEntryRowCount(entryEntityKey);
                model.insertEntryRow(entryEntityKey, rowCount);
                if (STRUCT_ENTRY_ENTITY.equals(entryEntityKey)) {
                    model.setItemValueByNumber(STRUCT_PRE_CONFIG_ID, number, rowCount);
                    continue;
                }
                if (!FORMAT_ENTRY_ENTITY.equals(entryEntityKey)) continue;
                model.setItemValueByNumber(FORMAT_PRE_CONFIG_ID, number, rowCount);
            }
        }
    }

    private void lockCell() {
        DynamicObject[] structList;
        List<String> configIds = AddressUtil.getCountryAndAdminPreConfigIds();
        EntryGrid entryGrid = (EntryGrid)this.getControl(FORMAT_ENTRY_ENTITY);
        DynamicObject[] list = entryGrid.getEntryData().getDataEntitys();
        List ids = Arrays.stream(list).map(e -> e.getDynamicObject(FORMAT_PRE_CONFIG_ID).getString(ID)).collect(Collectors.toList());
        ids.removeAll(configIds);
        for (DynamicObject dy : list) {
            this.getView().setEnable(Boolean.FALSE, dy.getInt(SEQ) - 1, new String[]{FORMAT_PRE_CONFIG_ID});
            if (!ids.contains(dy.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue().toString())) continue;
            this.getView().setEnable(Boolean.FALSE, dy.getInt(SEQ) - 1, new String[]{FORMAT_REPLACE_ATTR});
        }
        List<Map<String, Object>> levelMaps = AddressUtil.getAdminLevelPreConfigList();
        List levelConfigIds = levelMaps.stream().map(levelMap -> levelMap.get(ID).toString()).distinct().collect(Collectors.toList());
        EntryGrid structGrid = (EntryGrid)this.getControl(STRUCT_ENTRY_ENTITY);
        for (DynamicObject dy : structList = structGrid.getEntryData().getDataEntitys()) {
            this.getView().setEnable(Boolean.FALSE, dy.getInt(SEQ) - 1, new String[]{STRUCT_PRE_CONFIG_ID});
            if (!levelConfigIds.contains(dy.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue().toString())) continue;
            this.getView().setEnable(Boolean.FALSE, dy.getInt(SEQ) - 1, new String[]{STRUCT_USER_DEFINE_TAG});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter filterParameter = showParameter.getListFilterParameter();
        if (FORMAT_REPLACE_ATTR.equals(evt.getProperty().getName())) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(FORMAT_PRE_CONFIG_ID);
            Long id = (Long)dynamicObject.getPkValue();
            DynamicObject object = AddressUtil.getPreConfigById(id);
            if (object == null) {
                return;
            }
            String type = object.getString(TYPE);
            String baseType = object.getString(BASE_TYPE);
            if ("2".equals(type)) {
                if (BD_COUNTRY.equals(baseType)) {
                    filterParameter.setFilter(new QFilter(TYPE, "=", (Object)COUNTRY));
                }
                if (BD_ADMIN_DIVISION.equals(baseType)) {
                    filterParameter.setFilter(new QFilter(TYPE, "=", (Object)ADMIN_DIVISION));
                }
            }
        }
    }

    private void isShowChangedEvent(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject[] formatEntities;
        HashMap<Object, DynamicObject> formatMap = new HashMap<Object, DynamicObject>(16);
        EntryGrid formatEntryEntity = (EntryGrid)this.getControl(FORMAT_ENTRY_ENTITY);
        for (DynamicObject format : formatEntities = formatEntryEntity.getEntryData().getDataEntitys()) {
            formatMap.put(format.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue(), format);
        }
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        Boolean isShow = (Boolean)changeData.getNewValue();
        DynamicObject dataEntity = changeData.getDataEntity();
        this.controlEntryEntityRow(structFields, dataEntity.getInt(SEQ) - 1, isShow, Boolean.TRUE);
        DynamicObject formatEntry = (DynamicObject)formatMap.get(dataEntity.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue());
        this.controlEntryEntityRow(formatFields, formatEntry.getInt(SEQ) - 1, isShow, new Boolean[0]);
        this.lockCell();
    }

    private void isIncludeChangedEvent(PropertyChangedArgs propertyChangedArgs) {
        DynamicObject[] structEntities;
        HashMap<Object, DynamicObject> structMap = new HashMap<Object, DynamicObject>(16);
        EntryGrid structEntryEntity = (EntryGrid)this.getControl(STRUCT_ENTRY_ENTITY);
        for (DynamicObject struct : structEntities = structEntryEntity.getEntryData().getDataEntitys()) {
            structMap.put(struct.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue(), struct);
        }
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        Boolean isShow = (Boolean)changeData.getNewValue();
        DynamicObject dataEntity = changeData.getDataEntity();
        int index = dataEntity.getInt(SEQ) - 1;
        DynamicObject dynamicObject = (DynamicObject)structMap.get(dataEntity.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue());
        Boolean isshow = Boolean.FALSE;
        if (dynamicObject != null) {
            isshow = dynamicObject.getBoolean(STRUCT_ISSHOW);
        }
        if (isshow.booleanValue() || index == 0) {
            ArrayList<String> newFormatFields = new ArrayList<String>(10);
            for (int i = 0; i < formatFields.size(); ++i) {
                if (i == 1) continue;
                newFormatFields.add(formatFields.get(i));
            }
            this.controlEntryEntityRow(newFormatFields, dataEntity.getInt(SEQ) - 1, isShow, new Boolean[0]);
        }
        this.lockCell();
    }

    private void controlEntryEntity() {
        DynamicObject[] formatEntities;
        EntryGrid structEntryEntity = (EntryGrid)this.getControl(STRUCT_ENTRY_ENTITY);
        EntryGrid formatEntryEntity = (EntryGrid)this.getControl(FORMAT_ENTRY_ENTITY);
        DynamicObject[] structEntities = structEntryEntity.getEntryData().getDataEntitys();
        ArrayList<Object> disabledStructIds = new ArrayList<Object>(15);
        for (DynamicObject struct : structEntities) {
            Boolean structisshow = struct.getBoolean(STRUCT_ISSHOW);
            if (structisshow.booleanValue()) continue;
            disabledStructIds.add(struct.getDynamicObject(STRUCT_PRE_CONFIG_ID).getPkValue());
            this.controlEntryEntityRow(structFields, struct.getInt(SEQ) - 1, Boolean.FALSE, new Boolean[0]);
        }
        for (DynamicObject format : formatEntities = formatEntryEntity.getEntryData().getDataEntitys()) {
            Object formatpreconfigid = format.getDynamicObject(FORMAT_PRE_CONFIG_ID).getPkValue();
            if (!disabledStructIds.contains(formatpreconfigid)) continue;
            this.controlEntryEntityRow(formatFields, format.getInt(SEQ) - 1, Boolean.FALSE, new Boolean[0]);
        }
        this.lockCell();
        boolean isEditStatus = AddressConfigUtil.isEditStatus(this);
        if (isEditStatus) {
            AddressConfigUtil.controlEntryEntityInEditStatus(this);
        }
    }

    private void controlEntryEntityRow(List<String> fields, int index, Boolean enable, Boolean ... struct) {
        if (enable.booleanValue() && struct != null && struct.length > 0) {
            this.getModel().setValue(STRUCT_LENGTH_SPEC, (Object)1, index);
        }
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            this.getView().setEnable(enable, index, new String[]{field});
            if (enable.booleanValue() && FORMAT_IS_INCLUDE.equals(field)) {
                this.getModel().setValue(field, (Object)Boolean.TRUE, index);
            }
            if (!enable.booleanValue() && i != 0) {
                this.getModel().setValue(field, null, index);
            }
            if (i != 0) continue;
            this.getView().setEnable(Boolean.FALSE, index, new String[]{field});
        }
    }

    private String getCounrtyName() {
        DynamicObjectCollection formatentryentity = this.getModel().getEntryEntity(FORMAT_ENTRY_ENTITY);
        for (int i = 0; i < formatentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)formatentryentity.get(i);
            DynamicObject formatpreconfigid = (DynamicObject)dynamicObject.get(FORMAT_PRE_CONFIG_ID);
            if (!formatpreconfigid.get(NUMBER).equals(FIELD_COUNTRYID) || dynamicObject.getBoolean(FORMAT_IS_INCLUDE)) continue;
            return formatpreconfigid.getString(NAME);
        }
        return "";
    }

    private void checkEntryFields() {
        String name;
        HashMap<String, String> fields = new HashMap<String, String>(16);
        DynamicObjectCollection structentryentity = this.getModel().getEntryEntity(STRUCT_ENTRY_ENTITY);
        for (int i = 0; i < structentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)structentryentity.get(i);
            if (!dynamicObject.getBoolean(STRUCT_ISSHOW)) continue;
            String number = dynamicObject.getDynamicObject(STRUCT_PRE_CONFIG_ID).getString(NUMBER);
            String name2 = dynamicObject.getDynamicObject(STRUCT_PRE_CONFIG_ID).getString(NAME);
            fields.put(number, name2);
        }
        HashMap<String, String> textFormatMap = new HashMap<String, String>(16);
        DynamicObjectCollection formatentryentity = this.getModel().getEntryEntity(FORMAT_ENTRY_ENTITY);
        for (int i = 0; i < formatentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)formatentryentity.get(i);
            if (!dynamicObject.getBoolean(FORMAT_IS_INCLUDE)) continue;
            String string = dynamicObject.getDynamicObject(FORMAT_PRE_CONFIG_ID).getString(NUMBER);
            name = dynamicObject.getDynamicObject(FORMAT_PRE_CONFIG_ID).getString(NAME);
            textFormatMap.put(string, name);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : fields.entrySet()) {
            name = (String)textFormatMap.get(entry.getKey());
            if (!StringUtils.isEmpty((String)name)) continue;
            builder.append('\"');
            builder.append((String)entry.getValue());
            builder.append("\"\u3001");
        }
        String countryName = this.getCounrtyName();
        if (StringUtils.isNotEmpty((String)countryName)) {
            builder.append('\"');
            builder.append(countryName);
            builder.append("\"\u3001");
        }
        if (!StringUtils.isEmpty((String)builder.toString())) {
            String string = builder.substring(0, builder.length() - 1);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OPT_SAVE, (IFormPlugin)this);
            confirmCallBacks.setView(this.getView());
            String tip = ResManager.loadKDString((String)"\u5c06\u4e0d\u4f1a\u5305\u542b\u5728\u5730\u5740\u6587\u672c\uff0c\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"AddressConfigFormPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(string + tip, MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            boolean bl = AddressConfigUtil.isEditStatus(this);
            boolean isReferenced = this.isConfigReferenced();
            if (!bl && isReferenced) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5730\u5740\u683c\u5f0f\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6b64\u9875\u9762\u8fdb\u884c\u7f16\u8f91\u3002", (String)"AddressConfigFormPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            this.refreshParentView();
            if (bl) {
                AddressConfigUtil.controlAdminInEditStatus(this, true);
                AddressConfigUtil.controlEntryEntityInEditStatus(this);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AddressConfigFormPlugin_3", (String)"bos-address-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (Objects.equals(OPT_SAVE, messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            boolean isEditStatus = AddressConfigUtil.isEditStatus(this);
            boolean isReferenced = this.isConfigReferenced();
            if (!isEditStatus && isReferenced) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u5730\u5740\u683c\u5f0f\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6b64\u9875\u9762\u8fdb\u884c\u7f16\u8f91\u3002", (String)"AddressConfigFormPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            this.refreshParentView();
            if (isEditStatus) {
                AddressConfigUtil.controlAdminInEditStatus(this, true);
                AddressConfigUtil.controlEntryEntityInEditStatus(this);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AddressConfigFormPlugin_3", (String)"bos-address-formplugin", (Object[])new Object[0]));
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String isTipsFormatTab;
        boolean isEditStatus = AddressConfigUtil.isEditStatus(this);
        if (isEditStatus && TABPAGEAP1.equals(evt.getTabKey()) && (isTipsFormatTab = this.getPageCache().get(IS_TIPS_FORMAT_TAB)) == null) {
            String tip = ResManager.loadKDString((String)"\u683c\u5f0f\u4fee\u6539\u4e0d\u4f1a\u66f4\u65b0\u5386\u53f2\u6570\u636e\uff0c\u4ec5\u5bf9\u540e\u7eed\u8be5\u683c\u5f0f\u6570\u636e\u751f\u6548!", (String)"AddressConfigFormPlugin_4", (String)"bos-address-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(tip, "", MessageTypes.Default);
            this.getPageCache().put(IS_TIPS_FORMAT_TAB, TRUE);
        }
    }

    private void refreshParentView() {
        IFormView parentView;
        boolean isEditStatus = AddressConfigUtil.isEditStatus(this);
        if (isEditStatus && (parentView = this.getView().getParentView()) instanceof ListView && "cts_addressconfig".equals(((ListView)parentView).getBillFormId())) {
            parentView.getPageCache().put("listdatachanged", "1");
        }
    }

    static {
        structFields.add(STRUCT_PRE_CONFIG_ID);
        structFields.add(STRUCT_IS_REQUIRED);
        structFields.add(STRUCT_IS_NEWLINE);
        structFields.add(STRUCT_USER_DEFINE_TAG);
        structFields.add(STRUCT_LENGTH_SPEC);
        formatFields.add(FORMAT_PRE_CONFIG_ID);
        formatFields.add(FORMAT_IS_INCLUDE);
        formatFields.add(FORMAT_IS_NEWLINE);
        formatFields.add(FORMAT_REPLACE_ATTR);
        formatFields.add(FORMAT_PREFIX);
        formatFields.add(FORMAT_SUFFIX);
        formatFields.add(CONTAIN_BLANK);
    }
}

