/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AddressConfigListPlugin
extends AbstractListPlugin {
    private static final String CTS_ADDRESS_CONFIG = "cts_addressconfig";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String OPERATE_DELETE = "delete";
    private static final String ADDRESS_CONFIG_ID = "configid";
    private static final String DELETE_CACHE_KEY = "deleteFailures";
    private static final String FORMAT_CONVERT = "formatconvert";
    private static final String FORMAT_CONVERT_PAGE = "formatconvertpage";
    private static final String DISABLE = "disable";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String IS_DEFAULT = "isdefault";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection coll;
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (OPERATE_DELETE.equals(operateKey)) {
            Object primaryKeyValue;
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            ArrayList<Object> disableFailedPks = new ArrayList<Object>(10);
            for (Object keyValue : primaryKeyValues) {
                primaryKeyValue = keyValue;
                QFilter configF = new QFilter(ADDRESS_CONFIG_ID, "=", primaryKeyValue);
                DynamicObject[] addresses = BusinessDataServiceHelper.load((String)CTS_ADDRESS, (String)"id", (QFilter[])new QFilter[]{configF});
                if (addresses == null || addresses.length <= 0) continue;
                disableFailedPks.add(primaryKeyValue);
            }
            ArrayList<String> disableFailedNumbers = new ArrayList<String>(10);
            Iterator it = listSelectedData.iterator();
            while (it.hasNext()) {
                ListSelectedRow listSelectedRow = (ListSelectedRow)it.next();
                primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                if (!disableFailedPks.contains(primaryKeyValue)) continue;
                disableFailedNumbers.add(listSelectedRow.getNumber());
                it.remove();
            }
            this.getPageCache().put(DELETE_CACHE_KEY, SerializationUtils.toJsonString(disableFailedNumbers));
        } else if (DISABLE.equals(operateKey) && !this.checkDisableData(coll = args.getListSelectedData())) {
            args.setCancel(true);
        }
        super.beforeDoOperation(args);
    }

    private boolean checkDisableData(ListSelectedRowCollection coll) {
        for (ListSelectedRow row : coll) {
            DynamicObject addressConfigDy = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getPrimaryKeyValue(), (String)"cts_addressconfig");
            if (addressConfigDy == null) continue;
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7981\u7528\u56fd\u5bb6\u6216\u5730\u533a\u9ed8\u8ba4\u683c\u5f0f\u3002", (String)"AddressConfigListPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
            Boolean isDefault = addressConfigDy.getBoolean(IS_DEFAULT);
            if (!isDefault.booleanValue()) continue;
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPERATE_DELETE.equals(operateKey)) {
            ArrayList<OperateErrorInfo> allErrorOrValidateInfo = new ArrayList<OperateErrorInfo>(10);
            String deleteFailures = this.getPageCache().get(DELETE_CACHE_KEY);
            List failedNumbers = new ArrayList(10);
            if (StringUtil.isNotBlank((CharSequence)deleteFailures)) {
                failedNumbers = SerializationUtils.fromJsonStringToList((String)deleteFailures, String.class);
                for (int i = 0; i < failedNumbers.size(); ++i) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setErrorCode("errorCode" + allErrorOrValidateInfo.size() + 1);
                    errorInfo.setLevel(ErrorLevel.Error);
                    errorInfo.setPkValue(failedNumbers.get(i));
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664", (String)"AddressConfigListPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
                    errorInfo.setEntityKey("cts_addressconfig");
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u683c\u5f0f\u4e0b\u5df2\u5b58\u5728\u5730\u5740\u6570\u636e,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AddressConfigListPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]), failedNumbers.get(i)));
                    allErrorOrValidateInfo.add(errorInfo);
                }
            }
            this.reduceValidateResult(afterDoOperationEventArgs, allErrorOrValidateInfo, OPERATE_DELETE, failedNumbers.size());
        }
    }

    private void reduceValidateResult(AfterDoOperationEventArgs afterDoOperationEventArgs, List<OperateErrorInfo> allErrorOrValidateInfo, String validatorKey, int validateFailedSize) {
        ValidateResultCollection validateResult = afterDoOperationEventArgs.getOperationResult().getValidateResult();
        if (allErrorOrValidateInfo != null && allErrorOrValidateInfo.size() > 0) {
            ValidateResult validateResult1 = new ValidateResult();
            validateResult1.setAllErrorInfo(allErrorOrValidateInfo);
            validateResult.addValidateError(validatorKey, validateResult1);
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            operationResult.setValidateResult(validateResult);
            operationResult.setBillCount(operationResult.getBillCount() + validateFailedSize);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (FORMAT_CONVERT.equals(itemKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(FORMAT_CONVERT_PAGE);
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(openStyle);
            this.getView().showForm(formShowParameter);
        }
    }
}

