/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.AddressProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IPCListPlugin;

public class AddressExportListPlugin
extends AbstractListPlugin
implements IPCListPlugin {
    private static final String EXPORT_LIST = "exportlist";
    private static final String SELECTED_EXPORT_FIELD = "selectedExportField";
    private static final int FIRST_ROW_IDX = 0;
    private static final String ADDRESS_TYPE = "addressType";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String[] ADDRESS_BASEDATA_FIELDS = new String[]{"countryid", "configid", "admindivisionid1", "admindivisionid2", "admindivisionid3", "admindivisionid4", "admindivisionid5", "admindivisionid6"};

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof ExportList) {
            IPageCache pageCache = this.getView().getPageCache();
            ExportList source = (ExportList)args.getSource();
            String operateKey = source.getOperateKey();
            String pageId = this.getView().getPageId();
            if (EXPORT_LIST.equals(operateKey)) {
                pageCache.put(EXPORT_LIST + pageId, pageId);
            }
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        String selectFields = e.getSelectFields();
        IPageCache pageCache = this.getView().getPageCache();
        String pageId = this.getView().getPageId();
        pageCache.put(SELECTED_EXPORT_FIELD + pageId, selectFields);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        IPageCache pageCache = this.getView().getPageCache();
        String pageId = this.getView().getPageId();
        if (pageId.equals(pageCache.get(EXPORT_LIST + pageId))) {
            DataEntityPropertyCollection properties = e.getQueryValues()[0].getDynamicObjectType().getProperties();
            List<EntryProp> entryPropList = properties.stream().filter(item -> item instanceof EntryProp).map(prop -> (EntryProp)prop).collect(Collectors.toList());
            List<AddressProp> addressPropList = properties.stream().filter(item -> item instanceof AddressProp).map(prop -> (AddressProp)prop).collect(Collectors.toList());
            List<String> billHeaderAddressFieldKeys = this.getKeysFromBillHeader(addressPropList);
            Map<String, List<String>> entryKey2AddressFieldKeys = this.getKeysFromEntry(entryPropList);
            String selectFields = pageCache.get(SELECTED_EXPORT_FIELD + pageId);
            String[] selectedFields = selectFields.split(",");
            HashSet<String> set = new HashSet<String>(Arrays.asList(selectedFields));
            billHeaderAddressFieldKeys = this.filterNotInSelectedFields(billHeaderAddressFieldKeys, set);
            entryKey2AddressFieldKeys.forEach((k, v) -> {
                v = this.filterNotInSelectedFields((List<String>)v, (Set<String>)set);
            });
            if (!NAME.equals(this.getView().getPageCache().get(ADDRESS_TYPE))) {
                this.replaceAllData(e.getQueryValues(), billHeaderAddressFieldKeys, entryKey2AddressFieldKeys);
            }
        }
    }

    private List<String> getKeysFromBillHeader(List<AddressProp> addressPropList) {
        return addressPropList.stream().map(DynamicProperty::getName).collect(Collectors.toList());
    }

    private Map<String, List<String>> getKeysFromEntry(List<EntryProp> entryPropList) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        entryPropList.forEach(item -> {
            DataEntityPropertyCollection properties = item.getDynamicCollectionItemPropertyType().getProperties();
            List<AddressProp> addressPropList = properties.stream().filter(prop -> prop instanceof AddressProp).map(prop -> (AddressProp)prop).collect(Collectors.toList());
            if (addressPropList.size() > 0) {
                List<String> keysFromBillHeader = this.getKeysFromBillHeader(addressPropList);
                map.put(item.getName(), keysFromBillHeader);
            }
        });
        return map;
    }

    private boolean isContainsAddressType(DynamicObject[] dynamicObjects) {
        boolean isMatched = false;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DataEntityPropertyCollection properties = dynamicObjects[0].getDynamicObjectType().getProperties();
            Set set = properties.stream().filter(item -> item instanceof AddressProp).map(IMetadata::getName).collect(Collectors.toSet());
        }
        return isMatched;
    }

    private List<String> filterNotInSelectedFields(List<String> keys, Set<String> selectedKeys) {
        return keys.stream().filter(selectedKeys::contains).collect(Collectors.toList());
    }

    private void replaceAllData(DynamicObject[] values, List<String> addressKeyList, Map<String, List<String>> entityAddressKey) {
        if (addressKeyList.size() > 0) {
            Arrays.stream(values).forEach(item -> addressKeyList.forEach(key -> this.replaceBaseDataInAddressNameWithNumber(item.getDynamicObject(key))));
        }
        entityAddressKey.forEach((entryKey, addressKeys) -> {
            if (addressKeys.size() > 0) {
                Arrays.stream(values).forEach(value -> {
                    DynamicObjectCollection entry = value.getDynamicObjectCollection(entryKey);
                    entry.forEach(row -> addressKeys.forEach(key -> {
                        DynamicObject address = row.getDynamicObject(key);
                        this.replaceBaseDataInAddressNameWithNumber(address);
                    }));
                });
            }
        });
    }

    private void replaceBaseDataInAddressNameWithNumber(DynamicObject address) {
        if (address != null) {
            Arrays.stream(ADDRESS_BASEDATA_FIELDS).forEach(key -> {
                DynamicObject dynamicObject;
                if (address.containsProperty(key) && (dynamicObject = address.getDynamicObject(key)) != null) {
                    String number = dynamicObject.getString(NUMBER);
                    dynamicObject.set(NAME, (Object)number);
                }
            });
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        super.afterExportFile(e);
        this.clearCache();
    }

    private void clearCache() {
        IPageCache pageCache = this.getView().getPageCache();
        String pageId = this.getView().getPageId();
        pageCache.remove(EXPORT_LIST + pageId);
        pageCache.remove(SELECTED_EXPORT_FIELD + pageId);
    }
}

