/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AddressExportPlugin
extends AbstractListPlugin {
    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                Row row = sheet.getRow(2);
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    String stringCellValue;
                    Cell cell = row.getCell(i);
                    if (cell == null || !StringUtils.isNotBlank((CharSequence)(stringCellValue = cell.getStringCellValue())) || !stringCellValue.contains("name")) continue;
                    sheet.setColumnHidden(i, true);
                    break;
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.afterExportFile(e);
    }
}

