/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.address.util.AddressUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;

public class AddressImportPlugin
extends BatchImportPlugin {
    private static final Log log = LogFactory.getLog(AddressImportPlugin.class);
    private static final String NUMBER = "number";
    private static final String ENABLE = "enable";
    private static final String COUNTRY = "country";
    private static final String LEVEL = "level";
    private static final String CONFIG_ID = "configid";
    private static final String COUNTRY_ID = "countryid";
    private static final String STRUCT_ISSHOW = "structisshow";
    private static final String STRUCT_PRECONFIGID = "structpreconfigid";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String STRUCT_ISREQUIRED = "structisrequired";
    private static final String STREET1 = "street1";
    private static final String STREET2 = "street2";
    private static final String HOUSENUM = "housenum";
    private static final String HOUSENUM2 = "housenum2";
    private static final String BUILDING = "building";
    private static final String FLOOR = "floor";
    private static final String ROOMNUM = "roomnum";
    private static final String POBOX = "pobox";
    private static final String ADDRESS1 = "address1";
    private static final String ADDRESS2 = "address2";
    private static final String ADDRESS3 = "address3";
    private static final String ADDRESS4 = "address4";
    private static final String ADDRESS5 = "address5";
    private static final String POSTCODE1 = "postcode1";
    private static final String POSTCODE2 = "postcode2";
    private static final String POSTCODE3 = "postcode3";
    private static final String POSTCODEEXT = "postcodeext";
    private static final String ADMINDIVISION1 = "admindivisionid1";
    private static final String ADMINDIVISION2 = "admindivisionid2";
    private static final String ADMINDIVISION3 = "admindivisionid3";
    private static final String ADMINDIVISION4 = "admindivisionid4";
    private static final String ADMINDIVISION5 = "admindivisionid5";
    private static final String ADMINDIVISION6 = "admindivisionid6";
    private static final String LONGITUDE = "longitude";
    private static final String LATITUDE = "latitude";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String BD_COUNTRY = "bd_country";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final List<String> fields = new ArrayList<String>(15);
    protected static final Map<String, Long> fieldLength = new HashMap<String, Long>(16);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        ImportBillData billData = billdatas.get(0);
        JSONObject jsonObject = billData.getData();
        int startIndex = billData.getStartIndex();
        Object importtype = option.get("importtype");
        if (!"new".equals(importtype)) {
            billdatas.remove(0);
            logger.fail().log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u7981\u6b62\u5bf9\u6570\u636e\u8fdb\u884c\u7f16\u8f91\u6216\u7f16\u8f91\u5e76\u65b0\u589e\u64cd\u4f5c", (String)"AddressImportPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkAddressNumber(billdatas, jsonObject, startIndex, logger).booleanValue()) {
            return;
        }
        if (!this.checkMustInputNumber(billdatas, jsonObject, startIndex, logger).booleanValue()) {
            return;
        }
        if (!this.checkAdvsShowAndRequired(billdatas, jsonObject, startIndex, logger).booleanValue()) {
            return;
        }
        if (this.checkFieldFormat(billdatas)) {
            return;
        }
        Map<String, Object> nameMap = this.createNameMap(jsonObject);
        String configNum = jsonObject.getJSONObject(CONFIG_ID).getString(NUMBER);
        Object configId = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_ADDRESSCONFIG, (QFilter[])new QFilter(NUMBER, "=", (Object)configNum).toArray()).getPkValue();
        String countryNum = jsonObject.getJSONObject(COUNTRY_ID).getString(NUMBER);
        Object countryId = BusinessDataServiceHelper.loadSingleFromCache((String)BD_COUNTRY, (QFilter[])new QFilter(NUMBER, "=", (Object)countryNum).toArray()).getPkValue();
        String addressFormatStr = AddressUtil.getAddressFormatStr(nameMap, Long.valueOf(configId.toString()), Long.valueOf(countryId.toString()));
        jsonObject.put("name", (Object)addressFormatStr);
    }

    private Map<String, Object> createNameMap(JSONObject jsonObject) {
        HashMap<String, Object> nameMap = new HashMap<String, Object>(32);
        nameMap.put(ADDRESS1, jsonObject.getString(ADDRESS1));
        nameMap.put(ADDRESS2, jsonObject.getString(ADDRESS2));
        nameMap.put(ADDRESS3, jsonObject.getString(ADDRESS3));
        nameMap.put(ADDRESS4, jsonObject.getString(ADDRESS4));
        nameMap.put(ADDRESS5, jsonObject.getString(ADDRESS5));
        nameMap.put(STREET1, jsonObject.getString(STREET1));
        nameMap.put(STREET2, jsonObject.getString(STREET2));
        nameMap.put(POBOX, jsonObject.getString(POBOX));
        nameMap.put(POSTCODE1, jsonObject.getString(POSTCODE1));
        nameMap.put(POSTCODE2, jsonObject.getString(POSTCODE2));
        nameMap.put(POSTCODE3, jsonObject.getString(POSTCODE3));
        nameMap.put(POSTCODEEXT, jsonObject.getString(POSTCODEEXT));
        nameMap.put(ROOMNUM, jsonObject.getString(ROOMNUM));
        nameMap.put(HOUSENUM, jsonObject.getString(HOUSENUM));
        nameMap.put(HOUSENUM2, jsonObject.getString(HOUSENUM2));
        nameMap.put(FLOOR, jsonObject.getString(FLOOR));
        nameMap.put(BUILDING, jsonObject.getString(BUILDING));
        nameMap.put(LONGITUDE, Optional.ofNullable(jsonObject.getBigDecimal(LONGITUDE)).orElse(BigDecimal.ZERO));
        nameMap.put(LATITUDE, Optional.ofNullable(jsonObject.getBigDecimal(LATITUDE)).orElse(BigDecimal.ZERO));
        JSONObject admin1 = jsonObject.getJSONObject(ADMINDIVISION1);
        JSONObject admin2 = jsonObject.getJSONObject(ADMINDIVISION2);
        JSONObject admin3 = jsonObject.getJSONObject(ADMINDIVISION3);
        JSONObject admin4 = jsonObject.getJSONObject(ADMINDIVISION4);
        JSONObject admin5 = jsonObject.getJSONObject(ADMINDIVISION5);
        HashSet<String> numbers = new HashSet<String>(16);
        if (admin1 != null) {
            nameMap.put(ADMINDIVISION1, BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter(NUMBER, "=", (Object)admin1.getString(NUMBER)).toArray()));
        }
        if (admin2 != null) {
            numbers.add(admin2.getString(NUMBER));
            nameMap.put(ADMINDIVISION2, BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter(NUMBER, "=", (Object)admin2.getString(NUMBER)).toArray()));
        }
        if (admin3 != null) {
            numbers.add(admin3.getString(NUMBER));
            nameMap.put(ADMINDIVISION3, BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter(NUMBER, "=", (Object)admin3.getString(NUMBER)).toArray()));
        }
        if (admin4 != null) {
            numbers.add(admin4.getString(NUMBER));
            nameMap.put(ADMINDIVISION4, BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter(NUMBER, "=", (Object)admin4.getString(NUMBER)).toArray()));
        }
        if (admin5 != null) {
            numbers.add(admin5.getString(NUMBER));
            nameMap.put(ADMINDIVISION5, BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter(NUMBER, "=", (Object)admin5.getString(NUMBER)).toArray()));
        }
        return nameMap;
    }

    private boolean checkFieldFormat(List<ImportBillData> billDataList) {
        ImportBillData billData = billDataList.get(0);
        JSONObject jsonObject = billData.getData();
        try {
            jsonObject.getBigDecimal(LONGITUDE);
            jsonObject.getBigDecimal(LATITUDE);
        }
        catch (NumberFormatException exception) {
            return true;
        }
        return false;
    }

    private Boolean checkAddressNumber(List<ImportBillData> billdatas, JSONObject jsonObject, int startIndex, ImportLogger logger) {
        String number = jsonObject.getString(NUMBER);
        if (StringUtils.isNotEmpty((String)number)) {
            DynamicObject[] cts_names = BusinessDataServiceHelper.load((String)CTS_ADDRESS, (String)"", (QFilter[])new QFilter(NUMBER, "=", (Object)number).toArray());
            if (cts_names != null && cts_names.length != 0) {
                billdatas.remove(0);
                logger.fail().log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u7f16\u7801\u5df2\u5b58\u5728", (String)"AddressImportPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]), number));
                return Boolean.FALSE;
            }
        } else {
            number = CodeRuleServiceHelper.getNumber((String)CTS_ADDRESS, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)CTS_ADDRESS), null);
            jsonObject.put(NUMBER, (Object)number);
        }
        return Boolean.TRUE;
    }

    private Boolean checkMustInputNumber(List<ImportBillData> billdatas, JSONObject jsonObject, int startIndex, ImportLogger logger) {
        JSONObject config = jsonObject.getJSONObject(CONFIG_ID);
        JSONObject country = jsonObject.getJSONObject(COUNTRY_ID);
        if (country == null || StringUtils.isBlank((String)country.getString(NUMBER))) {
            billdatas.remove(0);
            logger.fail().log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a.\u7f16\u7801\u5fc5\u586b", (String)"AddressImportPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String countryNumber = country.getString(NUMBER);
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)countryNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BD_COUNTRY, (String)"", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            billdatas.remove(0);
            logger.fail().log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a.\u7f16\u7801\u672a\u5b9a\u4e49", (String)"AddressImportPlugin_3", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (config == null || StringUtils.isBlank((String)config.getString(NUMBER))) {
            billdatas.remove(0);
            logger.fail().log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f.\u7f16\u7801\u5fc5\u586b", (String)"AddressImportPlugin_4", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String configNumber = config.getString(NUMBER);
        qFilter = new QFilter(NUMBER, "=", (Object)configNumber);
        dynamicObject = BusinessDataServiceHelper.loadSingle((String)CTS_ADDRESSCONFIG, (String)"", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            billdatas.remove(0);
            logger.fail().log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f.\u7f16\u7801\u672a\u5b9a\u4e49", (String)"AddressImportPlugin_5", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkAdvsShowAndRequired(List<ImportBillData> billdatas, JSONObject jsonObject, int startIndex, ImportLogger logger) {
        String configNumber = jsonObject.getJSONObject(CONFIG_ID).getString(NUMBER);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)CTS_ADDRESSCONFIG, (String)"structisshow,structisrequired,country,structpreconfigid,structisshow,structisrequired", (QFilter[])new QFilter(NUMBER, "=", (Object)configNumber).toArray());
        DynamicObjectCollection structpreconfigid = dynamicObject.getDynamicObjectCollection(STRUCT_ENTRY_ENTITY);
        HashMap<String, Boolean> isshowMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> isrequiredMap = new HashMap<String, Boolean>(16);
        for (DynamicObject entry : structpreconfigid) {
            Boolean structisshow = entry.getBoolean(STRUCT_ISSHOW);
            Boolean structisrequired = entry.getBoolean(STRUCT_ISREQUIRED);
            String number = entry.getDynamicObject(STRUCT_PRECONFIGID).getString(NUMBER);
            isshowMap.put(number, structisshow);
            isrequiredMap.put(number, structisrequired);
        }
        String parentCode = "";
        String countryNumber = jsonObject.getJSONObject(COUNTRY_ID).getString(NUMBER);
        QFilter countryFilter = new QFilter(NUMBER, "=", (Object)countryNumber);
        countryFilter.and(ENABLE, "=", (Object)Character.valueOf('1'));
        String pkValue = BusinessDataServiceHelper.loadSingle((String)BD_COUNTRY, (String)"", (QFilter[])countryFilter.toArray()).getPkValue().toString();
        for (int i = 0; i < fields.size(); ++i) {
            String number = fields.get(i);
            Boolean ishow = isshowMap.get(number) != null ? (Boolean)isshowMap.get(number) : Boolean.FALSE;
            String value = "";
            if (i < 6) {
                JSONObject admindivision = jsonObject.getJSONObject(number);
                if (admindivision != null) {
                    value = admindivision.getString(NUMBER);
                }
            } else {
                value = jsonObject.getString(number);
            }
            if (!ishow.booleanValue() && StringUtil.isNotBlank((CharSequence)value)) {
                billdatas.remove(0);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cts_addresspreconfig", (String)"", (QFilter[])new QFilter(NUMBER, "=", (Object)number).toArray());
                String name = dynamicObject.getLocaleString("name").getLocaleValue();
                String msg = String.format(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0d\u5305\u542b'%s'\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"AddressImportPlugin_6", (String)"bos-address-formplugin", (Object[])new Object[0]), name);
                logger.fail().log(Integer.valueOf(startIndex), msg);
                return Boolean.FALSE;
            }
            Boolean isrequired = (Boolean)isrequiredMap.get(number);
            if (ishow.booleanValue() && isrequired.booleanValue() && StringUtil.isBlank((CharSequence)value)) {
                billdatas.remove(0);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cts_addresspreconfig", (String)"", (QFilter[])new QFilter(NUMBER, "=", (Object)number).toArray());
                String name = dynamicObject.getLocaleString("name").getLocaleValue();
                logger.fail().log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"%s\u5fc5\u586b", (String)"AddressImportPlugin_8", (String)"bos-address-formplugin", (Object[])new Object[0]), name));
                return Boolean.FALSE;
            }
            Long length = fieldLength.get(number);
            if (i > 6 && isrequired.booleanValue() && (long)value.length() > length) {
                billdatas.remove(0);
                dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cts_addresspreconfig", (String)"", (QFilter[])new QFilter(NUMBER, "=", (Object)number).toArray());
                String name = dynamicObject.getLocaleString("name").getLocaleValue();
                String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6\u4e3a", (String)"AddressImportPlugin_9", (String)"bos-address-formplugin", (Object[])new Object[0]);
                String tip = ResManager.loadKDString((String)"\u5f55\u5165\u4fe1\u606f\u8d85\u957f", (String)"AddressImportPlugin_10", (String)"bos-address-formplugin", (Object[])new Object[0]);
                logger.fail().log(Integer.valueOf(startIndex), name + msg + length + tip);
                return Boolean.FALSE;
            }
            if (i >= 6 || !ishow.booleanValue() || !StringUtils.isNotEmpty((String)value)) continue;
            Boolean checked = this.checkAdmindivision(pkValue, parentCode, value, i + 1, billdatas, startIndex, logger);
            if (!checked.booleanValue()) {
                return Boolean.FALSE;
            }
            parentCode = value;
        }
        return Boolean.TRUE;
    }

    private Boolean checkAdmindivision(String countryId, String parentAdvs, String advs, int level, List<ImportBillData> billdatas, int startIndex, ImportLogger logger) {
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
        countryFilter.and(NUMBER, "=", (Object)advs);
        countryFilter.and(LEVEL, "=", (Object)level);
        DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((String)BD_ADMINDIVISION, (String)"", (QFilter[])countryFilter.toArray());
        if (admindivision == null) {
            billdatas.remove(0);
            String msg = ResManager.loadKDString((String)"\u6240\u5c5e\u56fd\u5bb6\u6216\u5730\u533a\u7684\u884c\u653f\u533a\u5212", (String)"AddressImportPlugin_11", (String)"bos-address-formplugin", (Object[])new Object[0]);
            String tip = ResManager.loadKDString((String)"\u7ea7\u6b21\u672a\u5b9a\u4e49", (String)"AddressImportPlugin_12", (String)"bos-address-formplugin", (Object[])new Object[0]);
            logger.fail().log(Integer.valueOf(startIndex), msg + level + tip);
            return Boolean.FALSE;
        }
        if (level > 1) {
            countryFilter = new QFilter(COUNTRY, "=", (Object)Long.parseLong(countryId));
            countryFilter.and(NUMBER, "=", (Object)parentAdvs);
            countryFilter.and(LEVEL, "=", (Object)(level - 1));
            admindivision = BusinessDataServiceHelper.loadSingle((String)BD_ADMINDIVISION, (String)"", (QFilter[])countryFilter.toArray());
            if (admindivision == null) {
                billdatas.remove(0);
                String msg = ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212", (String)"AddressImportPlugin_13", (String)"bos-address-formplugin", (Object[])new Object[0]);
                String tip = ResManager.loadKDString((String)"\u7ea7", (String)"AddressImportPlugin_14", (String)"bos-address-formplugin", (Object[])new Object[0]);
                String info = ResManager.loadKDString((String)"\u4e0e\u4e0a\u7ea7\u884c\u653f\u533a\u5212\u4e0d\u5339\u914d", (String)"AddressImportPlugin_15", (String)"bos-address-formplugin", (Object[])new Object[0]);
                logger.fail().log(Integer.valueOf(startIndex), msg + level + tip + advs + info);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 1;
    }

    static {
        fields.add(ADMINDIVISION1);
        fields.add(ADMINDIVISION2);
        fields.add(ADMINDIVISION3);
        fields.add(ADMINDIVISION4);
        fields.add(ADMINDIVISION5);
        fields.add(ADMINDIVISION6);
        fields.add(STREET1);
        fields.add(STREET2);
        fields.add(HOUSENUM);
        fields.add(HOUSENUM2);
        fields.add(BUILDING);
        fields.add(FLOOR);
        fields.add(ROOMNUM);
        fields.add(POSTCODE1);
        fields.add(POSTCODE2);
        fields.add(POSTCODE3);
        fields.add(POSTCODEEXT);
        fields.add(POBOX);
        fields.add(ADDRESS1);
        fields.add(ADDRESS2);
        fields.add(ADDRESS3);
        fields.add(ADDRESS4);
        fields.add(ADDRESS5);
        fieldLength.put(ADDRESS1, 255L);
        fieldLength.put(ADDRESS2, 255L);
        fieldLength.put(ADDRESS3, 255L);
        fieldLength.put(ADDRESS4, 255L);
        fieldLength.put(ADDRESS5, 255L);
        fieldLength.put(POBOX, 255L);
        fieldLength.put(STREET1, 255L);
        fieldLength.put(STREET2, 255L);
        fieldLength.put(HOUSENUM, 255L);
        fieldLength.put(HOUSENUM2, 255L);
        fieldLength.put(BUILDING, 255L);
        fieldLength.put(ROOMNUM, 255L);
        fieldLength.put(FLOOR, 255L);
        fieldLength.put(POSTCODE1, 10L);
        fieldLength.put(POSTCODE2, 10L);
        fieldLength.put(POSTCODE3, 10L);
        fieldLength.put(POSTCODEEXT, 10L);
    }
}

