/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class AddressInfoBuildPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ADVANCE_ADDRESS_CONFIG = "cts_advance_address";
    private static final String SYSTEM_PRESET_NUMBER = "SYSTEM_PRESET";
    private static final String ADDRESS_INFO_FIELD_PAGE = "addressinfofieldpage";
    private static final String ADDRESS_INFO_FIELD_FLEX = "addressinfofieldflex";
    private static final String COUNTRY = "country";
    private static final String ADDRESS_FORMAT = "addressformat";
    private static final String ADDR_CONFIG_ID = "addrconfigid";
    private static final String ADDR_COUNTRY_ID = "addrcountryid";
    private static final String SAVE = "save";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String CONFIG_ID = "configid";
    private static final String EDIT_ADDRESS_ID = "editAddressId";
    private static final String SOURCE_ENTITY_ID = "sourceEntityId";
    private static final String F7_CALLBACK_ID = "f7SelectConfirm";
    private static final String IS_ADDRESS_CONFIG_PREVIEW = "is_address_config_preview";
    private static final String ADDRESS_CONFIG_PREVIEW_MODEL = "address_config_preview_model";
    private static final String ADDRESS_CONFIG_PREVIEW_MODEL_VAL = "-1";
    private static final String ADDRESS_NAME = "address_name";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String CLICK_CACHE = "clickCache";
    private static final String SOURCE_METHOD = "click";
    private static final String HYPERLINK_REMARK = "HyperLink";
    private static final String MOB_ADDRESSINFOFIELDPAGE = "mob_addressinfofieldpage";
    private static final String EMPTY_CONFIG_ID = "0";

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ADDRESS_FORMAT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit countryEdit = (BasedataEdit)this.getControl(COUNTRY);
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String addrConfigId = (String)this.getView().getFormShowParameter().getCustomParam("addrConfigId");
        String countryId = (String)this.getView().getFormShowParameter().getCustomParam("countryId");
        Object HyperLink = this.getView().getFormShowParameter().getCustomParam("from");
        if (HYPERLINK_REMARK.equals(HyperLink)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{COUNTRY, ADDRESS_FORMAT});
        }
        if (!(StringUtils.isBlank((CharSequence)addrConfigId) || addrConfigId.equals(ADDRESS_CONFIG_PREVIEW_MODEL_VAL) || StringUtils.isBlank((CharSequence)countryId))) {
            this.getModel().setValue(COUNTRY, (Object)Long.parseLong(countryId));
            this.getModel().setValue(ADDRESS_FORMAT, (Object)Long.parseLong(addrConfigId));
            this.showAddressForm();
        } else {
            Object editAddressId = this.getView().getFormShowParameter().getCustomParam(EDIT_ADDRESS_ID);
            if (editAddressId != null) {
                DynamicObject address = BusinessDataServiceHelper.loadSingle((Object)editAddressId, (String)CTS_ADDRESS);
                this.getModel().setValue(COUNTRY, ((DynamicObject)address.get("countryid")).getPkValue());
                this.getModel().setValue(ADDRESS_FORMAT, address.getDynamicObject(CONFIG_ID).getPkValue());
                this.showAddressForm();
                return;
            }
            Boolean isAddressConfigPreview = (Boolean)this.getView().getFormShowParameter().getCustomParam(IS_ADDRESS_CONFIG_PREVIEW);
            if (isAddressConfigPreview != null && isAddressConfigPreview.booleanValue()) {
                DynamicObject dummyAddrConfig = BusinessDataServiceHelper.newDynamicObject((String)CTS_ADDRESSCONFIG);
                dummyAddrConfig.set(NAME, this.getView().getFormShowParameter().getCustomParam(ADDRESS_NAME));
                dummyAddrConfig.set(NUMBER, this.getView().getFormShowParameter().getCustomParam(ADDRESS_NAME));
                dummyAddrConfig.set(ID, (Object)-1L);
                this.getModel().setValue(COUNTRY, (Object)Long.valueOf(countryId));
                BasedataProp prop = (BasedataProp)this.getModel().getProperty(ADDRESS_FORMAT);
                prop.setValueFast((Object)this.getModel().getDataEntity(), (Object)dummyAddrConfig);
                this.showAddressFormPreview(Long.valueOf(countryId));
                return;
            }
            Object defaultCountry = SystemParamServiceHelper.loadPublicParameterFromCache((String)"defaultcountry");
            if (defaultCountry != null) {
                Map defaultCountryMap = (Map)defaultCountry;
                this.setCountryAndDefaultConfig(Long.valueOf(defaultCountryMap.get(ID).toString()));
            }
        }
    }

    private void setCountryAndConfig(String countryId, String styleConfigId) {
        this.getModel().setValue(COUNTRY, (Object)Long.valueOf(countryId));
        Object value = this.getModel().getValue(ADDRESS_FORMAT);
        if (EMPTY_CONFIG_ID.equals(styleConfigId)) {
            styleConfigId = Optional.ofNullable(this.getDefaultFormatId(Long.parseLong(countryId))).map(Object::toString).orElse(EMPTY_CONFIG_ID);
        }
        this.getModel().setValue(ADDRESS_FORMAT, (Object)Long.parseLong(styleConfigId));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        if (ADDRESS_FORMAT.equals(fieldName)) {
            this.showAddressForm();
        }
        if (COUNTRY.equals(fieldName)) {
            DynamicObject object = (DynamicObject)e.getChangeSet()[0].getNewValue();
            long countryId = object.getLong(ID);
            DynamicObject addressFormatDy = (DynamicObject)this.getModel().getValue(ADDRESS_FORMAT);
            Long newAddressFormat = (Long)this.getDefaultFormatId(countryId);
            if (newAddressFormat != null && newAddressFormat != 0L && addressFormatDy != null && newAddressFormat.equals(addressFormatDy.getPkValue())) {
                this.showAddressForm();
            } else {
                this.getModel().setValue(ADDRESS_FORMAT, this.getDefaultFormatId(countryId));
            }
            this.getView().updateView(ADDRESS_FORMAT);
            this.getPageCache().remove("propertyValueCache");
        }
    }

    private void setCountryAndDefaultConfig(Long countryId) {
        this.getModel().setValue(COUNTRY, (Object)countryId);
        Long newAddressFormat = (Long)this.getDefaultFormatId(countryId);
        if (newAddressFormat != null && newAddressFormat != 0L) {
            this.getModel().setValue(ADDRESS_FORMAT, (Object)newAddressFormat);
            this.showAddressForm();
        }
        this.getPageCache().remove("propertyValueCache");
    }

    private Object getDefaultFormatId(long countryId) {
        String sql = "SELECT m.fid id FROM t_cts_addressconfig m LEFT JOIN t_cts_addrconfigcountry n ON m.fid = n.fid WHERE n.fbasedataid = ? and m.fisdefault = '1'";
        return DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{countryId}, rs -> {
            if (rs.next()) {
                return rs.getLong(ID);
            }
            return null;
        });
    }

    private void showAddressForm() {
        Object addressFormat = this.getModel().getValue(ADDRESS_FORMAT);
        Object country = this.getModel().getValue(COUNTRY);
        Object pkValue = null;
        if (addressFormat != null) {
            pkValue = ((DynamicObject)addressFormat).getPkValue();
        }
        Object countryPkValue = ((DynamicObject)country).getPkValue();
        String sourceEntityId = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_ENTITY_ID);
        MobileFormShowParameter formShowParameter = null;
        if (this.getView().getFormShowParameter() instanceof MobileFormShowParameter) {
            formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId(MOB_ADDRESSINFOFIELDPAGE);
        } else {
            formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(ADDRESS_INFO_FIELD_PAGE);
        }
        formShowParameter.setCustomParam(ADDR_CONFIG_ID, pkValue);
        formShowParameter.setCustomParam(ADDR_COUNTRY_ID, countryPkValue);
        formShowParameter.setCustomParam(SOURCE_ENTITY_ID, (Object)sourceEntityId);
        Object editAddressId = this.getView().getFormShowParameter().getCustomParam(EDIT_ADDRESS_ID);
        if (editAddressId != null) {
            DynamicObject address = BusinessDataServiceHelper.loadSingle((Object)editAddressId, (String)CTS_ADDRESS);
            DynamicObject addressCountry = address.getDynamicObject("countryid");
            Object addressCountryId = null;
            if (addressCountry != null) {
                addressCountryId = addressCountry.getPkValue();
            }
            if (null != pkValue && pkValue.equals(address.getDynamicObject(CONFIG_ID).getPkValue()) && countryPkValue.equals(addressCountryId)) {
                formShowParameter.setCustomParam(EDIT_ADDRESS_ID, editAddressId);
            }
        }
        formShowParameter.getOpenStyle().setTargetKey(ADDRESS_INFO_FIELD_FLEX);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SAVE));
        if (pkValue == null) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            formShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.getPageCache().put("childPageId", formShowParameter.getPageId());
    }

    private void showAddressFormPreview(Long addrCountryId) {
        String sourceEntityId = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_ENTITY_ID);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam(ADDR_CONFIG_ID, (Object)-1);
        formShowParameter.setCustomParam(ADDR_COUNTRY_ID, (Object)addrCountryId);
        formShowParameter.setCustomParam(SOURCE_ENTITY_ID, (Object)sourceEntityId);
        formShowParameter.setCustomParam(ADDRESS_CONFIG_PREVIEW_MODEL, this.getView().getFormShowParameter().getCustomParam(ADDRESS_CONFIG_PREVIEW_MODEL));
        formShowParameter.setCustomParam(IS_ADDRESS_CONFIG_PREVIEW, (Object)Boolean.TRUE);
        formShowParameter.setFormId(ADDRESS_INFO_FIELD_PAGE);
        formShowParameter.getOpenStyle().setTargetKey(ADDRESS_INFO_FIELD_FLEX);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SAVE));
        formShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (F7_CALLBACK_ID.equals(evt.getCallBackId()) && MessageBoxResult.Yes == evt.getResult()) {
            this.getPageCache().put(CLICK_CACHE, "f7Select");
            ((BasedataEdit)this.getControl(ADDRESS_FORMAT)).click();
        }
        if ("f7SelectCountryConfirm".equals(evt.getCallBackId()) && MessageBoxResult.Yes == evt.getResult()) {
            this.getPageCache().put("clickCountryCache", "f7Select");
            ((BasedataEdit)this.getControl(COUNTRY)).click();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object country;
        String name = evt.getProperty().getName();
        String sourceMethod = evt.getSourceMethod();
        Object address = this.getModel().getValue(ADDRESS_FORMAT);
        if (address != null && ADDRESS_FORMAT.equals(name) && SOURCE_METHOD.equals(sourceMethod)) {
            String value = this.getPageCache().get(CLICK_CACHE);
            if (value == null) {
                evt.setCancel(true);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(F7_CALLBACK_ID, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u683c\u5f0f\u53ef\u80fd\u6e05\u9664\u90e8\u5206\u5b57\u6bb5\u4fe1\u606f\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"AddressInfoBuildPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            }
            this.getPageCache().remove(CLICK_CACHE);
        }
        if ((country = this.getModel().getValue(COUNTRY)) != null && COUNTRY.equals(name) && SOURCE_METHOD.equals(sourceMethod)) {
            String value = this.getPageCache().get("clickCountryCache");
            if (value == null) {
                evt.setCancel(true);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("f7SelectCountryConfirm", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u56fd\u5bb6/\u5730\u533a\u4f1a\u6e05\u9664\u5730\u5740\u4fe1\u606f\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"AddressInfoBuildPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            }
            this.getPageCache().remove("clickCountryCache");
        }
        if (ADDRESS_FORMAT.equals(evt.getProperty().getName())) {
            List filters = evt.getCustomQFilters();
            if (country == null) {
                if (!"setItemByNumber".equals(evt.getSourceMethod())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u3002", (String)"AddressInfoBuildPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
                }
                evt.setCancel(true);
                return;
            }
            String sql = "SELECT fid FROM t_cts_addrconfigcountry WHERE fbasedataid = ? ";
            ArrayList ids = new ArrayList(10);
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{((DynamicObject)country).getPkValue()}, rs -> {
                while (rs.next()) {
                    ids.add(rs.getLong("fid"));
                }
                return ids;
            });
            QFilter qFilter = new QFilter(ID, "in", ids);
            filters.add(qFilter);
        }
        if (COUNTRY.equals(evt.getProperty().getName()) && "setItemByNumber".equals(evt.getSourceMethod())) {
            evt.setCancel(true);
            return;
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String selectProperties = "id,enablemap";
        QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET_NUMBER);
        DynamicObject advanceAddress = BusinessDataServiceHelper.loadSingleFromCache((String)ADVANCE_ADDRESS_CONFIG, (String)selectProperties, (QFilter[])advanceAddressQFilter.toArray());
        if (advanceAddress == null || !advanceAddress.getBoolean("enablemap")) {
            FormConfig formConfig = e.getFormShowParameter().getFormConfig();
            formConfig.setHeight(new LocaleString("680"));
        }
    }
}

