/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.address.entity.AddressFieldMetadata;
import kd.bos.address.enums.AddressFieldLengthEnum;
import kd.bos.address.enums.AddressFiledTypeEnum;
import kd.bos.address.plugin.AddressImportPlugin;
import kd.bos.address.util.AddressUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class AddressInfoDynamicFieldPagePlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(AddressInfoDynamicFieldPagePlugin.class);
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String COUNTRY = "country";
    private static final String ADDRESS_FORMAT = "addressformat";
    private static final String OPT_SAVE = "opt_save";
    private static final String OPT_CANCLE = "opt_cancle";
    private static final String FIELD_FLEX = "flex";
    private static final String PANEL = "panel";
    private static final String SAVE = "save";
    private static final String CANCLE = "cancle";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String SYSTEM_PRESET_NUMBER = "SYSTEM_PRESET";
    private static final String ADVANCE_ADDRESS_CONFIG = "cts_advance_address";
    private static final String MAP_CONFIG_ENTRY = "mapconfigentry";
    private static final String MAP_FIELD_MAPPING_ENTRY = "mapfieldmappingentry";
    private static final String PARENT_ID = "parent_id";
    private static final String ID = "_id";
    private static final Integer MINLENGTH = 0;
    private static final Integer MAXLENGTH = 100;
    private static final Integer FONTSIZE = 14;
    private static final String EDIT_ADDRESS_ID = "editAddressId";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String MAP_CONTROL_AP = "mapcontrolap";
    private static final String ADDR_CONFIG_ID = "addrconfigid";
    private static final String ADDR_COUNTRY_ID = "addrcountryid";
    private static final String HYPERLINK_REMARK = "HyperLink";
    private static final String PROPERTY_VALUE_CACHE = "propertyValueCache";
    private static final String SAVE_VALUE_CACHE = "saveValueCache";
    private static final Set<String> admindivisions = new HashSet<String>(7);
    private static final String F7_LIST_FORM_ID = "bos_listf7";
    private static final String ADMIN_DIVISION_ID = "admindivisionid";
    private static final String MODEL_TYPE_PC = "form";
    private static final String LAT = "latitude";
    private static final String LNG = "longitude";
    private static final String EDIT_STATUS = "EDIT";
    private static final String CREATE_STATUS = "CREATE";
    private static final String PAGE_STATUS = "PAGE_STATUS";
    private static final String LONG_NUMBER = "longnumber";
    private static final String LEVEL = "level";
    private static final String ITEM = "item";
    private static final String ENABLE = "enable";
    private static final String ADMIN_DIVISION_CHANGED = "admindivisionchanged";
    private String modelType;
    private static final String[] NOT_BELONG_ADDRESS_FIELDS;

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE, CANCLE});
        List<AddressFieldMetadata> addressFieldMetadatas = this.buildAddressFieldMetas();
        if (addressFieldMetadatas != null && addressFieldMetadatas.size() > 0) {
            for (int i = 0; i < addressFieldMetadatas.size(); ++i) {
                AddressFieldMetadata addressFieldMetadata = addressFieldMetadatas.get(i);
                String fieldKey = addressFieldMetadata.getFieldKey();
                AddressFiledTypeEnum fieldType = addressFieldMetadata.getFieldType();
                String priviousKey = addressFieldMetadata.getPriviousKey();
                if (AddressFiledTypeEnum.BASEDATA != fieldType || !StringUtils.isNotBlank((CharSequence)priviousKey)) continue;
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(fieldKey);
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
        if (this.isPCView()) {
            this.getInfo();
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<AddressFieldMetadata> list = this.buildAddressFieldMetas();
        Long editAddressId = (Long)this.getView().getFormShowParameter().getCustomParam(EDIT_ADDRESS_ID);
        if (editAddressId != null && editAddressId != 0L) {
            Object HyperLink;
            DynamicObject addressDy = BusinessDataServiceHelper.loadSingle((Object)editAddressId, (String)CTS_ADDRESS);
            if (addressDy != null) {
                for (AddressFieldMetadata metadata : list) {
                    Object defaultValue = addressDy.get(metadata.getFieldKey());
                    this.getModel().setValue(metadata.getFieldKey(), defaultValue);
                }
            }
            if (HYPERLINK_REMARK.equals(HyperLink = this.getView().getParentView().getFormShowParameter().getCustomParam("from"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE});
            }
            this.getModel().getDataEntity().getDataEntityState().setDirty(false);
            return;
        }
        if (this.getView().getParentView() == null) {
            return;
        }
        IPageCache iPageCache = this.getView().getParentView().getPageCache();
        if (iPageCache == null) {
            return;
        }
        String valueCache = iPageCache.get(PROPERTY_VALUE_CACHE);
        if (valueCache != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)valueCache, Map.class);
            Set keySet = map.keySet();
            for (AddressFieldMetadata metadata : list) {
                if (!keySet.contains(metadata.getFieldKey())) continue;
                this.getModel().setValue(metadata.getFieldKey(), map.get(metadata.getFieldKey()));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Button)evt.getSource()).getOperationKey();
        if (OPT_SAVE.equals(key)) {
            if (EDIT_STATUS.equals(this.getPageCache().get(PAGE_STATUS)) && !this.getModel().getDataEntity().getDataEntityState().getDataEntityDirty() && !"true".equals(this.getPageCache().get(ADMIN_DIVISION_CHANGED))) {
                this.getView().close();
                return;
            }
            Boolean isShow = Boolean.FALSE;
            Map<Boolean, String> isShowMap = this.isShowConfirmPage();
            if (this.interestToShowLatTip()) {
                isShow = isShowMap.keySet().stream().findFirst().orElse(Boolean.FALSE);
            }
            if (isShow.booleanValue()) {
                String changedName = isShowMap.values().stream().findFirst().orElse("");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(changedName, (IFormPlugin)this);
                confirmCallBacks.setView(this.getView());
                String tipMsg = "";
                if (changedName.equals(ChangedEnum.ADDRESS_CHANGED.name())) {
                    tipMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u4fee\u6539\u4e86\u5730\u5740\u4fe1\u606f\u4f46\u672a\u4fee\u6539\u7ecf\u7eac\u5ea6\uff0c\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"AddressInfoDynamicFieldPagePlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
                } else if (changedName.equals(ChangedEnum.LNG_OR_LAT_CHANGED.name())) {
                    tipMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u4fee\u6539\u4e86\u7ecf\u7eac\u5ea6\u4f46\u672a\u4fee\u6539\u5730\u5740\u4fe1\u606f\uff0c\u786e\u8ba4\u4fdd\u5b58\uff1f", (String)"AddressInfoDynamicFieldPagePlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]);
                }
                this.getView().showConfirm(tipMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            }
            evt.setCancel(true);
            if (!isShow.booleanValue()) {
                this.tryCloseView();
            }
        }
    }

    private boolean interestToShowLatTip() {
        if (!this.isPCView()) {
            return false;
        }
        Control control = this.getView().getControl(LAT);
        if (control == null) {
            return false;
        }
        if (!EDIT_STATUS.equals(this.getPageCache().get(PAGE_STATUS))) {
            return false;
        }
        BigDecimal lat = (BigDecimal)this.getModel().getValue(LAT);
        BigDecimal lng = (BigDecimal)this.getModel().getValue(LNG);
        return BigDecimal.ZERO.compareTo(lat) != 0 || BigDecimal.ZERO.compareTo(lng) != 0;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List items = e.getItems();
        List<FlexPanelAp> controls = this.flexPanelList(AddressUtil.buildAddressFieldMetas((FormShowParameter)e.getSource(), null), e);
        for (int i = 0; i < controls.size(); ++i) {
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", FIELD_FLEX + i);
            mapHead.put("items", (String)controls.get(i).createControl().get("items"));
            items.add(mapHead);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs getEntityTypeEventArgs) {
        MainEntityType oldMainType = getEntityTypeEventArgs.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        getEntityTypeEventArgs.setNewEntityType(newMainType);
    }

    private boolean isPCView() {
        return this.isPCView(null);
    }

    private boolean isPCView(LoadCustomControlMetasArgs e) {
        String modelType = MODEL_TYPE_PC;
        if (e == null) {
            modelType = this.getView() == null ? this.getModelType() : this.getView().getFormShowParameter().getFormConfig().getModelType();
        } else {
            FormShowParameter formShowParameter = null;
            if (e.getSource() instanceof FormShowParameter) {
                formShowParameter = (FormShowParameter)e.getSource();
                modelType = formShowParameter.getFormConfig().getModelType();
            }
        }
        return MODEL_TYPE_PC.equals(modelType);
    }

    public void onGetControl(OnGetControlArgs controlArgs) {
        String key;
        List<AddressFieldMetadata> fields = this.buildAddressFieldMetas();
        Map keyMap = fields.stream().collect(Collectors.toMap(AddressFieldMetadata::getFieldKey, Function.identity()));
        AddressFieldMetadata addressFieldMetadata = (AddressFieldMetadata)keyMap.get(key = controlArgs.getKey());
        if (addressFieldMetadata == null) {
            return;
        }
        String fieldKey = addressFieldMetadata.getFieldKey();
        AddressFiledTypeEnum fieldType = addressFieldMetadata.getFieldType();
        String baseDataEntityId = addressFieldMetadata.getBaseDataEntityId();
        List<QFilter> qFilters = addressFieldMetadata.getqFilters();
        String priviousKey = addressFieldMetadata.getPriviousKey();
        if (AddressFiledTypeEnum.TEXT == fieldType) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(fieldKey);
            textEdit.setView(this.getView());
            controlArgs.setControl((Control)textEdit);
        }
        if (AddressFiledTypeEnum.DECIMAL == fieldType) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(fieldKey);
            decimalEdit.setView(this.getView());
            controlArgs.setControl((Control)decimalEdit);
        }
        if (AddressFiledTypeEnum.BASEDATA == fieldType) {
            BasedataEdit basedataEdit = new BasedataEdit();
            basedataEdit.setKey(fieldKey);
            basedataEdit.setF7Click(true);
            basedataEdit.setF7BatchFill(true);
            basedataEdit.setFieldKey(fieldKey);
            basedataEdit.setItemByNumber(baseDataEntityId);
            basedataEdit.setF7MultipleSelect(true);
            basedataEdit.setView(this.getView());
            basedataEdit.setModel(this.getModel());
            basedataEdit.setShowUsed(true);
            basedataEdit.setDisplayProp(NAME);
            basedataEdit.setEditSearchProp(NUMBER);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilters);
            if (priviousKey != null) {
                this.handlePriviousKey(addressFieldMetadata, priviousKey, qFilterList);
            }
            basedataEdit.setQFilters(qFilterList);
            controlArgs.setControl((Control)basedataEdit);
        }
    }

    private void makeMapCanMarkerDraggable() {
        String selectProperties = "id,enablemap";
        QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET_NUMBER);
        DynamicObject advanceAddress = BusinessDataServiceHelper.loadSingleFromCache((String)ADVANCE_ADDRESS_CONFIG, (String)selectProperties, (QFilter[])advanceAddressQFilter.toArray());
        if (advanceAddress != null && advanceAddress.getBoolean("enablemap")) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("canMarkerDraggble", Boolean.TRUE);
            dataMap.put("k", MAP_CONTROL_AP);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("u", dataMap);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MAP_CONTROL_AP});
        }
    }

    private void getInfo() {
        final IDataModel iDataModel = this.getView().getModel();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            MapControl mapCtl = (MapControl)this.getView().getControl(MAP_CONTROL_AP);
            mapCtl.addSelectListener(new MapSelectListener(){

                public void select(MapSelectEvent evt) {
                    try {
                        AddressInfoDynamicFieldPagePlugin.this.clearAllText();
                        AddressInfoDynamicFieldPagePlugin.this.setSelectData(evt.getPoint(), iDataModel);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    super.select(evt);
                }
            });
        }
    }

    private void clearAllText() {
        List<AddressFieldMetadata> list = this.buildAddressFieldMetas();
        for (AddressFieldMetadata metadata : list) {
            this.getModel().setValue(metadata.getFieldKey(), null);
        }
    }

    private void setSelectData(Map<String, Object> map, IDataModel iDataModel) throws JsonProcessingException {
        String location = null;
        Object pointObj = map.get("point");
        if (pointObj instanceof HashMap) {
            HashMap point = (HashMap)pointObj;
            location = point.get("lat") + "," + point.get("lng");
        }
        if (map.containsKey(LAT) && map.containsKey(LNG)) {
            location = map.get(LAT) + "," + map.get(LNG);
        }
        if (StringUtils.isNotBlank(location)) {
            String selectProperties = "id,mapconfigentry.id,mapconfigentry.mapkey,mapconfigentry.mapurl,mapconfigentry.mapconfigtype,mapfieldmappingentry.id,mapfieldmappingentry.addressconfigfield,mapfieldmappingentry.mapinterfacefield,mapfieldmappingentry.admindivisionnumber";
            QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET_NUMBER);
            DynamicObject advanceAddress = BusinessDataServiceHelper.loadSingleFromCache((String)ADVANCE_ADDRESS_CONFIG, (String)selectProperties, (QFilter[])advanceAddressQFilter.toArray());
            DynamicObject mapConfig = null;
            for (DynamicObject dynamicObject : advanceAddress.getDynamicObjectCollection(MAP_CONFIG_ENTRY)) {
                if (!"1".equals(dynamicObject.getString("mapconfigtype"))) continue;
                mapConfig = dynamicObject;
            }
            assert (mapConfig != null);
            String mapKey = mapConfig.getString("mapkey");
            String mapUrl = mapConfig.getString("mapurl");
            if (StringUtils.isBlank((CharSequence)mapKey) || StringUtils.isBlank((CharSequence)mapUrl)) {
                return;
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("location", location);
            param.put("ak", mapKey);
            param.put("output", "json");
            String result = HttpClientUtils.get((String)mapUrl, param);
            ObjectMapper jackson = new ObjectMapper();
            JsonNode node = jackson.readTree(result).get("result");
            HashMap<String, String> resultMap = new HashMap<String, String>();
            AddressInfoDynamicFieldPagePlugin.jsonLeaf(resultMap, null, node);
            HashMap<String, String> valueMap = new HashMap<String, String>(16);
            List<AddressFieldMetadata> fields = this.buildAddressFieldMetas();
            Set propertyMap = fields.stream().map(AddressFieldMetadata::getFieldKey).collect(Collectors.toSet());
            String address = (String)map.get("address");
            if (StringUtils.isNotBlank((CharSequence)address)) {
                String province = (String)resultMap.get("addressComponent.province");
                String city = (String)resultMap.get("addressComponent.city");
                String district = (String)resultMap.get("addressComponent.district");
                province = province == null ? "" : province;
                city = city == null ? "" : city;
                district = district == null ? "" : district;
                address = address.replaceFirst(province, "");
                address = address.replaceFirst(city, "");
                address = address.replaceFirst(district, "");
                if (propertyMap.contains("detail")) {
                    iDataModel.setValue("detail", (Object)address);
                }
            }
            this.getPageCache().put(SAVE_VALUE_CACHE, null);
            for (DynamicObject mapping : advanceAddress.getDynamicObjectCollection(MAP_FIELD_MAPPING_ENTRY)) {
                try {
                    String mapInterfaceField = mapping.getString("mapinterfacefield");
                    String[] split = mapInterfaceField.split("&");
                    StringBuilder builder = new StringBuilder();
                    for (String s : split) {
                        if (!StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(s)))) continue;
                        builder.append((String)resultMap.get(s));
                    }
                    String addressConfigField = mapping.getString("addressconfigfield");
                    if (addressConfigField.contains("admindivision")) {
                        String adminDivisionNumber = mapping.getString("admindivisionnumber");
                        QFilter admindivisionQFilter = new QFilter(adminDivisionNumber, "=", (Object)builder.toString());
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (String)"id,longnumber", (QFilter[])admindivisionQFilter.toArray());
                        if (dynamicObject == null) continue;
                        String longnumber = dynamicObject.getString(LONG_NUMBER);
                        String[] split1 = longnumber.split("\\.");
                        QFilter longnumberQFilter = new QFilter(NUMBER, "in", (Object)split1);
                        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)BD_ADMINDIVISION, (String)"id,longnumber", (QFilter[])longnumberQFilter.toArray(), (String)"level asc").values().toArray(new DynamicObject[0]);
                        for (int i = 0; i < dynamicObjects.length; ++i) {
                            if (propertyMap.contains(ADMIN_DIVISION_ID + (i + 1))) {
                                iDataModel.setValue(ADMIN_DIVISION_ID + (i + 1), (Object)dynamicObjects[i].getString("id"));
                                continue;
                            }
                            valueMap.put(ADMIN_DIVISION_ID + (i + 1), dynamicObjects[i].getString("id"));
                        }
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)builder.toString())) continue;
                    if (propertyMap.contains(addressConfigField)) {
                        iDataModel.setValue(addressConfigField, (Object)builder.toString());
                        continue;
                    }
                    valueMap.put(addressConfigField, builder.toString());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.getPageCache() != null && !valueMap.isEmpty()) {
                this.getPageCache().put(SAVE_VALUE_CACHE, SerializationUtils.toJsonString(valueMap));
            }
        }
    }

    private static void jsonLeaf(Map<String, String> map, String key, JsonNode node) {
        if (node.isValueNode()) {
            map.put(key, node.asText());
        }
        if (node.isObject()) {
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String newKey = (String)entry.getKey();
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    newKey = key + "." + newKey;
                }
                AddressInfoDynamicFieldPagePlugin.jsonLeaf(map, newKey, (JsonNode)entry.getValue());
            }
        }
        if (node.isArray()) {
            for (int i = 0; i < node.size(); ++i) {
                AddressInfoDynamicFieldPagePlugin.jsonLeaf(map, key + "[" + i + "]", node.get(i));
            }
        }
    }

    private void handlePriviousKey(AddressFieldMetadata addressFieldMetadata, String priviousKey, List<QFilter> qFilterList) {
        if (priviousKey.equals(COUNTRY)) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                DynamicObject country = (DynamicObject)parentView.getModel().getValue(COUNTRY);
                Object value = country.getPkValue();
                QFilter qFilter = new QFilter(COUNTRY, "=", value);
                qFilterList.add(qFilter);
            }
        } else {
            int adminDivisionLevel = addressFieldMetadata.getAdminDivisionLevel();
            List<AddressFieldMetadata> addressFieldMetadataList = this.buildAddressFieldMetas();
            List adminDivisionList = addressFieldMetadataList.stream().filter(metadata -> metadata.getAdminDivisionLevel() > 0).collect(Collectors.toList());
            for (int i = adminDivisionList.size() - 1; i >= 0; --i) {
                DynamicObject parentVal;
                AddressFieldMetadata adminDivision = (AddressFieldMetadata)adminDivisionList.get(i);
                if (adminDivision.getAdminDivisionLevel() >= adminDivisionLevel || (parentVal = (DynamicObject)this.getModel().getValue(adminDivision.getFieldKey())) == null) continue;
                List<Long> idList = AddressUtil.getChildIdListByAdminDivisonIdAndLevel((Long)parentVal.getPkValue(), adminDivision.getAdminDivisionLevel(), adminDivisionLevel);
                qFilterList.add(new QFilter("id", "in", idList));
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                DynamicObject country = (DynamicObject)parentView.getModel().getValue(COUNTRY);
                Object value = country.getPkValue();
                QFilter qFilter = new QFilter(COUNTRY, "=", value);
                qFilterList.add(qFilter);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        int size;
        if (this.getView().getFormShowParameter().getCustomParam(EDIT_ADDRESS_ID) != null) {
            this.getPageCache().put(PAGE_STATUS, EDIT_STATUS);
        } else {
            this.getPageCache().put(PAGE_STATUS, CREATE_STATUS);
        }
        List<AddressFieldMetadata> fields = this.buildAddressFieldMetas();
        List<FlexPanelAp> controls = this.flexPanelList(fields);
        for (int i = 0; i < controls.size(); ++i) {
            Container container = (Container)this.getView().getControl(FIELD_FLEX + i);
            List items = container.getItems();
            Container container1 = (Container)controls.get(i).buildRuntimeControl();
            items.addAll(container1.getItems());
            this.getView().createControlIndex(container.getItems());
        }
        for (int i = size = controls.size(); i <= 13; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_FLEX + i});
        }
        this.makeMapCanMarkerDraggable();
        this.initAdminDivisionMustInput();
    }

    private void initAdminDivisionMustInput() {
        block10: {
            AddressFieldMetadata adminDivisionField;
            int i;
            ArrayList<AddressFieldMetadata> adminDivisionList = new ArrayList<AddressFieldMetadata>();
            for (AddressFieldMetadata addressField : this.buildAddressFieldMetas()) {
                if (addressField.getAdminDivisionLevel() <= 0) continue;
                adminDivisionList.add(addressField);
            }
            adminDivisionList.sort(Comparator.comparingInt(AddressFieldMetadata::getAdminDivisionLevel));
            if (adminDivisionList.size() <= 0) break block10;
            int index = -1;
            DynamicObject parentVal = null;
            for (i = adminDivisionList.size() - 1; i >= 0; --i) {
                adminDivisionField = (AddressFieldMetadata)adminDivisionList.get(i);
                DynamicObject adminDivisionVal = (DynamicObject)this.getModel().getValue(adminDivisionField.getFieldKey());
                if (adminDivisionVal == null || !adminDivisionVal.getBoolean(ENABLE)) continue;
                index = i;
                parentVal = adminDivisionVal;
                break;
            }
            if (index == -1) {
                if (this.getView().getParentView() == null) {
                    return;
                }
                DynamicObject country = (DynamicObject)this.getView().getParentView().getModel().getValue(COUNTRY);
                Long countryId = (Long)country.getPkValue();
                for (AddressFieldMetadata adminDivisionField2 : adminDivisionList) {
                    if (!adminDivisionField2.getMustInput().booleanValue()) continue;
                    if (!this.hasChildLevelAdminDivision(countryId, adminDivisionField2.getAdminDivisionLevel())) {
                        this.updateControlMustInput(adminDivisionField2.getFieldKey(), false);
                        continue;
                    }
                    this.updateControlMustInput(adminDivisionField2.getFieldKey(), true);
                }
            } else {
                for (i = 0; i < adminDivisionList.size(); ++i) {
                    String parentNumber;
                    adminDivisionField = (AddressFieldMetadata)adminDivisionList.get(i);
                    if (!adminDivisionField.getMustInput().booleanValue()) continue;
                    if (i <= index) {
                        this.updateControlMustInput(adminDivisionField.getFieldKey(), true);
                        continue;
                    }
                    String string = parentNumber = parentVal != null ? parentVal.getString(NUMBER) : " ";
                    if (!this.hasChildLevelAdminDivision(parentNumber, adminDivisionField.getAdminDivisionLevel())) {
                        this.updateControlMustInput(adminDivisionField.getFieldKey(), false);
                        continue;
                    }
                    this.updateControlMustInput(adminDivisionField.getFieldKey(), true);
                }
            }
        }
    }

    private boolean hasChildLevelAdminDivision(String parentNum, int childLevel) {
        QFilter numberFilter = new QFilter(LONG_NUMBER, "like", (Object)("%." + parentNum + ".%")).or(new QFilter(LONG_NUMBER, "like", (Object)(parentNum + ".%")));
        QFilter levelFilter = new QFilter(LEVEL, "=", (Object)childLevel);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        DynamicObject[] dy = BusinessDataServiceHelper.load((String)BD_ADMINDIVISION, (String)"", (QFilter[])new QFilter[]{numberFilter, levelFilter, enableFilter});
        return dy.length != 0;
    }

    private boolean hasChildLevelAdminDivision(Long countryId, int childLevel) {
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)countryId);
        QFilter levelFilter = new QFilter(LEVEL, "=", (Object)childLevel);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        DynamicObject[] dy = BusinessDataServiceHelper.load((String)BD_ADMINDIVISION, (String)"", (QFilter[])new QFilter[]{countryFilter, levelFilter, enableFilter});
        return dy.length != 0;
    }

    private void updateControlMustInput(String key, boolean mustInput) {
        HashMap<String, Map<String, Boolean>> map = new HashMap<String, Map<String, Boolean>>();
        map.put(ITEM, Collections.singletonMap("mi", mustInput));
        this.getView().updateControlMetadata(key, map);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List<AddressFieldMetadata> addressFields = this.buildAddressFieldMetas();
        for (int i = 0; i < addressFields.size(); ++i) {
            String fieldKey = addressFields.get(i).getFieldKey();
            String fieldName = addressFields.get(i).getFieldName();
            Boolean mustInput = addressFields.get(i).getMustInput();
            AddressFiledTypeEnum fieldType = addressFields.get(i).getFieldType();
            String baseDataEntityId = addressFields.get(i).getBaseDataEntityId();
            if (AddressFiledTypeEnum.TEXT == fieldType) {
                TextProp textProp = new TextProp();
                textProp.setName(fieldKey);
                textProp.setDbIgnore(true);
                if (this.isPCView()) {
                    textProp.setMinLenth(MINLENGTH.intValue());
                    textProp.setMaxLenth(MAXLENGTH.intValue());
                }
                textProp.setMustInput(mustInput.booleanValue());
                textProp.setDisplayName(new LocaleString(fieldName));
                newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
            if (AddressFiledTypeEnum.DECIMAL == fieldType) {
                DecimalProp decimalProp = new DecimalProp();
                decimalProp.setName(fieldKey);
                decimalProp.setDbIgnore(true);
                decimalProp.setMustInput(mustInput.booleanValue());
                decimalProp.setDisplayName(new LocaleString(fieldName));
                if (LNG.equals(fieldKey)) {
                    decimalProp.setDataScope("[-180,180]");
                    decimalProp.setMin(new BigDecimal(-180));
                    decimalProp.setMax(new BigDecimal(180));
                    decimalProp.setInclMin(true);
                    decimalProp.setInclMax(true);
                    decimalProp.setPrecision(21);
                    decimalProp.setScale(8);
                } else if (LAT.equals(fieldKey)) {
                    decimalProp.setDataScope("[-90,90]");
                    decimalProp.setMin(new BigDecimal(-90));
                    decimalProp.setMax(new BigDecimal(90));
                    decimalProp.setInclMin(true);
                    decimalProp.setInclMax(true);
                    decimalProp.setPrecision(21);
                    decimalProp.setScale(8);
                }
                newMainType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
            }
            if (AddressFiledTypeEnum.BASEDATA != fieldType) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseDataEntityId);
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setName(fieldKey);
            basedataProp.setDisplayName(new LocaleString(fieldName));
            basedataProp.setBaseEntityId(dataEntityType.getName());
            basedataProp.setDbIgnore(false);
            basedataProp.setDisplayProp(NAME);
            basedataProp.setNumberProp(NUMBER);
            LongProp idProp = new LongProp();
            idProp.setName(fieldKey + ID);
            idProp.setDbIgnore(true);
            basedataProp.setRefIdProp((IDataEntityProperty)idProp);
            basedataProp.setRefIdProp((IDataEntityProperty)idProp);
            basedataProp.setRefIdPropName(idProp.getName());
            basedataProp.setComplexType((IDataEntityType)dataEntityType);
            newMainType.addProperty((DynamicProperty)idProp);
            newMainType.addProperty((DynamicProperty)basedataProp);
        }
    }

    private List<FlexPanelAp> flexPanelList(List<AddressFieldMetadata> addressFields) {
        return this.flexPanelList(addressFields, null);
    }

    private List<FlexPanelAp> flexPanelList(List<AddressFieldMetadata> addressFields, LoadCustomControlMetasArgs e) {
        ArrayList<FlexPanelAp> flexPanelList = new ArrayList<FlexPanelAp>(15);
        FlexPanelAp flex = new FlexPanelAp();
        for (int i = 0; i < addressFields.size(); ++i) {
            if (i == 0 || i > 0 && addressFields.get(i).getNextLine().booleanValue()) {
                flex = new FlexPanelAp();
                flex.setKey(PANEL);
                flexPanelList.add(flex);
                if (i == 0) {
                    Style style = new Style();
                    Margin margin = new Margin();
                    margin.setBottom("50px");
                    margin.setTop("50px");
                    style.setMargin(margin);
                    flex.setStyle(style);
                }
            }
            List items = flex.getItems();
            String fieldKey = addressFields.get(i).getFieldKey();
            String fieldName = addressFields.get(i).getFieldName();
            Boolean mustInput = addressFields.get(i).getMustInput();
            AddressFiledTypeEnum fieldType = addressFields.get(i).getFieldType();
            String baseDataEntityId = addressFields.get(i).getBaseDataEntityId();
            AddressFieldLengthEnum fieldLength = addressFields.get(i).getFieldLength();
            if (AddressFiledTypeEnum.TEXT == fieldType) {
                FieldAp textField = this.textField(fieldKey, fieldName, fieldLength, mustInput, e);
                items.add(textField);
            }
            if (AddressFiledTypeEnum.DECIMAL == fieldType && this.isPCView(e)) {
                FieldAp decimalField = this.decimalField(fieldKey, fieldName, fieldLength, mustInput, e);
                items.add(decimalField);
            }
            if (AddressFiledTypeEnum.BASEDATA != fieldType) continue;
            FieldAp basedataField = this.basedataField(fieldKey, fieldName, baseDataEntityId, fieldLength, mustInput, e);
            items.add(basedataField);
        }
        return flexPanelList;
    }

    private FieldAp basedataField(String key, String name, String formid, AddressFieldLengthEnum length, Boolean mustInput, LoadCustomControlMetasArgs e) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        if (this.isPCView(e)) {
            fieldAp.setWidth(new LocaleString("230px"));
        }
        fieldAp.setFontSize(FONTSIZE.intValue());
        fieldAp.setFieldFontSize(FONTSIZE.intValue());
        fieldAp.setFireUpdEvt(true);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setQuickAddNew(false);
        BasedataField basedataField = new BasedataField();
        basedataField.setId(key);
        basedataField.setAllowAutoList(true);
        basedataField.setCacheLookUpList(true);
        basedataField.setKey(key);
        basedataField.setBaseEntityId(formid);
        basedataField.setMustInput(mustInput.booleanValue());
        basedataField.setName(new LocaleString(name));
        basedataField.setBaseEntityId(formid);
        basedataField.setCacheLookUpList(true);
        fieldAp.setField((Field)basedataField);
        if (this.isPCView(e)) {
            if (AddressFieldLengthEnum.MEDIUM == length) {
                fieldAp.setWidth(new LocaleString("490px"));
            }
            if (AddressFieldLengthEnum.LONG == length) {
                fieldAp.setWidth(new LocaleString("750px"));
            }
        }
        return fieldAp;
    }

    private FieldAp textField(String key, String name, AddressFieldLengthEnum length, Boolean mustInput, LoadCustomControlMetasArgs e) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        if (this.isPCView(e)) {
            fieldAp.setWidth(new LocaleString("230px"));
        }
        fieldAp.setFontSize(FONTSIZE.intValue());
        fieldAp.setFieldFontSize(FONTSIZE.intValue());
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        TextField field = new TextField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput.booleanValue());
        field.setName(new LocaleString(name));
        field.setMinLength(MINLENGTH.intValue());
        Map<String, Long> fieldLength = AddressImportPlugin.fieldLength;
        if (this.isPCView(e)) {
            Long maxLength = fieldLength.get(key);
            field.setMaxLength(maxLength != null ? maxLength.intValue() : MAXLENGTH.intValue());
            if (AddressFieldLengthEnum.MEDIUM == length) {
                fieldAp.setWidth(new LocaleString("490px"));
            }
            if (AddressFieldLengthEnum.LONG == length) {
                fieldAp.setWidth(new LocaleString("750px"));
            }
        }
        fieldAp.setField((Field)field);
        return fieldAp;
    }

    private FieldAp decimalField(String key, String name, AddressFieldLengthEnum length, Boolean mustInput, LoadCustomControlMetasArgs e) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setWidth(new LocaleString("230px"));
        fieldAp.setFontSize(FONTSIZE.intValue());
        fieldAp.setFieldFontSize(FONTSIZE.intValue());
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        DecimalField field = new DecimalField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput.booleanValue());
        field.setName(new LocaleString(name));
        if (LNG.equals(key)) {
            field.setDataScope("[-180,180]");
            field.setPrecision(21);
            field.setScale(8);
            field.setZeroShow(false);
        } else if (LAT.equals(key)) {
            field.setDataScope("[-90,90]");
            field.setPrecision(21);
            field.setScale(8);
            field.setZeroShow(false);
        }
        fieldAp.setField((Field)field);
        if (AddressFieldLengthEnum.MEDIUM == length) {
            fieldAp.setWidth(new LocaleString("490px"));
        }
        if (AddressFieldLengthEnum.LONG == length) {
            fieldAp.setWidth(new LocaleString("750px"));
        }
        return fieldAp;
    }

    private List<AddressFieldMetadata> buildAddressFieldMetas() {
        return AddressUtil.buildAddressFieldMetas(this.getView().getFormShowParameter(), this.getPageCache());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List<AddressFieldMetadata> addressFieldMetadatas = this.buildAddressFieldMetas();
        Map addressFieldMetadataMap = addressFieldMetadatas.stream().collect(Collectors.toMap(AddressFieldMetadata::getFieldKey, Function.identity()));
        String propertyName = evt.getProperty().getName();
        if (StringUtils.isNotBlank((CharSequence)propertyName) && propertyName.contains(ADMIN_DIVISION_ID)) {
            evt.getFormShowParameter().setFormId(F7_LIST_FORM_ID);
        }
    }

    private void setPropertyValueCache(String name, Object newValue) {
        if (this.getView().getParentView() == null) {
            return;
        }
        Map map = null;
        IPageCache iPageCache = this.getView().getParentView().getPageCache();
        String valueCache = iPageCache.get(PROPERTY_VALUE_CACHE);
        map = null == valueCache ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)valueCache, Map.class);
        if (newValue instanceof DynamicObject) {
            map.put(name, ((DynamicObject)newValue).get("id"));
        } else {
            map.put(name, newValue);
        }
        iPageCache.put(PROPERTY_VALUE_CACHE, SerializationUtils.toJsonString(map));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        this.setPropertyValueCache(name, e.getChangeSet()[0].getNewValue());
        if (LAT.equals(name)) {
            this.logChangingInPageCache(ChangedEnum.LNG_OR_LAT_CHANGED);
        } else if (LNG.equals(name)) {
            this.logChangingInPageCache(ChangedEnum.LNG_OR_LAT_CHANGED);
        }
        if (Arrays.stream(NOT_BELONG_ADDRESS_FIELDS).noneMatch(item -> item.equals(name))) {
            this.logChangingInPageCache(ChangedEnum.ADDRESS_CHANGED);
        }
        if (admindivisions.contains(name)) {
            this.getPageCache().put(ADMIN_DIVISION_CHANGED, "true");
            this.adminDivisionChange(name);
            this.initAdminDivisionMustInput();
        }
    }

    private void adminDivisionChange(String name) {
        this.getModel().beginInit();
        AddressFieldMetadata adminDivision = null;
        ArrayList<AddressFieldMetadata> adminDivisionList = new ArrayList<AddressFieldMetadata>();
        List<AddressFieldMetadata> addressFieldList = this.buildAddressFieldMetas();
        for (int i = 0; i < addressFieldList.size(); ++i) {
            AddressFieldMetadata addressField = addressFieldList.get(i);
            if (addressField.getAdminDivisionLevel() <= 0) continue;
            adminDivisionList.add(addressField);
        }
        adminDivisionList.sort(Comparator.comparingInt(AddressFieldMetadata::getAdminDivisionLevel));
        int index = -1;
        for (int i = 0; i < adminDivisionList.size(); ++i) {
            AddressFieldMetadata adminDivisionField = (AddressFieldMetadata)adminDivisionList.get(i);
            if (!adminDivisionField.getFieldKey().equals(name)) continue;
            adminDivision = adminDivisionField;
            index = i;
        }
        if (adminDivision != null) {
            DynamicObject adminDivisionVal = (DynamicObject)this.getModel().getValue(adminDivision.getFieldKey());
            if (adminDivisionVal == null) {
                for (int i = index; i < adminDivisionList.size(); ++i) {
                    this.setAdminDivisionVal(((AddressFieldMetadata)adminDivisionList.get(i)).getFieldKey(), null);
                }
            } else {
                int i;
                for (i = 0; i < index; ++i) {
                    AddressFieldMetadata parentAdminDivision = (AddressFieldMetadata)adminDivisionList.get(i);
                    DynamicObject parentAdminDivisionVal = this.getParentAdminDivision(parentAdminDivision.getAdminDivisionLevel(), adminDivisionVal);
                    this.setAdminDivisionVal(parentAdminDivision.getFieldKey(), parentAdminDivisionVal);
                }
                for (i = index + 1; i < adminDivisionList.size(); ++i) {
                    AddressFieldMetadata childAdminDivision = (AddressFieldMetadata)adminDivisionList.get(i);
                    DynamicObject childAdminDivisionVal = (DynamicObject)this.getModel().getValue(childAdminDivision.getFieldKey());
                    if (childAdminDivisionVal != null) {
                        if (this.hasParentChildRelation(adminDivisionVal, childAdminDivisionVal)) continue;
                        this.setAdminDivisionVal(childAdminDivision.getFieldKey(), null);
                        continue;
                    }
                    break;
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void setAdminDivisionVal(String fieldKey, Object val) {
        this.setPropertyValueCache(fieldKey, val);
        this.getModel().setValue(fieldKey, val);
    }

    private boolean hasParentChildRelation(DynamicObject parent, DynamicObject child) {
        String childLongNumber = child.getString(LONG_NUMBER);
        String parentLongNumber = parent.getString(LONG_NUMBER);
        return childLongNumber.contains("." + parentLongNumber + ".") || childLongNumber.startsWith(parentLongNumber + ".");
    }

    private DynamicObject getParentAdminDivision(int level, DynamicObject adminDivisionVal) {
        String longNumber = adminDivisionVal.getString(LONG_NUMBER);
        String[] numberArray = longNumber.split("\\.");
        String number = numberArray[level - 1];
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter levelFilter = new QFilter(LEVEL, "=", (Object)level);
        DynamicObject adminDivision = BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter[]{numberFilter, levelFilter});
        return adminDivision;
    }

    private void logChangingInPageCache(Enum<ChangedEnum> changedEnum) {
        if (this.interestToShowLatTip()) {
            this.getPageCache().put(changedEnum.name(), Boolean.TRUE.toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (ChangedEnum.ADDRESS_CHANGED.name().equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.tryCloseView();
            } else {
                DecimalEdit decimalEdit = (DecimalEdit)this.getControl(LNG);
                decimalEdit.setFocus(true);
            }
        } else if (ChangedEnum.LNG_OR_LAT_CHANGED.name().equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.tryCloseView();
            } else {
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl("admindivisionid1");
                basedataEdit.setFocus(true);
            }
        }
    }

    private void tryCloseView() {
        if (AddressUtil.saveAddress(this.getPageCache(), this.getView(), this.getModel(), this.isPCView())) {
            this.getView().close();
        }
    }

    private Map<Boolean, String> isShowConfirmPage() {
        boolean isLatOrLngChanged;
        HashMap<Boolean, String> result = new HashMap<Boolean, String>(1);
        boolean isAddressChanged = Optional.ofNullable(this.getPageCache().get(ChangedEnum.ADDRESS_CHANGED.name())).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
        boolean val = isAddressChanged ^ (isLatOrLngChanged = Optional.ofNullable(this.getPageCache().get(ChangedEnum.LNG_OR_LAT_CHANGED.name())).map(Boolean::parseBoolean).orElse(Boolean.FALSE).booleanValue());
        if (val && isAddressChanged) {
            result.put(Boolean.TRUE, ChangedEnum.ADDRESS_CHANGED.name());
        } else if (val) {
            result.put(Boolean.TRUE, ChangedEnum.LNG_OR_LAT_CHANGED.name());
        } else {
            result.put(Boolean.FALSE, null);
        }
        return result;
    }

    static {
        admindivisions.add("countryid");
        admindivisions.add("admindivisionid1");
        admindivisions.add("admindivisionid2");
        admindivisions.add("admindivisionid3");
        admindivisions.add("admindivisionid4");
        admindivisions.add("admindivisionid5");
        admindivisions.add("admindivisionid6");
        NOT_BELONG_ADDRESS_FIELDS = new String[]{"configid", "countryid", LAT, LNG};
    }

    static enum ChangedEnum {
        ADDRESS_CHANGED,
        LNG_OR_LAT_CHANGED;

    }
}

