/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class AddressListPlugin
extends AbstractListPlugin {
    private static final String EDIT_ADDRESS_ID = "editAddressId";
    private static final String ADDRESS_INFO_PAGE = "address_info_page";
    private static final String FROM = "from";
    private static final String HYPERLINK = "HyperLink";
    private static final String VALID = "valid";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String ADDRESS_CHECK = "address_check";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"address", (int)1);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object primaryKeyValue = hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam(EDIT_ADDRESS_ID, primaryKeyValue);
        formShowParameter.setFormId(ADDRESS_INFO_PAGE);
        formShowParameter.setCustomParam(FROM, (Object)HYPERLINK);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(openStyle);
        this.getView().showForm(formShowParameter);
        args.setCancel(true);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "address_check": {
                this.checkAddress();
                break;
            }
        }
    }

    private void checkAddress() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] addresses = BusinessDataServiceHelper.load((String)CTS_ADDRESS, (String)VALID, (QFilter[])qFilter.toArray());
        ArrayList updates = new ArrayList(1000);
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i].set(VALID, (Object)Character.valueOf('2'));
        }
        SaveServiceHelper.update((DynamicObject[])addresses);
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        billlistap.refresh();
        Runnable runnable = () -> {
            for (int i = 0; i < addresses.length; ++i) {
                DynamicObject address = addresses[i];
                boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)CTS_ADDRESS, (Object)address.getPkValue());
                address.set(VALID, (Object)Character.valueOf('1'));
                if (!refrenced) {
                    address.set(VALID, (Object)Character.valueOf('0'));
                }
                updates.add(address);
            }
            DynamicObject[] dynamicObjects = new DynamicObject[updates.size()];
            for (int i = 0; i < updates.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)updates.get(i);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        };
        threadPool.execute(runnable);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof StatusConvert && "disable".equals(operateKey = ((StatusConvert)args.getSource()).getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable", (IFormPlugin)this);
            confirmCallBacks.setView(this.getView());
            String tip = ResManager.loadKDString((String)"\u5220\u9664\u76f8\u5173\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5417\uff1f", (String)"AddressListPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("disable".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            HashSet<String> errorPkIds = new HashSet<String>(16);
            ArrayList<Object> successPkIds = new ArrayList<Object>(10);
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(10);
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)CTS_ADDRESS, (Object)primaryKeyValue);
                if (refrenced) {
                    errorPkIds.add(listSelectedRow.getNumber());
                    continue;
                }
                successPkIds.add(primaryKeyValue);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)CTS_ADDRESS);
                dynamicObject.set("id", primaryKeyValue);
                dynamicObject.set("enable", (Object)Character.valueOf('0'));
                dynamicObjects.add(dynamicObject);
            }
            if (errorPkIds.size() > 0) {
                OperationResult operationResult = new OperationResult();
                ValidateResultCollection validateResultCollection = new ValidateResultCollection();
                ValidateResult validateResult = new ValidateResult();
                validateResultCollection.addValidateError("disable", validateResult);
                validateResultCollection.setErrorPkIds(errorPkIds);
                ArrayList<OperateErrorInfo> operateErrorInfos = new ArrayList<OperateErrorInfo>(10);
                validateResult.setAllErrorInfo(operateErrorInfos);
                operationResult.setValidateResult(validateResultCollection);
                operationResult.setBillCount(selectedRows.size());
                for (Object e : errorPkIds) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setLevel(ErrorLevel.Error);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\u5730\u5740\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"AddressListPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]), e + ": "));
                    operateErrorInfos.add(errorInfo);
                }
                operationResult.setSuccessPkIds(successPkIds);
                this.getView().showOperationResult(operationResult);
            }
            if (successPkIds.size() != 0) {
                DynamicObject[] dys = new DynamicObject[successPkIds.size()];
                for (int i = 0; i < dynamicObjects.size(); ++i) {
                    dys[i] = (DynamicObject)dynamicObjects.get(i);
                }
                SaveServiceHelper.update((DynamicObject[])dys);
            }
        }
        this.getSelectedRows().clear();
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        billlistap.refresh();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AddressListDataProvider());
        super.beforeCreateListDataProvider(args);
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        e.setFilters(qFilter.toArray());
    }

    static class AddressListDataProvider
    extends ListDataProvider {
        AddressListDataProvider() {
        }

        public List<QFilter> getQFilters() {
            List qFilters = super.getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            return qFilters;
        }
    }
}

