/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.List;
import kd.bos.address.entity.AddressFieldMetadata;
import kd.bos.address.util.AddressUtil;
import kd.bos.address.validator.AddressSaveValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.id.ID;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;

public class AddressSaveServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String NAME = "name";
    private static final String CONFIG_ID = "configid";
    private static final String COUNTRY_ID = "countryid";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AddressSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            String name;
            String number;
            Object id = dynamicObject.get(ID);
            if (id == null) {
                id = kd.bos.id.ID.genLongId();
                dynamicObject.set(ID, id);
            }
            if (StringUtils.isEmpty((String)(number = dynamicObject.getString(NUMBER)))) {
                number = CodeRuleServiceHelper.getNumber((String)CTS_ADDRESS, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)CTS_ADDRESS), null);
                dynamicObject.set(NUMBER, (Object)number);
            }
            if (!StringUtils.isEmpty((String)(name = dynamicObject.getString(NAME)))) continue;
            Long addrConfigId = (Long)dynamicObject.getDynamicObject(CONFIG_ID).getPkValue();
            Long addrCountryId = (Long)dynamicObject.getDynamicObject(COUNTRY_ID).getPkValue();
            DynamicObject addrConfigDy = BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)"cts_addressconfig");
            List<AddressFieldMetadata> structMetadataList = AddressUtil.buildAddressFieldMetas(addrCountryId, addrConfigDy);
            name = AddressUtil.getFormatStr(structMetadataList, (Object)dynamicObject, addrConfigId, addrCountryId);
            dynamicObject.set(NAME, (Object)name);
        }
    }
}

