/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.address.util.HttpUtil;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.address.AddressCommitResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.AddressField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class AdvanceAddressConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(AdvanceAddressConfigPlugin.class);
    private static final String PROJECT_ID = "bos-address-formplugin";
    private static final String ADVANCE_ADDRESS_CONFIG = "cts_advance_address";
    private static final String SYSTEM_PRESET_NUMBER = "SYSTEM_PRESET";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String SYNC_STATUS = "syncstatus";
    private static final String SYNC_STATUS_UNSYNC = "0";
    private static final String SYNC_STATUS_SYNCING = "1";
    private static final String SYNC_STATUS_COMPLETE = "2";
    private static final String SYNC_STATUS_FAILED = "3";
    private static final String INIT_DATA = "initdata";
    private static final String MOVE_ADDRESS_DATA = "MoveAddressData";
    private static final String INIT_DATA_LOCK = "bos/cts/move_address/initData";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String MOVE_ADDRESS_ITEM_LOCK_PREFIX = "bos/cts/move_address/";
    private static final String OPERATE_TABLE = "operateTable";
    private static final String ADMINDIVISION_KEY_FIELD = "admindivisionKeyField";
    private static final String DETAILADDRESS_KEY_FIELD = "detailaddressKeyField";
    private static final String ADDRESS_KEY_FIELD = "addressKeyField";
    private static final String PK_FIELD = "pkField";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String COUNTRY = "country";
    private static final String CTS_ADVANCE_ADDRESS = "cts_advance_address";
    private static final String MESSAGE = "message";
    private static final String FROM_FORM = "fromForm";
    private static final String DETAIL = "detail";
    private static final String ADDRESS_CONFIG_ID = "addressConfigId";
    private static final String ADMINDIVISION = "admindivision";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ADMINDIVISION_ID = "admindivisionid";
    private static final String CTS_ADDRESSPRECONFIG = "cts_addresspreconfig";
    private static final String ADDRESS_CONFIG_FIELD = "addressconfigfield";
    private static final String MAP_FIELD_MAPPING_ENTRY = "mapfieldmappingentry";
    private static final String ADMINDIVISION_NUMBER = "admindivisionnumber";
    private static final String MAP_CONFIG_ENTRY = "mapconfigentry";
    private static final String SEQ = "seq";
    private static final String CONN_STATUS = "connstatus";
    private static final String ENABLE_MAP = "enablemap";
    private static final String ADVCONAP1 = "advconap1";
    private static final String ADVCONAP2 = "advconap2";
    private static final String OPEN = "open";
    private static final String AREACODE = "areacode";
    private static final String CONN_TEST = "conntest";
    private static final String MAP_KEY = "mapkey";
    private static final String MAP_URL = "mapurl";
    private static final String MAP_CONFIG_TYPE = "mapconfigtype";
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;
    private static final String ENABLE_FEATURE = "enablefeature";
    private static final String BILL_KEY = "billkey";
    private static final String ADMIN_DIVISION_KEY = "admindivisionkey";
    private static final String DETAIL_ADDRESS_KEY = "detailaddresskey";
    private static final String ADDRESS_KEY = "addresskey";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter formShowParameter = (BaseShowParameter)e.getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.EDIT);
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)SYSTEM_PRESET_NUMBER);
        DynamicObject advanceAddressConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"cts_advance_address", (String)ID, (QFilter[])qFilter.toArray());
        if (advanceAddressConfig != null) {
            formShowParameter.setPkId(advanceAddressConfig.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(SYNC_STATUS_SYNCING);
        typeList.add(SYNC_STATUS_FAILED);
        QFilter typeFilter = new QFilter(TYPE, "in", typeList);
        DynamicObject[] addressPreConfigArray = BusinessDataServiceHelper.load((String)CTS_ADDRESSPRECONFIG, (String)"number,name,type,basetype", (QFilter[])new QFilter[]{typeFilter});
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<Object> nameList = new ArrayList<Object>();
        keyList.add(ADMINDIVISION_ID);
        nameList.add(new LocaleString(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212", (String)"AdvanceAddressConfigPlugin_0", (String)PROJECT_ID, (Object[])new Object[0])));
        for (DynamicObject dy : addressPreConfigArray) {
            keyList.add(dy.getString(NUMBER));
            nameList.add((ILocaleString)dy.get(NAME));
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        int i = 0;
        for (String item : keyList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(LocaleString.fromMap((Map)((Map)nameList.get(i))));
            ++i;
            comboItem.setValue(item);
            comboItemList.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(ADDRESS_CONFIG_FIELD);
        comboEdit.setComboItems(comboItemList);
        ArrayList<ComboItem> adminNumbercomboItemList = new ArrayList<ComboItem>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)BD_ADMINDIVISION);
        Map entityTypeMap = mainEntityType.getAllEntities();
        for (Object entityType : entityTypeMap.values()) {
            if (!(entityType instanceof MainEntityType)) continue;
            Map propMap = entityType.getFields();
            for (Object prop : propMap.values()) {
                if (!(prop instanceof TextProp) || prop instanceof MuliLangTextProp) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(prop.getName());
                comboItem.setCaption(prop.getDisplayName());
                adminNumbercomboItemList.add(comboItem);
            }
        }
        ComboEdit adminNumberComboEdit = (ComboEdit)this.getControl(ADMINDIVISION_NUMBER);
        adminNumberComboEdit.setComboItems(adminNumbercomboItemList);
        for (DynamicObject mapFieldMappingEntryDy : this.getModel().getDataEntity().getDynamicObjectCollection(MAP_FIELD_MAPPING_ENTRY)) {
            int index = mapFieldMappingEntryDy.getInt(SEQ) - 1;
            if (ADMINDIVISION_ID.equals(mapFieldMappingEntryDy.getString(ADDRESS_CONFIG_FIELD))) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{ADMINDIVISION_NUMBER});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{ADMINDIVISION_NUMBER});
        }
        Boolean enableFeature = (Boolean)this.getModel().getValue(ENABLE_FEATURE);
        if (enableFeature.booleanValue()) {
            this.getView().setVisible(TRUE, new String[]{ENABLE_MAP, ADVCONAP1});
        } else {
            this.getView().setVisible(FALSE, new String[]{ENABLE_MAP, ADVCONAP1});
        }
        DynamicObjectCollection mapconfigentryColl = this.getModel().getEntryEntity(MAP_CONFIG_ENTRY);
        boolean lockEnableMap = false;
        for (DynamicObject mapConfigEntry : mapconfigentryColl) {
            String connStatus = mapConfigEntry.getString(CONN_STATUS);
            if (!SYNC_STATUS_SYNCING.equals(connStatus)) continue;
            lockEnableMap = true;
            break;
        }
        if (lockEnableMap) {
            this.getView().setEnable(FALSE, new String[]{ENABLE_MAP});
        } else {
            this.getView().setEnable(TRUE, new String[]{ENABLE_MAP});
        }
        Boolean enableMap = (Boolean)this.getModel().getValue(ENABLE_MAP);
        if (!enableMap.booleanValue()) {
            this.getView().setVisible(FALSE, new String[]{ADVCONAP2});
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ENABLE_FEATURE.equals(name)) {
            boolean newValue = Boolean.parseBoolean(e.getChangeSet()[0].getNewValue().toString());
            boolean oldValue = Boolean.parseBoolean(e.getChangeSet()[0].getOldValue().toString());
            if (newValue || !oldValue) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OPEN, (IFormPlugin)this);
                confirmCallBacks.setView(this.getView());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672c\u7279\u6027\u5f00\u542f\u540e\u5c06\u65e0\u6cd5\u5173\u95ed\uff0c\u786e\u8ba4\u542f\u7528\uff1f", (String)"AdvanceAddressConfigPlugin_1", (String)PROJECT_ID, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
            if (newValue) {
                this.getView().setVisible(TRUE, new String[]{ENABLE_MAP, ADVCONAP1});
            } else {
                this.getView().setVisible(FALSE, new String[]{ENABLE_MAP, ADVCONAP1});
            }
        } else if (ADDRESS_CONFIG_FIELD.equals(name)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (ADMINDIVISION_ID.equals(newValue)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{ADMINDIVISION_NUMBER});
                String admindivisionNumber = (String)this.getModel().getValue(ADMINDIVISION_NUMBER, rowIndex);
                if (StringUtils.isEmpty((String)admindivisionNumber)) {
                    this.getModel().setValue(ADMINDIVISION_NUMBER, (Object)AREACODE, rowIndex);
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{ADMINDIVISION_NUMBER});
                this.getModel().setValue(ADMINDIVISION_NUMBER, null, rowIndex);
            }
        } else if (ENABLE_MAP.equals(name)) {
            Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(newValue, new String[]{ADVCONAP2});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (MAP_FIELD_MAPPING_ENTRY.equals(e.getEntryProp().getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{ADMINDIVISION_NUMBER});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (OPEN.equals(callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u5730\u5740\u6570\u636e\u5e76\u8fd0\u884c\u3010\u6570\u636e\u521d\u59cb\u5316\u3011\u3002\u5982\u679c\u60a8\u6ca1\u6709\u6216\u4e0d\u9700\u8981\u8fc1\u79fb\u539f\u5730\u5740\u6570\u636e\uff0c\u8bf7\u5ffd\u7565\u3002", (String)"AdvanceAddressConfigPlugin_2", (String)PROJECT_ID, (Object[])new Object[0]), MessageBoxOptions.OK);
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.getModel().setValue(ENABLE_FEATURE, (Object)Boolean.FALSE);
            }
        } else if (ENABLE_MAP.equals(callBackId) && Objects.equals(ENABLE_MAP, messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue(ENABLE_MAP, (Object)TRUE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            StringBuilder messageBuilder = new StringBuilder();
            if (this.buildTipMessage(messageBuilder)) {
                args.setCancel(true);
                this.getView().showErrorNotification(messageBuilder.toString());
            }
        } else if (args.getSource() instanceof Donothing) {
            Donothing operation = (Donothing)args.getSource();
            String operateKey = operation.getOperateKey();
            if (CONN_TEST.equals(operateKey)) {
                DynamicObjectCollection mapConfigEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAP_CONFIG_ENTRY);
                int i = 0;
                boolean canEnableMap = true;
                for (DynamicObject mapConfig : mapConfigEntry) {
                    String mapKey = mapConfig.getString(MAP_KEY);
                    String mapUrl = mapConfig.getString(MAP_URL);
                    String mapConfigType = mapConfig.getString(MAP_CONFIG_TYPE);
                    boolean connStatus = HttpUtil.testConnection(mapConfigType, mapKey, mapUrl);
                    this.getModel().setValue(CONN_STATUS, (Object)(connStatus ? SYNC_STATUS_UNSYNC : SYNC_STATUS_SYNCING), i);
                    ++i;
                    if (connStatus) continue;
                    canEnableMap = false;
                }
                Boolean enableMap = (Boolean)this.getModel().getValue(ENABLE_MAP);
                if (canEnableMap && !enableMap.booleanValue()) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ENABLE_MAP, (IFormPlugin)this);
                    confirmCallBacks.setView(this.getView());
                    String confirmMessage = ResManager.loadKDString((String)"\u8fde\u63a5\u6210\u529f\u3002\u662f\u5426\u542f\u7528\u5730\u56fe\u7ec4\u4ef6\uff1f", (String)"AdvanceAddressConfigPlugin_3", (String)PROJECT_ID, (Object[])new Object[0]);
                    this.getView().showConfirm(confirmMessage, MessageBoxOptions.YesNo, confirmCallBacks);
                }
                if (!canEnableMap) {
                    String errorMessage = ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u53c2\u6570\u3002", (String)"AdvanceAddressConfigPlugin_4", (String)PROJECT_ID, (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorMessage);
                    this.getView().setEnable(FALSE, new String[]{ENABLE_MAP});
                    if (enableMap.booleanValue()) {
                        this.getModel().setValue(ENABLE_MAP, (Object)FALSE);
                    }
                } else {
                    this.getView().setEnable(TRUE, new String[]{ENABLE_MAP});
                }
            } else if (INIT_DATA.equals(operateKey)) {
                OperationResult result = this.getView().invokeOperation("save");
                if (!result.isSuccess()) {
                    args.setCancel(true);
                    return;
                }
                DynamicObject advanceAddressConfig = BusinessDataServiceHelper.loadSingle((Object)1235511229410241536L, (String)"cts_advance_address");
                if (advanceAddressConfig == null || advanceAddressConfig.getDynamicObjectCollection(ENTRY_ENTITY).size() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8981\u8fdb\u884c\u521d\u59cb\u5316\u7684\u5355\u636e\u548c\u5b57\u6bb5\u3002", (String)"AdvanceAddressConfigPlugin_5", (String)PROJECT_ID, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DLockInfo lockInfo = DLock.getLockInfo((String)INIT_DATA_LOCK);
                if (lockInfo == null) {
                    ThreadPools.executeOnceIncludeRequestContext((String)MOVE_ADDRESS_DATA, this::initData);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u6b63\u5728\u540e\u53f0\u521d\u59cb\u5316\uff0c\u5b8c\u6210\u540e\u5c06\u901a\u8fc7\u6d88\u606f\u4e2d\u5fc3\u901a\u77e5\u3002", (String)"AdvanceAddressConfigPlugin_6", (String)PROJECT_ID, (Object[])new Object[0]));
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u6b63\u5728\u521d\u59cb\u5316\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AdvanceAddressConfigPlugin_7", (String)PROJECT_ID, (Object[])new Object[0]));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        DLock lockInitData = DLock.create((String)INIT_DATA_LOCK, (String)"Address data migration");
        lockInitData.lock();
        try {
            DynamicObject preAddressConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)1234851804710225920L, (String)"cts_addressconfig");
            Set validCountryId = preAddressConfig.getDynamicObjectCollection(COUNTRY).stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            DynamicObject advanceAddressConfig = BusinessDataServiceHelper.loadSingle((Object)1235511229410241536L, (String)"cts_advance_address");
            if (advanceAddressConfig == null) {
                return;
            }
            DynamicObjectCollection mapMoveEntry = advanceAddressConfig.getDynamicObjectCollection(ENTRY_ENTITY);
            ArrayList<String> itemExecInfo = new ArrayList<String>();
            for (Object mapMove : mapMoveEntry) {
                String billKey = mapMove.getDynamicObject(BILL_KEY).getString(NUMBER);
                String admindivisionKey = mapMove.getString(ADMIN_DIVISION_KEY);
                String detailaddressKey = mapMove.getString(DETAIL_ADDRESS_KEY);
                String syncStatus = mapMove.getString(SYNC_STATUS);
                if (SYNC_STATUS_COMPLETE.equals(syncStatus)) {
                    String errorStatus = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u672a\u505a\u540c\u6b65\uff0c\u6761\u76ee\u72b6\u6001\u4e3a\u4e0d\u9700\u8981\u540c\u6b65\u3002", (String)"AdvanceAddressConfigPlugin_9", (String)PROJECT_ID, (Object[])new Object[0]);
                    String itemErrorInfo = String.format(errorStatus, billKey, admindivisionKey, detailaddressKey);
                    itemExecInfo.add(itemErrorInfo);
                    continue;
                }
                Long entryId = (Long)mapMove.getPkValue();
                DLock lock = DLock.create((String)(MOVE_ADDRESS_ITEM_LOCK_PREFIX + entryId), (String)("Address is migrating entries:" + entryId));
                boolean tryLock = lock.tryLock();
                if (!tryLock) {
                    String errorLockNotAcquire = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u672a\u505a\u540c\u6b65\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u3002", (String)"AdvanceAddressConfigPlugin_10", (String)PROJECT_ID, (Object[])new Object[0]);
                    String itemErrorInfo = String.format(errorLockNotAcquire, billKey, admindivisionKey, detailaddressKey);
                    itemExecInfo.add(itemErrorInfo);
                    continue;
                }
                try {
                    mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_SYNCING);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                    String entityId = MetadataDao.getIdByNumber((String)billKey, (MetaCategory)MetaCategory.Entity);
                    EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                    Map<String, String> tableFieldInfoMap = this.getTableFieldInfo((DynamicObject)mapMove, entityMetadata);
                    if (tableFieldInfoMap.size() == 0) {
                        String errorGetTableInfoFailed = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u83b7\u53d6\u8868\u7ed3\u6784\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdvanceAddressConfigPlugin_11", (String)PROJECT_ID, (Object[])new Object[0]);
                        String itemErrorInfo = String.format(errorGetTableInfoFailed, billKey, admindivisionKey, detailaddressKey);
                        itemExecInfo.add(itemErrorInfo);
                        mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_FAILED);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                        continue;
                    }
                    String operateTable = tableFieldInfoMap.get(OPERATE_TABLE);
                    String admindivisionKeyField = tableFieldInfoMap.get(ADMINDIVISION_KEY_FIELD);
                    String detailaddressKeyField = tableFieldInfoMap.get(DETAILADDRESS_KEY_FIELD);
                    String addressKeyField = tableFieldInfoMap.get(ADDRESS_KEY_FIELD);
                    String pkField = tableFieldInfoMap.get(PK_FIELD);
                    String selectSql = String.format("select %s,%s from %s where %s = 0", pkField, admindivisionKeyField, operateTable, addressKeyField);
                    if (StringUtils.isNotEmpty((String)detailaddressKeyField)) {
                        selectSql = String.format("select %s,%s,%s from %s where %s = 0", pkField, admindivisionKeyField, detailaddressKeyField, operateTable, addressKeyField);
                    }
                    if (StringUtils.isEmpty((String)detailaddressKeyField) && StringUtils.isNotEmpty((String)detailaddressKey)) {
                        String errorGetTableInfoFailed = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u8be5\u5355\u636e\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"AdvanceAddressConfigPlugin_24", (String)PROJECT_ID, (Object[])new Object[0]);
                        String itemErrorInfo = String.format(errorGetTableInfoFailed, billKey, admindivisionKey, detailaddressKey);
                        itemExecInfo.add(itemErrorInfo);
                        mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_FAILED);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                        continue;
                    }
                    String updateSql = String.format("update %s set %s = ? where %s = ? and %s = 0", operateTable, addressKeyField, pkField, addressKeyField);
                    DBRoute dbRoute = DBRoute.of((String)entityMetadata.getDBRouteKey());
                    ArrayList errorEntityIdList = new ArrayList();
                    String adminField = admindivisionKeyField;
                    String addressField = detailaddressKeyField;
                    DB.query((DBRoute)dbRoute, (String)selectSql, rs -> {
                        while (rs.next()) {
                            Long fid = rs.getLong(pkField);
                            String admindivisionIdStr = rs.getString(adminField);
                            if (StringUtils.isEmpty((String)admindivisionIdStr)) continue;
                            Long admindivisionId = Long.valueOf(admindivisionIdStr);
                            String detailAddress = null;
                            if (StringUtils.isNotEmpty((String)addressField)) {
                                detailAddress = rs.getString(addressField);
                            }
                            if (admindivisionId == 0L) continue;
                            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)admindivisionId, (String)BD_ADMINDIVISION);
                            if (adminDivision == null) {
                                errorEntityIdList.add(fid);
                                continue;
                            }
                            DynamicObject country = adminDivision.getDynamicObject(COUNTRY);
                            if (country == null) {
                                errorEntityIdList.add(fid);
                                continue;
                            }
                            Long countryId = (Long)country.getPkValue();
                            if (!validCountryId.contains(countryId)) continue;
                            try {
                                AddressCommitResult result = this.covertAddress(billKey, admindivisionId, detailAddress, countryId);
                                if (result.getSuccess().booleanValue()) {
                                    DB.execute((DBRoute)dbRoute, (String)updateSql, (Object[])new Object[]{result.getId(), fid});
                                    continue;
                                }
                                errorEntityIdList.add(fid);
                            }
                            catch (Exception e) {
                                errorEntityIdList.add(fid);
                            }
                        }
                        return null;
                    });
                    if (errorEntityIdList.size() > 0) {
                        String errorPartialDataFailed = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u540c\u6b65\u5931\u8d25\uff0c\u90e8\u5206\u6570\u636e\u540c\u6b65\u9519\u8bef\u3002", (String)"AdvanceAddressConfigPlugin_12", (String)PROJECT_ID, (Object[])new Object[0]);
                        String itemErrorInfo = String.format(errorPartialDataFailed, billKey, admindivisionKey, detailaddressKey);
                        itemExecInfo.add(itemErrorInfo);
                        mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_FAILED);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                        continue;
                    }
                    String syncSuccess = ResManager.loadKDString((String)"\u8868\u5355(%1$s),\u884c\u653f\u533a\u5212\u5b57\u6bb5(%2$s),\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5(%3$s)\u6761\u76ee\uff0c\u540c\u6b65\u6210\u529f\u3002", (String)"AdvanceAddressConfigPlugin_13", (String)PROJECT_ID, (Object[])new Object[0]);
                    String itemSuccessInfo = String.format(syncSuccess, billKey, admindivisionKey, detailaddressKey);
                    itemExecInfo.add(itemSuccessInfo);
                    mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_COMPLETE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                }
                catch (Exception e) {
                    logger.error("\u5730\u5740\u8fc1\u79fb\u5f02\u5e38", (Throwable)e);
                    mapMove.set(SYNC_STATUS, (Object)SYNC_STATUS_FAILED);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{advanceAddressConfig});
                }
                finally {
                    lock.unlock();
                }
            }
            StringBuilder sb = new StringBuilder();
            for (String itenInfo : itemExecInfo) {
                sb.append(itenInfo).append('\n');
            }
            String messageContent = sb.toString();
            this.sendMsg(messageContent);
        }
        catch (Exception e) {
            String moveAddressTaskFailed = ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u51fa\u9519\u3002", (String)"AdvanceAddressConfigPlugin_14", (String)PROJECT_ID, (Object[])new Object[0]);
            this.sendMsg(moveAddressTaskFailed);
        }
        finally {
            lockInitData.unlock();
        }
    }

    private Map<String, String> getTableFieldInfo(DynamicObject dyMove, EntityMetadata entityMetadata) {
        String admindivisionKey = dyMove.getString(ADMIN_DIVISION_KEY);
        String detailaddressKey = dyMove.getString(DETAIL_ADDRESS_KEY);
        String addressKey = dyMove.getString(ADDRESS_KEY);
        String operateTable = null;
        String admindivisionKeyField = null;
        String detailaddressKeyField = null;
        String addressKeyField = null;
        String pkField = null;
        List entitys = entityMetadata.getEntitys();
        for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem entityItem : items) {
                if (admindivisionKey.equals(entityItem.getKey())) {
                    operateTable = entityMetadata.getFieldByKey(admindivisionKey).getTableName(entity);
                    admindivisionKeyField = entityMetadata.getFieldByKey(admindivisionKey).getFieldName();
                    if (entity instanceof EntryEntity) {
                        pkField = ((EntryEntity)entity).getEntryPkFieldName();
                        continue;
                    }
                    if (!(entity instanceof BillEntity)) continue;
                    pkField = ((BillEntity)entity).getPkFieldName();
                    continue;
                }
                if (detailaddressKey.equals(entityItem.getKey())) {
                    detailaddressKeyField = entityMetadata.getFieldByKey(detailaddressKey).getFieldName();
                    continue;
                }
                if (!addressKey.equals(entityItem.getKey())) continue;
                addressKeyField = entityMetadata.getFieldByKey(addressKey).getFieldName();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotEmpty(operateTable) && StringUtils.isNotEmpty(admindivisionKeyField) && StringUtils.isNotEmpty(addressKeyField) && StringUtils.isNotEmpty(pkField)) {
            result.put(OPERATE_TABLE, operateTable);
            result.put(ADMINDIVISION_KEY_FIELD, admindivisionKeyField);
            if (StringUtils.isNotEmpty(detailaddressKeyField)) {
                result.put(DETAILADDRESS_KEY_FIELD, detailaddressKeyField);
            }
            result.put(ADDRESS_KEY_FIELD, addressKeyField);
            result.put(PK_FIELD, pkField);
        }
        return result;
    }

    private AddressCommitResult covertAddress(String billKey, Long admindivisionId, String detailAddress, Long countryId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ADDRESS_CONFIG_ID, 1234851804710225920L);
        map.put(COUNTRY, countryId);
        map.put(FROM_FORM, billKey);
        map.put(ADMINDIVISION, admindivisionId);
        map.put(DETAIL, detailAddress);
        return InteServiceHelper.commitAddressInfo(map);
    }

    private void sendMsg(String messageContent) {
        String title = ResManager.loadKDString((String)"\u5730\u5740\u6570\u636e\u8fc1\u79fb", (String)"AdvanceAddressConfigPlugin_15", (String)PROJECT_ID, (Object[])new Object[0]);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(messageContent));
        messageInfo.setUserIds(Collections.singletonList(userId));
        messageInfo.setType(MESSAGE);
        messageInfo.setMessageTag((ILocaleString)new LocaleString(title));
        messageInfo.setEntityNumber("cts_advance_address");
        messageInfo.setSenderId(userId);
        try {
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u53d1\u9001\u5b58\u5728\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private boolean buildTipMessage(StringBuilder messageBuilder) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<String> messageList = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject billkey = ((DynamicObject)collection.get(i)).getDynamicObject(BILL_KEY);
            if (billkey == null) continue;
            String billNumber = billkey.getString(NUMBER);
            String entityId = MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            Map<String, EntityItem> itemMap = entityMetadata.getItems().stream().collect(Collectors.toMap(AbstractElement::getKey, entityItem -> entityItem));
            String adminDivisionKey = ((DynamicObject)collection.get(i)).getString(ADMIN_DIVISION_KEY);
            String detailAddressKey = ((DynamicObject)collection.get(i)).getString(DETAIL_ADDRESS_KEY);
            String addressKey = ((DynamicObject)collection.get(i)).getString(ADDRESS_KEY);
            EntityItem adminDivision = itemMap.get(adminDivisionKey);
            EntityItem detailAddress = itemMap.get(detailAddressKey);
            EntityItem address = itemMap.get(addressKey);
            String tipMessage0 = ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u7b2c%s\u884c\u6570\u636e\uff1a", (String)"AdvanceAddressConfigPlugin_16", (String)PROJECT_ID, (Object[])new Object[]{i + 1});
            StringJoiner joiner = new StringJoiner("\uff0c", tipMessage0, "\u3002");
            boolean isExistError = false;
            if (!(adminDivision instanceof AdminDivisionField)) {
                isExistError = true;
                String tipMessage3 = ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e0d\u662f\u884c\u653f\u533a\u5212\u7c7b\u578b\u3002", (String)"AdvanceAddressConfigPlugin_19", (String)PROJECT_ID, (Object[])new Object[]{adminDivisionKey});
                joiner.add(tipMessage3);
            }
            if (detailAddress != null && !(detailAddress instanceof TextField)) {
                isExistError = true;
                String tipMessage4 = ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff08\u4e0d\u662f\u6587\u672c\u7c7b\u578b\uff09", (String)"AdvanceAddressConfigPlugin_20", (String)PROJECT_ID, (Object[])new Object[]{detailAddressKey});
                joiner.add(tipMessage4);
            }
            if (!(address instanceof AddressField)) {
                isExistError = true;
                String tipMessage5 = ResManager.loadResFormat((String)"\u9ad8\u7ea7\u5730\u5740\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff08\u4e0d\u662f\u5730\u5740\u7c7b\u578b\uff09", (String)"AdvanceAddressConfigPlugin_21", (String)PROJECT_ID, (Object[])new Object[]{addressKey});
                joiner.add(tipMessage5);
            }
            if (!isExistError) continue;
            messageList.add(joiner.toString());
        }
        Boolean enableMap = (Boolean)this.getModel().getValue(ENABLE_MAP);
        if (enableMap.booleanValue()) {
            DynamicObjectCollection mapFieldMappingeDyColl = this.getModel().getEntryEntity(MAP_FIELD_MAPPING_ENTRY);
            int mapFieldMappingeDyCollSize = mapFieldMappingeDyColl.size();
            HashSet<String> addressConfigFieldSet = new HashSet<String>();
            for (DynamicObject mapFieldMappingeDy : mapFieldMappingeDyColl) {
                addressConfigFieldSet.add(mapFieldMappingeDy.getString(ADDRESS_CONFIG_FIELD));
            }
            if (mapFieldMappingeDyCollSize > addressConfigFieldSet.size()) {
                String tipMessage6 = ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u5b57\u6bb5\u503c\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"AdvanceAddressConfigPlugin_22", (String)PROJECT_ID, (Object[])new Object[0]);
                messageList.add(tipMessage6);
            }
            for (DynamicObject mapFieldMappingeDy : mapFieldMappingeDyColl) {
                if (!ADMINDIVISION_ID.equals(mapFieldMappingeDy.getString(ADDRESS_CONFIG_FIELD)) || !StringUtils.isEmpty((String)mapFieldMappingeDy.getString(ADMINDIVISION_NUMBER))) continue;
                String tipMessage7 = ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u5b57\u6bb5\u884c\u653f\u533a\u5212\u7684\u884c\u653f\u533a\u5212\u7f16\u7801\u5b57\u6bb5\u5fc5\u586b\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"AdvanceAddressConfigPlugin_23", (String)PROJECT_ID, (Object[])new Object[0]);
                messageList.add(tipMessage7);
            }
        }
        if (messageList.size() > 0) {
            messageList.forEach(item -> messageBuilder.append((String)item).append('\n'));
        }
        return messageList.size() > 0;
    }
}

