/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.property.AddressProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.inte.api.address.AddressCommitResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;

public class BatchImportAddressHelper {
    private static final Log log = LogFactory.getLog(BatchImportAddressHelper.class);
    private static final String SUFFIX = "xlsx";
    private static final int FIRST_ROW_IDX = 0;
    private static final int FIRST_SHEET_IDX = 0;
    private static final int KEY_OF_ROW_IN_EXCEL_IDX = 2;
    private static final String ID = "id";
    private static final String IMPORTPROP = "importprop";
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";
    private static final String[] ADDRESS_BASEDATA_FIELDS = new String[]{"countryid", "configid", "admindivisionid1", "admindivisionid2", "admindivisionid3", "admindivisionid4", "admindivisionid5", "admindivisionid6"};
    private static final String BD_COUNTRY = "bd_country";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String NAME = "name";
    private static final String ADDRESS_TYPE = "addressType";

    public void saveCheck(List<ImportBillData> rowdatas, ImportLogger logger, ImportContext ctx, MainEntityType mainEntityType) {
        if (rowdatas.size() <= 0) {
            return;
        }
        ImportBillData importBillData = rowdatas.get(0);
        ImportEntityMapping entityMapping = importBillData.getEntityMapping();
        Set billHeaderSelectedFields = entityMapping.getCols().keySet();
        Set<AddressProp> allAddressFields = mainEntityType.getAllFields().values().stream().filter(dataEntityProperty -> dataEntityProperty instanceof AddressProp).map(dataEntityProperty -> (AddressProp)dataEntityProperty).collect(Collectors.toSet());
        HashMap<String, List> entryKey2AddressFields = new HashMap<String, List>();
        allAddressFields.forEach(addressProp -> {
            IDataEntityType parent = addressProp.getParent();
            if (parent instanceof EntryType) {
                entryKey2AddressFields.computeIfAbsent(parent.getName(), k -> new LinkedList());
                ((List)entryKey2AddressFields.get(parent.getName())).add(addressProp);
            }
        });
        List<String> billHeaderAddressFieldKeys = allAddressFields.stream().filter(addressProp -> billHeaderSelectedFields.contains(addressProp.getName())).map(DynamicProperty::getName).collect(Collectors.toList());
        LinkedHashMap<String, List> entryKey2AddressKeys = new LinkedHashMap<String, List>();
        entryKey2AddressFields.forEach((entryKey, addressFields) -> {
            ImportEntityMapping entryMapping = (ImportEntityMapping)entityMapping.getEntries().get(entryKey);
            if (entryMapping == null) {
                return;
            }
            LinkedList addressKeys = new LinkedList();
            addressFields.forEach(addressProp -> {
                if (entryMapping.getCols().containsKey(addressProp.getName())) {
                    addressKeys.add(addressProp.getName());
                }
            });
            entryKey2AddressKeys.put((String)entryKey, addressKeys);
        });
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData importData = iterator.next();
            JSONObject currentRecord = importData.getData();
            try {
                billHeaderAddressFieldKeys.forEach(key -> {
                    if (currentRecord.getJSONObject(key) != null) {
                        AddressCommitResult addressCommitResult = this.invokeInsertAddressApi(currentRecord.getJSONObject(key), ctx, mainEntityType);
                        if (addressCommitResult.getSuccess().booleanValue()) {
                            Long id = addressCommitResult.getId();
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put(IMPORTPROP, (Object)ID);
                            jsonObject.put(ID, (Object)id);
                            currentRecord.put(key, (Object)jsonObject);
                        } else {
                            throw new RuntimeException(addressCommitResult.getErrorMsg().toString());
                        }
                    }
                });
                entryKey2AddressKeys.forEach((entryKey, addressKeys) -> {
                    JSONArray entryDataRows = currentRecord.getJSONArray(entryKey);
                    entryDataRows.forEach(row -> {
                        JSONObject rowJsonObject = (JSONObject)row;
                        addressKeys.forEach(addressKey -> {
                            JSONObject address = rowJsonObject.getJSONObject(addressKey);
                            if (address != null) {
                                AddressCommitResult addressCommitResult = this.invokeInsertAddressApi(address, ctx, mainEntityType);
                                if (addressCommitResult.getSuccess().booleanValue()) {
                                    Long id = addressCommitResult.getId();
                                    JSONObject jsonObject = new JSONObject();
                                    jsonObject.put(IMPORTPROP, (Object)ID);
                                    jsonObject.put(ID, (Object)id);
                                    rowJsonObject.put(addressKey, (Object)jsonObject);
                                } else {
                                    throw new RuntimeException(addressCommitResult.getErrorMsg().toString());
                                }
                            }
                        });
                    });
                });
            }
            catch (Exception e) {
                log.error("\u5730\u5740\u63a7\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                logger.fail().log(Integer.valueOf(importData.getStartIndex()), e.getMessage());
                iterator.remove();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AddressCommitResult invokeInsertAddressApi(JSONObject address, ImportContext ctx, MainEntityType mainEntityType) {
        DynamicObject adminDivision = this.handleAdminDivision(address, ctx);
        Long countryId = 0L;
        Long configId = 0L;
        IPageCache pageCache = this.getPageCache(ctx);
        if (pageCache != null) {
            String pageCacheCountryId = pageCache.get("countryid");
            String pageCacheConfigId = pageCache.get("configid");
            if (!StringUtils.isEmpty((String)pageCacheCountryId) && !StringUtils.isEmpty((String)pageCacheConfigId)) {
                countryId = Long.parseLong(pageCacheCountryId);
                configId = Long.parseLong(pageCacheConfigId);
            }
        }
        if (countryId == 0L && configId == 0L) {
            if (!address.containsKey((Object)"countryid") || StringUtils.isEmpty((String)address.getString("countryid"))) {
                if (adminDivision == null) throw new RuntimeException(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchImportAddressHelper_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
                countryId = (Long)adminDivision.getDynamicObject("country").getPkValue();
            } else {
                DynamicObject country = this.loadDynamicObjectByNumberOrName(BD_COUNTRY, address.get((Object)"countryid"), ctx, ID);
                if (country == null) throw new RuntimeException(ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a\u627e\u4e0d\u5230\u3002", (String)"BatchImportAddressHelper_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
                countryId = (Long)country.getPkValue();
            }
            if (!address.containsKey((Object)"configid") || StringUtils.isEmpty((String)address.getString("configid"))) {
                configId = this.getDefaultFormatId(countryId);
                if (configId == null) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchImportAddressHelper_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
                }
            } else {
                DynamicObject configIdDy = this.loadDynamicObjectByNumberOrName(CTS_ADDRESSCONFIG, address.get((Object)"configid"), ctx, ID);
                if (configIdDy == null) throw new RuntimeException(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u627e\u4e0d\u5230\u3002", (String)"BatchImportAddressHelper_3", (String)"bos-address-formplugin", (Object[])new Object[0]));
                configId = (Long)configIdDy.getPkValue();
            }
        }
        if (!this.countryAddrConfigMatch(countryId, configId)) {
            if (!StringUtils.isNotEmpty((String)address.getString("countryid"))) throw new RuntimeException(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0e\u56fd\u5bb6\u6216\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u6216\u4fee\u6539\u5730\u5740\u683c\u5f0f\u914d\u7f6e\u3002", (String)"BatchImportAddressHelper_5", (String)"bos-address-formplugin", (Object[])new Object[0]));
            if (!StringUtils.isNotEmpty((String)address.getString("configid"))) throw new RuntimeException(ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0e\u56fd\u5bb6\u6216\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u6216\u4fee\u6539\u5730\u5740\u683c\u5f0f\u914d\u7f6e\u3002", (String)"BatchImportAddressHelper_5", (String)"bos-address-formplugin", (Object[])new Object[0]));
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u672a\u914d\u7f6e\u8be5%2$s\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u6216\u4fee\u6539\u5730\u5740\u683c\u5f0f\u914d\u7f6e\u3002", (String)"BatchImportAddressHelper_4", (String)"bos-address-formplugin", (Object[])new Object[0]), address.getString("configid"), address.getString("countryid")));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("country", countryId);
        params.put("addressConfigId", configId);
        params.put("fromForm", mainEntityType.getName());
        if (adminDivision != null) {
            params.put("admindivision", adminDivision.getPkValue());
        }
        params.putAll(this.handleNotBaseDataFields(address));
        return InteServiceHelper.commitAddressInfo(params);
    }

    private boolean countryAddrConfigMatch(Long countryId, Long configId) {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select fid,fbasedataid,fpkid from t_cts_addrconfigcountry where fid = ? and fbasedataid = ?", (Object[])new Object[]{configId, countryId}, rs -> {
            Boolean countryMatch = Boolean.FALSE;
            while (rs.next()) {
                countryMatch = Boolean.TRUE;
            }
            return countryMatch;
        });
    }

    private DynamicObject loadDynamicObjectByNumberOrName(String entityNumber, Object val, ImportContext ctx, String selectProperties) {
        if (NAME.equals(this.getPageCache(ctx).get(ADDRESS_TYPE))) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectProperties, (QFilter[])new QFilter(NAME, "=", val).and(ENABLE, "=", (Object)Boolean.TRUE).toArray());
            if (dynamicObjectMap.size() == 0) {
                return null;
            }
            if (dynamicObjectMap.size() == 1) {
                return (DynamicObject)dynamicObjectMap.values().toArray()[0];
            }
            if (BD_COUNTRY.equals(entityNumber)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u540c\u540d\u56fd\u5bb6\u6216\u5730\u533a\u3002", (String)"BatchImportAddressHelper_6", (String)"bos-address-formplugin", (Object[])new Object[0]));
            }
            if (BD_ADMINDIVISION.equals(entityNumber)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u540c\u540d\u884c\u653f\u533a\u5212\u3002", (String)"BatchImportAddressHelper_7", (String)"bos-address-formplugin", (Object[])new Object[0]));
            }
            if (CTS_ADDRESSCONFIG.equals(entityNumber)) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u540c\u540d\u5730\u5740\u683c\u5f0f\u3002", (String)"BatchImportAddressHelper_8", (String)"bos-address-formplugin", (Object[])new Object[0]));
            }
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u540c\u540d%s\u3002", (String)"BatchImportAddressHelper_9", (String)"bos-address-formplugin", (Object[])new Object[0]), entityNumber));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)ID, (QFilter[])new QFilter(NUMBER, "=", val).and(ENABLE, "=", (Object)Boolean.TRUE).toArray());
        return dynamicObject;
    }

    private DynamicObject loadAdminDivisionByNumberOrName(String entityNumber, Object val, List<String> valList, ImportContext ctx, String selectProperties) {
        if (NAME.equals(this.getPageCache(ctx).get(ADDRESS_TYPE))) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)selectProperties, (QFilter[])new QFilter(NAME, "=", val).and(ENABLE, "=", (Object)Boolean.TRUE).toArray());
            if (dynamicObjectMap.size() == 0) {
                return null;
            }
            if (dynamicObjectMap.size() == 1) {
                return (DynamicObject)dynamicObjectMap.values().toArray()[0];
            }
            List<DynamicObject> matchDyList = this.filterMatchAdmindivision(dynamicObjectMap.values(), valList);
            if (matchDyList.size() == 0) {
                return null;
            }
            if (matchDyList.size() == 1) {
                return matchDyList.get(0);
            }
            throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u540c\u540d\u884c\u653f\u533a\u5212\u3002", (String)"BatchImportAddressHelper_7", (String)"bos-address-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)ID, (QFilter[])new QFilter(NUMBER, "=", val).and(ENABLE, "=", (Object)Boolean.TRUE).toArray());
        return dynamicObject;
    }

    private List<DynamicObject> filterMatchAdmindivision(Collection<DynamicObject> dyList, List<String> valList) {
        return dyList.stream().filter(dy -> {
            List<Object> nameList = this.getParentNameList((DynamicObject)dy);
            return nameList.containsAll(valList);
        }).collect(Collectors.toList());
    }

    private List<Object> getParentNameList(DynamicObject dy) {
        String[] longNumber = dy.getString("longnumber").split("\\.");
        return Arrays.stream(longNumber).map(num -> {
            DynamicObject adminDivisionDy = BusinessDataServiceHelper.loadSingleFromCache((String)BD_ADMINDIVISION, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", num)});
            if (adminDivisionDy == null) {
                return "";
            }
            return adminDivisionDy.getString(NAME);
        }).collect(Collectors.toList());
    }

    private IPageCache getPageCache(ImportContext ctx) {
        IFormView view = (IFormView)this.callInstanceField("kd.bos.form.plugin.impt.ImportContext", ctx, "view");
        return view.getParentView().getPageCache();
    }

    private Object callInstanceField(String className, Object obj, String name) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getDeclaredField(name);
            ReflectionUtils.makeAccessible((Field)field);
            return field.get(obj);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private Long getDefaultFormatId(long countryId) {
        String sql = "SELECT m.fid id FROM t_cts_addressconfig m LEFT JOIN t_cts_addrconfigcountry n ON m.fid = n.fid WHERE n.fbasedataid = ? and m.fisdefault = '1'";
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{countryId}, rs -> {
            if (rs.next()) {
                return rs.getLong(ID);
            }
            return null;
        });
    }

    private DynamicObject handleAdminDivision(JSONObject address, ImportContext ctx) {
        String adminDivisionFieldPart = "admindivision";
        List adminDivisionKeyList = address.entrySet().stream().filter(item -> ((String)item.getKey()).contains("admindivision") && StringUtils.isNotEmpty((String)item.getValue().toString())).map(Map.Entry::getKey).collect(Collectors.toList());
        String lastAdminDivision = adminDivisionKeyList.stream().max(Comparator.naturalOrder()).orElse("");
        String lastAdminDivisionInfo = address.getString(lastAdminDivision);
        List<String> adminDivisionInfoList = adminDivisionKeyList.stream().sorted(Comparator.naturalOrder()).map(arg_0 -> ((JSONObject)address).getString(arg_0)).collect(Collectors.toList());
        DynamicObject admindivision = this.loadAdminDivisionByNumberOrName(BD_ADMINDIVISION, lastAdminDivisionInfo, adminDivisionInfoList, ctx, "id,country,longnumber");
        if (StringUtils.isNotEmpty((String)lastAdminDivision) && admindivision == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\u3002", (String)"BatchImportAddressHelper_10", (String)"bos-address-formplugin", (Object[])new Object[0]));
        }
        return admindivision;
    }

    private Map<String, Object> handleNotBaseDataFields(JSONObject address) {
        HashMap<String, Object> otherFieldMap = new HashMap<String, Object>();
        address.forEach((key, val) -> {
            if (Arrays.stream(ADDRESS_BASEDATA_FIELDS).noneMatch(item -> item.equals(key)) && !IMPORTPROP.equals(key) && !address.getString(IMPORTPROP).equals(key)) {
                otherFieldMap.put((String)key, val);
            }
        });
        return otherFieldMap;
    }
}

