/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.address.service.ZoneService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class ZoneFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final LocalDate END_DATE = LocalDate.of(2099, 12, 31);
    private static final String CONDITION_JSON = "conditionjson";
    private static final String CONDITION_DESCRIPTION = "filterdescription";

    public void initialize() {
        super.initialize();
        TextEdit json = (TextEdit)this.getControl(CONDITION_JSON);
        ((TextProp)json.getProperty()).setMaxLenth(100000);
        this.addClickListeners(new String[]{"parent"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit adF7 = (BasedataEdit)this.getControl("parent");
        adF7.addBeforeF7SelectListener(evt -> {
            Object zoneTypeObj = this.getModel().getValue("zonetype");
            if (zoneTypeObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u533a\u57df\u7c7b\u578b\u3002", (String)"ZoneFormPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject zoneType = (DynamicObject)zoneTypeObj;
            List customQFilters = evt.getCustomQFilters();
            if (customQFilters != null) {
                customQFilters.add(new QFilter("zonetype", "=", (Object)zoneType.getLong("id")));
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey())) {
            this.setConditionJson();
        }
    }

    private void setConditionJson() {
        Map<String, Object> ret = this.getConditionMap();
        String err = (String)ret.get("err");
        if (!StringUtils.isBlank((CharSequence)err)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"ZoneFormPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]), err, MessageTypes.Default);
        } else {
            this.getModel().setValue(CONDITION_JSON, ret.get(CONDITION_JSON));
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        HashMap map = new HashMap(10);
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        map1.put("maxlength", 100000);
        map.put("item", map1);
        view.updateControlMetadata(CONDITION_JSON, map);
        view.sendFormAction(view);
        this.setZoneTypeDefaultValue(e);
        this.setStartEndTimeDefaultValue();
    }

    private Map<String, Object> getConditionMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filterList = filterCondition.getFilterRow();
        if (filterList == null || filterList.isEmpty()) {
            data.put(CONDITION_JSON, "");
            return data;
        }
        List filterColumns = filterGrid.getFilterColumns();
        ZoneService.renameFieldCaption(filterColumns);
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"DynamicFormModel", (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        FilterBuilder filterBuilder = this.buildFilterBuilder(filterCondition);
        String desc = filterBuilder.getFilterObject().getFilter();
        data.put(CONDITION_JSON, filterJson);
        data.put(CONDITION_DESCRIPTION, desc);
        return data;
    }

    private FilterBuilder buildFilterBuilder(FilterCondition filterCondition) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cts_address");
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    public void afterBindData(EventObject e) {
        this.initFilterCondition();
        Object condition = this.getModel().getValue(CONDITION_JSON);
        if (!ObjectUtils.isEmpty((Object)condition)) {
            this.setDataFilter(condition.toString());
        }
    }

    private void initFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        ZoneService.initFilterGrid(filterGrid);
        this.getView().updateView("filtergridap");
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.SetValue(filterCondition);
    }

    private void setStartEndTimeDefaultValue() {
        Date endTime;
        Date startTime;
        ZoneId zoneId = ZoneId.systemDefault();
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (parent == null) {
            LocalDate startDate = LocalDate.now();
            ZonedDateTime startZoneDateTime = startDate.atStartOfDay(zoneId);
            startTime = Date.from(startZoneDateTime.toInstant());
            ZonedDateTime endZoneDateTime = END_DATE.atStartOfDay(zoneId);
            endTime = Date.from(endZoneDateTime.toInstant());
        } else {
            DynamicObject parentEntity = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"cts_zone");
            startTime = parentEntity.getDate("starttime");
            endTime = parentEntity.getDate("endtime");
        }
        this.getModel().setValue("starttime", (Object)startTime);
        this.getModel().setValue("endtime", (Object)endTime);
    }

    private void setZoneTypeDefaultValue(EventObject e) {
        DynamicObject parent = (DynamicObject)((BaseModel)e.getSource()).getDataEntity().get("parent");
        if (parent != null) {
            long id = parent.getLong("id");
            DynamicObject parentNode = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cts_zone");
            long zoneTypeId = parentNode.getDynamicObject("zonetype").getLong("id");
            this.getModel().setValue("zonetype", (Object)zoneTypeId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName = e.getProperty().getName();
        if (changeName.equals("zonetype")) {
            this.zoneTypeChanged();
        }
    }

    private void zoneTypeChanged() {
        this.getModel().setValue("parent", (Object)"");
    }
}

