/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.address.plugin.ZoneTreeListViewWrapper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.list.query.QueryFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;

public class ZoneTreeListPlugin
extends AbstractTreeListPlugin
implements ItemClickListener {
    private static final int MAX_LEVEL = 20;
    private static final String IS_SHOW_DISABLED = "isshowdisabled";
    private final ZoneTreeListViewWrapper wrapper = new ZoneTreeListViewWrapper();

    public void initialize() {
        super.initialize();
        TreeView tv = (TreeView)this.getControl("treeview");
        tv.getView().setVisible(Boolean.TRUE, new String[]{"iscontainlower"});
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        ArrayList<QFilter> treeFilter = this.getTreeModel().getTreeFilter();
        QFilter zoneTypeFilter = args.getQFilter("zonetype.id");
        if (treeFilter == null || treeFilter.size() <= 0) {
            treeFilter = new ArrayList<QFilter>();
        }
        if (zoneTypeFilter != null) {
            treeFilter.add(zoneTypeFilter);
        }
        this.resetTree();
    }

    private void resetTree() {
        TreeNode root = this.getTreeModel().getRoot();
        TreeView treeView = this.wrapper.getTreeView();
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getTreeModel().refreshNode((Object)root.getId());
        treeView.updateNode(root);
        this.recoverNowAndChildrenInitState();
        treeView.focusNode(root);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet().length < 1) {
            return;
        }
        String changingName = e.getProperty().getName();
        if (Arrays.asList("iscontainnow", "iscontainlower").contains(changingName)) {
            this.doRefreshList();
        }
    }

    private void doRefreshList() {
        if (this.wrapper.getTreeModel() == null) {
            return;
        }
        Object nodeId = this.wrapper.getTreeModel().getCurrentNodeId();
        TreeNode rootNode = this.wrapper.getTreeModel().getRoot();
        if (nodeId == null || rootNode == null) {
            return;
        }
        GroupProp groupProp = this.wrapper.getTreeModel().getGroupProp();
        if (groupProp == null) {
            return;
        }
        TreeNode currentNode = rootNode.getTreeNode(nodeId.toString(), 20);
        if (currentNode == null) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        this.handleContainsNode(currentNode, groupProp, billList);
    }

    private void handleContainsNode(TreeNode currentNode, GroupProp groupProp, BillList billList) {
        String groupName = groupProp.getName();
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)currentNode.getLongNumber())) {
            List<Long> childrenIds = this.getChildrenIds(currentNode, groupProp);
            int dbType = groupProp.getDbType();
            qFilter = new QFilter(groupName, "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId()));
            Map<String, Boolean> containsMap = this.getContainsMap();
            qFilter = this.getContainsFilter(containsMap, qFilter, childrenIds, Long.valueOf(currentNode.getId()));
        }
        this.doContainsChangedAction(qFilter, billList);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        if (e.getNodeId().equals(root.getId())) {
            this.recoverNowAndChildrenInitState();
        }
    }

    private void recoverNowAndChildrenInitState() {
        TreeView tv = (TreeView)this.getControl("treeview");
        tv.getModel().setValue("iscontainlower", (Object)Boolean.TRUE);
        tv.getModel().setValue("iscontainnow", (Object)Boolean.TRUE);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object nodeId = this.wrapper.getTreeModel().getCurrentNodeId();
        TreeNode rootNode = this.wrapper.getTreeModel().getRoot();
        if (nodeId == null || rootNode == null) {
            return;
        }
        GroupProp groupProp = this.wrapper.getTreeModel().getGroupProp();
        if (groupProp == null) {
            return;
        }
        TreeNode currentNode = rootNode.getTreeNode(nodeId.toString(), 20);
        if (currentNode == null) {
            return;
        }
        String groupName = groupProp.getName();
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)currentNode.getLongNumber())) {
            List<Long> childrenIds = this.getChildrenIds(currentNode, groupProp);
            int dbType = groupProp.getDbType();
            qFilter = new QFilter(groupName, "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId()));
            Map<String, Boolean> containsMap = this.getContainsMap();
            qFilter = this.getContainsFilter(containsMap, qFilter, childrenIds, Long.valueOf(currentNode.getId()));
        }
        if (qFilter != null) {
            e.addCustomQFilter(qFilter);
        }
    }

    private QFilter getContainsFilter(Map<String, Boolean> containsMap, QFilter qFilter, List<Long> childrenIds, Long currentId) {
        if (childrenIds != null && childrenIds.size() > 0) {
            if (containsMap.get("iscontainlower").booleanValue()) {
                qFilter.or(new QFilter("id", "in", childrenIds));
            } else {
                qFilter.and(new QFilter("id", "not in", childrenIds));
            }
        }
        if (containsMap.get("iscontainnow").booleanValue()) {
            qFilter.or(new QFilter("id", "=", (Object)currentId));
        } else {
            qFilter.and(new QFilter("id", "!=", (Object)currentId));
        }
        return qFilter;
    }

    private List<Long> getChildrenIds(TreeNode currentNode, GroupProp groupProp) {
        String longNumber = currentNode.getLongNumber();
        IQuery query = QueryFactory.createQuery();
        List idArrays = query.getChildsId(groupProp, longNumber);
        List<Long> ids = idArrays.stream().map(Long::valueOf).collect(Collectors.toList());
        return ids;
    }

    private void doContainsChangedAction(QFilter qFilter, BillList billList) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (qFilter != null) {
            filters.add(qFilter);
        }
        FieldEdit showDisabledDataEdit = (FieldEdit)this.getControl(IS_SHOW_DISABLED);
        boolean showDisabledData = false;
        if (showDisabledDataEdit != null) {
            showDisabledData = (Boolean)showDisabledDataEdit.getModel().getValue(IS_SHOW_DISABLED);
        }
        billList.setShowDisabledData(showDisabledData);
        billList.setQueryFilterParameter(new FilterParameter(filters, (String)null));
        boolean isF7 = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            isF7 = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        }
        if (!isF7) {
            billList.clearEntryState();
            billList.clearSelection();
        }
        billList.refresh();
    }

    private Map<String, Boolean> getContainsMap() {
        TreeView tv = (TreeView)this.getControl("treeview");
        Boolean isContainsChildren = (Boolean)tv.getView().getModel().getValue("iscontainlower");
        Boolean isContainsCurrent = (Boolean)tv.getView().getModel().getValue("iscontainnow");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("iscontainnow", isContainsCurrent);
        map.put("iscontainlower", isContainsChildren);
        return map;
    }

    private void setTreeFilter() {
        String value;
        ControlFilter controlFilter;
        Map controlFilterMap = Optional.ofNullable(this.getControlFilters()).map(ControlFilters::getFilters).orElse(null);
        if (controlFilterMap != null && (controlFilter = (ControlFilter)controlFilterMap.get("zonetype.id")) != null && StringUtils.isNotEmpty((CharSequence)(value = controlFilter.getValue().get(0).toString()))) {
            QFilter qFilter = new QFilter("zonetype.id", "=", (Object)Long.valueOf(value));
            this.treeListView.getTreeModel().getTreeFilter().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("cts_zonetype_config");
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            listShowParameter.setOpenStyle(openStyle);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.setTreeFilter();
            this.resetTree();
        }
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.wrapper);
    }
}

