/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.address.util.AddressUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AddressConfigUtil {
    private static final String NUMBER = "number";
    private static final String CTS_ADDRESSCONFIG = "cts_addressconfig";
    private static final String COUNTRY = "country";
    private static final String BD_COUNTRY = "bd_country";
    private static final String ADDRESS_INFO_PAGE = "address_info_page";
    private static final String IS_ADDRESS_CONFIG_PREVIEW = "is_address_config_preview";
    private static final String ADDRESS_CONFIG_PREVIEW_MODEL = "address_config_preview_model";
    private static final String SOURCE_ENTITY_ID = "sourceEntityId";
    private static final String EMPTY = " ";
    private static final String COUNTRY_ID = "countryId";
    private static final String ADDR_CONFIG_ID = "addrConfigId";
    private static final String CTS_ADDR_FORMAT_PREVIEW = "cts_addr_format_preview";
    private static final String PREVIEW_FORMAT_STR = "preview_format_str";
    private static final String ADDRESS_NAME = "address_name";
    private static final String NAME = "name";
    private static final String FBASEDATA_ID = "fbasedataid";
    private static final String KEY = "key";
    private static final String CTS_ADDR_PVW_SEL_COUNTRY = "cts_addr_pvw_sel_country";
    private static final String SELECT_COUNTRY_LIST = "select_country_list";
    private static final String ID = "id";
    private static final String IS_CONTAIN_ADMIN = "iscontainadmin";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String FORMAT_ENTRY_ENTITY = "formatentryentity";
    private static final String ADMIN_LEVEL = "adminlevel";
    private static final String STRUCT_IS_SHOW = "structisshow";
    private static final String STRUCT_PRECONFIG_ID = "structpreconfigid";
    private static final String FORMAT_IS_INCLUDE = "formatisinclude";
    private static final String FORMAT_PRECONFIG_ID = "formatpreconfigid";
    private static final String SELECTED_STRUCT_LIST = "selectedStructList";
    private static final String SELECTED_FORMAT_LIST = "selectedFormatList";
    private static final String SEQ = "seq";
    private static final String EDIT = "EDIT";
    private static final String IS_DEFAULT = "isdefault";
    private static final String FID = "fid";
    private static final String FNAME = "fname";

    public static Boolean checkAddrConfigErrorInfo(IFormView view, IDataModel model) {
        String errorInfo = AddressConfigUtil.isUniqueNumber(model);
        if (errorInfo != null) {
            view.showErrorNotification(errorInfo);
            return Boolean.FALSE;
        }
        errorInfo = AddressConfigUtil.isUniqueDefaultFormat(view, model);
        if (errorInfo != null) {
            view.showErrorNotification(errorInfo);
            return Boolean.FALSE;
        }
        errorInfo = AddressConfigUtil.checkLineCount(view.getModel().getDataEntity(true));
        if (errorInfo != null) {
            view.showErrorNotification(errorInfo);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String checkLineCount(DynamicObject addrConfigDy) {
        ArrayList<Long> countryIdList = new ArrayList<Long>();
        DynamicObjectCollection collection = addrConfigDy.getDynamicObjectCollection(COUNTRY);
        for (DynamicObject country : collection) {
            countryIdList.add(country.getLong("fbasedataid_id"));
        }
        for (Long countryId : countryIdList) {
            int count = AddressUtil.getLineCountByAddrConfig(addrConfigDy, countryId);
            if (count <= 14) continue;
            String errorInfo = ResManager.loadKDString((String)"\u5355\u636e\u683c\u5f0f\u6700\u5927\u884c\u6570\u4e3a14\u884c\uff0c\u73b0\u5728\u5df2\u7ecf%d\u884c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u8ba1\u3002", (String)"AddressConfigUtil_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
            return String.format(errorInfo, count);
        }
        return null;
    }

    private static String isUniqueNumber(IDataModel model) {
        Object pkValue1 = model.getDataEntity().getPkValue();
        QFilter idQ = new QFilter(ID, "!=", pkValue1);
        QFilter numberQ = new QFilter(NUMBER, "=", model.getValue(NUMBER));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)CTS_ADDRESSCONFIG, (String)"", (QFilter[])new QFilter[]{numberQ, idQ});
        if (load != null && load.length > 0) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u91cd\u590d", (String)"AddressConfigUtil_1", (String)"bos-address-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private static String isUniqueDefaultFormat(IFormView view, IDataModel model) {
        Object pkValue1 = model.getDataEntity().getPkValue();
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getValue(COUNTRY);
        Boolean isdefault = (Boolean)model.getValue(IS_DEFAULT);
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        int value = status.getValue();
        if (isdefault.booleanValue()) {
            HashMap countryConfig = new HashMap(16);
            StringBuilder builder = new StringBuilder();
            builder.append(" SELECT config.fid,config.fisdefault,config_l.fname,configcountry.fbasedataid FROM t_cts_addressconfig config ");
            builder.append(" LEFT JOIN t_cts_addressconfig_l config_l ON config_l.fid = config.fid AND config_l.flocaleid = ? ");
            builder.append(" LEFT JOIN t_cts_addrconfigcountry configcountry ");
            builder.append(" ON config.fid = configcountry.fid ");
            builder.append(" LEFT JOIN t_bd_country country ");
            builder.append(" ON country.fid = configcountry.fbasedataid ");
            builder.append(" WHERE config.fisdefault = '1' AND configcountry.fbasedataid in( ");
            int size = dynamicObjects.size();
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    builder.append("? )");
                    continue;
                }
                builder.append("? ,");
            }
            Object[] objects = new Object[1 + size];
            objects[0] = Lang.get().getLocale().toString();
            for (int i = 1; i <= dynamicObjects.size(); ++i) {
                DynamicObject county = (DynamicObject)((DynamicObject)dynamicObjects.get(i - 1)).get(FBASEDATA_ID);
                objects[i] = county.getPkValue();
            }
            DB.query((DBRoute)DBRoute.basedata, (String)builder.toString(), (Object[])objects, rs -> {
                while (rs.next()) {
                    boolean idNotEquals;
                    boolean idEquals;
                    String fid = rs.getString(FID);
                    String fname = rs.getString(FNAME);
                    long countryId = rs.getLong(FBASEDATA_ID);
                    boolean bl = idEquals = pkValue1 != null && pkValue1.toString().equals(fid);
                    if (0 == value && idEquals || 1 == value && idEquals) break;
                    boolean bl2 = idNotEquals = pkValue1 != null && !pkValue1.toString().equals(fid);
                    if ((0 != value || !idNotEquals) && (1 != value || !idNotEquals)) continue;
                    countryConfig.put(countryId, fname);
                }
                return countryConfig;
            });
            if (countryConfig.size() == 0) {
                return null;
            }
            Object[] countries = countryConfig.keySet().toArray();
            DynamicObject[] bd_coutries = BusinessDataServiceHelper.load((Object[])countries, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BD_COUNTRY));
            StringBuilder tips = new StringBuilder();
            tips.append(ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a\u53ea\u80fd\u6307\u5b9a\u552f\u4e00\u7684\u9ed8\u8ba4\u503c\uff1a", (String)"AddressConfigUtil_2", (String)"bos-address-formplugin", (Object[])new Object[0]));
            for (int i = 0; i < bd_coutries.length; ++i) {
                tips.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u6307\u5b9a\u9ed8\u8ba4\u683c\u5f0f\u201c%2$s\u201d", (String)"AddressConfigUtil_3", (String)"bos-address-formplugin", (Object[])new Object[0]), bd_coutries[i].getLocaleString(NAME), countryConfig.get(Long.valueOf(bd_coutries[i].getPkValue().toString()))));
                if (i == bd_coutries.length - 1) continue;
                tips.append('\u3001');
            }
            return tips.toString();
        }
        return null;
    }

    public static void addressConfigStructPreview(IFormView view, IDataModel model, String addrCountryId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ADDRESS_INFO_PAGE);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(COUNTRY_ID, (Object)addrCountryId);
        showParameter.setCustomParam(ADDR_CONFIG_ID, (Object)String.valueOf(-1));
        String entityId = view.getEntityId();
        if (!StringUtils.isBlank((CharSequence)entityId)) {
            showParameter.setCustomParam(SOURCE_ENTITY_ID, (Object)entityId);
        } else {
            showParameter.setCustomParam(SOURCE_ENTITY_ID, (Object)EMPTY);
        }
        showParameter.setCustomParam(ADDRESS_NAME, (Object)model.getDataEntity().getString(NAME));
        showParameter.setCustomParam(IS_ADDRESS_CONFIG_PREVIEW, (Object)Boolean.TRUE);
        showParameter.setCustomParam(ADDRESS_CONFIG_PREVIEW_MODEL, (Object)SerializationUtils.serializeToBase64((Object)model.getDataEntity(true)));
        showParameter.setStatus(OperationStatus.EDIT);
        view.showForm(showParameter);
    }

    public static void addressConfigFormatPreview(IFormView view, IDataModel model, String addrCountryId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(CTS_ADDR_FORMAT_PREVIEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject addrConfigDy = model.getDataEntity(true);
        String previewFormatStr = AddressUtil.getPreviewFormatStr(addrConfigDy, Long.valueOf(addrCountryId));
        showParameter.setCustomParam(PREVIEW_FORMAT_STR, (Object)previewFormatStr);
        view.showForm(showParameter);
    }

    public static void addressConfigPreviewSelectCountry(IFormView view, IDataModel model, IFormPlugin plugin, String actionId) {
        if (!AddressConfigUtil.checkAddrConfigErrorInfo(view, model).booleanValue()) {
            return;
        }
        DynamicObjectCollection countryColl = (DynamicObjectCollection)model.getDataEntity().get(COUNTRY);
        if (countryColl == null || countryColl.isEmpty()) {
            return;
        }
        ArrayList countryList = new ArrayList();
        for (DynamicObject dy : countryColl) {
            DynamicObject countryDy = (DynamicObject)dy.get(FBASEDATA_ID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(NAME, countryDy.getString(NAME));
            map.put(KEY, countryDy.getString(ID));
            countryList.add(map);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(CTS_ADDR_PVW_SEL_COUNTRY);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(SELECT_COUNTRY_LIST, countryList);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        view.showForm(showParameter);
    }

    public static void controlAdminInEditStatus(AbstractFormPlugin plugin, boolean saveOpt) {
        IDataModel model = plugin.getView().getModel();
        TextEdit numberEdit = (TextEdit)plugin.getControl(NUMBER);
        MulBasedataEdit countryEdit = (MulBasedataEdit)plugin.getControl(COUNTRY);
        numberEdit.setEnable(null, false, 0);
        countryEdit.setEnable(null, false, 0);
        boolean isContainAdmin = model.getDataEntity().getBoolean(IS_CONTAIN_ADMIN);
        FieldEdit isContainAdminFieldEdit = (FieldEdit)plugin.getControl(IS_CONTAIN_ADMIN);
        ComboEdit comboEdit = (ComboEdit)plugin.getControl(ADMIN_LEVEL);
        if (isContainAdmin) {
            isContainAdminFieldEdit.setEnable(null, false, 0);
            int minLevel = model.getDataEntity().getInt(ADMIN_LEVEL);
            if (minLevel <= 6) {
                ArrayList<Iterator> itemList = new ArrayList<Iterator>(10);
                for (int i = minLevel; i <= 6; ++i) {
                    Iterator item = new ComboItem(new LocaleString(String.valueOf(i)), String.valueOf(i));
                    itemList.add(item);
                }
                comboEdit.setComboItems(itemList);
            }
        } else {
            isContainAdminFieldEdit.setEnable(null, true, 0);
            if (!saveOpt) {
                plugin.getView().getModel().setValue(ADMIN_LEVEL, null);
                plugin.getView().setEnable(Boolean.FALSE, new String[]{ADMIN_LEVEL});
            }
        }
        DynamicObjectCollection structColl = (DynamicObjectCollection)model.getDataEntity().get(STRUCT_ENTRY_ENTITY);
        DynamicObjectCollection formatColl = (DynamicObjectCollection)model.getDataEntity().get(FORMAT_ENTRY_ENTITY);
        ArrayList<Long> selectedStructList = new ArrayList<Long>();
        if (structColl != null && structColl.size() > 0) {
            for (DynamicObject dy : structColl) {
                if (!dy.getBoolean(STRUCT_IS_SHOW)) continue;
                Long configId = (Long)((DynamicObject)dy.get(STRUCT_PRECONFIG_ID)).getPkValue();
                selectedStructList.add(configId);
            }
        }
        ArrayList<Long> selectedFormatList = new ArrayList<Long>();
        if (formatColl != null && formatColl.size() > 0) {
            for (DynamicObject dy : formatColl) {
                if (!dy.getBoolean(FORMAT_IS_INCLUDE)) continue;
                Long configId = (Long)((DynamicObject)dy.get(FORMAT_PRECONFIG_ID)).getPkValue();
                selectedFormatList.add(configId);
            }
        }
        plugin.getPageCache().put(SELECTED_STRUCT_LIST, SerializationUtils.serializeToBase64(selectedStructList));
        plugin.getPageCache().put(SELECTED_FORMAT_LIST, SerializationUtils.serializeToBase64(selectedFormatList));
    }

    public static void controlEntryEntityInEditStatus(AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        IFormView view = plugin.getView();
        String selectedStructListStr = plugin.getPageCache().get(SELECTED_STRUCT_LIST);
        if (selectedStructListStr == null) {
            return;
        }
        List selectedStructList = (List)SerializationUtils.deSerializeFromBase64((String)selectedStructListStr);
        DynamicObjectCollection structColl = (DynamicObjectCollection)model.getDataEntity(true).get(STRUCT_ENTRY_ENTITY);
        for (DynamicObject dy : structColl) {
            Long configId = (Long)((DynamicObject)dy.get(STRUCT_PRECONFIG_ID)).getPkValue();
            if (!selectedStructList.contains(configId)) continue;
            view.setEnable(Boolean.FALSE, dy.getInt(SEQ) - 1, new String[]{STRUCT_IS_SHOW});
        }
    }

    public static boolean isEditStatus(AbstractFormPlugin plugin) {
        String status = AddressConfigUtil.getSatus(plugin);
        return EDIT.equals(status);
    }

    public static String getSatus(AbstractFormPlugin plugin) {
        String isReferenced = plugin.getPageCache().get("isReferenced");
        if (!"true".equals(isReferenced)) {
            return "ADDNEW";
        }
        return EDIT;
    }
}

