/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.address.entity.AddressFieldMetadata;
import kd.bos.address.enums.AddressFieldLengthEnum;
import kd.bos.address.enums.AddressFiledTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class AddressUtil {
    private static final String CTS_ADDRESS_PRE_CONFIG = "cts_addresspreconfig";
    private static final String ID = "id";
    private static final String SOURCE = "source";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String SELECT_FIELDS = "id,number,name";
    private static final String ADDR_CONFIG_ID = "addrconfigid";
    private static final String ADDR_COUNTRY_ID = "addrcountryid";
    private static final String SOURCE_ENTITY_ID = "sourceEntityId";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String CTS_ADDRESS_CONFIG = "cts_addressconfig";
    private static final String FORMAT_ENTRY_ENTITY = "formatentryentity";
    private static final String FORMAT_IS_INCLUDE = "formatisinclude";
    private static final String FORMAT_IS_NEW_LINE = "formatisnewline";
    private static final String FORMAT_PREFIX = "formatprefix";
    private static final String FORMAT_SUFFIX = "formatsuffix";
    private static final String FORMAT_REPLACEA_ATTR = "formatreplaceattr";
    private static final String LINE_FEED = "\r\n";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String STRUCT_IS_SHOW = "structisshow";
    private static final String STRUCT_IS_REQUIRED = "structisrequired";
    private static final String TRUE = "true";
    private static final String STRUCT_PRE_CONFIG_ID = "structpreconfigid";
    private static final String BD_ADMINDIVISON = "bd_admindivision";
    private static final String BD_COUNTRY = "bd_country";
    private static final String STRUCT_USER_DEFINE_TAG = "structuserdefinetag";
    private static final String STRUCT_IS_NEW_LINE = "structisnewline";
    private static final String STRUCT_LENGTH_SPEC = "structlengthspec";
    private static final String ADMINDIVISION_ID = "admindivisionid";
    private static final String LEVEL = "level";
    private static final String LENGTH_SHORT = "1";
    private static final String LENGTH_MEDIUM = "2";
    private static final String LENGTH_LONG = "3";
    private static final String CONFIG_ID = "configid";
    private static final String CREATOR_ID = "creatorid";
    private static final String CREATE_TIME = "createtime";
    private static final String FORMAT_PRE_CONFIG_ID = "formatpreconfigid";
    private static final String BUILD_ADDRESS_FIELD_METAS_CACHE = "buildAddressFieldMetasCache";
    private static final String COUNTRY_ID = "countryid";
    private static final String BASE_TYPE = "basetype";
    private static final String MAX_LEVEL = "maxLevel";
    private static final String COLUMN_NAME = "columnname";
    private static final char SPACE_SEPARATOR = ' ';
    private static final String FORMAT_CONTAIN_BLANK = "containblank";
    private static final String ENABLE = "enable";
    private static final String COUNTRY = "country";
    private static final String BD_ADMINDIVISIONLEVEL = "bd_admindivisionlevel";
    private static final String ADMIN_LEVEL = "adminlevel";
    private static final String IS_CONTAIN_ADMIN = "iscontainadmin";
    private static final String PARENT = "parent";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String SAVE_VALUE_CACHE = "saveValueCache";

    public static boolean saveAddress(IPageCache pageCache, IFormView view, IDataModel dataModel, boolean isPC) {
        if (isPC && !AddressUtil.checkLatitudeLongitude(pageCache, view, dataModel)) {
            return false;
        }
        Long addrConfigId = (Long)view.getFormShowParameter().getCustomParam(ADDR_CONFIG_ID);
        Long addrCountryId = Long.valueOf(view.getFormShowParameter().getCustomParam(ADDR_COUNTRY_ID).toString());
        String sourceEntityId = (String)view.getFormShowParameter().getCustomParam(SOURCE_ENTITY_ID);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)CTS_ADDRESS);
        DynamicObject addressSaveDy = new DynamicObject((DynamicObjectType)type);
        Long id = kd.bos.id.ID.genLongId();
        addressSaveDy.set(ID, (Object)id);
        addressSaveDy.set(SOURCE, (Object)sourceEntityId);
        addressSaveDy.set(COUNTRY_ID, (Object)BusinessDataServiceHelper.loadSingle((Object)addrCountryId, (String)BD_COUNTRY));
        addressSaveDy.set(CONFIG_ID, (Object)BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)CTS_ADDRESS_CONFIG));
        List<AddressFieldMetadata> fields = AddressUtil.buildAddressFieldMetas(view.getFormShowParameter(), pageCache);
        for (AddressFieldMetadata metadata : fields) {
            addressSaveDy.set(metadata.getFieldKey(), dataModel.getDataEntity().get(metadata.getFieldKey()));
        }
        String name = AddressUtil.getFormatStr(view, pageCache, addrConfigId, dataModel, addrCountryId);
        if (name.length() > 1024) {
            String msg = ResManager.loadKDString((String)"\u5730\u5740\u6587\u672c\u8d85\u957f\uff08\u6700\u5927\u957f\u5ea6\uff1a1024\uff09\uff0c\u8bf7\u66f4\u6b63\u540e\u4fdd\u5b58\u3002", (String)"AddressUtil_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
            view.showErrorNotification(msg);
            return false;
        }
        if (pageCache != null && pageCache.get(SAVE_VALUE_CACHE) != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)pageCache.get(SAVE_VALUE_CACHE), Map.class);
            map.forEach((propName, value) -> {
                DynamicProperty prop = addressSaveDy.getDynamicObjectType().getProperty(propName);
                if (prop instanceof DecimalProp) {
                    DecimalProp decimalProp = (DecimalProp)prop;
                    BigDecimal val = new BigDecimal((String)value);
                    val = val.setScale(decimalProp.getScale(), 4);
                    addressSaveDy.set(propName, (Object)val);
                } else {
                    addressSaveDy.set(propName, value);
                }
            });
        }
        addressSaveDy.set(NAME, (Object)name);
        addressSaveDy.set(ENABLE, (Object)Character.valueOf('1'));
        addressSaveDy.set(CREATOR_ID, (Object)RequestContext.get().getCurrUserId());
        addressSaveDy.set(CREATE_TIME, (Object)new Date());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)CTS_ADDRESS, (DynamicObject[])new DynamicObject[]{addressSaveDy}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            view.returnDataToParent((Object)id);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : operationResult.getAllErrorOrValidateInfo()) {
            stringBuilder.append(info.getMessage());
        }
        view.showErrorNotification(stringBuilder.toString());
        return false;
    }

    private static boolean checkLatitudeLongitude(IPageCache pageCache, IFormView view, IDataModel dataModel) {
        List<AddressFieldMetadata> fields = AddressUtil.buildAddressFieldMetas(view.getFormShowParameter(), pageCache);
        List errorFieldList = fields.stream().filter(field -> {
            if (("longitude".equals(field.getFieldKey()) || "latitude".equals(field.getFieldKey())) && field.getMustInput().booleanValue()) {
                BigDecimal val = (BigDecimal)dataModel.getDataEntity().get(field.getFieldKey());
                return val.compareTo(BigDecimal.ZERO) == 0;
            }
            return false;
        }).map(AddressFieldMetadata::getFieldName).collect(Collectors.toList());
        if (errorFieldList.size() != 0) {
            String errorTips = String.format(ResManager.loadKDString((String)"%s\u6682\u4e0d\u652f\u6301\u5f55\u51650\u3002", (String)"AddressUtil_1", (String)"bos-address-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorFieldList));
            view.showTipNotification(errorTips);
            return false;
        }
        return true;
    }

    private static List<AddressFieldMetadata> getAddressFieldMetas(Long addrConfigId, Long addrCountryId) {
        DynamicObject addrConfigDy = BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)CTS_ADDRESS_CONFIG);
        DynamicObjectCollection addrSturctConfigColl = (DynamicObjectCollection)addrConfigDy.get(STRUCT_ENTRY_ENTITY);
        ArrayList<AddressFieldMetadata> list = new ArrayList<AddressFieldMetadata>();
        int loadMaxAdminLevel = AddressUtil.calculateLoadAdminLevel(addrCountryId, addrConfigDy);
        TreeSet<Integer> admindivisionLevelInfoSet = new TreeSet<Integer>();
        AddressUtil.checkIsShow(addrSturctConfigColl, loadMaxAdminLevel, admindivisionLevelInfoSet);
        AddressUtil.createLineWrapList(addrSturctConfigColl, loadMaxAdminLevel, addrCountryId, admindivisionLevelInfoSet, list);
        AddressUtil.lineWrap(list);
        return list;
    }

    public static int getLineCountByAddrConfig(DynamicObject addrConfigDy, Long addrCountryId) {
        DynamicObjectCollection addrSturctConfigColl = (DynamicObjectCollection)addrConfigDy.get(STRUCT_ENTRY_ENTITY);
        ArrayList<AddressFieldMetadata> list = new ArrayList<AddressFieldMetadata>();
        int loadMaxAdminLevel = AddressUtil.calculateLoadAdminLevel(addrCountryId, addrConfigDy);
        TreeSet<Integer> admindivisionLevelInfoSet = new TreeSet<Integer>();
        AddressUtil.checkIsShow(addrSturctConfigColl, loadMaxAdminLevel, admindivisionLevelInfoSet);
        AddressUtil.createLineWrapList(addrSturctConfigColl, loadMaxAdminLevel, addrCountryId, admindivisionLevelInfoSet, list);
        AddressUtil.lineWrap(list);
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            AddressFieldMetadata metadata = (AddressFieldMetadata)list.get(i);
            if (i != 0 && (i <= 0 || !metadata.getNextLine().booleanValue())) continue;
            ++count;
        }
        return count;
    }

    private static String getFormatStr(IFormView formView, IPageCache pageCache, Long addrConfigId, IDataModel dataModel, Long addrCountryId) {
        List<AddressFieldMetadata> structMetadataList = AddressUtil.buildAddressFieldMetas(formView.getFormShowParameter(), pageCache);
        return AddressUtil.getFormatStr(structMetadataList, (Object)dataModel.getDataEntity(), addrConfigId, addrCountryId);
    }

    public static String getFormatStr(List<AddressFieldMetadata> structMetadataList, Object dataEntity, Long addrConfigId, Long addrCountryId) {
        Object value;
        DynamicObject addrPreConfigDy;
        HashSet<String> showFieldIdSet = new HashSet<String>(16);
        for (AddressFieldMetadata field : structMetadataList) {
            showFieldIdSet.add(field.getFieldKey());
        }
        StringBuilder sb = new StringBuilder();
        DynamicObject addrConfigDy = BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)CTS_ADDRESS_CONFIG);
        DynamicObjectCollection coll = (DynamicObjectCollection)addrConfigDy.get(FORMAT_ENTRY_ENTITY);
        ArrayList adminDivisionFormatList = new ArrayList();
        TreeMap<Integer, DynamicObject> adminDivisionFormatMap = new TreeMap<Integer, DynamicObject>((i1, i2) -> i2 - i1);
        for (DynamicObject dy : coll) {
            DynamicObject addrPreConfigDy2;
            if (!dy.getBoolean(FORMAT_IS_INCLUDE) || !AddressUtil.isAdminDivisionBaseData(addrPreConfigDy2 = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)dy.get(FORMAT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG))) continue;
            adminDivisionFormatMap.put(addrPreConfigDy2.getInt(ADMIN_LEVEL), dy);
        }
        adminDivisionFormatList.addAll(adminDivisionFormatMap.values());
        int index = -1;
        DynamicObject lastAdminDivisionFormatDy = null;
        for (int i = 0; i < adminDivisionFormatList.size(); ++i) {
            DynamicObject formatDy = (DynamicObject)adminDivisionFormatList.get(i);
            addrPreConfigDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)formatDy.get(FORMAT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG);
            if (!showFieldIdSet.contains(addrPreConfigDy.getString(NUMBER))) continue;
            value = null;
            if (dataEntity instanceof DynamicObject) {
                if (!COUNTRY_ID.equals(addrPreConfigDy.getString(NUMBER))) {
                    value = ((DynamicObject)dataEntity).get(addrPreConfigDy.getString(NUMBER));
                }
            } else if (dataEntity instanceof Map) {
                value = ((Map)dataEntity).get(addrPreConfigDy.getString(NUMBER));
            } else {
                throw new RuntimeException("dataEntity type must is Map or DynamicObject");
            }
            if (value == null) continue;
            index = i;
            lastAdminDivisionFormatDy = formatDy;
            break;
        }
        if (index != -1) {
            boolean lastAdminDivisionNeedNextLine = false;
            for (int i = 0; i < index; ++i) {
                DynamicObject formatDy = (DynamicObject)adminDivisionFormatList.get(i);
                if (!formatDy.getBoolean(FORMAT_IS_NEW_LINE)) continue;
                lastAdminDivisionNeedNextLine = true;
                if (lastAdminDivisionFormatDy == null) break;
                lastAdminDivisionFormatDy.set(FORMAT_IS_NEW_LINE, (Object)Boolean.TRUE);
                break;
            }
        }
        for (DynamicObject dy : coll) {
            addrPreConfigDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)dy.get(FORMAT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG);
            if (!showFieldIdSet.contains(addrPreConfigDy.getString(NUMBER)) && !AddressUtil.isCountryBaseData(addrPreConfigDy) || !dy.getBoolean(FORMAT_IS_INCLUDE)) continue;
            value = null;
            if (dataEntity instanceof DynamicObject) {
                if (!COUNTRY_ID.equals(addrPreConfigDy.getString(NUMBER))) {
                    value = ((DynamicObject)dataEntity).get(addrPreConfigDy.getString(NUMBER));
                }
            } else if (dataEntity instanceof Map) {
                value = ((Map)dataEntity).get(addrPreConfigDy.getString(NUMBER));
            } else {
                throw new RuntimeException("dataEntity type must is Map or DynamicObject");
            }
            sb.append(AddressUtil.getFormatStr(addrPreConfigDy, dy, value, addrCountryId));
        }
        return sb.toString();
    }

    public static String getAddressFormatStr(Object dataEntity, Long addrConfigId, Long addrCountryId) {
        List<AddressFieldMetadata> structMetadataList = AddressUtil.getAddressFieldMetas(addrConfigId, addrCountryId);
        return AddressUtil.getFormatStr(structMetadataList, dataEntity, addrConfigId, addrCountryId);
    }

    private static String getFormatStr(DynamicObject addrPreConfigDy, DynamicObject dy, Object value, Long addrCountryId) {
        if (AddressUtil.isBaseData(addrPreConfigDy)) {
            if (AddressUtil.isCountryBaseData(addrPreConfigDy)) {
                return AddressUtil.getCountryBaseDataFormatStr(dy, addrCountryId);
            }
            DynamicObject basedataDy = (DynamicObject)value;
            return AddressUtil.getBasedataFormatStr(dy, basedataDy);
        }
        if (LENGTH_LONG.equals(addrPreConfigDy.getString("type"))) {
            BigDecimal contentVal = (BigDecimal)value;
            FormatObject formatObject = InteServiceHelper.getFormat((Long)494148073165990912L);
            formatObject.getNumberFormat().setMaximumFractionDigits(8);
            formatObject.getNumberFormat().setMinimumFractionDigits(8);
            String content = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(formatObject).format(contentVal);
            return AddressUtil.getTextFormatStr(dy, content);
        }
        String content = (String)value;
        return AddressUtil.getTextFormatStr(dy, content);
    }

    public static String getPreviewFormatStr(DynamicObject addrConfigDy, Long addrCountryId) {
        DynamicObjectCollection structList = (DynamicObjectCollection)addrConfigDy.get(STRUCT_ENTRY_ENTITY);
        DynamicObjectCollection formatList = (DynamicObjectCollection)addrConfigDy.get(FORMAT_ENTRY_ENTITY);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject format : formatList) {
            int adminlevel;
            int loadMaxAdminLevel = AddressUtil.calculateLoadAdminLevel(addrCountryId, addrConfigDy);
            DynamicObject preFieldConfigDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)format.get(FORMAT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG);
            if (AddressUtil.isAdminDivisionBaseData(preFieldConfigDy) && (adminlevel = preFieldConfigDy.getInt(ADMIN_LEVEL)) > loadMaxAdminLevel) continue;
            DynamicObject struct = null;
            for (DynamicObject structDy : structList) {
                if (!((DynamicObject)format.get(FORMAT_PRE_CONFIG_ID)).getPkValue().equals(((DynamicObject)structDy.get(STRUCT_PRE_CONFIG_ID)).getPkValue())) continue;
                struct = structDy;
                break;
            }
            if (!format.getBoolean(FORMAT_IS_INCLUDE)) continue;
            if (format.getBoolean(FORMAT_IS_NEW_LINE)) {
                sb.append(LINE_FEED);
            }
            String formatprefix = AddressUtil.getFormatPrefix(format);
            sb.append(formatprefix);
            sb.append("&lt;");
            sb.append(AddressUtil.getContent(struct, format, addrCountryId));
            sb.append("&gt;");
            String formatsuffix = AddressUtil.getFormatSuffix(format);
            sb.append(formatsuffix);
            if (!format.getBoolean(FORMAT_CONTAIN_BLANK)) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String getContent(DynamicObject struct, DynamicObject format, Long addrCountryId) {
        DynamicObject preFieldConfigDy = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)format.get(FORMAT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG);
        String tag = "";
        if (AddressUtil.isCountryBaseData(preFieldConfigDy)) {
            tag = preFieldConfigDy.getString(NAME);
        } else if (AddressUtil.isAdminDivisionBaseData(preFieldConfigDy)) {
            tag = AddressUtil.getAdminDivisionLevelName(addrCountryId, preFieldConfigDy);
            if (StringUtils.isBlank((CharSequence)tag)) {
                tag = preFieldConfigDy.getString(NAME);
            }
        } else if (struct == null || StringUtils.isBlank((CharSequence)(tag = struct.getString(STRUCT_USER_DEFINE_TAG)))) {
            tag = preFieldConfigDy.getString(NAME);
        }
        return tag;
    }

    private static String getBasedataFormatStr(DynamicObject dy, DynamicObject basedataDy) {
        String basedataStr;
        if (basedataDy == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (dy.getBoolean(FORMAT_IS_NEW_LINE)) {
            sb.append(LINE_FEED);
        }
        String formatprefix = AddressUtil.getFormatPrefix(dy);
        sb.append(formatprefix);
        Object o = dy.get(FORMAT_REPLACEA_ATTR);
        if (o != null) {
            String attr = ((DynamicObject)o).getString(COLUMN_NAME);
            basedataStr = basedataDy.getString(attr);
        } else {
            basedataStr = basedataDy.getString(NAME);
        }
        sb.append(basedataStr);
        String formatsuffix = AddressUtil.getFormatSuffix(dy);
        sb.append(formatsuffix);
        if (dy.getBoolean(FORMAT_CONTAIN_BLANK)) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String getCountryBaseDataFormatStr(DynamicObject dy, Long countryId) {
        String basedataStr;
        DynamicObject countryDy = BusinessDataServiceHelper.loadSingle((Object)countryId, (String)BD_COUNTRY);
        if (countryDy == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (dy.getBoolean(FORMAT_IS_NEW_LINE)) {
            sb.append(LINE_FEED);
        }
        String formatprefix = AddressUtil.getFormatPrefix(dy);
        sb.append(formatprefix);
        Object o = dy.get(FORMAT_REPLACEA_ATTR);
        if (o != null) {
            String attr = ((DynamicObject)o).getString(COLUMN_NAME);
            basedataStr = countryDy.getString(attr);
        } else {
            basedataStr = countryDy.getString(NAME);
        }
        sb.append(basedataStr);
        String formatsuffix = AddressUtil.getFormatSuffix(dy);
        sb.append(formatsuffix);
        if (dy.getBoolean(FORMAT_CONTAIN_BLANK)) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String getTextFormatStr(DynamicObject dy, String content) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)content)) {
            if (dy.getBoolean(FORMAT_IS_NEW_LINE)) {
                sb.append(LINE_FEED);
            }
            String formatprefix = AddressUtil.getFormatPrefix(dy);
            sb.append(formatprefix);
            sb.append(content);
            String formatsuffix = AddressUtil.getFormatSuffix(dy);
            sb.append(formatsuffix);
            if (dy.getBoolean(FORMAT_CONTAIN_BLANK)) {
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    private static String getFormatPrefix(DynamicObject dy) {
        String formatprefix = dy.getString(FORMAT_PREFIX);
        if (!StringUtils.isBlank((CharSequence)formatprefix)) {
            return formatprefix;
        }
        return "";
    }

    private static String getFormatSuffix(DynamicObject dy) {
        String formatsuffix = dy.getString(FORMAT_SUFFIX);
        if (!StringUtils.isBlank((CharSequence)formatsuffix)) {
            return formatsuffix;
        }
        return "";
    }

    public static List<AddressFieldMetadata> buildAddressFieldMetas(FormShowParameter formShowParameter, IPageCache pageCache) {
        Object addrConfigIdObj = formShowParameter.getCustomParam(ADDR_CONFIG_ID);
        if (addrConfigIdObj == null) {
            return new ArrayList<AddressFieldMetadata>(10);
        }
        Long addrConfigId = Long.valueOf(addrConfigIdObj.toString());
        Long addrCountryId = Long.valueOf(formShowParameter.getCustomParam(ADDR_COUNTRY_ID).toString());
        if (pageCache != null && pageCache.get(BUILD_ADDRESS_FIELD_METAS_CACHE) != null) {
            String str = pageCache.get(BUILD_ADDRESS_FIELD_METAS_CACHE);
            return SerializationUtils.fromJsonStringToList((String)str, AddressFieldMetadata.class);
        }
        DynamicObject addrConfigDy = addrConfigId == -1L ? (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)formShowParameter.getCustomParam("address_config_preview_model"))) : BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)CTS_ADDRESS_CONFIG);
        List<AddressFieldMetadata> list = AddressUtil.buildAddressFieldMetas(addrCountryId, addrConfigDy);
        if (pageCache != null) {
            pageCache.put(BUILD_ADDRESS_FIELD_METAS_CACHE, SerializationUtils.toJsonString(list));
        }
        return list;
    }

    public static List<AddressFieldMetadata> buildAddressFieldMetas(Long addrCountryId, DynamicObject addrConfigDy) {
        DynamicObjectCollection addrSturctConfigColl = (DynamicObjectCollection)addrConfigDy.get(STRUCT_ENTRY_ENTITY);
        ArrayList<AddressFieldMetadata> list = new ArrayList<AddressFieldMetadata>();
        int loadMaxAdminLevel = AddressUtil.calculateLoadAdminLevel(addrCountryId, addrConfigDy);
        TreeSet<Integer> admindivisionLevelInfoSet = new TreeSet<Integer>();
        AddressUtil.checkIsShow(addrSturctConfigColl, loadMaxAdminLevel, admindivisionLevelInfoSet);
        AddressUtil.createLineWrapList(addrSturctConfigColl, loadMaxAdminLevel, addrCountryId, admindivisionLevelInfoSet, list);
        AddressUtil.lineWrap(list);
        return list;
    }

    public static Map<String, Object> convertMapAddress(String result, Long addrContryId, Long addrConfigId) {
        HashMap<String, Object> addressMap = new HashMap<String, Object>();
        String selectProperties = "id,mapfieldmappingentry.id,mapfieldmappingentry.addressconfigfield,mapfieldmappingentry.maptipsfield,mapfieldmappingentry.admindivisionnumber";
        QFilter advanceAddressQFilter = new QFilter(NUMBER, "=", (Object)"SYSTEM_PRESET");
        DynamicObject advanceAddress = BusinessDataServiceHelper.loadSingleFromCache((String)"cts_advance_address", (String)selectProperties, (QFilter[])advanceAddressQFilter.toArray());
        try {
            ObjectMapper jackson = new ObjectMapper();
            JsonNode node = jackson.readTree(result);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            AddressUtil.jsonLeaf(resultMap, null, node);
            DynamicObject addrConfigDy = BusinessDataServiceHelper.loadSingle((Object)addrConfigId, (String)CTS_ADDRESS_CONFIG);
            List<AddressFieldMetadata> fields = AddressUtil.buildAddressFieldMetas(addrContryId, addrConfigDy);
            Set propertyMap = fields.stream().map(AddressFieldMetadata::getFieldKey).collect(Collectors.toSet());
            for (DynamicObject mapping : advanceAddress.getDynamicObjectCollection("mapfieldmappingentry")) {
                String mapTipsField = mapping.getString("maptipsfield");
                String[] split = mapTipsField.split("&");
                StringBuilder builder = new StringBuilder();
                for (String s : split) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(s)))) continue;
                    builder.append((String)resultMap.get(s));
                }
                String addressConfigField = mapping.getString("addressconfigfield");
                if (addressConfigField.contains("admindivision")) {
                    String adminDivisionNumber = mapping.getString("admindivisionnumber");
                    QFilter admindivisionQFilter = new QFilter(adminDivisionNumber, "=", (Object)builder.toString());
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_admindivision", (String)"id,longnumber", (QFilter[])admindivisionQFilter.toArray());
                    if (dynamicObject == null) continue;
                    addressMap.put("admindivision", dynamicObject.getString(ID));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)builder.toString()) || !propertyMap.contains(addressConfigField)) continue;
                addressMap.put(addressConfigField, builder.toString());
            }
        }
        catch (Exception e) {
            addressMap = new HashMap();
        }
        return addressMap;
    }

    private static void jsonLeaf(Map<String, String> map, String key, JsonNode node) {
        if (node.isValueNode()) {
            map.put(key, node.asText());
        }
        if (node.isObject()) {
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String newKey = (String)entry.getKey();
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    newKey = key + "." + newKey;
                }
                AddressUtil.jsonLeaf(map, newKey, (JsonNode)entry.getValue());
            }
        }
        if (node.isArray()) {
            for (int i = 0; i < node.size(); ++i) {
                AddressUtil.jsonLeaf(map, key + "[" + i + "]", node.get(i));
            }
        }
    }

    private static void checkIsShow(DynamicObjectCollection addrSturctConfigColl, int loadMaxAdminLevel, TreeSet<Integer> admindivisionLevelInfoSet) {
        for (DynamicObject addrStructConfigDy : addrSturctConfigColl) {
            int adminlevel;
            Map dyMap = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{((DynamicObject)addrStructConfigDy.get(STRUCT_PRE_CONFIG_ID)).getLong(ID)}, (String)CTS_ADDRESS_PRE_CONFIG);
            if (dyMap == null || dyMap.size() <= 0) continue;
            DynamicObject preFieldConfigDy = (DynamicObject)dyMap.values().toArray()[0];
            String isshow = addrStructConfigDy.getString(STRUCT_IS_SHOW);
            if (!isshow.equals(TRUE) || (adminlevel = preFieldConfigDy.getInt(ADMIN_LEVEL)) > loadMaxAdminLevel || !AddressUtil.isAdminDivisionBaseData(preFieldConfigDy)) continue;
            int adminLevel = preFieldConfigDy.getInt(ADMIN_LEVEL);
            admindivisionLevelInfoSet.add(adminLevel);
        }
    }

    private static void createLineWrapList(DynamicObjectCollection addrSturctConfigColl, int loadMaxAdminLevel, Long addrCountryId, TreeSet<Integer> admindivisionLevelInfoSet, List<AddressFieldMetadata> list) {
        List adminDivisionList;
        boolean hideAdminDivisionHasNextLine = false;
        for (DynamicObject addrStructConfigDy : addrSturctConfigColl) {
            String tag;
            int adminlevel;
            DynamicObject preFieldConfigDy = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)addrStructConfigDy.get(STRUCT_PRE_CONFIG_ID)).getLong(ID), (String)CTS_ADDRESS_PRE_CONFIG);
            String isshow = addrStructConfigDy.getString(STRUCT_IS_SHOW);
            if (!isshow.equals(TRUE)) continue;
            if (AddressUtil.isAdminDivisionBaseData(preFieldConfigDy) && (adminlevel = preFieldConfigDy.getInt(ADMIN_LEVEL)) > loadMaxAdminLevel) {
                if (!addrStructConfigDy.getBoolean(STRUCT_IS_NEW_LINE)) continue;
                hideAdminDivisionHasNextLine = true;
                continue;
            }
            AddressFieldMetadata addressFieldMetadata = new AddressFieldMetadata();
            addressFieldMetadata.setMustInput((Boolean)addrStructConfigDy.get(STRUCT_IS_REQUIRED));
            addressFieldMetadata.setNextLine((Boolean)addrStructConfigDy.get(STRUCT_IS_NEW_LINE));
            if (AddressUtil.isAdminDivisionBaseData(preFieldConfigDy)) {
                tag = AddressUtil.getAdminDivisionLevelName(addrCountryId, preFieldConfigDy);
                if (StringUtils.isBlank((CharSequence)tag)) {
                    tag = preFieldConfigDy.getString(NAME);
                }
                addressFieldMetadata.setFieldName(tag);
            } else {
                tag = addrStructConfigDy.getString(STRUCT_USER_DEFINE_TAG);
                if (StringUtils.isBlank((CharSequence)tag)) {
                    tag = preFieldConfigDy.getString(NAME);
                }
                addressFieldMetadata.setFieldName(tag);
            }
            AddressFieldLengthEnum lengthEnum = AddressFieldLengthEnum.SHORT;
            String length = addrStructConfigDy.getString(STRUCT_LENGTH_SPEC);
            if (length.equals(LENGTH_SHORT)) {
                lengthEnum = AddressFieldLengthEnum.SHORT;
            } else if (length.equals(LENGTH_MEDIUM)) {
                lengthEnum = AddressFieldLengthEnum.MEDIUM;
            } else if (length.equals(LENGTH_LONG)) {
                lengthEnum = AddressFieldLengthEnum.LONG;
            }
            addressFieldMetadata.setFieldLength(lengthEnum);
            addressFieldMetadata.setFieldKey(preFieldConfigDy.getString(NUMBER));
            AddressFiledTypeEnum fieldType = AddressFiledTypeEnum.TEXT;
            if (AddressUtil.isBaseData(preFieldConfigDy)) {
                if (AddressUtil.isAdminDivisionBaseData(preFieldConfigDy)) {
                    fieldType = AddressFiledTypeEnum.BASEDATA;
                    AddressUtil.handleAdminDivisionBaseData(preFieldConfigDy, addressFieldMetadata, admindivisionLevelInfoSet);
                }
                addressFieldMetadata.setBaseDataEntityId(preFieldConfigDy.getString(BASE_TYPE));
            } else if (LENGTH_LONG.equals(preFieldConfigDy.getString("type"))) {
                fieldType = AddressFiledTypeEnum.DECIMAL;
            }
            addressFieldMetadata.setFieldType(fieldType);
            list.add(addressFieldMetadata);
        }
        if (hideAdminDivisionHasNextLine && (adminDivisionList = list.stream().filter(meta -> meta.getAdminDivisionLevel() > 0).sorted(Comparator.comparingInt(AddressFieldMetadata::getAdminDivisionLevel)).collect(Collectors.toList())).size() > 0 && !((AddressFieldMetadata)adminDivisionList.get(adminDivisionList.size() - 1)).getNextLine().booleanValue()) {
            ((AddressFieldMetadata)adminDivisionList.get(adminDivisionList.size() - 1)).setNextLine(Boolean.TRUE);
        }
    }

    private static void handleAdminDivisionBaseData(DynamicObject preFieldConfigDy, AddressFieldMetadata addressFieldMetadata, TreeSet<Integer> admindivisionLevelInfoSet) {
        Integer level = preFieldConfigDy.getInt(ADMIN_LEVEL);
        QFilter qFilter = new QFilter(LEVEL, "=", (Object)level);
        Integer priviousLevel = admindivisionLevelInfoSet.lower(level);
        if (priviousLevel != null) {
            String previousKey = ADMINDIVISION_ID + priviousLevel;
            addressFieldMetadata.setPriviousKey(previousKey);
        } else {
            addressFieldMetadata.setPriviousKey(COUNTRY);
        }
        addressFieldMetadata.setAdminDivisionLevel(level);
        addressFieldMetadata.setqFilters(Collections.singletonList(qFilter));
    }

    private static void lineWrap(List<AddressFieldMetadata> addressFields) {
        int lineMaxlength = 0;
        for (AddressFieldMetadata metadata : addressFields) {
            int fieldLength = 1;
            if (AddressFieldLengthEnum.LONG == metadata.getFieldLength()) {
                fieldLength = 3;
            } else if (AddressFieldLengthEnum.MEDIUM == metadata.getFieldLength()) {
                fieldLength = 2;
            }
            if (metadata.getNextLine().booleanValue()) {
                lineMaxlength = fieldLength;
                continue;
            }
            if (lineMaxlength + fieldLength <= 3) {
                lineMaxlength += fieldLength;
                continue;
            }
            lineMaxlength = fieldLength;
            metadata.setNextLine(Boolean.TRUE);
        }
    }

    private static String getAdminDivisionLevelName(Long addrCountryId, DynamicObject preFieldConfigDy) {
        int adminlevel = preFieldConfigDy.getInt(ADMIN_LEVEL);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)LENGTH_SHORT);
        QFilter countryFilter = new QFilter(COUNTRY, "=", (Object)addrCountryId);
        QFilter levelFilter = new QFilter(LEVEL, "=", (Object)adminlevel);
        DynamicObject[] adminLevelDyArray = BusinessDataServiceHelper.load((String)BD_ADMINDIVISIONLEVEL, (String)"name,country,level,enable", (QFilter[])new QFilter[]{enableFilter, countryFilter, levelFilter});
        if (adminLevelDyArray.length > 0) {
            return adminLevelDyArray[0].getString(NAME);
        }
        return preFieldConfigDy.getString(NAME);
    }

    private static int calculateLoadAdminLevel(Long countryId, DynamicObject addrConfigDy) {
        int loadAdminLevel = 0;
        Boolean isContainAdmin = addrConfigDy.getBoolean(IS_CONTAIN_ADMIN);
        String adminLevel = addrConfigDy.getString(ADMIN_LEVEL);
        if (isContainAdmin != null && !StringUtils.isBlank((CharSequence)adminLevel)) {
            int adminDivisionCountryMaxLevel = 0;
            String sql = "SELECT fid,flevel FROM t_bd_admindivisionlevel WHERE fenable = '1' AND fcountryid = ?";
            ArrayList adminLevelList = new ArrayList();
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{countryId}, rs -> {
                while (rs.next()) {
                    HashMap<String, Number> map = new HashMap<String, Number>();
                    map.put(ID, rs.getLong("FID"));
                    map.put(LEVEL, rs.getInt("FLEVEL"));
                    adminLevelList.add(map);
                }
                return adminLevelList;
            });
            for (Map map : adminLevelList) {
                Integer level = (Integer)map.get(LEVEL);
                adminDivisionCountryMaxLevel = Math.max(adminDivisionCountryMaxLevel, level);
            }
            int selectedAdminLevel = Integer.parseInt(adminLevel);
            loadAdminLevel = selectedAdminLevel > adminDivisionCountryMaxLevel ? adminDivisionCountryMaxLevel : selectedAdminLevel;
        }
        return loadAdminLevel;
    }

    private static boolean isBaseData(DynamicObject preFieldConfigDy) {
        String type = preFieldConfigDy.getString("type");
        return LENGTH_MEDIUM.equals(type);
    }

    private static boolean isAdminDivisionBaseData(DynamicObject preFieldConfigDy) {
        return AddressUtil.isBaseData(preFieldConfigDy) && "bd_admindivision".equals(preFieldConfigDy.getString(BASE_TYPE));
    }

    private static boolean isCountryBaseData(DynamicObject preFieldConfigDy) {
        return AddressUtil.isBaseData(preFieldConfigDy) && BD_COUNTRY.equals(preFieldConfigDy.getString(BASE_TYPE));
    }

    public static List<Map<String, Object>> getPreConfigList() {
        DynamicObjectCollection dycoll = QueryServiceHelper.query((String)CTS_ADDRESS_PRE_CONFIG, (String)SELECT_FIELDS, null, (String)"FSEQ ASC");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject dy : dycoll) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ID, dy.getLong(ID));
            map.put(NUMBER, dy.getString(NUMBER));
            map.put(NAME, dy.getString(NAME));
            list.add(map);
        }
        return list;
    }

    public static DynamicObject getPreConfigById(Long id) {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, "=", (Object)id)};
        String selectField = "type, basetype";
        return QueryServiceHelper.queryOne((String)CTS_ADDRESS_PRE_CONFIG, (String)selectField, (QFilter[])qFilters);
    }

    public static List<String> getCountryAndAdminPreConfigIds() {
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)Character.valueOf('2')), new QFilter(BASE_TYPE, "in", Arrays.asList(BD_COUNTRY, "bd_admindivision"))};
        String selectField = ID;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)CTS_ADDRESS_PRE_CONFIG, (String)selectField, (QFilter[])qFilters);
        return dynamicObjects.stream().map(e -> e.getString(ID)).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> getAdminLevelPreConfigList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        QFilter qFilter = new QFilter(NUMBER, "like", (Object)"admindivisionid%");
        DynamicObjectCollection dys = QueryServiceHelper.query((String)CTS_ADDRESS_PRE_CONFIG, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dy : dys) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ID, dy.getLong(ID));
            map.put(NUMBER, dy.getString(NUMBER));
            map.put(NAME, dy.getString(NAME));
            list.add(map);
        }
        return list;
    }

    public static int getMaxAdminLevelByCountryIds(List countryIds) {
        if (CollectionUtils.isEmpty((Collection)countryIds)) {
            return 0;
        }
        String sql = String.format("SELECT MAX(FLEVEL) maxLevel FROM T_BD_ADMINDIVISIONLEVEL WHERE FENABLE = '1' AND FCOUNTRYID IN (%s)", StringUtils.join((Object[])countryIds.toArray(), (String)","));
        ArrayList res = new ArrayList(10);
        DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rs -> {
            while (rs.next()) {
                res.add(rs.getInt(MAX_LEVEL));
            }
            return res;
        });
        if (!CollectionUtils.isEmpty(res)) {
            return (Integer)res.get(0);
        }
        return 0;
    }

    public static List<Long> getChildIdListByAdminDivisonIdAndLevel(long adminId, int adminLevel, int targetLevel) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(adminId);
        for (int i = adminLevel + 1; i <= targetLevel; ++i) {
            QFilter qFilter = new QFilter(LEVEL, "=", (Object)i).and(new QFilter(PARENT, "in", idList));
            DynamicObject[] dyArray = BusinessDataServiceHelper.loadFromCache((String)"bd_admindivision", (String)ID, (QFilter[])qFilter.toArray()).values().toArray(new DynamicObject[0]);
            if (dyArray.length == 0) {
                return new ArrayList<Long>();
            }
            idList = new ArrayList(16);
            for (DynamicObject dy : dyArray) {
                idList.add(dy.getLong(ID));
            }
        }
        return idList;
    }
}

