/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.address.validator;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AddressSaveValidator
extends AbstractValidator {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String LEVEL = "level";
    private static final String PARENT = "parent";
    private static final String NAME = "name";
    private static final String MASTERID = "masterid";
    private static final String ENABLE = "enable";
    private static final String IS_CONTAIN_ADMIN = "iscontainadmin";
    private static final String IS_DEFAULT = "isdefault";
    private static final String ADMINLEVEL = "adminlevel";
    private static final String TYPE = "type";
    private static final String COLUMNNAME = "columnname";
    private static final String DESCRIPTION = "description";
    private static final String CREATOR_ID = "creatorid";
    private static final String CREATE_TIME = "createtime";
    private static final String FORMAT_REPLACE_ATTR = "formatreplaceattr";
    private static final String FORMAT_PRECONFIG_ID = "formatpreconfigid";
    private static final String STRUCT_ISSHOW = "structisshow";
    private static final String FORMATPREFIX = "formatprefix";
    private static final String FORMATSUFFIX = "formatsuffix";
    private static final String CONTAINBLANK = "containblank";
    private static final String FORMATISINCLUDE = "formatisinclude";
    private static final String FORMATISNEWLINE = "formatisnewline";
    private static final String STRUCT_ISREQUIRED = "structisrequired";
    private static final String STRUCT_ENTRY_ENTITY = "structentryentity";
    private static final String FORMAT_ENTRY_ENTITY = "formatentryentity";
    private static final String STRUCT_PRECONFIGID = "structpreconfigid";
    private static final String CTS_ADDRESS_CONFIG = "cts_addressconfig";
    private static final String CTS_ADDRESS_PRECONFIG = "cts_addresspreconfig";
    private static final String CTS_ADDRESS = "cts_address";
    private static final String BD_COUNTRY = "bd_country";
    private static final String NUMBER = "number";
    private static final List<String> fields = new ArrayList<String>(15);
    private static final Map<String, Long> fieldLength = new HashMap<String, Long>(16);
    private static final String LONGITUDE = "longitude";
    private static final String LATITUDE = "latitude";
    private static final String STREET1 = "street1";
    private static final String STREET2 = "street2";
    private static final String HOUSENUM = "housenum";
    private static final String HOUSENUM2 = "housenum2";
    private static final String BUILDING = "building";
    private static final String FLOOR = "floor";
    private static final String ROOMNUM = "roomnum";
    private static final String POBOX = "pobox";
    private static final String ADDRESS1 = "address1";
    private static final String ADDRESS2 = "address2";
    private static final String ADDRESS3 = "address3";
    private static final String ADDRESS4 = "address4";
    private static final String ADDRESS5 = "address5";
    private static final String POSTCODE1 = "postcode1";
    private static final String POSTCODE2 = "postcode2";
    private static final String POSTCODE3 = "postcode3";
    private static final String POSTCODEEXT = "postcodeext";
    private static final String DETAIL = "detail";
    private static final String PREFIX = "prefix";
    private static final String SUFFIX = "suffix";
    private static final String DEFINE_TAG = "defineTag";
    private static final String COUNTRY = "country";
    private static final String SOURCE = "source";
    private static final String CONFIG_ID = "configid";
    private static final String FROM_FORM = "fromForm";
    private static final String COUNTRY_ID = "countryid";
    private static final String ADMINDIVISION = "admindivision";
    private static final String ADMINDIVISION_ID = "admindivisionid";
    private static final String ADDRESS_CONFIG_ID = "addressConfigId";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String ID = "id";
    private static final String BOS_ADDRESS_FORMPLUGIN = "bos-address-formplugin";

    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject dynamicObject = extend.getDataEntity();
            Map<String, String> errorMap = this.checkBaseInfo(dynamicObject);
            if (errorMap.size() > 0) {
                this.addErrorMessage(errorMap, extend);
                return;
            }
            errorMap = this.checkAddressConfigParams(dynamicObject.getDynamicObject(CONFIG_ID).getPkValue().toString(), dynamicObject);
            if (errorMap.size() <= 0) continue;
            this.addErrorMessage(errorMap, extend);
            return;
        }
    }

    private void addErrorMessage(Map<String, String> errorMap, ExtendedDataEntity extend) {
        String errorMsg = Joiner.on((String)"").join(errorMap.values());
        this.addMessage(extend, errorMsg, ErrorLevel.Error);
    }

    private Map<String, String> checkBaseInfo(DynamicObject dynamicObject) {
        double lat;
        String msg;
        double lon;
        String msg2;
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        DynamicObject country = dynamicObject.getDynamicObject(COUNTRY_ID);
        Object source = dynamicObject.get(SOURCE);
        DynamicObject addressConfig = dynamicObject.getDynamicObject(CONFIG_ID);
        if (country == null) {
            msg2 = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddressSaveValidator_0", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
            errorMsg.put(COUNTRY, msg2);
        }
        if (addressConfig == null) {
            msg2 = ResManager.loadKDString((String)"\u5730\u5740\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddressSaveValidator_1", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
            errorMsg.put(ADDRESS_CONFIG_ID, msg2);
        }
        if (source == null) {
            msg2 = ResManager.loadKDString((String)"\u5730\u5740\u6765\u6e90\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddressSaveValidator_2", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
            errorMsg.put("formForm", msg2);
        }
        Object longitude = dynamicObject.get(LONGITUDE);
        Object latitude = dynamicObject.get(LATITUDE);
        if (longitude != null && ((lon = Double.parseDouble(longitude.toString())) < -180.0 || lon > 180.0)) {
            msg = ResManager.loadKDString((String)"\u7ecf\u5ea6\u6570\u503c\u8981\u4ecb\u4e8e-180\u81f3180\u3002", (String)"AddressSaveValidator_3", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
            errorMsg.put(LONGITUDE, msg);
        }
        if (latitude != null && ((lat = Double.parseDouble(latitude.toString())) < -90.0 || lat > 90.0)) {
            msg = ResManager.loadKDString((String)"\u7eac\u5ea6\u6570\u503c\u8981\u4ecb\u4e8e-90\u81f390\u3002", (String)"AddressSaveValidator_4", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
            errorMsg.put(LATITUDE, msg);
        }
        if (errorMsg.size() > 0) {
            return errorMsg;
        }
        if (addressConfig != null && country != null) {
            String sql = "SELECT fid FROM t_cts_addrconfigcountry WHERE fid = ? AND fbasedataid = ? ";
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{addressConfig.getPkValue(), country.getPkValue()}, rs -> {
                while (rs.next()) {
                    long fid = rs.getLong("fid");
                    if (fid <= 0L) continue;
                    return Boolean.TRUE;
                }
                String msg = ResManager.loadResFormat((String)"\u5730\u5740\u683c\u5f0f\u548c\u56fd\u5bb6\u6216\u5730\u533a\u4e0d\u5bf9\u5e94\u3002", (String)"AddressSaveValidator_5", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[0]);
                errorMsg.put(ADDRESS_CONFIG_ID, msg);
                return Boolean.FALSE;
            });
        }
        return errorMsg;
    }

    private Map<String, String> checkAddressConfigParams(String addressConfigId, DynamicObject addressInfo) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)addressConfigId, (String)CTS_ADDRESS_CONFIG);
        DynamicObjectCollection structpreconfigid = dynamicObject.getDynamicObjectCollection(STRUCT_ENTRY_ENTITY);
        HashMap<String, Boolean> fieldShowMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> fieldRequiredMap = new HashMap<String, Boolean>(16);
        for (DynamicObject entry : structpreconfigid) {
            Boolean structisshow = entry.getBoolean(STRUCT_ISSHOW);
            Boolean structisrequired = entry.getBoolean(STRUCT_ISREQUIRED);
            String number = entry.getDynamicObject(STRUCT_PRECONFIGID).getString(NUMBER);
            fieldShowMap.put(number, structisshow);
            fieldRequiredMap.put(number, structisrequired);
        }
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        for (int i = 0; i < fields.size(); ++i) {
            int length;
            String field = fields.get(i);
            Boolean show = (Boolean)fieldShowMap.get(field);
            Boolean require = (Boolean)fieldRequiredMap.get(field);
            Object value = addressInfo.get(field);
            show = show == null ? Boolean.FALSE : show;
            Boolean bl = require = require == null ? Boolean.FALSE : require;
            if (show.booleanValue() && require.booleanValue() && (value == null || StringUtils.isBlank((CharSequence)value.toString()))) {
                String msg = ResManager.loadResFormat((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddressSaveValidator_6", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[]{field});
                errorMsg.put(field, msg);
                continue;
            }
            if (!(show.booleanValue() || value == null || value instanceof String && !StringUtils.isNotBlank((CharSequence)value.toString()) || LATITUDE.equals(field) || LONGITUDE.equals(field))) {
                String msg = ResManager.loadResFormat((String)"%s\u9700\u8981\u4e3a\u7a7a\u3002", (String)"AddressSaveValidator_7", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[]{field});
                errorMsg.put(field, msg);
                continue;
            }
            if (value == null || (long)(length = value.toString().length()) <= fieldLength.get(field)) continue;
            String msg = ResManager.loadResFormat((String)"%s\u8d85\u957f\u3002", (String)"AddressSaveValidator_8", (String)BOS_ADDRESS_FORMPLUGIN, (Object[])new Object[]{field});
            errorMsg.put(field, msg);
        }
        return errorMsg;
    }

    static {
        fields.add(STREET1);
        fields.add(STREET2);
        fields.add(HOUSENUM);
        fields.add(HOUSENUM2);
        fields.add(BUILDING);
        fields.add(FLOOR);
        fields.add(ROOMNUM);
        fields.add(POSTCODE1);
        fields.add(POSTCODE2);
        fields.add(POSTCODE3);
        fields.add(POSTCODEEXT);
        fields.add(POBOX);
        fields.add(ADDRESS1);
        fields.add(ADDRESS2);
        fields.add(ADDRESS3);
        fields.add(ADDRESS4);
        fields.add(ADDRESS5);
        fields.add(DETAIL);
        fields.add(LATITUDE);
        fields.add(LONGITUDE);
        fieldLength.put(ADDRESS1, 255L);
        fieldLength.put(ADDRESS2, 255L);
        fieldLength.put(ADDRESS3, 255L);
        fieldLength.put(ADDRESS4, 255L);
        fieldLength.put(ADDRESS5, 255L);
        fieldLength.put(POBOX, 30L);
        fieldLength.put(STREET1, 50L);
        fieldLength.put(STREET2, 50L);
        fieldLength.put(HOUSENUM, 50L);
        fieldLength.put(HOUSENUM2, 50L);
        fieldLength.put(BUILDING, 30L);
        fieldLength.put(ROOMNUM, 30L);
        fieldLength.put(FLOOR, 10L);
        fieldLength.put(POSTCODE1, 10L);
        fieldLength.put(POSTCODE2, 10L);
        fieldLength.put(POSTCODE3, 10L);
        fieldLength.put(POSTCODEEXT, 10L);
        fieldLength.put(PREFIX, 30L);
        fieldLength.put(SUFFIX, 30L);
        fieldLength.put(DETAIL, 500L);
        fieldLength.put(DEFINE_TAG, 50L);
        fieldLength.put(LATITUDE, 50L);
        fieldLength.put(LONGITUDE, 50L);
    }
}

