/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.exrate.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IMobileView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.field.ExRateConfigUtil;
import kd.bos.form.field.ExchangeRateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExchangeRateHandlePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ExchangeRateHandlePlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initExRateAndQuotationInAddNewStatus(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initExchangeRateGroupKeyInCache();
        this.initExRateLock();
        this.quotationControl();
        this.initExRateShowTailZero();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initRateCopyValue();
        this.getModel().endInit();
        this.initExRateAndQuotationInAddNewStatus(false);
        this.getModel().beginInit();
    }

    private void initRateCopyValue() {
        this.initExchangeRateGroupKeyInCache();
        ArrayList exchangeRateKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
        for (String exRateKey : exchangeRateKeyList) {
            ExchangeRateEdit exRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
            log.info("\u6c47\u7387\u63a7\u4ef6,exRateKey:" + exRateKey);
            IDataEntityType parentEntityType = exRateEdit.getProperty().getParent();
            if (parentEntityType instanceof EntryType) {
                DynamicObjectCollection entryDyColl = (DynamicObjectCollection)this.getModel().getDataEntity().get(parentEntityType.getName());
                for (int i = 0; i < entryDyColl.size(); ++i) {
                    this.getModel().setValue(exRateEdit.getFieldKey(), (Object)BigDecimal.valueOf(-1L), i);
                }
                continue;
            }
            this.getModel().setValue(exRateEdit.getFieldKey(), (Object)BigDecimal.valueOf(-1L));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.initExchangeRateGroupKeyInCache();
        String propName = e.getProperty().getName();
        Control control = this.getControl(propName);
        if (control instanceof ExchangeRateEdit) {
            return;
        }
        ArrayList exchangeRateRelationKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateRelationKeyList"));
        if (exchangeRateRelationKeyList.contains(propName)) {
            Map exchangRateMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangRateMap"));
            Set exRateKeySet = (Set)exchangRateMap.get(propName);
            for (String exRateKey : exRateKeySet) {
                ExchangeRateEdit exRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                if (!propName.equals(exRateEdit.getKey()) && !propName.equals(exRateEdit.getExRateQuotationKey())) {
                    this.handleExRateGroupChange(e.getProperty(), exRateEdit, rowIndex);
                    continue;
                }
                if (!propName.equals(exRateEdit.getExRateQuotationKey())) continue;
                this.handleQuotationChange(exRateEdit, rowIndex);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.initExchangeRateGroupKeyInCache();
        RowDataEntity[] entities = e.getRowDataEntities();
        ArrayList<String> keys = new ArrayList<String>();
        if (entities.length > 0) {
            ArrayList exchangeRateKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
            DynamicObject dataEntity = entities[0].getDataEntity();
            for (IDataEntityProperty prop : dataEntity.getDynamicObjectType().getProperties()) {
                if (!(prop instanceof ExchangeRateProp) || !exchangeRateKeyList.contains(prop.getName())) continue;
                keys.add(prop.getName());
            }
        }
        for (RowDataEntity rowDataEntity : entities) {
            for (String exRateKey : keys) {
                ExchangeRateEdit edit = (ExchangeRateEdit)this.getControl(exRateKey);
                this.initExRateAndQuotation(edit, rowDataEntity.getRowIndex(), true);
            }
        }
    }

    private void handleQuotationChange(ExchangeRateEdit exRateEdit, int currentRowIndex) {
        DynamicObject ori = (DynamicObject)this.getValue(exRateEdit.getOriginalCurrencyFieldKey(), currentRowIndex);
        DynamicObject target = (DynamicObject)this.getValue(exRateEdit.getTargetCurrencyFieldKey(), currentRowIndex);
        DynamicObject exRateType = (DynamicObject)this.getValue(exRateEdit.getExRateTypeFieldKey(), currentRowIndex);
        Date date = (Date)this.getValue(exRateEdit.getExRateDateFieldKey(), currentRowIndex);
        String quotation = (String)this.getValue(exRateEdit.getExRateQuotationKey(), currentRowIndex);
        if (ori != null && target != null && exRateType != null && date != null && quotation != null) {
            boolean quotationType = !"0".equals(quotation);
            BigDecimal rate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)((Long)ori.getPkValue()), (Long)((Long)target.getPkValue()), (Long)((Long)exRateType.getPkValue()), (Date)date, (boolean)quotationType);
            rate = this.exRateHandleScale(exRateEdit, rate, (Long)ori.getPkValue(), (Long)target.getPkValue());
            this.getModel().setValue(exRateEdit.getFieldKey(), (Object)rate, currentRowIndex);
        }
    }

    private void handleExRateGroupChange(IDataEntityProperty changeProp, ExchangeRateEdit exRateEdit, int currentRowIndex) {
        boolean isInEntry = exRateEdit.getProperty().getParent() instanceof EntryType;
        boolean isNeedRecalculateEntry = this.isNeedRecalculateEntry(changeProp, isInEntry);
        if (isNeedRecalculateEntry) {
            this.reCalculateEntry(exRateEdit);
        } else {
            this.reCalculateRow(exRateEdit, currentRowIndex, true);
        }
    }

    private boolean isChangeDecimalValue(BigDecimal oldValue, BigDecimal newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return oldValue.compareTo(newValue) != 0;
    }

    private boolean isChangeValue(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        return oldValue == null ? true : !oldValue.equals(newValue);
    }

    private Object getValue(String key, int currentRowIndex) {
        FieldEdit edit = (FieldEdit)this.getControl(key);
        if (edit.getEntryKey() != null) {
            return this.getModel().getValue(key, currentRowIndex);
        }
        return this.getModel().getValue(key);
    }

    private boolean isNeedRecalculateEntry(IDataEntityProperty changeProp, boolean isExRateInEntry) {
        boolean isPropInEntry = changeProp.getParent() instanceof EntryType;
        return !isPropInEntry && isExRateInEntry;
    }

    private void reCalculateEntry(ExchangeRateEdit exRateEdit) {
        String entryKey = exRateEdit.getEntryKey();
        DynamicObjectCollection entryColl = (DynamicObjectCollection)this.getModel().getDataEntity(true).get(entryKey);
        for (int i = 0; i < entryColl.size(); ++i) {
            this.reCalculateRow(exRateEdit, i, true);
        }
    }

    private void reCalculateRow(ExchangeRateEdit exRateEdit, int i, boolean canControlEntity) {
        DynamicObject ori = (DynamicObject)this.getValue(exRateEdit.getOriginalCurrencyFieldKey(), i);
        DynamicObject target = (DynamicObject)this.getValue(exRateEdit.getTargetCurrencyFieldKey(), i);
        DynamicObject exRateType = (DynamicObject)this.getValue(exRateEdit.getExRateTypeFieldKey(), i);
        Date date = (Date)this.getValue(exRateEdit.getExRateDateFieldKey(), i);
        String oldQuotationVal = (String)this.getValue(exRateEdit.getExRateQuotationKey(), i);
        BigDecimal oldExRateVal = (BigDecimal)this.getValue(exRateEdit.getFieldKey(), i);
        if (ori != null && target != null && ori.getPkValue().equals(target.getPkValue())) {
            String quotationVal = "0";
            BigDecimal exchangeRate = BigDecimal.ONE;
            boolean isChangeExRate = this.isChangeDecimalValue(oldExRateVal, exchangeRate);
            boolean isChangeQuotation = this.isChangeValue(oldQuotationVal, quotationVal);
            this.setExRateAndQuotation(exRateEdit, exchangeRate, quotationVal, i, false, isChangeExRate, isChangeQuotation, canControlEntity);
        } else if (ori != null && target != null && exRateType != null && date != null) {
            BigDecimal exchangeRate;
            Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)((Long)ori.getPkValue()), (Long)((Long)target.getPkValue()), (Long)((Long)exRateType.getPkValue()), (Date)date);
            String quotationVal = "0";
            if (((Boolean)exchangeRateByRules.get("quoteType")).booleanValue()) {
                quotationVal = "1";
            }
            if ((exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate")) == null) {
                exchangeRate = exRateEdit.getProperty().isEnableNull() ? null : BigDecimal.ZERO;
            }
            exchangeRate = this.exRateHandleScale(exRateEdit, exchangeRate, (Long)ori.getPkValue(), (Long)target.getPkValue());
            boolean isChangeExRate = this.isChangeDecimalValue(oldExRateVal, exchangeRate);
            boolean isChangeQuotation = this.isChangeValue(oldQuotationVal, quotationVal);
            boolean canModify = BaseDataServiceHelper.canModifyExchangeRate((Long)((Long)exRateType.getPkValue()));
            this.setExRateAndQuotation(exRateEdit, exchangeRate, quotationVal, i, canModify, isChangeExRate, isChangeQuotation, canControlEntity);
        } else {
            BigDecimal nullVal = exRateEdit.getProperty().isEnableNull() ? null : BigDecimal.ZERO;
            boolean isChangeExRate = this.isChangeDecimalValue(oldExRateVal, nullVal);
            boolean isChangeQuotation = this.isChangeValue(oldQuotationVal, null);
            this.setExRateAndQuotation(exRateEdit, nullVal, null, i, false, isChangeExRate, isChangeQuotation, canControlEntity);
        }
    }

    private BigDecimal exRateHandleScale(ExchangeRateEdit exRateEdit, BigDecimal exchangeRate, Long oriCurrId, Long tarCurrId) {
        if (exchangeRate != null && ExRateConfigUtil.isEnableExRatePrecisionControl()) {
            int exRateScale;
            int currencyPairScale = ExRateConfigUtil.getExchangeRatePrecision((Long)oriCurrId, (Long)tarCurrId);
            if (currencyPairScale == 0) {
                currencyPairScale = ((ExchangeRateProp)exRateEdit.getProperty()).getScale();
            }
            if ((exRateScale = exchangeRate.stripTrailingZeros().scale()) > currencyPairScale) {
                exchangeRate = BigDecimal.ZERO;
            }
            return exchangeRate;
        }
        return exchangeRate;
    }

    private void setExRateAndQuotation(ExchangeRateEdit exRateEdit, BigDecimal exchangeRate, String quotationVal, int currentRowIndex, boolean enable, boolean isChangeExRate, boolean isChangeQuotation, boolean canControlEntity) {
        String exRateKey = exRateEdit.getKey();
        String exRateFieldKey = exRateEdit.getFieldKey();
        String quotationKey = exRateEdit.getExRateQuotationKey();
        if (isChangeExRate && isChangeQuotation) {
            this.getModel().beginInit();
            this.getModel().setValue(quotationKey, (Object)quotationVal, currentRowIndex);
            this.getModel().endInit();
            if (exRateEdit.getEntryKey() == null) {
                this.getView().updateView(quotationKey);
            } else {
                this.getView().updateView(quotationKey, currentRowIndex);
            }
        } else {
            this.getModel().setValue(quotationKey, (Object)quotationVal, currentRowIndex);
        }
        this.getModel().setValue(exRateFieldKey, (Object)exchangeRate, currentRowIndex);
        if (canControlEntity) {
            this.setExRateAndQuotationEnable(enable, exRateEdit, exRateKey, quotationKey, currentRowIndex);
        }
    }

    private void setExRateAndQuotationEnable(boolean enable, ExchangeRateEdit exRateEdit, String exRateKey, String quotationKey, int currentRowIndex) {
        if (exRateEdit.getProperty().getParent() instanceof EntryType) {
            this.getView().setEnable(Boolean.valueOf(enable), currentRowIndex, new String[]{exRateKey, quotationKey});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{exRateKey, quotationKey});
        }
    }

    private void initExRateLock() {
        ArrayList exchangeRateKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
        for (String exRateKey : exchangeRateKeyList) {
            ExchangeRateEdit exRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
            log.info("\u6c47\u7387\u63a7\u4ef6,exRateKey:" + exRateKey);
            IDataEntityType parentEntityType = exRateEdit.getProperty().getParent();
            if (parentEntityType instanceof EntryType) {
                DynamicObjectCollection entryDyColl = (DynamicObjectCollection)this.getModel().getDataEntity().get(parentEntityType.getName());
                for (int i = 0; i < entryDyColl.size(); ++i) {
                    this.calExRateLock(exRateEdit, i);
                }
                continue;
            }
            this.calExRateLock(exRateEdit, -1);
        }
    }

    private void calExRateLock(ExchangeRateEdit exRateEdit, int i) {
        DynamicObject ori = (DynamicObject)this.getValue(exRateEdit.getOriginalCurrencyFieldKey(), i);
        DynamicObject target = (DynamicObject)this.getValue(exRateEdit.getTargetCurrencyFieldKey(), i);
        DynamicObject exRateType = (DynamicObject)this.getValue(exRateEdit.getExRateTypeFieldKey(), i);
        Date date = (Date)this.getValue(exRateEdit.getExRateDateFieldKey(), i);
        if (ori != null && target != null && ori.getPkValue().equals(target.getPkValue())) {
            this.setExRateAndQuotationEnable(false, exRateEdit, exRateEdit.getKey(), exRateEdit.getExRateQuotationKey(), i);
        } else if (ori != null && target != null && exRateType != null && date != null) {
            boolean canModify = BaseDataServiceHelper.canModifyExchangeRate((Long)((Long)exRateType.getPkValue()));
            this.setExRateAndQuotationEnable(canModify, exRateEdit, exRateEdit.getKey(), exRateEdit.getExRateQuotationKey(), i);
        } else {
            this.setExRateAndQuotationEnable(false, exRateEdit, exRateEdit.getKey(), exRateEdit.getExRateQuotationKey(), i);
        }
    }

    private void initExRateAndQuotationInAddNewStatus(boolean canControlEntity) {
        this.initExchangeRateGroupKeyInCache();
        ArrayList exchangeRateKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
        for (String exRateKey : exchangeRateKeyList) {
            ExchangeRateEdit exRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
            log.info("\u6c47\u7387\u63a7\u4ef6,exRateKey:" + exRateKey);
            IDataEntityType parentEntityType = exRateEdit.getProperty().getParent();
            if (parentEntityType instanceof EntryType) {
                DynamicObjectCollection entryDyColl = (DynamicObjectCollection)this.getModel().getDataEntity().get(parentEntityType.getName());
                for (int i = 0; i < entryDyColl.size(); ++i) {
                    this.initExRateAndQuotation(exRateEdit, i, canControlEntity);
                }
                continue;
            }
            this.initExRateAndQuotation(exRateEdit, -1, canControlEntity);
        }
    }

    private void initExRateAndQuotation(ExchangeRateEdit exRateEdit, int currentRowIndex, boolean canControlEntity) {
        this.reCalculateRow(exRateEdit, currentRowIndex, canControlEntity);
    }

    private void initExchangeRateGroupKeyInCache() {
        if (this.getPageCache().get("exchangeRateRelationKeyList") == null) {
            ArrayList<String> exchangeRateRelationKeyList = new ArrayList<String>();
            ArrayList<String> exchangeRateKeyList = new ArrayList<String>();
            HashMap<String, Set<String>> exchangRateMap = new HashMap<String, Set<String>>();
            FormRoot root = (FormRoot)this.getView().getRootControl();
            this.createExchangeRateControlIndex(root.getItems(), exchangeRateRelationKeyList, exchangeRateKeyList, exchangRateMap);
            this.getPageCache().put("exchangeRateRelationKeyList", SerializationUtils.serializeToBase64(exchangeRateRelationKeyList));
            this.getPageCache().put("exchangeRateKeyList", SerializationUtils.serializeToBase64(exchangeRateKeyList));
            this.getPageCache().put("exchangRateMap", SerializationUtils.serializeToBase64(exchangRateMap));
        }
    }

    private void quotationControl() {
        if (this.getPageCache().get("exchangeRateKeyList") != null) {
            List exchangeRateKeyList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
            boolean enableIndirectRate = BaseDataServiceHelper.isEnableIndirectRateConversion();
            if (!enableIndirectRate) {
                for (String exRateKey : exchangeRateKeyList) {
                    ExchangeRateEdit exchangeRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
                    this.getView().setVisible(Boolean.FALSE, new String[]{exchangeRateEdit.getExRateQuotationKey()});
                }
            }
        }
    }

    private void createExchangeRateControlIndex(List<Control> items, List<String> exchangeRateRelationKeyList, List<String> exchangeRateKeyList, Map<String, Set<String>> exchangRateMap) {
        for (Control ctl : items) {
            if (ctl instanceof ExchangeRateEdit) {
                ExchangeRateEdit edit = (ExchangeRateEdit)ctl;
                String oriKey = edit.getOriginalCurrencyFieldKey();
                String tarKey = edit.getTargetCurrencyFieldKey();
                String exRateTypeKey = edit.getExRateTypeFieldKey();
                String dateKey = edit.getExRateDateFieldKey();
                String exRateKey = edit.getKey();
                String quatationKey = edit.getExRateQuotationKey();
                exchangeRateRelationKeyList.add(oriKey);
                exchangeRateRelationKeyList.add(tarKey);
                exchangeRateRelationKeyList.add(exRateTypeKey);
                exchangeRateRelationKeyList.add(dateKey);
                exchangeRateRelationKeyList.add(exRateKey);
                exchangeRateRelationKeyList.add(quatationKey);
                exchangeRateKeyList.add(exRateKey);
                this.handleExchangRateMap(exchangRateMap, oriKey, exRateKey);
                this.handleExchangRateMap(exchangRateMap, tarKey, exRateKey);
                this.handleExchangRateMap(exchangRateMap, exRateTypeKey, exRateKey);
                this.handleExchangRateMap(exchangRateMap, dateKey, exRateKey);
                this.handleExchangRateMap(exchangRateMap, exRateKey, exRateKey);
                this.handleExchangRateMap(exchangRateMap, quatationKey, exRateKey);
            }
            if (!(ctl instanceof Container)) continue;
            this.createExchangeRateControlIndex(((Container)ctl).getItems(), exchangeRateRelationKeyList, exchangeRateKeyList, exchangRateMap);
        }
    }

    private void handleExchangRateMap(Map<String, Set<String>> exchangRateMap, String key, String val) {
        if (exchangRateMap.get(key) == null) {
            HashSet<String> exchangeRateKeySet = new HashSet<String>();
            exchangeRateKeySet.add(val);
            exchangRateMap.put(key, exchangeRateKeySet);
        } else {
            exchangRateMap.get(key).add(val);
        }
    }

    private void initExRateShowTailZero() {
        if (!ExRateConfigUtil.isEnableExRatePrecisionControl()) {
            return;
        }
        Map config = ExRateConfigUtil.getExRatePrecisionControlConfig();
        if (config == null) {
            return;
        }
        boolean showTailZero = (Boolean)config.get("showtailzero");
        this.initExchangeRateGroupKeyInCache();
        ArrayList exchangeRateKeyList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("exchangeRateKeyList"));
        for (String exRateKey : exchangeRateKeyList) {
            ExchangeRateEdit exchangeRateEdit = (ExchangeRateEdit)this.getControl(exRateKey);
            IDataEntityType parentEntityType = exchangeRateEdit.getProperty().getParent();
            if (parentEntityType instanceof EntryType && !(this.getView() instanceof IMobileView)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                if (!showTailZero) continue;
                proxy.invokeControlMethod(parentEntityType.getName(), "setColEditorProp", new Object[]{exRateKey, "sz", Boolean.FALSE});
                continue;
            }
            if (!showTailZero) continue;
            this.getView().updateControlMetadata(exRateKey, Collections.singletonMap("item", Collections.singletonMap("sz", Boolean.FALSE)));
        }
    }
}

