/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.name.NameDynamicPagePlugin;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.name.util.NameUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class NameConfigStructMobilePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(NameDynamicPagePlugin.class);
    private static final String NAME_FORMAT = "ns_namestyle";
    private static final String NAME_CONFIG = "nameconfig";
    private static final String COUNTRY = "ns_country";
    private static final String CTS_NAME_CONFIG_FORMAT = "cts_nameconfigformat";
    private static final String F7_CALLBACK_ID = "f7SelectConfirm";
    private static final String Click_Cache = "clickCache";

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(NAME_FORMAT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit countryEdit = (BasedataEdit)this.getControl(COUNTRY);
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        try {
            String name = propertyChangedArgs.getProperty().getName();
            if (NAME_FORMAT.equals(name)) {
                this.showNameFieldPage(propertyChangedArgs.getChangeSet()[0].getNewValue());
            }
            if (COUNTRY.equals(name)) {
                DynamicObject newCountry = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
                Long countryId = (Long)newCountry.getPkValue();
                this.getModel().setValue(NAME_FORMAT, (Object)NameUtil.getCountryDefaultNameStyleId(countryId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void showNameFieldPage(Object nameFormat) {
        if (nameFormat != null) {
            Object pkvalue = null;
            if (nameFormat instanceof DynamicObject) {
                DynamicObject configFormat = (DynamicObject)nameFormat;
                nameFormat = configFormat.getPkValue();
                pkvalue = configFormat.getDynamicObject(NAME_CONFIG).getPkValue();
            } else {
                DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)nameFormat, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CTS_NAME_CONFIG_FORMAT));
                pkvalue = dynamicObject.getDynamicObject(NAME_CONFIG).getPkValue();
            }
            List<NameConfigStruct> nameConfigStructs = NameUtil.getNameStyleConfig((Long)pkvalue, null);
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            Map params = this.getView().getFormShowParameter().getCustomParams();
            formShowParameter.setCustomParam("type", (Object)0);
            formShowParameter.setCustomParam("valueMap", params.get("valueMap"));
            formShowParameter.setCustomParam("params", nameConfigStructs);
            formShowParameter.setCustomParam("nameconfigformatid", nameFormat);
            formShowParameter.getOpenStyle().setTargetKey("flexpanelap1");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.setFormId("cts_name_mobile_view");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        HashMap valueMap = (HashMap)this.getView().getFormShowParameter().getCustomParams().get("valueMap");
        if (valueMap == null) {
            valueMap = new HashMap();
        }
        this.setDefaultValue(valueMap);
        this.showNameFieldPage(valueMap.get(NAME_FORMAT));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map map = (Map)closedCallBackEvent.getReturnData();
        if (map != null && !map.isEmpty()) {
            String str;
            HashMap<String, String> i18nMap = new HashMap<String, String>();
            HashMap<String, String> returnMap = new HashMap<String, String>();
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Map keyMap = (Map)params.get("keyMap");
            DynamicObject nameFormat = (DynamicObject)this.getModel().getValue(NAME_FORMAT);
            map.put(NAME_FORMAT, nameFormat.getPkValue());
            DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
            map.put(COUNTRY, country.getPkValue());
            map.forEach((k, v) -> {
                String s = (String)keyMap.get(k);
                if (StringUtils.isNotEmpty((CharSequence)s)) {
                    returnMap.put(s, (String)v);
                    if (v != null) {
                        i18nMap.put((String)k, v.toString());
                    }
                }
            });
            if (!i18nMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)(str = NameUtil.getNameFormatStr((Long)nameFormat.getPkValue(), i18nMap)))) {
                returnMap.put((String)params.get("key"), str);
            }
            this.getView().returnDataToParent(returnMap);
        }
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (F7_CALLBACK_ID.equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().put(Click_Cache, "f7Select");
            ((BasedataEdit)this.getControl(NAME_FORMAT)).click();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (NAME_FORMAT.equals(evt.getProperty().getName())) {
            String name = evt.getProperty().getName();
            String sourceMethod = evt.getSourceMethod();
            if (NAME_FORMAT.equals(name)) {
                Object nameFormat = this.getModel().getValue(NAME_FORMAT);
                this.handleNameFormatClick(nameFormat, sourceMethod, evt);
                DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
                List filters = evt.getCustomQFilters();
                if (country == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u3002", (String)"NameDynamicPagePlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Set<Long> configFormatIds = NameUtil.getCountryNameTextStyles((Long)country.getPkValue());
                QFilter qFilter = new QFilter("id", "in", configFormatIds);
                filters.add(qFilter);
            }
        }
    }

    private void handleNameFormatClick(Object nameFormat, String sourceMethod, BeforeF7SelectEvent evt) {
        if (nameFormat != null && "click".equals(sourceMethod)) {
            String value = this.getPageCache().get(Click_Cache);
            if (value == null) {
                evt.setCancel(true);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(F7_CALLBACK_ID, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u683c\u5f0f\u53ef\u80fd\u6e05\u9664\u90e8\u5206\u5b57\u6bb5\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"NameDynamicPagePlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            }
            this.getPageCache().remove(Click_Cache);
        }
    }

    private void setDefaultValue(Map<String, Object> valueMap) {
        Object country = valueMap.get(COUNTRY);
        if (StringUtils.isBlank((Object)country)) {
            DynamicObject dynamicObject;
            long countryId = 1000001L;
            Object defaultcountry = SystemParamServiceHelper.loadPublicParameterFromCache((String)"defaultcountry");
            if (defaultcountry != null) {
                Map map = (Map)defaultcountry;
                countryId = Long.parseLong(map.get("id").toString());
            }
            if ((dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)countryId, (String)"bd_country")) != null && "1".equals(dynamicObject.getString("enable"))) {
                this.getModel().setValue(COUNTRY, (Object)countryId);
                valueMap.put(COUNTRY, Long.toString(countryId));
            }
        } else {
            this.getModel().setValue(COUNTRY, country);
        }
        Object nameStyle = valueMap.get(NAME_FORMAT);
        if (StringUtils.isBlank((Object)nameStyle)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(COUNTRY);
            Long nameStyleId = NameUtil.getCountryDefaultNameStyleId((Long)dynamicObject.getPkValue());
            this.getModel().setValue(NAME_FORMAT, (Object)nameStyleId);
            valueMap.put(NAME_FORMAT, String.valueOf(nameStyleId));
        } else {
            this.getModel().setValue(NAME_FORMAT, nameStyle);
        }
    }
}

