/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class NameConfigStructMobileViewPlugin
extends AbstractMobFormPlugin
implements ClickListener {
    private static final String FIELD_FLEX = "flex";
    private static final String PANEL = "panel";
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List items = e.getItems();
        List<FlexPanelAp> controls = this.flexPanelList(e);
        for (int i = 0; i < controls.size(); ++i) {
            HashMap<String, String> mapHead = new HashMap<String, String>(16);
            mapHead.put("id", FIELD_FLEX + (i + 1));
            mapHead.put("items", (String)controls.get(i).createControl().get("items"));
            items.add(mapHead);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List nameConfigStructs = (List)this.getView().getFormShowParameter().getCustomParams().get("params");
        Map<String, JSONObject> fieldMap = nameConfigStructs.stream().collect(Collectors.toMap(v -> v.getString("fieldKey"), v -> v, (k1, k2) -> k1));
        if ("title".equals(e.getKey()) || "positionaltitle".equals(e.getKey())) {
            JSONObject nameConfigStruct = fieldMap.get(e.getKey());
            ComboEdit comboEdit = new ComboEdit();
            JSONArray comboValues = nameConfigStruct.getJSONArray("comboValues");
            comboEdit.setKey(e.getKey());
            comboEdit.setView(this.getView());
            if (CollectionUtils.isNotEmpty((Collection)comboValues)) {
                ArrayList data = new ArrayList();
                comboValues.forEach(v -> data.add(new kd.bos.form.field.ComboItem(new LocaleString((String)v), (String)v)));
                comboEdit.setComboItems(data);
            }
            e.setControl((Control)comboEdit);
            return;
        }
        if (fieldMap.containsKey(e.getKey())) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs getEntityTypeEventArgs) {
        MainEntityType oldMainType = getEntityTypeEventArgs.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        getEntityTypeEventArgs.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List nameConfigStructs = (List)this.getView().getFormShowParameter().getCustomParams().get("params");
        for (JSONObject nameConfigStruct : nameConfigStructs) {
            String fieldKey = nameConfigStruct.getString("fieldKey");
            String fieldName = nameConfigStruct.getString("fieldName");
            Boolean mustInput = nameConfigStruct.getBoolean("mustInput");
            String customerTag = nameConfigStruct.getString("customerTag");
            JSONArray comboValues = nameConfigStruct.getJSONArray("comboValues");
            if (StringUtils.isEmpty((String)customerTag)) {
                customerTag = fieldName;
            }
            if ("title".equals(fieldKey) || "positionaltitle".equals(fieldKey)) {
                ComboProp comboProp = new ComboProp();
                comboProp.setName(fieldKey);
                comboProp.setDbIgnore(true);
                comboProp.setMustInput(mustInput.booleanValue());
                comboProp.setDisplayName(new LocaleString(customerTag));
                if (CollectionUtils.isNotEmpty((Collection)comboValues)) {
                    ArrayList comboItems = new ArrayList();
                    comboValues.forEach(v -> comboItems.add(new ValueMapItem(null, (String)v, new LocaleString((String)v))));
                    comboProp.setComboItems(comboItems);
                }
                newMainType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
                continue;
            }
            TextProp textProp = new TextProp();
            textProp.setName(fieldKey);
            textProp.setDbIgnore(true);
            textProp.setMustInput(mustInput.booleanValue());
            textProp.setDisplayName(new LocaleString(customerTag));
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private List<FlexPanelAp> flexPanelList() {
        List nameConfigStructs = (List)this.getView().getFormShowParameter().getCustomParams().get("params");
        ArrayList<FlexPanelAp> flexPanelList = new ArrayList<FlexPanelAp>(15);
        for (JSONObject nameConfigStruct : nameConfigStructs) {
            FlexPanelAp flex = new FlexPanelAp();
            flex.setKey(PANEL);
            flexPanelList.add(flex);
            List items = flex.getItems();
            String fieldKey = nameConfigStruct.getString("fieldKey");
            String fieldName = nameConfigStruct.getString("fieldName");
            Boolean mustInput = nameConfigStruct.getBoolean("mustInput");
            String customerTag = nameConfigStruct.getString("customerTag");
            JSONArray comboValues = nameConfigStruct.getJSONArray("comboValues");
            if (StringUtils.isEmpty((String)customerTag)) {
                customerTag = fieldName;
            }
            ArrayList<String> combo = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)comboValues)) {
                comboValues.forEach(v -> combo.add((String)v));
            }
            FieldAp fieldAp = this.textField(fieldKey, customerTag, mustInput, combo);
            items.add(fieldAp);
        }
        return flexPanelList;
    }

    private List<FlexPanelAp> flexPanelList(LoadCustomControlMetasArgs args) {
        List nameConfigStructs = (List)((FormShowParameter)args.getSource()).getCustomParam("params");
        ArrayList<FlexPanelAp> flexPanelList = new ArrayList<FlexPanelAp>(15);
        for (NameConfigStruct nameConfigStruct : nameConfigStructs) {
            FlexPanelAp flex = new FlexPanelAp();
            flex.setKey(PANEL);
            flexPanelList.add(flex);
            List items = flex.getItems();
            String fieldKey = nameConfigStruct.getFieldKey();
            String customerTag = nameConfigStruct.getCustomerTag();
            if (StringUtils.isEmpty((String)customerTag)) {
                customerTag = nameConfigStruct.getFieldName();
            }
            Boolean mustInput = nameConfigStruct.getMustInput();
            List<String> comboValues = nameConfigStruct.getComboValues();
            FieldAp fieldAp = this.textField(fieldKey, customerTag, mustInput, comboValues);
            items.add(fieldAp);
        }
        return flexPanelList;
    }

    private FieldAp textField(String key, String name, Boolean mustInput, List<String> comboValues) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        if ("title".equals(key) || "positionaltitle".equals(key)) {
            ComboField field = new ComboField();
            field.setId(key);
            field.setKey(key);
            field.setMustInput(mustInput.booleanValue());
            field.setName(new LocaleString(name));
            if (CollectionUtils.isNotEmpty(comboValues)) {
                ArrayList data = new ArrayList();
                AtomicInteger i = new AtomicInteger(1);
                comboValues.forEach(v -> data.add(new ComboItem(i.getAndIncrement(), new LocaleString(v), v)));
                field.setItems(data);
            }
            fieldAp.setField((Field)field);
        } else {
            TextField field = new TextField();
            field.setId(key);
            field.setKey(key);
            field.setMustInput(mustInput.booleanValue());
            field.setName(new LocaleString(name));
            fieldAp.setField((Field)field);
        }
        return fieldAp;
    }

    public void click(EventObject evt) {
        String key = ((Button)evt.getSource()).getOperationKey();
        if (SAVE.equals(key)) {
            HashMap<String, String> map = new HashMap<String, String>();
            List nameConfigStructs = (List)this.getView().getFormShowParameter().getCustomParams().get("params");
            for (JSONObject nameConfigStruct : nameConfigStructs) {
                String s;
                String fieldKey = nameConfigStruct.getString("fieldKey");
                Object value = this.getModel().getValue(fieldKey);
                if (value == null || !StringUtils.isNotEmpty((String)(s = value.toString().trim()))) continue;
                map.put(fieldKey, s);
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map valueMap = (Map)customParams.get("valueMap");
        List nameConfigStructs = (List)customParams.get("params");
        for (JSONObject nameConfigStruct : nameConfigStructs) {
            String fieldKey = nameConfigStruct.getString("fieldKey");
            String s = (String)valueMap.get(fieldKey);
            if (!StringUtils.isNotEmpty((String)s)) continue;
            this.getModel().setValue(fieldKey, (Object)s);
        }
        List<FlexPanelAp> controls = this.flexPanelList();
        for (int i = 0; i < controls.size(); ++i) {
            Container container = (Container)this.getView().getControl(FIELD_FLEX + (i + 1));
            container.getItems().addAll(((Container)controls.get(i).buildRuntimeControl()).getItems());
            this.getView().createControlIndex(container.getItems());
        }
    }
}

