/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.name.util.NameUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NameDynamicPagePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(NameDynamicPagePlugin.class);
    private static final String NAME_FORMAT = "nameformat";
    private static final String NAME_CONFIG = "nameconfig";
    private static final String COUNTRY = "country";
    private static final String NAME_ID = "nameid";
    private static final String CTS_NAME = "cts_name";
    private static final String PRE_CONFIGID = "preconfigid";
    private static final String NUMBER = "number";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CTS_NAME_CONFIG_FORMAT = "cts_nameconfigformat";
    private static final String F7_CALLBACK_ID = "f7SelectConfirm";
    private static final String Click_Cache = "clickCache";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter param = e.getFormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u59d3\u540d\u5f55\u5165", (String)"NameDynamicPagePlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(NAME_FORMAT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit countryEdit = (BasedataEdit)this.getControl(COUNTRY);
        countryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object country = formShowParameter.getCustomParam(COUNTRY);
        Object nameformat = formShowParameter.getCustomParam(NAME_FORMAT);
        this.getModel().setValue(COUNTRY, country);
        this.getModel().setValue(NAME_FORMAT, nameformat);
        this.showNameFieldPage(nameformat);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        try {
            String name = propertyChangedArgs.getProperty().getName();
            if (NAME_FORMAT.equals(name)) {
                this.showNameFieldPage(propertyChangedArgs.getChangeSet()[0].getNewValue());
            }
            if (COUNTRY.equals(name)) {
                DynamicObject newCountry = (DynamicObject)propertyChangedArgs.getChangeSet()[0].getNewValue();
                Long countryId = (Long)newCountry.getPkValue();
                this.getModel().setValue(NAME_FORMAT, (Object)NameUtil.getCountryDefaultNameStyleId(countryId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> fieldKeyValue() {
        HashMap<String, String> fieldKeyValue = new HashMap<String, String>(16);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object pkvalue = formShowParameter.getCustomParam(NAME_ID);
        Object nameformat = formShowParameter.getCustomParam(NAME_FORMAT);
        if (pkvalue == null) {
            return fieldKeyValue;
        }
        DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)nameformat, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CTS_NAME_CONFIG_FORMAT), (Boolean)Boolean.TRUE);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkvalue, (String)CTS_NAME);
        for (int i = 0; i < entryentity.size(); ++i) {
            String key = ((DynamicObject)entryentity.get(i)).getDynamicObject(PRE_CONFIGID).getString(NUMBER);
            String value = dynamicObject.getString(key);
            fieldKeyValue.put(key, value);
        }
        return fieldKeyValue;
    }

    private void showNameFieldPage(Object nameFormat) {
        Map<String, String> stringStringMap = this.fieldKeyValue();
        ArrayList nameConfigStructs = new ArrayList(10);
        if (nameFormat != null) {
            Object pkvalue = null;
            if (nameFormat instanceof DynamicObject) {
                DynamicObject configFormat = (DynamicObject)nameFormat;
                nameFormat = configFormat.getPkValue();
                pkvalue = configFormat.getDynamicObject(NAME_CONFIG).getPkValue();
            } else {
                DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)nameFormat, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CTS_NAME_CONFIG_FORMAT));
                pkvalue = dynamicObject.getDynamicObject(NAME_CONFIG).getPkValue();
            }
            StringBuilder builder = new StringBuilder();
            builder.append(" SELECT namefieldL.fname,namefield.fnumber,fcustomlabel,ftype,fbdtype,fisrequired ");
            builder.append(" FROM t_cts_nameconfigstruct struct ");
            builder.append(" INNER JOIN t_cts_nameprefield namefield on struct.fpreconfigid = namefield.fid ");
            builder.append(" INNER JOIN t_cts_nameprefield_l namefieldL on namefield.fid = namefieldL.fid AND namefieldL.flocaleid = ? ");
            builder.append(" WHERE struct.fid = ? and struct.fisshow = '1' order by struct.fseq");
            DB.query((DBRoute)DBRoute.basedata, (String)builder.toString(), (Object[])new Object[]{Lang.get().getLocale().toString(), pkvalue}, rs -> {
                while (rs.next()) {
                    String number = rs.getString("fnumber");
                    NameConfigStruct nameConfigStruct = new NameConfigStruct();
                    nameConfigStruct.setDefaultValue((String)stringStringMap.get(number));
                    nameConfigStruct.setFieldKey(number);
                    nameConfigStruct.setFieldName(rs.getString("fname"));
                    nameConfigStruct.setBasedata(rs.getInt("ftype") == 1);
                    nameConfigStruct.setFormId(rs.getString("fbdtype"));
                    nameConfigStruct.setMustInput(rs.getBoolean("fisrequired"));
                    nameConfigStruct.setCustomerTag(rs.getString("fcustomlabel"));
                    nameConfigStructs.add(nameConfigStruct);
                }
                return nameConfigStructs;
            });
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("type", (Object)0);
            formShowParameter.setCustomParam("params", nameConfigStructs);
            formShowParameter.setCustomParam("nameconfigformatid", nameFormat);
            formShowParameter.getOpenStyle().setTargetKey("namefieldflex");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.setFormId("cts_name_field_form");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent((Object)Long.valueOf(returnData.toString()));
        }
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (F7_CALLBACK_ID.equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().put(Click_Cache, "f7Select");
            ((BasedataEdit)this.getControl(NAME_FORMAT)).click();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (NAME_FORMAT.equals(evt.getProperty().getName())) {
            String name = evt.getProperty().getName();
            String sourceMethod = evt.getSourceMethod();
            if (NAME_FORMAT.equals(name)) {
                Object nameFormat = this.getModel().getValue(NAME_FORMAT);
                this.handleNameFormatClick(nameFormat, sourceMethod, evt);
                DynamicObject country = (DynamicObject)this.getModel().getValue(COUNTRY);
                List filters = evt.getCustomQFilters();
                if (country == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u3002", (String)"NameDynamicPagePlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                Set<Long> configFormatIds = NameUtil.getCountryNameTextStyles((Long)country.getPkValue());
                QFilter qFilter = new QFilter("id", "in", configFormatIds);
                filters.add(qFilter);
            }
        }
    }

    private void handleNameFormatClick(Object nameFormat, String sourceMethod, BeforeF7SelectEvent evt) {
        if (nameFormat != null && "click".equals(sourceMethod)) {
            String value = this.getPageCache().get(Click_Cache);
            if (value == null) {
                evt.setCancel(true);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(F7_CALLBACK_ID, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u683c\u5f0f\u53ef\u80fd\u6e05\u9664\u90e8\u5206\u5b57\u6bb5\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"NameDynamicPagePlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
            }
            this.getPageCache().remove(Click_Cache);
        }
    }
}

