/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.name.util.NameUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class NameFieldFormPlugin
extends AbstractFormPlugin {
    private static final String PANEL = "panel";
    private static final Integer FONTSIZE = 14;
    private static final String FIELDPX = "50px";
    private static final String PROPERTY_VALUE_CACHE = "propertyValueCache";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        List items = e.getItems();
        List nameConfigStructs = (List)((FormShowParameter)e.getSource()).getCustomParam("params");
        FlexPanelAp control = this.flexPanelList(nameConfigStructs);
        HashMap<String, String> mapHead = new HashMap<String, String>(16);
        mapHead.put("id", "contentpanel");
        mapHead.put("items", (String)control.createControl().get("items"));
        items.add(mapHead);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            NameUtil.saveName(this);
            this.getView().close();
        } else {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cts_title", (boolean)false);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            QFilter typeFilter = null;
            if (key.equals("title")) {
                typeFilter = new QFilter("type", "=", (Object)"0");
            } else if (key.equals("positionaltitle")) {
                typeFilter = new QFilter("type", "=", (Object)"1");
            }
            if (typeFilter != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(typeFilter);
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            listShowParameter.getListFilterParameter().getQFilters().add(enableFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection coll;
        super.closedCallBack(closedCallBackEvent);
        TextEdit textEdit = (TextEdit)this.getControl(closedCallBackEvent.getActionId());
        if (textEdit != null && closedCallBackEvent.getReturnData() != null && (coll = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()).size() > 0) {
            this.getModel().setValue(closedCallBackEvent.getActionId(), (Object)coll.get(0).getName());
        }
    }

    public void onGetControl(OnGetControlArgs controlArgs) {
        String key;
        List nameConfigStructs = SerializationUtils.fromJsonStringToList((String)this.getView().getFormShowParameter().getCustomParam("params").toString(), NameConfigStruct.class);
        Map keyMap = nameConfigStructs.stream().collect(Collectors.toMap(NameConfigStruct::getFieldKey, Function.identity()));
        NameConfigStruct nameConfigStruct = (NameConfigStruct)keyMap.get(key = controlArgs.getKey());
        if (nameConfigStruct == null) {
            return;
        }
        String fieldKey = nameConfigStruct.getFieldKey();
        TextEdit textEdit = new TextEdit();
        textEdit.setKey(fieldKey);
        textEdit.setView(this.getView());
        textEdit.setFieldKey(nameConfigStruct.getFieldKey());
        if (nameConfigStruct.getBasedata().booleanValue()) {
            textEdit.addClickListener((ClickListener)this);
        }
        controlArgs.setControl((Control)textEdit);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("NameFieldFormPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List nameConfigStructs = SerializationUtils.fromJsonStringToList((String)this.getView().getFormShowParameter().getCustomParam("params").toString(), NameConfigStruct.class);
        for (NameConfigStruct struct : nameConfigStructs) {
            TextProp textProp = new TextProp();
            textProp.setName(struct.getFieldKey());
            textProp.setDefaultValue((Object)struct.getDefaultValue());
            textProp.setDisplayName(new LocaleString(struct.getFieldName()));
            textProp.setDbIgnore(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private FlexPanelAp flexPanelList(List<NameConfigStruct> nameConfigStructs) {
        FlexPanelAp parentFlex = new FlexPanelAp();
        parentFlex.setKey("contentpanel");
        ArrayList<FlexPanelAp> flexPanelList = new ArrayList<FlexPanelAp>(15);
        FlexPanelAp flex = new FlexPanelAp();
        for (int i = 0; i < nameConfigStructs.size(); ++i) {
            if (i % 3 == 0) {
                flex = new FlexPanelAp();
                flex.setKey(PANEL);
                flexPanelList.add(flex);
                flex.setHeight(new LocaleString("66px"));
                flex.setOverflow("visible");
                flex.setAlignItems("flex-start");
                flex.setJustifyContent("flex-start");
                flex.setWrap(false);
                flex.setGrow(0);
                flex.setShrink(0);
                if (i == 0) {
                    Style style = new Style();
                    Margin margin = new Margin();
                    margin.setTop(FIELDPX);
                    style.setMargin(margin);
                    flex.setStyle(style);
                }
            }
            List items = flex.getItems();
            NameConfigStruct nameConfigStruct = nameConfigStructs.get(i);
            String fieldKey = nameConfigStruct.getFieldKey();
            String customerTag = nameConfigStruct.getCustomerTag();
            if (StringUtils.isEmpty((String)customerTag)) {
                customerTag = nameConfigStruct.getFieldName();
            }
            Boolean mustInput = nameConfigStruct.getMustInput();
            int editStyle = nameConfigStruct.getBasedata() != false ? 2 : 0;
            String defaultValue = nameConfigStruct.getDefaultValue();
            FieldAp textField = this.textField(fieldKey, customerTag, mustInput, editStyle, defaultValue);
            items.add(textField);
        }
        parentFlex.getItems().addAll(flexPanelList);
        return parentFlex;
    }

    private FieldAp textField(String key, String name, Boolean mustInput, int editStyle, String defaultValue) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setFontSize(FONTSIZE.intValue());
        fieldAp.setFieldFontSize(FONTSIZE.intValue());
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        TextField field = new TextField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput.booleanValue());
        field.setName(new LocaleString(name));
        field.setEditStyle(editStyle);
        field.setDefValue(defaultValue);
        fieldAp.setField((Field)field);
        return fieldAp;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            evt.setCancel(true);
            Long id = NameUtil.saveName(this);
            this.getView().returnDataToParent((Object)id);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        this.setPropertyValueCache(name, e.getChangeSet()[0].getNewValue());
    }

    private void setPropertyValueCache(String name, Object newValue) {
        Map map = null;
        IPageCache iPageCache = this.getView().getParentView().getPageCache();
        String valueCache = iPageCache.get(PROPERTY_VALUE_CACHE);
        map = null == valueCache ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)valueCache, Map.class);
        if (newValue instanceof DynamicObject) {
            map.put(name, ((DynamicObject)newValue).get("id"));
        } else {
            map.put(name, newValue);
        }
        iPageCache.put(PROPERTY_VALUE_CACHE, SerializationUtils.toJsonString(map));
    }

    public void beforeBindData(EventObject e) {
        String valueCache;
        super.beforeBindData(e);
        List nameConfigStructs = SerializationUtils.fromJsonStringToList((String)this.getView().getFormShowParameter().getCustomParam("params").toString(), NameConfigStruct.class);
        IPageCache iPageCache = this.getView().getParentView().getPageCache();
        if (iPageCache != null && (valueCache = iPageCache.get(PROPERTY_VALUE_CACHE)) != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)valueCache, Map.class);
            Set keySet = map.keySet();
            for (NameConfigStruct struct : nameConfigStructs) {
                if (!keySet.contains(struct.getFieldKey())) continue;
                this.getModel().setValue(struct.getFieldKey(), map.get(struct.getFieldKey()));
            }
        }
        FlexPanelAp control = this.flexPanelList(nameConfigStructs);
        List fieldEdits = ((Container)control.buildRuntimeControl()).getItems();
        control.createControl().get("items");
        Container contentpanel = (Container)this.getControl("contentpanel");
        contentpanel.getItems().addAll(fieldEdits);
        this.getView().createControlIndex(contentpanel.getItems());
    }
}

