/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class NameStructureConfigPlugin
extends AbstractFormPlugin {
    private static final String CTS_NAME_PREFIELD = "cts_nameprefield";
    private static final String CTS_NAME_CONFIGFORMAT = "cts_nameconfigformat";
    private static final String SEQ = "seq";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_ISSHOW = "isshow";
    private static final String FIELD_NAMECONFIG = "nameconfig";
    private static final String FIELD_ISMUSTINPUT = "ismustinput";
    private static final String FIELD_PRECONFIGID = "preconfigid";
    private static final String FIELD_USERDEFINETAG = "userdefinetag";
    private static final String ENTRYENTITY = "entryentity";
    private static final String OPT_SAVE = "bar_save";
    private static final List<String> fields = new ArrayList<String>(10);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int value = formShowParameter.getStatusValue();
        if (value == 1) {
            Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
            QFilter qFilter = new QFilter(FIELD_NAMECONFIG, "=", pkId);
            boolean exists = QueryServiceHelper.exists((String)CTS_NAME_CONFIGFORMAT, (QFilter[])qFilter.toArray());
            if (exists) {
                this.getView().setEnable(Boolean.FALSE, new String[]{OPT_SAVE});
            }
            this.controlEnable();
        }
    }

    private void controlEnable() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            if (dynamicObject.getBoolean(FIELD_ISSHOW)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_ISMUSTINPUT, FIELD_USERDEFINETAG});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<NameConfigStruct> nameConfigStructs = new ArrayList<NameConfigStruct>(10);
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                boolean isshow = dynamicObject.getBoolean(FIELD_ISSHOW);
                if (!isshow) continue;
                NameConfigStruct nameConfigStruct = new NameConfigStruct();
                nameConfigStruct.setMustInput(dynamicObject.getBoolean(FIELD_ISMUSTINPUT));
                nameConfigStruct.setCustomerTag(dynamicObject.getString(FIELD_USERDEFINETAG));
                DynamicObject preconfig = dynamicObject.getDynamicObject(FIELD_PRECONFIGID);
                nameConfigStruct.setFieldKey(preconfig.getString(FIELD_NUMBER));
                nameConfigStruct.setFieldName(preconfig.getLocaleString(FIELD_NAME).getLocaleValue());
                nameConfigStruct.setBasedata(preconfig.getInt("type") != 0);
                nameConfigStruct.setFormId(preconfig.getString("bdtype"));
                nameConfigStructs.add(nameConfigStruct);
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("cts_namestructpreview");
            formShowParameter.setCustomParam("params", nameConfigStructs);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] preFields;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int value = formShowParameter.getStatus().getValue();
        if (value == 0 && (preFields = BusinessDataServiceHelper.load((String)CTS_NAME_PREFIELD, (String)"number,name", null, (String)"sort")) != null && preFields.length != 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, preFields.length);
            for (int i = 0; i < preFields.length; ++i) {
                this.getModel().setValue(FIELD_PRECONFIGID, preFields[i].getPkValue(), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_ISMUSTINPUT});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_USERDEFINETAG});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertityName = propertyChangedArgs.getProperty().getName();
        if (FIELD_ISSHOW.equals(propertityName)) {
            ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
            Boolean isShow = (Boolean)changeData.getNewValue();
            DynamicObject dataEntity = changeData.getDataEntity();
            this.controlEntryEntityRow(dataEntity.getInt(SEQ) - 1, isShow);
        }
    }

    private void controlEntryEntityRow(int index, Boolean isShow) {
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            if (!isShow.booleanValue()) {
                this.getModel().setValue(field, null, index);
            }
            this.getView().setEnable(isShow, index, new String[]{field});
        }
    }

    static {
        fields.add(FIELD_ISMUSTINPUT);
        fields.add(FIELD_USERDEFINETAG);
    }
}

