/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.name.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.i18n.mservice.BatchImportNameCtlHelper;
import kd.bos.lang.Lang;
import kd.bos.name.entity.NameConfigStruct;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class NameUtil {
    private static final String CTS_NAME_CONFIG_FORMAT = "cts_nameconfigformat";

    public static Long saveName(AbstractFormPlugin plugin) {
        IFormView view = plugin.getView();
        Long nameConfigFormatId = (Long)view.getFormShowParameter().getCustomParam("nameconfigformatid");
        Object source = view.getParentView().getFormShowParameter().getCustomParams().get("source");
        Object country = view.getParentView().getModel().getValue("country");
        DynamicObject configFormat = BusinessDataServiceHelper.loadSingle((Object)nameConfigFormatId, (String)CTS_NAME_CONFIG_FORMAT);
        Long nameConfigStructId = (Long)((DynamicObject)configFormat.get("nameconfig")).getPkValue();
        DynamicObject configStruct = BusinessDataServiceHelper.loadSingle((Object)nameConfigStructId, (String)"cts_nameconfigstruct");
        DynamicObjectCollection structColl = (DynamicObjectCollection)configStruct.get("entryentity");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cts_name");
        DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
        DynamicObject nameSaveDy = new DynamicObject((DynamicObjectType)type);
        for (DynamicObject structItem : structColl) {
            if (!structItem.getBoolean("isshow")) continue;
            String key = ((DynamicObject)structItem.get("preconfigid")).getString("number");
            nameSaveDy.set(key, dataEntity.get(key));
        }
        String formatName = BatchImportNameCtlHelper.getFormatName((Long)nameConfigFormatId, (Object)plugin.getView().getModel().getDataEntity());
        nameSaveDy.set("number", (Object)formatName);
        nameSaveDy.set("name", (Object)formatName);
        nameSaveDy.set("source", source);
        nameSaveDy.set("nameconfig", (Object)Long.valueOf(configFormat.getPkValue().toString()));
        nameSaveDy.set("country", country);
        DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nameSaveDy});
        return Long.valueOf(save[0].getPkValue().toString());
    }

    @Deprecated
    private static String getFormatName(Long configFormatId, Object dataEntity) {
        DynamicObject configFormat = BusinessDataServiceHelper.loadSingle((Object)configFormatId, (String)CTS_NAME_CONFIG_FORMAT);
        if (configFormat == null) {
            throw new RuntimeException("this name config format is not exist");
        }
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection formatColl = (DynamicObjectCollection)configFormat.get("entryentity");
        for (DynamicObject formatItem : formatColl) {
            boolean isInclude;
            DynamicObject namePreField = (DynamicObject)formatItem.get("preconfigid");
            String content = null;
            if (dataEntity instanceof DynamicObject) {
                content = ((DynamicObject)dataEntity).getString(namePreField.getString("number"));
            } else if (dataEntity instanceof Map) {
                content = (String)((Map)dataEntity).get(namePreField.getString("number"));
            }
            if (!(isInclude = formatItem.getBoolean("isinclude")) || !StringUtils.isNotEmpty((String)content)) continue;
            String prefix = formatItem.getString("prefix");
            String suffix = formatItem.getString("suffix");
            boolean isSpaceSplit = formatItem.getBoolean("isspacesplit");
            sb.append(StringUtils.isNotEmpty((String)prefix) ? prefix : "");
            sb.append(content);
            sb.append(StringUtils.isNotEmpty((String)suffix) ? suffix : "");
            sb.append(isSpaceSplit ? " " : "");
        }
        String formatStr = sb.toString();
        if (StringUtils.isEmpty((String)formatStr)) {
            formatStr = " ";
        }
        return formatStr;
    }

    public static String getNameFormatStr(Long configFormatId, Map<String, String> dataEntity) {
        return BatchImportNameCtlHelper.getFormatName((Long)configFormatId, dataEntity);
    }

    @Deprecated
    public static Long getDefaultNameStyleId(Long countryId) throws Exception {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (countryId != null) {
            QFilter countryFilter = new QFilter("country.fbasedataid", "=", (Object)countryId);
            QFilter defaultFilter = new QFilter("iscountrydefault", "=", (Object)"1");
            DynamicObject defaultNameFormat = BusinessDataServiceHelper.loadSingle((String)CTS_NAME_CONFIG_FORMAT, (String)"id", (QFilter[])new QFilter[]{countryFilter, defaultFilter, enableFilter});
            if (defaultNameFormat != null) {
                return Long.valueOf(defaultNameFormat.getPkValue().toString());
            }
        }
        return NameUtil.getGlobalDefaultNameStyleId(enableFilter);
    }

    public static Set<Long> getCountryNameTextStyles(Long countryId) {
        String sql = "select fid from t_cts_nameconfigcountries where fcountry = " + countryId;
        HashSet<Long> ids = new HashSet<Long>(16);
        DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            while (rs.next()) {
                ids.add(rs.getLong("fid"));
            }
            return null;
        });
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Long id = NameUtil.getGlobalDefaultNameStyleId(enableFilter);
        if (id != 0L) {
            ids.add(id);
        }
        return ids;
    }

    public static Long getCountryDefaultNameStyleId(Long countryId) {
        String sql = "select fid from t_cts_nameconfigcountries where fisdefault = '1' and fcountry = " + countryId;
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, rs -> {
            Long id = null;
            while (rs.next()) {
                id = rs.getLong("fid");
            }
            if (id != null) {
                return id;
            }
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            return NameUtil.getGlobalDefaultNameStyleId(enableFilter);
        });
    }

    public static Long getGlobalDefaultNameStyleId(QFilter enableFilter) {
        long nameStyleId = 0L;
        QFilter isGlobalDefaultFilter = new QFilter("isglobaldefault", "=", (Object)"1");
        DynamicObject globalDefaultFormat = BusinessDataServiceHelper.loadSingle((String)CTS_NAME_CONFIG_FORMAT, (String)"id", (QFilter[])new QFilter[]{isGlobalDefaultFilter, enableFilter});
        if (globalDefaultFormat != null) {
            nameStyleId = Long.parseLong(globalDefaultFormat.getPkValue().toString());
        }
        return Optional.of(nameStyleId).orElse(0L);
    }

    public static List<NameConfigStruct> getNameStyleConfig(Long nameConfigStructId, Map<String, String> defaultValueMap) {
        ArrayList<NameConfigStruct> nameConfigStructList = new ArrayList<NameConfigStruct>();
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT namefieldL.fname,namefield.fnumber,fcustomlabel,ftype,fbdtype,fisrequired ");
        builder.append(" FROM t_cts_nameconfigstruct struct ");
        builder.append(" INNER JOIN t_cts_nameprefield namefield on struct.fpreconfigid = namefield.fid ");
        builder.append(" INNER JOIN t_cts_nameprefield_l namefieldL on namefield.fid = namefieldL.fid AND namefieldL.flocaleid = ? ");
        builder.append(" WHERE struct.fid = ? and struct.fisshow = '1' order by struct.fseq");
        DB.query((DBRoute)DBRoute.basedata, (String)builder.toString(), (Object[])new Object[]{Lang.get().getLocale().toString(), nameConfigStructId}, rs -> {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                NameConfigStruct nameConfigStruct = new NameConfigStruct();
                if (defaultValueMap != null && !defaultValueMap.isEmpty()) {
                    nameConfigStruct.setDefaultValue((String)defaultValueMap.get(number));
                }
                nameConfigStruct.setFieldKey(number);
                nameConfigStruct.setFieldName(rs.getString("fname"));
                nameConfigStruct.setBasedata(rs.getInt("ftype") == 1);
                nameConfigStruct.setFormId(rs.getString("fbdtype"));
                nameConfigStruct.setMustInput(rs.getBoolean("fisrequired"));
                nameConfigStruct.setCustomerTag(rs.getString("fcustomlabel"));
                if (NameUtil.isComboField(number)) {
                    nameConfigStruct.setComboValues(NameUtil.getComboItems(number));
                }
                nameConfigStructList.add(nameConfigStruct);
            }
            return nameConfigStructList;
        });
        return nameConfigStructList;
    }

    private static boolean isComboField(String key) {
        return "title".equals(key) || "positionaltitle".equals(key);
    }

    private static List<String> getComboItems(String key) {
        QFilter typeFilter = null;
        if (key.equals("title")) {
            typeFilter = new QFilter("type", "=", (Object)"0");
        } else if (key.equals("positionaltitle")) {
            typeFilter = new QFilter("type", "=", (Object)"1");
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] titleArray = BusinessDataServiceHelper.load((String)"cts_title", (String)"id,name", (QFilter[])new QFilter[]{typeFilter, enableFilter});
        ArrayList<String> nameList = new ArrayList<String>(10);
        for (DynamicObject title : titleArray) {
            nameList.add(title.getString("name"));
        }
        return nameList;
    }

    public static DynamicObject getCountryDefaultNameStyleId(String countryNumber, String countryName) {
        return BatchImportNameCtlHelper.getCountryDefaultNameStyleId((String)countryNumber, (String)countryName);
    }

    public static boolean checkCountryNameStyle(String countryNumber, String styleNumber) {
        return BatchImportNameCtlHelper.checkCountryNameStyle((String)countryNumber, (String)styleNumber);
    }

    public static List<String> getStructNameMustInputField(String number) {
        return BatchImportNameCtlHelper.getStructNameMustInputField((String)number);
    }
}

