/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.phone.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TelephoneFormatFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ROW_INDEX = "rowIndex";
    private static final String CONFIRM_CALLBACK_ID = "callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("digit".equals(name) && StringUtils.isNotBlank((CharSequence)(value = changeData.getNewValue().toString()))) {
            value = value.replace(" ", "");
            this.checkDigitValue(value, changeData.getRowIndex());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntityData();
    }

    private void initEntityData() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject object = QueryServiceHelper.queryOne((String)"cts_telephoneformat", (String)"id", null);
        if (object == null) {
            return;
        }
        String selectFields = "id,entryentity.id,entryentity.countryid,entryentity.digit,entryentity.segment,entryentity.ischeck,entryentity.issystem,entryentity.number";
        long id = object.getLong("id");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"cts_telephoneformat", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, (String)"entryentity.seq");
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.getModel().setValue("id", (Object)id);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]).addField("countryid", new Object[0]).addField("digit", new Object[0]).addField("segment", new Object[0]).addField("ischeck", new Object[0]).addField("issystem", new Object[0]).addField("number", new Object[0]);
        for (DynamicObject account : collection) {
            vs.addRow(new Object[]{account.getString("entryentity.id"), account.getString("entryentity.countryid"), account.getString("entryentity.digit"), account.getString("entryentity.segment"), account.getLong("entryentity.ischeck"), account.get("entryentity.issystem"), account.get("entryentity.number")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.getDataEntity().getDataEntityState().setFromDatabase(true);
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getView().updateView("entryentity");
    }

    private void checkDigitValue(String value, int rowIndex) {
        String[] split = value.split(",");
        boolean isNumber = Arrays.stream(split).allMatch(this::isNumber);
        if (!isNumber) {
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(false);
            this.getModel().setValue("digit", (Object)"", rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5f55\u51651-20\u7684\u6574\u6570\uff0c\u591a\u4e2a\u503c\u8bf7\u4ee5'\uff0c'\u5206\u9694\u3002", (String)"TelephoneFormatFormPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            this.getModel().setValue("digit", (Object)value, rowIndex);
        }
    }

    public void cellClick(CellClickEvent event) {
        DynamicObject entryentity;
        if ("segment".equals(event.getFieldKey()) && !(entryentity = this.getModel().getEntryRowEntity("entryentity", event.getRow())).getBoolean("issystem")) {
            String segment = (String)this.getModel().getValue("segment", event.getRow());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("cts_telephone_segment");
            parameter.setCustomParam("segment", (Object)segment);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CONFIRM_CALLBACK_ID));
            this.getView().showForm(parameter);
            this.getPageCache().put(ROW_INDEX, Integer.toString(event.getRow()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData != null) {
            Set segments = (Set)returnData;
            int rowIndex = Integer.parseInt(this.getPageCache().get(ROW_INDEX));
            this.getModel().setValue("segment", (Object)StringUtils.join((Object[])segments.toArray(), (String)","), rowIndex);
            this.getView().updateView("entryentity");
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (!entryentity.getBoolean("issystem")) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"TelephoneFormatFormPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("^([1][0-9]|20|[1-9])$", 32);
        return pattern.matcher(str).matches();
    }
}

