/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.phone.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.list.F7SelectedList;

public class TelephoneSegmentPlugin
extends AbstractBillPlugIn {
    private static final String BTN_OK = "btnok";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String SEGMENT = "segment";
    private static final String F7_SELECTED_LIST_AP = "f7selectedlistap";
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnSegmentsToParent();
        }
    }

    private void returnSegmentsToParent() {
        Set<String> segments = this.getSegments();
        this.getView().returnDataToParent(segments);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Integer newValue = (Integer)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "from": {
                int to = (Integer)this.getModel().getValue(TO, rowIndex);
                if (!this.compareFromTo(newValue, to)) break;
                this.getModel().setValue(FROM, (Object)0, rowIndex);
                break;
            }
            case "to": {
                int from = (Integer)this.getModel().getValue(FROM, rowIndex);
                if (!this.compareFromTo(from, newValue)) break;
                this.getModel().setValue(TO, (Object)0, rowIndex);
                break;
            }
        }
        this.f7SelectedValue();
    }

    private boolean compareFromTo(int from, int to) {
        boolean ret = false;
        if (from == 0 || to == 0) {
            return false;
        }
        if (to < from) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ece\u201d\u5e94\u5f53\u5c0f\u4e8e\u7b49\u4e8e\u201c\u81f3\u201d\u3002", (String)"TelephoneSegmentPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (String.valueOf(to).length() != String.valueOf(from).length()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ece\u201d\u548c\u201c\u81f3\u201d\u7684\u957f\u5ea6\u5e94\u5f53\u4e00\u81f4\u3002", (String)"TelephoneSegmentPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]));
            ret = true;
        }
        return ret;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.f7SelectedValue();
    }

    public void afterCreateNewData(EventObject e) {
        String[] split;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String segment = (String)parameter.getCustomParam(SEGMENT);
        if (StringUtils.isBlank((CharSequence)segment)) {
            return;
        }
        Map<String, Object> splitSegmentMap = this.splitSegment(segment);
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, splitSegmentMap.size());
        int i = 0;
        for (Map.Entry<String, Object> entry : splitSegmentMap.entrySet()) {
            this.getModel().setValue(FROM, (Object)entry.getKey(), rowIndex[i]);
            if (entry.getValue() != null) {
                this.getModel().setValue(TO, entry.getValue(), rowIndex[i]);
            }
            ++i;
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST_AP);
        f7SelectedList.removeAllItems();
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>(10);
        for (String s : split = segment.split(",")) {
            items.add(new ValueTextItem("", s));
        }
        f7SelectedList.addItems(items);
    }

    private Map<String, Object> splitSegment(String segment) {
        String[] split;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String s : split = segment.split(",")) {
            if (s.contains("-")) {
                String[] strings = s.split("-");
                map.put(strings[0], strings[1]);
                continue;
            }
            map.put(s, null);
        }
        return map;
    }

    private void f7SelectedValue() {
        ArrayList<ValueTextItem> items = new ArrayList<ValueTextItem>(10);
        Set<String> segments = this.getSegments();
        for (String segment : segments) {
            items.add(new ValueTextItem("", segment));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST_AP);
        f7SelectedList.addItems(items);
    }

    private Set<String> getSegments() {
        LinkedHashSet<String> segments = new LinkedHashSet<String>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject object : entryEntity) {
            String segment = this.getSegment(object.getInt(FROM), object.getInt(TO));
            segments.add(segment);
        }
        return segments;
    }

    private String getSegment(int from, int to) {
        if (from != 0 && to != 0) {
            return from + "-" + to;
        }
        if (from != 0) {
            return from + "";
        }
        return to != 0 ? String.valueOf(to) : "";
    }
}

