/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.phone.plugin.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;

public class TelephoneFormatValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject dynamicObject = this.dataEntities[0].getDataEntity();
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
        long id = dynamicObject.getLong("id");
        if (collection.isEmpty() && id == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7\u683c\u5f0f\u4fe1\u606f\u3002", (String)"TelephoneFormatValidator_0", (String)"bos-address-formplugin", (Object[])new Object[0]));
        }
        int index = 1;
        HashMap<String, Integer> countryIndexMap = new HashMap<String, Integer>(10);
        for (DynamicObject object : collection) {
            String countryId = object.getString("countryid");
            boolean isSystem = object.getBoolean("issystem");
            if (object.getBoolean("ischeck")) {
                this.checkProperty(index, countryId, countryIndexMap, isSystem);
            }
            ++index;
        }
    }

    private void checkProperty(int index, String countryId, Map<String, Integer> countryIndexMap, boolean isSystem) {
        if (StringUtils.isEmpty((CharSequence)countryId) && !isSystem) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c: \u56fd\u5bb6/\u5730\u533a\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"TelephoneFormatValidator_1", (String)"bos-address-formplugin", (Object[])new Object[0]), index));
        }
        if (null != countryId && countryIndexMap.containsKey(countryId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c: \u6bcf\u4e2a\u56fd\u5bb6\u6216\u5730\u533a\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u6821\u9a8c\u3002", (String)"TelephoneFormatValidator_2", (String)"bos-address-formplugin", (Object[])new Object[0]), countryIndexMap.get(countryId) + "\u3001" + index));
        }
        countryIndexMap.put(countryId, index);
    }
}

