/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.api.enums;

public enum DateType {
    WORKING("", 1),
    HALF_WORKING("", 2),
    REST_DAY("", 3),
    HOLIDAY("", 4),
    UNKNOWN("", 5);

    private final String value;
    private final int code;

    private DateType(String value, int code) {
        this.value = value;
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public static String getValueByCode(int code) {
        for (DateType dateType : DateType.values()) {
            if (dateType.getCode() != code) continue;
            return dateType.getValue();
        }
        return UNKNOWN.getValue();
    }

    public static DateType getByCode(int code) {
        for (DateType dateType : DateType.values()) {
            if (dateType.getCode() != code) continue;
            return dateType;
        }
        return UNKNOWN;
    }

    public static DateType get(String value) {
        for (DateType dateType : DateType.values()) {
            if (!dateType.getValue().equals(value)) continue;
            return dateType;
        }
        return UNKNOWN;
    }
}

