/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.i18n;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);

    public static JsonNode get(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        JsonNode resultObj = null;
        String responseStr = HttpClientUtils.get((String)url, header, body, (int)1500, (int)1500);
        if (responseStr != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            resultObj = (JsonNode)objectMapper.readValue(responseStr, JsonNode.class);
            logger.info("HttpUtils.get: url = " + url + ",bodyMap = " + body + ",responseStr = " + HttpUtils.validLog(responseStr));
        }
        return resultObj;
    }

    private static String validLog(String logs) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("%0a");
        list.add("%0b");
        list.add("%0c");
        list.add("%0d");
        list.add("%7f");
        list.add("%08");
        list.add("%0A");
        list.add("%0D");
        list.add("\r");
        list.add("\n");
        String normalize = Normalizer.normalize(logs, Normalizer.Form.NFKC);
        for (String str : list) {
            normalize = normalize.replace(str, "");
        }
        return normalize;
    }
}

