/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.i18n;

import com.fasterxml.jackson.databind.JsonNode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.i18n.HttpUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPools;

public class MMPMsgUtils {
    private static final Log logger = LogFactory.getLog(MMPMsgUtils.class);
    private static final Map<String, String> kDMsgInfoMap = new ConcurrentHashMap<String, String>();
    private static final String DELIMITER = "__";
    private static final String SEPARATOR = "_";

    public static String getMessageInfo(String msg, String msgCode, String systemType) {
        return MMPMsgUtils.getMessageInfo(msg, systemType + SEPARATOR + msgCode);
    }

    public static String getMessageInfo(String msg, String msgCode) {
        RequestContext rc = RequestContext.get();
        if (rc == null || msgCode == null || msg == null) {
            return msg;
        }
        String tenantId = RequestContext.get().getTenantId();
        String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
        if ("FALSE".equalsIgnoreCase(tipsOn)) {
            return msg;
        }
        String url = MMPMsgUtils.updateUrl(msgCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("msgcode", msgCode);
        param.put("href", StringUtils.isBlank((CharSequence)url) ? null : url);
        param.put("msg", msg);
        return SerializationUtils.toJsonString(param);
    }

    private static String updateUrl(String msgCode) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String today = sdf.format(new Date());
        String key = msgCode + DELIMITER + today;
        if (!kDMsgInfoMap.containsKey(key)) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            String yesterday = sdf.format(cal.getTime());
            String yesterdayKey = msgCode + DELIMITER + yesterday;
            try {
                Future<String> submit = MmpUrlThreadPool.executorService.submit(() -> MMPMsgUtils.getUrl(msgCode));
                String url = submit.get(1L, TimeUnit.SECONDS);
                if (url != null) {
                    kDMsgInfoMap.put(key, url);
                    kDMsgInfoMap.remove(yesterdayKey);
                    return url;
                }
            }
            catch (Exception e) {
                logger.error("MMPMsgUtils.updateUrl error", (Throwable)e);
            }
            String s = kDMsgInfoMap.get(yesterdayKey);
            kDMsgInfoMap.put(key, s == null ? "" : s);
            kDMsgInfoMap.remove(yesterdayKey);
        }
        return kDMsgInfoMap.get(key);
    }

    private static String getUrl(String msgCode) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json;charset=UTF-8");
        int modeType = LicenseServiceHelper.getModeType();
        String url = modeType == 4 ? "https://knowledge.kingdee.com/product/93/error-solutions" : (modeType == 3 ? "https://knowledge.kingdee.com/product/3/error-solutions" : "https://knowledge.kingdee.com/product/9/error-solutions");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("errcode", msgCode);
        String res = null;
        try {
            JsonNode jsonNode = HttpUtils.get(url, header, body);
            res = MMPMsgUtils.checkAndFormatResult(jsonNode);
        }
        catch (Exception e) {
            logger.error("MMPMsgUtils.getSolutionUrl error", (Throwable)e);
        }
        return res;
    }

    private static String checkAndFormatResult(JsonNode resultObj) {
        JsonNode content;
        if (resultObj != null && resultObj.get("content") != null && (content = resultObj.findValue("content")) != null) {
            if (content.findValue("entityUrl") != null) {
                return content.findValue("entityUrl").asText();
            }
            return "";
        }
        return null;
    }

    private static class MmpUrlThreadPool {
        private static final ExecutorService executorService = ThreadPools.newExecutorService((String)"mmpUrlThreadPool", (int)10);

        private MmpUrlThreadPool() {
        }
    }
}

