/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.ext.form.control.events.NameSegEnum;
import kd.bos.ext.metadata.entity.property.NameSegBasedataProp;
import kd.bos.ext.metadata.entity.property.NameSegComboProp;
import kd.bos.ext.metadata.entity.property.NameSegTextProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.inte.api.EnabledLang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class BatchImportNameCtlHelper {
    private static final int FIRST_ROW_IDX = 0;
    private static final String CTS_NAME_CONFIG_FORMAT = "cts_nameconfigformat";

    public static void checkAndModify(List<ImportBillData> rowdatas, ImportLogger logger, MainEntityType mainEntityType, ImportContext ctx) {
        if (rowdatas.size() <= 0) {
            return;
        }
        ImportBillData importBillData = rowdatas.get(0);
        ImportEntityMapping entityMapping = importBillData.getEntityMapping();
        Set billHeaderSelectedFields = entityMapping.getCols().keySet();
        HashMap map = new HashMap();
        mainEntityType.getAllFields().values().forEach(dataEntityProperty -> {
            if (billHeaderSelectedFields.contains(dataEntityProperty.getName())) {
                ArrayList<IDataEntityProperty> objects;
                if (dataEntityProperty instanceof NameSegBasedataProp) {
                    objects = new ArrayList<IDataEntityProperty>();
                    objects.add((IDataEntityProperty)dataEntityProperty);
                    map.merge(((NameSegBasedataProp)dataEntityProperty).getI18nNameKey(), objects, (oldV, newV) -> {
                        oldV.add(dataEntityProperty);
                        return oldV;
                    });
                }
                if (dataEntityProperty instanceof NameSegComboProp) {
                    objects = new ArrayList();
                    objects.add((IDataEntityProperty)dataEntityProperty);
                    map.merge(((NameSegComboProp)dataEntityProperty).getI18nNameKey(), objects, (oldV, newV) -> {
                        oldV.add(dataEntityProperty);
                        return oldV;
                    });
                }
                if (dataEntityProperty instanceof NameSegTextProp) {
                    objects = new ArrayList();
                    objects.add((IDataEntityProperty)dataEntityProperty);
                    map.merge(((NameSegTextProp)dataEntityProperty).getI18nNameKey(), objects, (oldV, newV) -> {
                        oldV.add(dataEntityProperty);
                        return oldV;
                    });
                }
            }
        });
        Boolean isAllowedNull = ctx.getOption().getOrDefault("isNSCountryAllowedNull", false);
        ListIterator<ImportBillData> iterator = rowdatas.listIterator();
        while (iterator.hasNext()) {
            ImportBillData importData = iterator.next();
            JSONObject currentRecord = importData.getData();
            try {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    List v = (List)entry.getValue();
                    Map<String, Object> commitResult = BatchImportNameCtlHelper.invokeInsertApi(currentRecord, v, isAllowedNull);
                    if (!((Boolean)commitResult.get("success")).booleanValue()) {
                        sb.append((String)commitResult.get("msg"));
                        continue;
                    }
                    String i18nName = (String)commitResult.get("i18nName");
                    IDataEntityProperty property = (IDataEntityProperty)mainEntityType.getAllFields().get(entry.getKey());
                    if (property instanceof MuliLangTextProp) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        List multiLangList = InteServiceHelper.getMultiLangEnabledLang();
                        for (EnabledLang enabledLang : multiLangList) {
                            hashMap.put(enabledLang.getNumber(), i18nName);
                        }
                        currentRecord.put((String)entry.getKey(), hashMap);
                        continue;
                    }
                    currentRecord.put((String)entry.getKey(), (Object)i18nName);
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    throw new RuntimeException(sb.toString());
                }
                iterator.set(importData);
            }
            catch (Exception e) {
                logger.fail().log(Integer.valueOf(importData.getStartIndex()), e.getMessage());
                iterator.remove();
            }
        }
    }

    private static Map<String, Object> invokeInsertApi(JSONObject currentRecord, List<IDataEntityProperty> properties, boolean isAllowedNull) {
        Map<String, Object> map;
        String name;
        String number;
        DynamicObject nameStyle;
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        HashMap<String, String> nameFormatMap = new HashMap<String, String>(16);
        properties.forEach(prop -> {
            String s;
            Object o = currentRecord.get((Object)prop.getName());
            String propName = (String)prop.getDisplayName().get((Object)InteServiceHelper.getDefaultLangNumber());
            if (prop instanceof NameSegBasedataProp) {
                FieldDefValue defValue2;
                s = Arrays.stream(NameSegEnum.decodeNameSegId((String)((NameSegBasedataProp)prop).getI18nNameFieldId())).findFirst().get();
                if (o == null && (defValue2 = ((NameSegBasedataProp)prop).getDefValue2()) != null && StringUtils.isNotBlank((CharSequence)defValue2.getFuncParameter())) {
                    o = JSONObject.parseObject((String)defValue2.getFuncParameter());
                }
                valueMap.put(s, o);
                keyMap.put(s, prop.getName());
                nameMap.put(s, propName);
            }
            if (prop instanceof NameSegComboProp) {
                s = Arrays.stream(NameSegEnum.decodeNameSegId((String)((NameSegComboProp)prop).getI18nNameFieldId())).findFirst().get();
                if (o == null || StringUtils.isBlank((CharSequence)o.toString())) {
                    o = ((NameSegComboProp)prop).getDefValue();
                }
                valueMap.put(s, o);
                keyMap.put(s, prop.getName());
                nameMap.put(s, propName);
                nameFormatMap.put(NameSegEnum.getPresetNameKeyByKey((String)s), o != null ? o.toString() : null);
            }
            if (prop instanceof NameSegTextProp) {
                s = Arrays.stream(NameSegEnum.decodeNameSegId((String)((NameSegTextProp)prop).getI18nNameFieldId())).findFirst().get();
                if (o == null || StringUtils.isBlank((CharSequence)o.toString())) {
                    o = ((NameSegTextProp)prop).getDefValue();
                }
                valueMap.put(s, o);
                keyMap.put(s, prop.getName());
                nameMap.put(s, propName);
                nameFormatMap.put(NameSegEnum.getPresetNameKeyByKey((String)s), o != null ? o.toString() : null);
            }
        });
        Object styleValue = valueMap.get(NameSegEnum.NS_NAME_STYLE.getKey());
        String key = (String)keyMap.get(NameSegEnum.NS_NAME_STYLE.getKey());
        Object countryValue = valueMap.get(NameSegEnum.NS_COUNTRY.getKey());
        Long configFormatId = 0L;
        if (styleValue == null && countryValue != null && (nameStyle = BatchImportNameCtlHelper.getCountryDefaultNameStyleId(number = (String)((JSONObject)countryValue).get((Object)"number"), name = (String)((JSONObject)countryValue).get((Object)"name"))) != null) {
            configFormatId = nameStyle.getLong("id");
            HashMap<String, String> nameStyleMap = new HashMap<String, String>(16);
            nameStyleMap.put("importprop", "number");
            nameStyleMap.put("number", nameStyle.getString("number"));
            nameStyleMap.put("name", nameStyle.getString("name"));
            styleValue = new JSONObject(nameStyleMap);
            currentRecord.put(key, styleValue);
            valueMap.put(NameSegEnum.NS_NAME_STYLE.getKey(), styleValue);
        }
        if (((Boolean)(map = BatchImportNameCtlHelper.checkNameStyle(valueMap, keyMap, nameMap, isAllowedNull)).get("success")).booleanValue()) {
            if (styleValue != null) {
                String number2 = ((JSONObject)styleValue).getString("number");
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and(new QFilter("number", "=", (Object)number2));
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)CTS_NAME_CONFIG_FORMAT, (QFilter[])filter.toArray());
                configFormatId = dynamicObject.getLong("id");
            }
            String nameFormatStr = BatchImportNameCtlHelper.getNameFormatStr(configFormatId, nameFormatMap);
            map.put("i18nName", nameFormatStr);
        }
        return map;
    }

    public static Map<String, Object> checkNameStyle(Map<String, Object> valueMap, Map<String, String> keyMap, Map<String, String> nameMap, boolean isAllowedNull) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        StringBuilder sb = new StringBuilder();
        Boolean result = Boolean.FALSE;
        JSONObject country = (JSONObject)valueMap.get(NameSegEnum.NS_COUNTRY.getKey());
        JSONObject style = (JSONObject)valueMap.get(NameSegEnum.NS_NAME_STYLE.getKey());
        if (style == null || StringUtils.isBlank((CharSequence)((String)style.get((Object)"number"))) && StringUtils.isBlank((CharSequence)((String)style.get((Object)"name")))) {
            String msg = ResManager.loadResFormat((String)"\u59d3\u540d\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchImportNameExtPlugin_0", (String)"bos-address-formplugin", (Object[])new Object[0]);
            sb.append(msg);
        } else if ((country == null || StringUtils.isBlank((CharSequence)((String)country.get((Object)"number"))) && StringUtils.isBlank((CharSequence)((String)country.get((Object)"name")))) && !isAllowedNull) {
            String msg = ResManager.loadResFormat((String)"\u56fd\u5bb6/\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchImportNameExtPlugin_3", (String)"bos-address-formplugin", (Object[])new Object[0]);
            sb.append(msg);
        } else if ((StringUtils.isNotBlank((CharSequence)((String)style.get((Object)"number"))) || StringUtils.isNotBlank((CharSequence)((String)style.get((Object)"name")))) && !BatchImportNameCtlHelper.checkStyleAndCountry(CTS_NAME_CONFIG_FORMAT, (String)style.get((Object)"number"), (String)style.get((Object)"name"))) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u59d3\u540d\u683c\u5f0f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatchImportNameExtPlugin_4", (String)"bos-address-formplugin", (Object[])new Object[0]);
            sb.append(msg);
        } else if (country != null && (StringUtils.isNotBlank((CharSequence)((String)country.get((Object)"number"))) || StringUtils.isNotBlank((CharSequence)((String)country.get((Object)"name")))) && !BatchImportNameCtlHelper.checkStyleAndCountry("bd_country", (String)country.get((Object)"number"), (String)country.get((Object)"name"))) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u56fd\u5bb6/\u5730\u533a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatchImportNameExtPlugin_5", (String)"bos-address-formplugin", (Object[])new Object[0]);
            sb.append(msg);
        } else {
            DynamicObject dynamicObject;
            QFilter filter;
            String styleNumber;
            String countryNumber;
            String countryStr = countryNumber = country == null ? "" : (String)country.get((Object)"number");
            String styleStr = styleNumber = (String)style.get((Object)"number");
            if (country != null && StringUtils.isBlank((CharSequence)countryNumber)) {
                countryStr = (String)country.get((Object)"name");
                filter = new QFilter("name", "=", (Object)countryStr).and("enable", "=", (Object)"1");
                dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"id", (QFilter[])filter.toArray());
                if (dynamicObject != null) {
                    countryNumber = dynamicObject.getString("number");
                }
            } else if (country != null && country.get((Object)"name") != null) {
                countryStr = countryNumber + "-" + country.getString("name");
            }
            if (StringUtils.isBlank((CharSequence)styleNumber) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_NAME_CONFIG_FORMAT, (String)"id", (QFilter[])(filter = new QFilter("name", "=", (Object)(styleStr = (String)style.get((Object)"name"))).and("enable", "=", (Object)"1")).toArray())) != null) {
                styleNumber = dynamicObject.getString("number");
            }
            if (StringUtils.isNotBlank((CharSequence)countryNumber) && StringUtils.isNotBlank((CharSequence)styleNumber) && BatchImportNameCtlHelper.checkCountryNameStyle(countryNumber, styleNumber)) {
                String msg = String.format(ResManager.loadKDString((String)"\u59d3\u540d\u683c\u5f0f%1$s\u672a\u5206\u914d\u7ed9\u56fd\u5bb6\u6216\u5730\u533a\uff1a%2$s\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u6216\u59d3\u540d\u683c\u5f0f\u914d\u7f6e\u3002", (String)"BatchImportNameExtPlugin_1", (String)"bos-address-formplugin", (Object[])new Object[0]), styleStr, countryStr);
                sb.append(msg);
            } else if (StringUtils.isNotBlank((CharSequence)styleNumber)) {
                List<String> number = BatchImportNameCtlHelper.getStructNameMustInputField(styleNumber);
                List keys = Arrays.stream(NameSegEnum.values()).filter(v -> number.contains(v.getPresetNameKey())).map(NameSegEnum::getKey).collect(Collectors.toList());
                HashSet<String> set = new HashSet<String>(16);
                for (String key : keys) {
                    Object o = valueMap.get(key);
                    if (o != null && !StringUtils.isBlank((CharSequence)o.toString())) continue;
                    set.add(nameMap.getOrDefault(key, keyMap.getOrDefault(key, key)));
                }
                if (!set.isEmpty()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u59d3\u540d\u683c\u5f0f%1$s\u8981\u6c42%2$s\u5fc5\u586b\u3002", (String)"BatchImportNameExtPlugin_2", (String)"bos-address-formplugin", (Object[])new Object[0]), styleStr, String.join((CharSequence)"\u3001", set));
                    sb.append(msg);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)sb.toString())) {
            result = Boolean.TRUE;
        }
        params.put("success", result);
        params.put("msg", sb.toString());
        return params;
    }

    public static boolean checkStyleAndCountry(String entityName, String number, String name) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            QFilter qFilter = new QFilter("number", "=", (Object)number).and("enable", "=", (Object)"1");
            return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])qFilter.toArray()) != null;
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            QFilter qFilter = new QFilter("name", "=", (Object)name).and("enable", "=", (Object)"1");
            return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])qFilter.toArray()) != null;
        }
        return false;
    }

    public static DynamicObject getCountryDefaultNameStyleId(String countryNumber, String countryName) {
        DynamicObject dynamicObject;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (kd.bos.util.StringUtils.isNotEmpty((String)countryNumber)) {
            filter.and("number", "=", (Object)countryNumber);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)countryName)) {
            filter.and("name", "=", (Object)countryName);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"id", (QFilter[])filter.toArray())) != null) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter defaultFilter = new QFilter("entryentity1.isdefault", "=", (Object)"1").and("entryentity1.country", "=", dynamicObject.getPkValue());
            QFilter qFilter = defaultFilter.and(enableFilter);
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_NAME_CONFIG_FORMAT, (String)"id,number,name", (QFilter[])qFilter.toArray());
            if (object == null) {
                QFilter isGlobalDefaultFilter = new QFilter("isglobaldefault", "=", (Object)"1").and(enableFilter);
                object = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_NAME_CONFIG_FORMAT, (String)"id,number,name", (QFilter[])isGlobalDefaultFilter.toArray());
            }
            return object;
        }
        return null;
    }

    public static String getFormatName(Long configFormatId, Object dataEntity) {
        DynamicObject configFormat = BusinessDataServiceHelper.loadSingle((Object)configFormatId, (String)CTS_NAME_CONFIG_FORMAT);
        if (configFormat == null) {
            throw new RuntimeException("this name config format is not exist");
        }
        StringBuilder sb = new StringBuilder();
        DynamicObjectCollection formatColl = (DynamicObjectCollection)configFormat.get("entryentity");
        for (DynamicObject formatItem : formatColl) {
            boolean isInclude;
            DynamicObject namePreField = (DynamicObject)formatItem.get("preconfigid");
            String content = null;
            if (dataEntity instanceof DynamicObject) {
                content = ((DynamicObject)dataEntity).getString(namePreField.getString("number"));
            } else if (dataEntity instanceof Map) {
                content = (String)((Map)dataEntity).get(namePreField.getString("number"));
            }
            if (!(isInclude = formatItem.getBoolean("isinclude")) || !kd.bos.util.StringUtils.isNotEmpty((String)content)) continue;
            String prefix = formatItem.getString("prefix");
            String suffix = formatItem.getString("suffix");
            boolean isSpaceSplit = formatItem.getBoolean("isspacesplit");
            sb.append(kd.bos.util.StringUtils.isNotEmpty((String)prefix) ? prefix : "");
            sb.append(content);
            sb.append(kd.bos.util.StringUtils.isNotEmpty((String)suffix) ? suffix : "");
            sb.append(isSpaceSplit ? " " : "");
        }
        String formatStr = sb.toString();
        if (kd.bos.util.StringUtils.isEmpty((String)formatStr)) {
            formatStr = " ";
        }
        return formatStr;
    }

    public static String getNameFormatStr(Long configFormatId, Map<String, String> dataEntity) {
        return BatchImportNameCtlHelper.getFormatName(configFormatId, dataEntity);
    }

    public static boolean checkCountryNameStyle(String countryNumber, String styleNumber) {
        QFilter filter;
        DynamicObject dynamicObject;
        DynamicObject object = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)countryNumber) && kd.bos.util.StringUtils.isNotEmpty((String)styleNumber) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"id", (QFilter[])(filter = new QFilter("number", "=", (Object)countryNumber).and("enable", "=", (Object)"1")).toArray())) != null) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1").and("number", "=", (Object)styleNumber);
            QFilter defaultFilter = new QFilter("entryentity1.country", "=", dynamicObject.getPkValue());
            QFilter isGlobalDefaultFilter = new QFilter("isglobaldefault", "=", (Object)"1");
            QFilter qFilter = enableFilter.and(defaultFilter.or(isGlobalDefaultFilter));
            object = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_NAME_CONFIG_FORMAT, (String)"id,number,name", (QFilter[])qFilter.toArray());
        }
        return object == null;
    }

    public static List<String> getStructNameMustInputField(String number) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject configFormat = BusinessDataServiceHelper.loadSingleFromCache((String)CTS_NAME_CONFIG_FORMAT, (String)"nameconfig", (QFilter[])filter.toArray());
        Long nameConfigStructId = (Long)((DynamicObject)configFormat.get("nameconfig")).getPkValue();
        DynamicObject configStruct = BusinessDataServiceHelper.loadSingleFromCache((Object)nameConfigStructId, (String)"cts_nameconfigstruct", (String)"entryentity.ismustinput,entryentity.preconfigid");
        DynamicObjectCollection structColl = (DynamicObjectCollection)configStruct.get("entryentity");
        for (DynamicObject structItem : structColl) {
            if (!structItem.getBoolean("ismustinput")) continue;
            String key = ((DynamicObject)structItem.get("preconfigid")).getString("number");
            list.add(key);
        }
        return list;
    }
}

