/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.i18n.api.IAddressService;
import kd.bos.i18n.api.IAdminDivisionService;
import kd.bos.i18n.api.IAmountConvertService;
import kd.bos.i18n.api.ICalendarService;
import kd.bos.i18n.api.IExchangeRateService;
import kd.bos.i18n.api.IIdentityService;
import kd.bos.i18n.api.ITaxNumberService;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.api.telephone.TelephoneService;
import kd.bos.i18n.mservice.utils.AmountConvertResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class I18nServiceHelper {
    private static final Log log = LogFactory.getLog(I18nServiceHelper.class);
    private static final String BD_EXRATE_TREE = "bd_exrate_tree";
    public static final String EXCTABLE = "exctable";
    public static final String ORGCUR = "orgcur";
    public static final String CUR = "cur";
    public static final String EXCVAL = "excval";
    public static final String EFFECTDATE = "effectdate";
    public static final String EXPIRYDATE = "expirydate";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    public static Set<Object> getTheZone(Long zoneTypeId, Long addrId, Date date) {
        IAddressService addressService = I18nServiceHelper.getService();
        return addressService.getTheZone(zoneTypeId, addrId, date);
    }

    public static Map<Long, Set<Object>> getTheZoneMap(List<Long> zoneTypeIds, Long addrId, Date date) {
        IAddressService addressService = I18nServiceHelper.getService();
        return addressService.getTheZoneMap(zoneTypeIds, addrId, date);
    }

    private static IAddressService getService() {
        return (IAddressService)ServiceFactory.getService(IAddressService.class);
    }

    public static Map<String, Object> getDateByWorkingPlan(Long workingPlanId, Date startDate, Date endDate) {
        ICalendarService calendarService = (ICalendarService)ServiceFactory.getService(ICalendarService.class);
        return calendarService.getDateByWorkingPlan(workingPlanId, startDate, endDate);
    }

    public static Map<String, Object> calculateDateByInterval(Long workingPlanId, Date date, Integer interval, Integer intervalType, Integer outputIntervalType) {
        ICalendarService calendarService = (ICalendarService)ServiceFactory.getService(ICalendarService.class);
        return calendarService.calculateDateByInterval(workingPlanId, date, interval, intervalType, outputIntervalType);
    }

    public static Map<String, Object> calculateDateByStartAndEndDate(Long workingPlanId, Date startDate, Date endDate) {
        ICalendarService calendarService = (ICalendarService)ServiceFactory.getService(ICalendarService.class);
        return calendarService.calculateDateByStartAndEndDate(workingPlanId, startDate, endDate);
    }

    public static Map<String, Object> validIdentityCardNo(Long countryId, String number, String identityNo) {
        IIdentityService iIdentityService = (IIdentityService)ServiceFactory.getService(IIdentityService.class);
        return iIdentityService.validIdentityCardNo(countryId, number, identityNo);
    }

    public static Map<String, Object> getIdentityNumber(Long countryId) {
        IIdentityService iIdentityService = (IIdentityService)ServiceFactory.getService(IIdentityService.class);
        return iIdentityService.getIdentityNumber(countryId);
    }

    public static boolean isEnabledAdvanceAddress() {
        IAddressService addressService = I18nServiceHelper.getService();
        return addressService.isEnabledAdvanceAddress();
    }

    public static String timeFormat(int seconds) {
        IFormat iFormat = FormatFactory.get((FormatTypes)FormatTypes.Time);
        FormatObject userFormat = I18nServiceHelper.getFormatObject();
        userFormat.setDateFormat(null);
        Format format = iFormat.getFormat(userFormat);
        Date date = null;
        try {
            date = new SimpleDateFormat("ss").parse(String.valueOf(seconds));
        }
        catch (Exception e) {
            log.error("Format seconds failed, seconds is " + seconds + e.getMessage());
        }
        if (date != null) {
            return format.format(date);
        }
        return "";
    }

    public static String dateFormat(Date date) {
        IFormat iFormat = FormatFactory.get((FormatTypes)FormatTypes.Date);
        return iFormat.getFormat(I18nServiceHelper.getFormatObject()).format(date);
    }

    public static String numberFormat(double number) {
        IFormat iFormat = FormatFactory.get((FormatTypes)FormatTypes.Number);
        return iFormat.getFormat(I18nServiceHelper.getFormatObject()).format(number);
    }

    public static String currencyFormat(double currency) {
        IFormat iFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency);
        return iFormat.getFormat(I18nServiceHelper.getFormatObject()).format(currency);
    }

    private static FormatObject getFormatObject() {
        return InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
    }

    public static Map<String, String> verifyTelephoneNumberFormat(String telephoneNumber, String ... countryNumber) {
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        return service.verifyTelephoneNumberFormat(telephoneNumber, countryNumber);
    }

    public static List<Map<String, String>> batchVerifyTelephoneNumberFormat(List<Map<String, Object>> telephoneNumberVerifyList) {
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        return service.batchVerifyTelephoneNumberFormat(telephoneNumberVerifyList);
    }

    public static TelephoneParseResult parseTelephone(String telephone) {
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        return service.parseTelephone(telephone);
    }

    public static List<TelephoneParseResult> batchParseTelephone(List<String> telephoneList) {
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        return service.batchParseTelephone(telephoneList);
    }

    public static AmountConvertResult amountConvertUppercase(String langAbbrCode, String currencyNumber, String amount) {
        IAmountConvertService service = (IAmountConvertService)ServiceFactory.getService(IAmountConvertService.class);
        return service.amountConvertUppercase(langAbbrCode, currencyNumber, amount, null);
    }

    public static AmountConvertResult amountConvertUppercase(String langAbbrCode, String currencyNumber, String amount, String isTransCurrNum) {
        IAmountConvertService service = (IAmountConvertService)ServiceFactory.getService(IAmountConvertService.class);
        return service.amountConvertUppercase(langAbbrCode, currencyNumber, amount, isTransCurrNum);
    }

    public static List<AmountConvertResult> batchAmountConvertUppercase(List<Map<String, String>> amountList) {
        IAmountConvertService service = (IAmountConvertService)ServiceFactory.getService(IAmountConvertService.class);
        return service.batchAmountConvertUppercase(amountList);
    }

    public static List<TelephoneVerifyResult> batchVerifyTelephoneNumber(List<String> telephoneNumberVerifyList) {
        TelephoneService service = (TelephoneService)ServiceFactory.getService(TelephoneService.class);
        return service.batchVerifyTelephoneNumber(telephoneNumberVerifyList);
    }

    public static List<Map<String, Object>> getCrossRate(List<Map<String, Object>> exchangeRateList) {
        IExchangeRateService service = (IExchangeRateService)ServiceFactory.getService(IExchangeRateService.class);
        return service.getCrossRate(exchangeRateList);
    }

    public static Map<String, String> VerifyTaxNumber(String number, String taxNumber) {
        ITaxNumberService service = (ITaxNumberService)ServiceFactory.getService(ITaxNumberService.class);
        return service.VerifyTaxNumber(number, taxNumber);
    }

    public static List<Map<String, Object>> getCrossRateByIds(List<Long> exchangeRateListIds) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])exchangeRateListIds.toArray(), (String)BD_EXRATE_TREE);
        ArrayList<Map<String, Object>> exchangeRateList = new ArrayList<Map<String, Object>>();
        dynamicObjectMap.values().forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject exctable = dy.getDynamicObject(EXCTABLE);
            DynamicObject orgcur = dy.getDynamicObject(ORGCUR);
            DynamicObject cur = dy.getDynamicObject(CUR);
            if (exctable != null && orgcur != null && cur != null) {
                map.put(EXCTABLE, exctable.getPkValue());
                map.put(ORGCUR, orgcur.getPkValue());
                map.put(CUR, cur.getPkValue());
                map.put(EXCVAL, dy.getString(EXCVAL));
                map.put(EFFECTDATE, I18nServiceHelper.dateFormatToString(dy.getDate(EFFECTDATE)));
                map.put(EXPIRYDATE, I18nServiceHelper.dateFormatToString(dy.getDate(EXPIRYDATE)));
                exchangeRateList.add(map);
            }
        });
        return I18nServiceHelper.getCrossRate(exchangeRateList);
    }

    private static String dateFormatToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(date);
    }

    public static Map<Long, String> batchGetAdminDivisionTimeZone(List<Long> adminDivisionIdList) {
        IAdminDivisionService service = (IAdminDivisionService)ServiceFactory.getService(IAdminDivisionService.class);
        return service.batchGetAdminDivisionTimeZone(adminDivisionIdList);
    }

    public static void saveUserFormatConfigByDefault(List<Object> userIdList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        boolean exists = QueryServiceHelper.exists((String)"inte_userlang", (QFilter[])new QFilter("user", "in", userIdList).toArray());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"inte_enabledlanguage", (String)"id,isdefaultsend", (QFilter[])new QFilter("isdefaultsend", "=", (Object)"1").toArray());
        if (dynamicObject != null && !exists) {
            for (Object userId : userIdList) {
                DynamicObject userLang = BusinessDataServiceHelper.newDynamicObject((String)"inte_userlang");
                userLang.set("user", userId);
                userLang.set("lang", dynamicObject.getPkValue());
                list.add(userLang);
            }
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        I18nServiceHelper.saveFormatByDefault(userIdList);
    }

    private static void saveFormatByDefault(List<Object> userIdList) {
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(10);
        boolean exists = QueryServiceHelper.exists((String)"inte_formatcfg", (QFilter[])new QFilter("user", "in", userIdList).toArray());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"inte_formatcfg_default", (String)"plan,iscustom,firstdayofweek,dateformat,timeformat,numformat,numgroupformat,decimalpoint,zeroshow,negativeformat,numseparator,amsign,pmsign,currposformat,currnegformat,currcnyshowprefix,democurrency", null);
        if (dynamicObjects != null && dynamicObjects.length > 0 && !exists) {
            for (Object userId : userIdList) {
                DynamicObject dynamicObject = dynamicObjects[0];
                DynamicObject formatcfg = BusinessDataServiceHelper.newDynamicObject((String)"inte_formatcfg");
                formatcfg.set("plan", (Object)dynamicObject.getDynamicObject("plan"));
                formatcfg.set("timezone", InteServiceHelper.getSysTimezone().get("id"));
                formatcfg.set("user", userId);
                formatcfg.set("firstdayofweek", dynamicObject.get("firstdayofweek"));
                formatcfg.set("dateformat", dynamicObject.get("dateformat"));
                formatcfg.set("timeformat", dynamicObject.get("timeformat"));
                formatcfg.set("numgroupformat", dynamicObject.get("numgroupformat"));
                formatcfg.set("decimalpoint", dynamicObject.get("decimalpoint"));
                formatcfg.set("zeroshow", dynamicObject.get("zeroshow"));
                formatcfg.set("negativeformat", dynamicObject.get("negativeformat"));
                formatcfg.set("numseparator", dynamicObject.get("numseparator"));
                formatcfg.set("amsign", dynamicObject.get("amsign"));
                formatcfg.set("pmsign", dynamicObject.get("pmsign"));
                formatcfg.set("currposformat", dynamicObject.get("currposformat"));
                formatcfg.set("currnegformat", dynamicObject.get("currnegformat"));
                formatcfg.set("cnyshowprefix", dynamicObject.get("currcnyshowprefix"));
                DynamicObject demoCurrency = (DynamicObject)dynamicObject.get("democurrency");
                formatcfg.set("democurrency", demoCurrency.get("id"));
                formatcfg.set("iscustom", dynamicObject.get("iscustom"));
                dyList.add(formatcfg);
            }
            SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
        }
    }

    public static Map<String, Object> getPublicHoliday(Collection<Object> countryIds, Date startDate, Date endDate) {
        ICalendarService calendarService = (ICalendarService)ServiceFactory.getService(ICalendarService.class);
        return calendarService.getPublicHoliday(countryIds, startDate, endDate);
    }

    public static Long getDefaultCountry() {
        Object defaultCountry = SystemParamServiceHelper.loadPublicParameterFromCache((String)"defaultcountry");
        long countryId = 1000001L;
        if (defaultCountry != null) {
            countryId = Long.parseLong(((Map)defaultCountry).get("id").toString());
        }
        return countryId;
    }
}

