/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.i18n.api.IAddressService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class AddressServiceImpl
implements IAddressService {
    private static final String CTS_ADDRESS = "cts_address";
    private static final String CTS_ZONE = "cts_zone";
    private static final String CONDITION_JSON = "conditionjson";
    private static final String ZONE_TYPE = "zonetype";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String ENABLE_FEATURE = "enablefeature";

    public Set<Object> getTheZone(Long zoneTypeId, Long addrId, Date date) {
        Set<Object> zone = null;
        Map<Long, Set<Object>> theZoneMap = this.getTheZoneMap(Collections.singletonList(zoneTypeId), addrId, date);
        for (Map.Entry<Long, Set<Object>> longSetEntry : theZoneMap.entrySet()) {
            zone = longSetEntry.getValue();
        }
        return zone;
    }

    public Map<Long, Set<Object>> getTheZoneMap(List<Long> zoneTypeIds, Long addrId, Date date) {
        HashMap<Long, Set<Object>> longSetMap = new HashMap<Long, Set<Object>>(10);
        if (zoneTypeIds == null || addrId == 0L || date == null) {
            return longSetMap;
        }
        String selectProperties = "number, longnumber, isleaf, zonetype, starttime, endtime, conditionjson";
        QFilter[] qFilters = new QFilter[]{new QFilter(ZONE_TYPE, "in", zoneTypeIds), new QFilter("starttime", "<=", (Object)date), new QFilter("endtime", ">=", (Object)date), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        HashMap zoneType2NumberMap = new HashMap();
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)CTS_ZONE, (String)selectProperties, (QFilter[])qFilters, (String)"isleaf desc");
        HashSet zoneNumbers = new HashSet();
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            boolean exist;
            long zoneTypeId;
            long l = zoneTypeId = dynamicObject.get(ZONE_TYPE) != null ? dynamicObject.getDynamicObject(ZONE_TYPE).getLong(ID) : 0L;
            if (zoneNumbers.contains(dynamicObject.getString(NUMBER)) || !(exist = AddressServiceImpl.existAddressByCondition(dynamicObject.getString(CONDITION_JSON), addrId))) continue;
            String[] longNumbers = dynamicObject.getString("longnumber").split("\\.");
            zoneNumbers.addAll(Arrays.stream(longNumbers).collect(Collectors.toSet()));
            if (zoneType2NumberMap.get(zoneTypeId) != null) {
                ((Set)zoneType2NumberMap.get(zoneTypeId)).addAll(Arrays.stream(longNumbers).collect(Collectors.toSet()));
                continue;
            }
            zoneType2NumberMap.put(zoneTypeId, Arrays.stream(longNumbers).collect(Collectors.toSet()));
        }
        for (Map.Entry entry : zoneType2NumberMap.entrySet()) {
            Map objectMap = BusinessDataServiceHelper.loadFromCache((String)CTS_ZONE, (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", entry.getValue())});
            longSetMap.put((Long)entry.getKey(), objectMap.keySet());
        }
        return longSetMap;
    }

    private static boolean existAddressByCondition(String conditionJson, long addrId) {
        if (StringUtils.isBlank((CharSequence)conditionJson)) {
            return false;
        }
        QFilter qFilter = AddressServiceImpl.buildQFilter(conditionJson);
        return QueryServiceHelper.exists((String)CTS_ADDRESS, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)addrId), qFilter});
    }

    private static QFilter buildQFilter(String conditionJson) {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(2);
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer serializer = new DcJsonSerializer(dts);
        FilterCondition fc = (FilterCondition)serializer.deserializeFromString(conditionJson, null);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)CTS_ADDRESS);
        FilterBuilder builder = new FilterBuilder(type, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter(true);
        return builder.getQFilter();
    }

    public boolean isEnabledAdvanceAddress() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)1235511229410241536L, (String)"cts_advance_address", (String)ENABLE_FEATURE);
        return dynamicObject.getBoolean(ENABLE_FEATURE);
    }
}

