/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.IAdminDivisionService;
import kd.bos.i18n.api.model.TimeZone;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class AdminDivisionServiceImpl
implements IAdminDivisionService {
    public TimeZone getAdminDivisionTimeZone(Long adminDivisionId) {
        if (adminDivisionId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdminDivisionServiceImpl_0", (String)"bos-mservice-i18n", (Object[])new Object[0]));
        }
        DynamicObject adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivisionId, (String)"bd_admindivision");
        if (adminDivision != null) {
            DynamicObject timeZoneDy = adminDivision.getDynamicObject("timezone");
            if (timeZoneDy != null) {
                Long timeZoneId = (Long)timeZoneDy.getPkValue();
                String timeZoneNumber = timeZoneDy.getString("number");
                return new TimeZone(timeZoneId, timeZoneNumber);
            }
            if (adminDivision.getInt("level") == 1) {
                Long countryId = (Long)adminDivision.getDynamicObject("country").getPkValue();
                Map countryConfigMap = InteServiceHelper.getCountryConfiguration((Long)countryId);
                if (countryConfigMap.size() > 0 && countryConfigMap.get("timezone") != null) {
                    timeZoneDy = (DynamicObject)countryConfigMap.get("timezone");
                    Long timeZoneId = (Long)timeZoneDy.getPkValue();
                    String timeZoneNumber = timeZoneDy.getString("number");
                    return new TimeZone(timeZoneId, timeZoneNumber);
                }
                return null;
            }
            DynamicObject parentDy = adminDivision.getDynamicObject("parent");
            if (parentDy != null) {
                return this.getAdminDivisionTimeZone((Long)parentDy.getPkValue());
            }
            return null;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\u3002", (String)"AdminDivisionServiceImpl_1", (String)"bos-mservice-i18n", (Object[])new Object[0]));
    }

    public Map<Long, String> batchGetAdminDivisionTimeZone(List<Long> adminDivisionIdList) {
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_admindivision", (String)"id,timezone,country", (QFilter[])new QFilter("id", "in", adminDivisionIdList).toArray());
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            if (dynamicObject == null) continue;
            DynamicObject timeZoneDy = dynamicObject.getDynamicObject("timezone");
            if (timeZoneDy != null) {
                String timeZoneNumber = timeZoneDy.getString("number");
                map.put(dynamicObject.getLong("id"), timeZoneNumber);
                continue;
            }
            Long countryId = (Long)dynamicObject.getDynamicObject("country").getPkValue();
            Map countryConfigMap = InteServiceHelper.getCountryConfiguration((Long)countryId);
            if (countryConfigMap.size() <= 0 || countryConfigMap.get("timezone") == null) continue;
            String timeZoneNumber = ((DynamicObject)countryConfigMap.get("timezone")).getString("number");
            map.put(dynamicObject.getLong("id"), timeZoneNumber);
        }
        return map;
    }
}

