/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.i18n.api.ICalendarService;
import kd.bos.i18n.mservice.utils.PublicHolidayUtils;
import kd.bos.i18n.mservice.utils.WorkingPlanUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CalendarServiceImpl
implements ICalendarService {
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String BOS_MSERVICE_I18N = "bos-mservice-i18n";

    public Map<String, Object> getDateByWorkingPlan(Long workingPlanId, Date startDate, Date endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (workingPlanId == null || workingPlanId <= 0L) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8ba1\u5212id\u4e3a\u7a7a,\u65e0\u6548\u7684\u53c2\u6570", (String)"CalendarServiceImpl_0", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"CalendarServiceImpl_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject workingPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)workingPlanId, (String)"working_plan");
        if (workingPlan == null) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u5de5\u4f5c\u65e5\u8ba1\u5212\u3002", (String)"CalendarServiceImpl_2", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        Date startValidDate = workingPlan.getDate("startdate");
        Date endValidDate = workingPlan.getDate("enddate");
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar endCal = new GregorianCalendar();
        calendar.setTime(startValidDate);
        endCal.setTime(endValidDate);
        if (startDate != null && startDate.after(startValidDate)) {
            calendar.setTime(startDate);
        }
        if (endDate != null && endDate.before(endValidDate)) {
            endCal.setTime(endDate);
        }
        if (endCal.before(calendar)) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u8f93\u5165\u65e5\u671f\u4e0d\u5728\u5de5\u4f5c\u65e5\u8ba1\u5212\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"CalendarServiceImpl_3", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        endCal.set(14, 0);
        resultMap.put("startValidDate", this.DATE_FORMAT.format(calendar.getTime()));
        resultMap.put("endValidDate", this.DATE_FORMAT.format(endCal.getTime()));
        HashMap<String, Map<String, Object>> dateMap = new HashMap<String, Map<String, Object>>(16);
        while (!calendar.after(endCal)) {
            Map<String, Object> data = WorkingPlanUtils.applyWorkingPlan(workingPlan, (Calendar)calendar);
            if (!((Boolean)data.get("valid")).booleanValue()) {
                resultMap.put("isSuccess", FALSE);
                resultMap.put("errorMsg", data.get("errorMsg"));
                return resultMap;
            }
            dateMap.put(this.DATE_FORMAT.format(calendar.getTime()), data);
            calendar.add(5, 1);
        }
        resultMap.put("data", dateMap);
        resultMap.put("isSuccess", TRUE);
        return resultMap;
    }

    public Map<String, Object> calculateDateByInterval(Long workingPlanId, Date date, Integer interval, Integer intervalType, Integer outputIntervalType) {
        Map<String, Object> result;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (workingPlanId == null || interval == null || intervalType == null || outputIntervalType == null) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u7684\u53c2\u6570", (String)"CalendarServiceImpl_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        if (workingPlanId <= 0L || date == null || interval < 0 || intervalType != 0 && intervalType != 1 || outputIntervalType != 0 && outputIntervalType != 1) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u7684\u53c2\u6570", (String)"CalendarServiceImpl_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(14, 0);
        int currInterval = 0;
        calendar.add(5, -1);
        while (true) {
            boolean isAddInterval;
            boolean isWorkingDay;
            calendar.add(5, 1);
            result = WorkingPlanUtils.applyWorkingPlan(workingPlanId, (Calendar)calendar);
            if (!((Boolean)result.get("valid")).booleanValue()) {
                resultMap.put("isSuccess", FALSE);
                resultMap.put("errorMsg", result.get("errorMsg"));
                return resultMap;
            }
            int dateType = (Integer)result.get("dateType");
            boolean bl = isWorkingDay = dateType == 1 || dateType == 2 || dateType == 4 && (Boolean)result.get("holidaytype") != false && (Boolean)result.get("halfDayInWorkDay") != false;
            if (intervalType == 0) {
                isAddInterval = false;
                if (isWorkingDay && currInterval != interval) {
                    ++currInterval;
                    isAddInterval = true;
                }
                if (currInterval != interval) continue;
                if (outputIntervalType == 0) {
                    if (isAddInterval || !isWorkingDay) continue;
                    return this.getDateInfoByWorkingPlan(result, calendar);
                }
                if (isAddInterval) continue;
                return this.getDateInfoByWorkingPlan(result, calendar);
            }
            isAddInterval = false;
            if (currInterval != interval) {
                ++currInterval;
                isAddInterval = true;
            }
            if (currInterval != interval) continue;
            if (outputIntervalType == 0) {
                if (isAddInterval || !isWorkingDay) continue;
                return this.getDateInfoByWorkingPlan(result, calendar);
            }
            if (!isAddInterval) break;
        }
        return this.getDateInfoByWorkingPlan(result, calendar);
    }

    private Map<String, Object> getDateInfoByWorkingPlan(Map<String, Object> result, Calendar calendar) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("isSuccess", TRUE);
        resultMap.put("errorMsg", "");
        resultMap.put("date", calendar.getTime());
        resultMap.put("dateType", result.get("dateType"));
        resultMap.put("workRangeList", Optional.ofNullable(result.get("workRangeList")).orElseGet(ArrayList::new));
        return resultMap;
    }

    public Map<String, Object> calculateDateByStartAndEndDate(Long workingPlanId, Date startDate, Date endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (workingPlanId == null || workingPlanId <= 0L || startDate == null || endDate == null) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u7684\u53c2\u6570", (String)"CalendarServiceImpl_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        GregorianCalendar endCal = new GregorianCalendar();
        calendar.setTime(startDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        endCal.setTime(endDate);
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        endCal.set(14, 0);
        if (!endCal.getTime().after(calendar.getTime())) {
            resultMap.put("isSuccess", FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"CalendarServiceImpl_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        int workingDayInterval = 0;
        int calendarDayInterval = 0;
        calendar.add(5, -1);
        while (true) {
            boolean isWorkingDay;
            calendar.add(5, 1);
            if (WorkingPlanUtils.isInSameDay((Calendar)calendar, endDate)) break;
            Map<String, Object> result = WorkingPlanUtils.applyWorkingPlan(workingPlanId, (Calendar)calendar);
            if (!((Boolean)result.get("valid")).booleanValue()) {
                resultMap.put("isSuccess", FALSE);
                resultMap.put("errorMsg", result.get("errorMsg"));
                return resultMap;
            }
            int dateType = (Integer)result.get("dateType");
            boolean bl = isWorkingDay = dateType == 1 || dateType == 2 || dateType == 4 && (Boolean)result.get("holidaytype") != false && (Boolean)result.get("halfDayInWorkDay") != false;
            if (isWorkingDay) {
                ++workingDayInterval;
            }
            ++calendarDayInterval;
        }
        resultMap.put("isSuccess", TRUE);
        resultMap.put("errorMsg", "");
        resultMap.put("workingDayInterval", workingDayInterval);
        resultMap.put("calendarDayInterval", calendarDayInterval);
        return resultMap;
    }

    public Map<String, Object> getPublicHoliday(Collection<Object> countryIds, Date startDate, Date endDate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (startDate == null || endDate == null) {
            resultMap.put("isSuccess", Boolean.FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65e0\u6548\u7684\u53c2\u6570", (String)"CalendarServiceImpl_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        if (startDate.after(endDate)) {
            resultMap.put("isSuccess", Boolean.FALSE);
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"CalendarServiceImpl_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return resultMap;
        }
        Map<String, Object> publicHoliday = PublicHolidayUtils.getPublicHoliday(countryIds, startDate, endDate);
        resultMap.put("isSuccess", Boolean.TRUE);
        resultMap.put("data", publicHoliday);
        return resultMap;
    }
}

