/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.i18n.api.IExchangeRateService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.ExchangeRateService;
import kd.bos.util.CollectionUtils;

public class ExchangeRateServiceImpl
implements IExchangeRateService {
    public static final String EXCTABLE = "exctable";
    public static final String EXRATETABLE = "exratetable";
    public static final String ORGCUR = "orgcur";
    public static final String TARGETCUR = "targetcur";
    public static final String CUR = "cur";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String OVERRIDE = "override";
    public static final String EXCVAL = "excval";
    public static final String EFFECTDATE = "effectdate";
    public static final String EXPIRYDATE = "expirydate";
    public static final String BD_EXRATE_TREE = "bd_exrate_tree";
    public static final String BD_EXRATE_CONF_CROSS = "bd_exrate_cross";
    public static final String ENTRYENTITY = "bd_exrate_crossentry";
    public static final String DELIMITER = "_";
    public static final String ENABLE = "enable";
    public static final String DATASOURCE = "datasource";
    public static final String DESCRIPTION = "computationrules";
    public static final String DESCRIPTION_DELIMITER_ONE = "/";
    public static final String DESCRIPTION_DELIMITER_TWO = ",";
    public static final String FX_002 = "FX_002";
    public static final String ONE = "1";
    public static final Long PK = 1615103559727292416L;
    public static final String YYYY_MM_DD = "yyyy-MM-dd";

    public List<Map<String, Object>> getCrossRate(List<Map<String, Object>> exchangeRateList) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)PK, (String)BD_EXRATE_CONF_CROSS);
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        if (collection.isEmpty() || CollectionUtils.isEmpty(exchangeRateList)) {
            return new ArrayList<Map<String, Object>>();
        }
        HashSet<Long> tableIds = new HashSet<Long>();
        HashSet<Long> curIds = new HashSet<Long>();
        HashSet<Long> baseCurIds = new HashSet<Long>();
        HashMap<String, List<String>> keyMap = new HashMap<String, List<String>>();
        HashMap<Long, String> curNumber = new HashMap<Long, String>();
        for (DynamicObject config : collection) {
            DynamicObject configExctable = config.getDynamicObject(EXRATETABLE);
            DynamicObject configOrgcur = config.getDynamicObject(ORGCUR);
            DynamicObject configCur = config.getDynamicObject(TARGETCUR);
            DynamicObject baseCur = configExctable.getDynamicObject(CUR);
            if (configOrgcur.getString(ID).equals(configCur.getString(ID)) || baseCur.getString(ID).equals(configCur.getString(ID)) || baseCur.getString(ID).equals(configOrgcur.getString(ID))) continue;
            curIds.add(configCur.getLong(ID));
            curIds.add(configOrgcur.getLong(ID));
            tableIds.add(configExctable.getLong(ID));
            baseCurIds.add(baseCur.getLong(ID));
            String key = configExctable.getString(ID) + DELIMITER + configOrgcur.getString(ID) + DELIMITER + configCur.getString(ID) + DELIMITER + baseCur.getString(ID);
            String key2 = configExctable.getString(ID) + DELIMITER + baseCur.getString(ID) + DELIMITER + configOrgcur.getString(ID);
            String key4 = configExctable.getString(ID) + DELIMITER + baseCur.getString(ID) + DELIMITER + configCur.getString(ID);
            String key1 = configExctable.getString(ID) + DELIMITER + configOrgcur.getString(ID) + DELIMITER + baseCur.getString(ID);
            String key3 = configExctable.getString(ID) + DELIMITER + configCur.getString(ID) + DELIMITER + baseCur.getString(ID);
            ArrayList<String> list = new ArrayList<String>();
            list.add(key1);
            list.add(key2);
            list.add(key3);
            list.add(key4);
            keyMap.put(key, list);
            curNumber.put(configOrgcur.getLong(ID), configOrgcur.getString(NUMBER));
            curNumber.put(configCur.getLong(ID), configCur.getString(NUMBER));
            curNumber.put(baseCur.getLong(ID), baseCur.getString(NUMBER));
        }
        Map<String, List<Object>> map = this.findMap(exchangeRateList);
        if (map.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        Map<String, List<Object>> dyMap = this.findDyMap(tableIds, curIds, baseCurIds);
        return this.findResult(keyMap, curNumber, dyMap, map);
    }

    private Map<String, List<Object>> findMap(List<Map<String, Object>> exchangeRateList) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        exchangeRateList.forEach(l -> {
            Object exctable = l.get(EXCTABLE);
            Object orgcur = l.get(ORGCUR);
            Object cur = l.get(CUR);
            Object excval = l.get(EXCVAL);
            Object effectdate = l.get(EFFECTDATE);
            if (exctable != null && orgcur != null && cur != null && excval != null && effectdate != null) {
                String key = exctable + DELIMITER + orgcur + DELIMITER + cur;
                ArrayList<Map> list = new ArrayList<Map>();
                list.add((Map)l);
                map.merge(key, list, (oldValue, newValue) -> {
                    oldValue.add(l);
                    return oldValue;
                });
            }
        });
        return map;
    }

    private Map<String, List<Object>> findDyMap(Set<Long> tableIds, Set<Long> curIds, Set<Long> baseCurIds) {
        HashMap<String, List<Object>> dbMap = new HashMap<String, List<Object>>();
        QFilter qFilter = new QFilter(ENABLE, "=", (Object)ONE).and(EXCTABLE, "in", tableIds).and(DATASOURCE, "!=", (Object)FX_002).and(new QFilter(ORGCUR, "in", curIds).and(CUR, "in", baseCurIds).or(new QFilter(ORGCUR, "in", baseCurIds).and(CUR, "in", curIds)));
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)BD_EXRATE_TREE, (QFilter[])qFilter.toArray());
        dynamicObjectMap.values().forEach(dy -> {
            DynamicObject exctable = dy.getDynamicObject(EXCTABLE);
            DynamicObject orgcur = dy.getDynamicObject(ORGCUR);
            DynamicObject cur = dy.getDynamicObject(CUR);
            String key = exctable.getString(ID) + DELIMITER + orgcur.getString(ID) + DELIMITER + cur.getString(ID);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            list.add((DynamicObject)dy);
            dbMap.merge(key, list, (oldValue, newValue) -> {
                oldValue.add(dy);
                return oldValue;
            });
        });
        return dbMap;
    }

    private List<Map<String, Object>> findResult(Map<String, List<String>> keyMap, Map<Long, String> curNumber, Map<String, List<Object>> dbMap, Map<String, List<Object>> map) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        keyMap.forEach((k, v) -> {
            List var1 = (List)map.get(v.get(0));
            List var2 = (List)map.get(v.get(1));
            List var3 = (List)map.get(v.get(2));
            List var4 = (List)map.get(v.get(3));
            List dbVar1 = (List)dbMap.get(v.get(0));
            List dbVar2 = (List)dbMap.get(v.get(1));
            List dbVar3 = (List)dbMap.get(v.get(2));
            List dbVar4 = (List)dbMap.get(v.get(3));
            if (var1 != null || var2 != null || var3 != null || var4 != null) {
                Long currency2;
                HashMap<String, Map<String, Object>> dateMap = new HashMap<String, Map<String, Object>>();
                String[] keys = k.split(DELIMITER);
                Long currency1 = Long.valueOf(keys[1]);
                BigDecimal exRatePrecision = ExchangeRateService.getExRatePrecision((Long)currency1, (Long)(currency2 = Long.valueOf(keys[2])));
                int scale = exRatePrecision != null ? exRatePrecision.intValue() : 10;
                BiFunction<BigDecimal, BigDecimal, BigDecimal> function1 = (v1, v2) -> v1.divide((BigDecimal)v2, scale, 4);
                this.calculate(var1, var3, function1, dateMap, curNumber);
                this.calculate(var1, dbVar3, function1, dateMap, curNumber);
                this.calculate(dbVar1, var3, function1, dateMap, curNumber);
                HashSet<String> dbSet = new HashSet<String>(this.calculate(dbVar1, dbVar3, function1, dateMap, curNumber));
                BiFunction<BigDecimal, BigDecimal, BigDecimal> function2 = (v1, v2) -> v1.multiply((BigDecimal)v2).setScale(scale, 4);
                this.calculate(var1, var4, function2, dateMap, curNumber);
                this.calculate(var1, dbVar4, function2, dateMap, curNumber);
                this.calculate(dbVar1, var4, function2, dateMap, curNumber);
                dbSet.addAll(this.calculate(dbVar1, dbVar4, function2, dateMap, curNumber));
                BiFunction<BigDecimal, BigDecimal, BigDecimal> function3 = (v1, v2) -> BigDecimal.ONE.divide(v1.multiply((BigDecimal)v2), scale, 4);
                this.calculate(var2, var3, function3, dateMap, curNumber);
                this.calculate(var2, dbVar3, function3, dateMap, curNumber);
                this.calculate(dbVar2, var3, function3, dateMap, curNumber);
                dbSet.addAll(this.calculate(dbVar2, dbVar3, function3, dateMap, curNumber));
                this.calculate(var4, var2, function1, dateMap, curNumber);
                this.calculate(var4, dbVar2, function1, dateMap, curNumber);
                this.calculate(dbVar4, var2, function1, dateMap, curNumber);
                dbSet.addAll(this.calculate(dbVar4, dbVar2, function1, dateMap, curNumber));
                dateMap.forEach((k1, v1) -> {
                    if (!dbSet.contains(k1)) {
                        v1.put(EXCTABLE, Long.valueOf(keys[0]));
                        v1.put(ORGCUR, currency1);
                        v1.put(CUR, currency2);
                        result.add((Map<String, Object>)v1);
                    }
                });
            }
        });
        return result;
    }

    private Set<String> calculate(List<Object> key1, List<Object> key2, BiFunction<BigDecimal, BigDecimal, BigDecimal> function, Map<String, Map<String, Object>> result, Map<Long, String> curNumber) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        HashSet<String> dateKeySet = new HashSet<String>();
        if (key1 != null && key2 != null) {
            String dateKey;
            for (Object o1 : key1) {
                dateKey = this.getDateKey(o1);
                if (dateKey == null) continue;
                dateMap.put(dateKey, o1);
            }
            for (Object o2 : key2) {
                Object o1;
                dateKey = this.getDateKey(o2);
                if (dateKey == null || (o1 = dateMap.get(dateKey)) == null) continue;
                Object v1 = BigDecimal.ONE;
                Object v2 = BigDecimal.ONE;
                Object effectdate = null;
                Object expirydate = null;
                Object cur1 = 0L;
                Object cur2 = 0L;
                Object cur3 = 0L;
                Object cur4 = 0L;
                if (o1 instanceof HashMap) {
                    v1 = ((Map)o1).get(EXCVAL);
                    effectdate = ((Map)o1).get(EFFECTDATE);
                    expirydate = ((Map)o1).get(EXPIRYDATE);
                    cur1 = ((Map)o1).get(ORGCUR);
                    cur2 = ((Map)o1).get(CUR);
                }
                if (o1 instanceof DynamicObject) {
                    v1 = ((DynamicObject)o1).get(EXCVAL);
                    effectdate = ((DynamicObject)o1).get(EFFECTDATE);
                    expirydate = ((DynamicObject)o1).get(EXPIRYDATE);
                    cur1 = ((DynamicObject)o1).getDynamicObject(ORGCUR).getString(ID);
                    cur2 = ((DynamicObject)o1).getDynamicObject(CUR).getString(ID);
                }
                if (o2 instanceof HashMap) {
                    v2 = ((Map)o2).get(EXCVAL);
                    cur3 = ((Map)o2).get(ORGCUR);
                    cur4 = ((Map)o2).get(CUR);
                }
                if (o2 instanceof DynamicObject) {
                    v2 = ((DynamicObject)o2).get(EXCVAL);
                    cur3 = ((DynamicObject)o2).getDynamicObject(ORGCUR).getString(ID);
                    cur4 = ((DynamicObject)o2).getDynamicObject(CUR).getString(ID);
                }
                if (v1 == null || v2 == null || cur1 == null || cur2 == null || cur3 == null || cur4 == null) continue;
                BigDecimal apply = function.apply(new BigDecimal(v1.toString()), new BigDecimal(v2.toString()));
                HashMap<String, String> newMap = new HashMap<String, String>();
                newMap.put(EFFECTDATE, this.dateFormat(effectdate));
                newMap.put(EXPIRYDATE, this.dateFormat(expirydate));
                newMap.put(EXCVAL, apply.toString());
                String s1 = curNumber.get(Long.valueOf(cur1.toString()));
                String s2 = curNumber.get(Long.valueOf(cur2.toString()));
                String s3 = curNumber.get(Long.valueOf(cur3.toString()));
                String s4 = curNumber.get(Long.valueOf(cur4.toString()));
                String des = s1 + DESCRIPTION_DELIMITER_ONE + s2 + DESCRIPTION_DELIMITER_TWO + s3 + DESCRIPTION_DELIMITER_ONE + s4;
                newMap.put(DESCRIPTION, des);
                Map<String, Object> o = result.get(dateKey);
                if (o != null) continue;
                result.put(dateKey, newMap);
                dateKeySet.add(dateKey);
            }
        }
        return dateKeySet;
    }

    private String dateFormat(Object date) {
        try {
            if (date == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
            if (date instanceof String) {
                date = sdf.parse((String)date);
            }
            return sdf.format((Date)date);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getDateKey(Object o) {
        String dateA;
        Date effectdate = null;
        Date expirydate = null;
        if (o instanceof HashMap) {
            effectdate = (Date)((Map)o).get(EFFECTDATE);
            expirydate = (Date)((Map)o).get(EXPIRYDATE);
        }
        if (o instanceof DynamicObject) {
            effectdate = ((DynamicObject)o).getDate(EFFECTDATE);
            expirydate = ((DynamicObject)o).getDate(EXPIRYDATE);
        }
        if ((dateA = this.dateFormat(effectdate)) == null) {
            return null;
        }
        String dateB = this.dateFormat(expirydate);
        if (dateB == null) {
            dateB = "";
        }
        return dateA + DELIMITER + dateB;
    }
}

