/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.i18n.api.IIdNumberCheckExtPlugin;
import kd.bos.i18n.api.IIdentityService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class IdentityServiceImpl
implements IIdentityService {
    private static final String PROJECT_NUMBER = "bos-mservice-i18n";
    private static final String PERSONAL_IDENTITY_ENTITY = "cts_personal_identity";
    private static final String IS_SUCCESS = "isSuccess";
    private static final String MSG = "msg";

    public Map<String, Object> validIdentityCardNo(Long countryId, String number, String identityNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(IS_SUCCESS, Boolean.FALSE);
        if (countryId == null && StringUtils.isBlank((CharSequence)number) || StringUtils.isBlank((CharSequence)identityNo)) {
            resultMap.put(MSG, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a\u548c\u8bc1\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u4e14\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6709\u6548\u7684\u53c2\u6570\u3002", (String)"IdentityServiceImpl_0", (String)PROJECT_NUMBER, (Object[])new Object[0]));
            return resultMap;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (countryId != null) {
            qFilter.and("group", "=", (Object)countryId);
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            qFilter.and("number", "=", (Object)number);
        }
        Collection identities = BusinessDataServiceHelper.loadFromCache((String)PERSONAL_IDENTITY_ENTITY, (String)"entryentity.regularexpression,entryentity.serialno,entryentity.displayformat", (QFilter[])qFilter.toArray()).values();
        Boolean isExpressionEmpty = null;
        ArrayList<String> numberList = new ArrayList<String>(16);
        ArrayList<String> formatList = new ArrayList<String>(16);
        StringBuffer buffer = new StringBuffer();
        if (identities.isEmpty()) {
            isExpressionEmpty = Boolean.TRUE;
        } else {
            for (DynamicObject identity : identities) {
                number = identity.getString("number");
                DynamicObjectCollection collection = identity.getDynamicObjectCollection("entryentity");
                if (collection == null || collection.isEmpty()) {
                    isExpressionEmpty = isExpressionEmpty == null;
                    continue;
                }
                isExpressionEmpty = Boolean.FALSE;
                for (DynamicObject dynamicObject : collection) {
                    numberList.add(dynamicObject.getString("serialno"));
                    formatList.add(dynamicObject.getString("displayformat"));
                    Pattern pattern = Pattern.compile(dynamicObject.get("regularexpression").toString());
                    boolean res = pattern.matcher(identityNo).matches();
                    if (!res) continue;
                    resultMap.put(IS_SUCCESS, Boolean.TRUE);
                    resultMap.put(MSG, ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6821\u9a8c\u6210\u529f\u3002", (String)"IdentityServiceImpl_1", (String)PROJECT_NUMBER, (Object[])new Object[0]));
                    String ext = this.checkIdNumberExt(number, identityNo);
                    if (StringUtils.isNotBlank((CharSequence)ext)) {
                        resultMap.put(MSG, ext);
                        resultMap.put(IS_SUCCESS, Boolean.FALSE);
                    }
                    return resultMap;
                }
            }
        }
        for (int i = 0; i < numberList.size(); ++i) {
            buffer.append((String)numberList.get(i)).append('\uff1a').append((String)formatList.get(i));
            if (formatList.size() != 1 && i != formatList.size() - 1) {
                buffer.append(ResManager.loadKDString((String)"\u6216\u8005", (String)"TaxNumberServiceImpl_3", (String)PROJECT_NUMBER, (Object[])new Object[0]));
            }
            if (i != formatList.size() - 1) continue;
            buffer.append(ResManager.loadKDString((String)"\u683c\u5f0f\u89c4\u5219", (String)"TaxNumberServiceImpl_4", (String)PROJECT_NUMBER, (Object[])new Object[0]));
        }
        if (isExpressionEmpty.booleanValue()) {
            resultMap.put(MSG, ResManager.loadKDString((String)"\u4e2a\u4eba\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u65e0\u6548\u3002", (String)"IdentityServiceImpl_2", (String)PROJECT_NUMBER, (Object[])new Object[0]));
        } else {
            resultMap.put(MSG, ResManager.loadKDString((String)"\u53f7\u7801\u683c\u5f0f\u4e0d\u7b26\u5408%s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxNumberServiceImpl_1", (String)PROJECT_NUMBER, (Object[])new Object[]{buffer}));
        }
        return resultMap;
    }

    public Map<String, Object> getIdentityNumber(Long countryId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(IS_SUCCESS, Boolean.FALSE);
        if (countryId == null || countryId <= 0L) {
            resultMap.put(MSG, ResManager.loadKDString((String)"\u65e0\u6548\u53c2\u6570", (String)"IdentityServiceImpl_4", (String)PROJECT_NUMBER, (Object[])new Object[0]));
            return resultMap;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')).and("group", "=", (Object)countryId);
        Collection identities = BusinessDataServiceHelper.loadFromCache((String)PERSONAL_IDENTITY_ENTITY, (String)"number,name", (QFilter[])qFilter.toArray()).values();
        resultMap.put(IS_SUCCESS, Boolean.TRUE);
        resultMap.put("data", identities);
        return resultMap;
    }

    private String checkIdNumberExt(String number, String idNumber) {
        PluginProxy pluginProxy = PluginProxy.create(IIdNumberCheckExtPlugin.class, (String)"BOS_I18N_ID_NUMBER_CHECK");
        List strings = pluginProxy.callReplace(p -> p.checkIdNumber(number, idNumber));
        return strings.stream().filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }
}

