/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.i18n.api.ITaxNumberService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class TaxNumberServiceImpl
implements ITaxNumberService {
    private static final String CTS_TAX_NUMBER_FORMAT = "cts_tax_number_format";
    private static final String CN_TAX_NUMBER = "CN01";
    private static final String NUMBER = "number";
    private static final String GROUP = "group.number";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String REGULAR_EXPRESSION = "regularexpression";
    private static final String DISPLAY_FORMAT = "displayformat";
    private static final List<Integer> weightFactor;
    private static final Map<Character, Integer> valueMap;
    private static final String BOS_MSERVICE_I18N = "bos-mservice-i18n";

    public Map<String, String> VerifyTaxNumber(String number, String taxNumber) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("isSuccess", "false");
        try {
            if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)taxNumber)) {
                result.put("errorMsg", ResManager.loadKDString((String)"\u7f16\u7801\u548c\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxNumberServiceImpl_0", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
                return result;
            }
            QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)CTS_TAX_NUMBER_FORMAT, (String)"number, group, entryentity.regularexpression, entryentity.displayformat", (QFilter[])qFilter.toArray());
            if (dynamicObjects.length == 0) {
                qFilter = new QFilter(GROUP, "=", (Object)number);
                dynamicObjects = BusinessDataServiceHelper.load((String)CTS_TAX_NUMBER_FORMAT, (String)"number, group, entryentity.regularexpression, entryentity.displayformat", (QFilter[])qFilter.toArray());
            }
            ArrayList<String> formatList = new ArrayList<String>();
            StringBuffer buffer = new StringBuffer();
            if (dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                    number = dynamicObject.getString(NUMBER);
                    if (!entryEntity.isEmpty()) {
                        for (DynamicObject object : entryEntity) {
                            String regex = object.getString(REGULAR_EXPRESSION);
                            formatList.add(object.getString(DISPLAY_FORMAT));
                            if (CN_TAX_NUMBER.equals(number)) {
                                if (!taxNumber.matches(regex) || !this.isConformCheckCodeRule(taxNumber)) continue;
                                result.put("isSuccess", "true");
                                return result;
                            }
                            if (!taxNumber.matches(regex)) continue;
                            result.put("isSuccess", "true");
                            return result;
                        }
                        for (int i = 0; i < formatList.size(); ++i) {
                            buffer.append(number).append("-0").append(i + 1).append('\uff1a').append((String)formatList.get(i));
                            if (formatList.size() != 1 && i != formatList.size() - 1) {
                                buffer.append(ResManager.loadKDString((String)"\u6216\u8005", (String)"TaxNumberServiceImpl_3", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
                            }
                            if (i != formatList.size() - 1) continue;
                            buffer.append(ResManager.loadKDString((String)"\u683c\u5f0f\u89c4\u5219", (String)"TaxNumberServiceImpl_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
                        }
                        continue;
                    }
                    result.put("isSuccess", "true");
                    return result;
                }
            } else {
                result.put("isSuccess", "true");
                return result;
            }
            result.put("errorMsg", ResManager.loadKDString((String)"\u53f7\u7801\u683c\u5f0f\u4e0d\u7b26\u5408%s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxNumberServiceImpl_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[]{buffer}));
            return result;
        }
        catch (Exception e) {
            result.put("errorMsg", ResManager.loadKDString((String)"\u7a0e\u53f7\u9a8c\u8bc1\u5f02\u5e38\u3002", (String)"TaxNumberServiceImpl_2", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
            return result;
        }
    }

    private boolean isConformCheckCodeRule(String taxNumber) {
        char[] chars = taxNumber.toCharArray();
        int sum = 0;
        for (int i = 0; i < chars.length - 1; ++i) {
            Integer value = valueMap.get(Character.valueOf(chars[i]));
            if (value == null) {
                return false;
            }
            int factor = weightFactor.get(i);
            sum += value * factor;
        }
        return valueMap.get(Character.valueOf(chars[chars.length - 1])) == 31 - sum % 31;
    }

    static {
        valueMap = new HashMap<Character, Integer>(31);
        weightFactor = Arrays.asList(1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28);
        valueMap.put(Character.valueOf('0'), 0);
        valueMap.put(Character.valueOf('1'), 1);
        valueMap.put(Character.valueOf('2'), 2);
        valueMap.put(Character.valueOf('3'), 3);
        valueMap.put(Character.valueOf('4'), 4);
        valueMap.put(Character.valueOf('5'), 5);
        valueMap.put(Character.valueOf('6'), 6);
        valueMap.put(Character.valueOf('7'), 7);
        valueMap.put(Character.valueOf('8'), 8);
        valueMap.put(Character.valueOf('9'), 9);
        valueMap.put(Character.valueOf('A'), 10);
        valueMap.put(Character.valueOf('B'), 11);
        valueMap.put(Character.valueOf('C'), 12);
        valueMap.put(Character.valueOf('D'), 13);
        valueMap.put(Character.valueOf('E'), 14);
        valueMap.put(Character.valueOf('F'), 15);
        valueMap.put(Character.valueOf('G'), 16);
        valueMap.put(Character.valueOf('H'), 17);
        valueMap.put(Character.valueOf('J'), 18);
        valueMap.put(Character.valueOf('K'), 19);
        valueMap.put(Character.valueOf('L'), 20);
        valueMap.put(Character.valueOf('M'), 21);
        valueMap.put(Character.valueOf('N'), 22);
        valueMap.put(Character.valueOf('P'), 23);
        valueMap.put(Character.valueOf('Q'), 24);
        valueMap.put(Character.valueOf('R'), 25);
        valueMap.put(Character.valueOf('T'), 26);
        valueMap.put(Character.valueOf('U'), 27);
        valueMap.put(Character.valueOf('W'), 28);
        valueMap.put(Character.valueOf('X'), 29);
        valueMap.put(Character.valueOf('Y'), 30);
    }
}

