/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.api.telephone.TelephoneService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TelephoneServiceImpl
implements TelephoneService {
    private static final String CODE_LABEL = "code";
    private static final String MSG_LABEL = "message";
    private static final String SYSTEM_ID = "bos-mservice-i18n";
    private static final String CTS_TELEPHONE_FORMAT = "cts_telephoneformat";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final long SYSTEM_SET_ID = 1087691293334756353L;
    private static final String CONTAINS_NON_NUMERIC = "\\D+\\d+|\\d+\\D+|\\D+|\\d+\\D+\\d+|\\D+\\d+\\D+";
    private static final String ALL_NUMERIC = "\\d+";
    private static final String IS_CHECK = "ischeck";
    private static final String NUMBER = "number";
    private static final String COUNTRYID = "countryid";
    private static final String BD_COUNTRY = "bd_country";
    private static final String AREACODE = "areacode";
    private static final String SEGMENT = "segment";
    private static final String DIGIT = "digit";

    public Map<String, String> verifyTelephoneNumberFormat(String telephoneNumber, String ... countryNumbers) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        for (String countryNumber : countryNumbers) {
            Map<String, String> aResultWithCountryNumber = this.verifyItems(countryNumber, telephoneNumber);
            if (StringUtils.equals((CharSequence)aResultWithCountryNumber.get(CODE_LABEL), (CharSequence)Boolean.TRUE.toString())) {
                return aResultWithCountryNumber;
            }
            list.add(aResultWithCountryNumber);
        }
        return list.stream().findFirst().orElse(null);
    }

    public List<Map<String, String>> batchVerifyTelephoneNumberFormat(List<Map<String, Object>> telephoneNumberVerifyList) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        for (Map<String, Object> telephoneNumberVerifyMap : telephoneNumberVerifyList) {
            String telephoneNumber = (String)telephoneNumberVerifyMap.get("telephoneNumber");
            List countryNumberList = (List)telephoneNumberVerifyMap.get("countryNumberList");
            resultList.add(this.verifyTelephoneNumberFormat(telephoneNumber, countryNumberList.toArray(new String[0])));
        }
        return resultList;
    }

    private Map<String, String> verifyItems(String countryNumber, String telephoneNumber) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CODE_LABEL, Boolean.FALSE.toString());
        if (StringUtils.isEmpty((CharSequence)countryNumber) || !this.isCountryExist(countryNumber)) {
            result.put(MSG_LABEL, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"TelephoneServiceImpl_0", (String)SYSTEM_ID, (Object[])new Object[0]));
            return result;
        }
        if (StringUtils.isEmpty((CharSequence)telephoneNumber)) {
            result.put(MSG_LABEL, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"TelephoneServiceImpl_6", (String)SYSTEM_ID, (Object[])new Object[0]));
            return result;
        }
        if (this.isCountryAreaCodeNotBeMaintained(countryNumber)) {
            result.put(MSG_LABEL, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a\u672a\u7ef4\u62a4\u533a\u53f7\u3002", (String)"TelephoneServiceImpl_2", (String)SYSTEM_ID, (Object[])new Object[0]));
            return result;
        }
        if (this.isContainsNonNumberChar(telephoneNumber)) {
            result.put(MSG_LABEL, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u5e94\u4e3a\u6570\u5b57\uff0c\u8bf7\u4fee\u6539\u975e\u6570\u5b57\u5b57\u7b26\u3002", (String)"TelephoneServiceImpl_1", (String)SYSTEM_ID, (Object[])new Object[0]));
            return result;
        }
        Map<String, Object> map = this.isNumberOfDigitsNotMatched(countryNumber, telephoneNumber);
        if (((Boolean)map.get("isFlag")).booleanValue()) {
            result.put(MSG_LABEL, String.format(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u4f4d\u6570\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TelephoneServiceImpl_4", (String)SYSTEM_ID, (Object[])new Object[0]), map.get(DIGIT)));
            return result;
        }
        if (this.isStartedNumberSegmentNotMatched(countryNumber, telephoneNumber)) {
            result.put(MSG_LABEL, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u7684\u8d77\u59cb\u53f7\u6bb5\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002\u8d77\u59cb\u53f7\u6bb5\u89c4\u5219\u8bf7\u5728\u201c\u56fd\u9645\u5316\u914d\u7f6e\u201d-\u201c\u624b\u673a\u53f7\u7801\u683c\u5f0f\u201d\u4e2d\u67e5\u770b\u3002", (String)"TelephoneServiceImpl_3", (String)SYSTEM_ID, (Object[])new Object[0]));
            return result;
        }
        result.put(CODE_LABEL, Boolean.TRUE.toString());
        result.put(MSG_LABEL, ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"TelephoneServiceImpl_5", (String)SYSTEM_ID, (Object[])new Object[0]));
        return result;
    }

    private boolean isContainsNonNumberChar(String telephoneNumber) {
        return !Pattern.matches(ALL_NUMERIC, telephoneNumber);
    }

    private boolean isCountryExist(String countryNumber) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)countryNumber);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)BD_COUNTRY, (String)AREACODE, (QFilter[])filter.toArray());
        return map.size() > 0;
    }

    private boolean isCountryAreaCodeNotBeMaintained(String countryNumber) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)countryNumber);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)BD_COUNTRY, (String)AREACODE, (QFilter[])filter.toArray());
        boolean allMatchElementIsEmpty = map.values().stream().map(item -> item.getString(AREACODE)).allMatch(StringUtils::isEmpty);
        return allMatchElementIsEmpty;
    }

    private boolean isStartedNumberSegmentNotMatched(String countryNumber, String telephoneNumber) {
        AtomicBoolean result = new AtomicBoolean(false);
        DynamicObject telephoneFormat = BusinessDataServiceHelper.loadSingleFromCache((Object)1087691293334756353L, (String)CTS_TELEPHONE_FORMAT, (String)"entryentity.ischeck,entryentity.segment,entryentity.countryid");
        DynamicObjectCollection dynamicObjectCollection = telephoneFormat.getDynamicObjectCollection(ENTRY_ENTITY);
        dynamicObjectCollection.forEach(item -> {
            String segment;
            Set<int[]> multiSegments;
            DynamicObject country = item.getDynamicObject(COUNTRYID);
            if (country != null && StringUtils.equals((CharSequence)country.getString(NUMBER), (CharSequence)countryNumber) && item.getInt(IS_CHECK) == 1 && (multiSegments = this.getMultiSegments(segment = item.getString(SEGMENT))) != null) {
                boolean noneMatch = multiSegments.stream().noneMatch(segments -> this.isMatchSegment((int[])segments, String.valueOf(segments[0]).length(), telephoneNumber));
                result.set(noneMatch);
            }
        });
        return result.get();
    }

    private boolean isMatchSegment(int[] segments, int segNums, String telephoneNumber) {
        int first = segments[0];
        int second = segments.length == 1 ? segments[0] : segments[1];
        int startNumber = Integer.parseInt(telephoneNumber.substring(0, segNums));
        return startNumber >= first && startNumber <= second;
    }

    private Set<int[]> getMultiSegments(String segment) {
        if (StringUtils.isNotEmpty((CharSequence)segment)) {
            String[] multiSegment = segment.split(",");
            return Arrays.stream(multiSegment).map(item -> item.split("-")).map(inner -> {
                int[] segments = new int[2];
                for (int i = 0; i < ((String[])inner).length; ++i) {
                    segments[i] = Integer.parseInt(inner[i]);
                }
                if (((String[])inner).length == 1) {
                    segments[1] = Integer.parseInt(inner[0]);
                }
                return segments;
            }).collect(Collectors.toSet());
        }
        return null;
    }

    private Map<String, Object> isNumberOfDigitsNotMatched(String countryNumber, String telephoneNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AtomicBoolean result = new AtomicBoolean(false);
        DynamicObject telephoneFormat = BusinessDataServiceHelper.loadSingleFromCache((Object)1087691293334756353L, (String)CTS_TELEPHONE_FORMAT, (String)"entryentity.ischeck,entryentity.digit,entryentity.countryid");
        DynamicObjectCollection dynamicObjectCollection = telephoneFormat.getDynamicObjectCollection(ENTRY_ENTITY);
        dynamicObjectCollection.forEach(item -> {
            DynamicObject country = item.getDynamicObject(COUNTRYID);
            if (country != null && StringUtils.equals((CharSequence)country.getString(NUMBER), (CharSequence)countryNumber) && item.getInt(IS_CHECK) == 1) {
                String[] digitArr = item.getString(DIGIT).split(",");
                boolean anyMatch = Arrays.stream(digitArr).anyMatch(digit -> Integer.parseInt(digit) == telephoneNumber.trim().length());
                result.set(!anyMatch);
                map.put(DIGIT, item.getString(DIGIT));
            }
        });
        map.put("isFlag", result.get());
        return map;
    }

    public TelephoneParseResult parseTelephone(String telephone) {
        List<Map<String, Object>> countryAreaCodeMap = this.getCountryAndAreaCode();
        return this.parseTelephone(telephone, countryAreaCodeMap);
    }

    public List<TelephoneParseResult> batchParseTelephone(List<String> telephoneList) {
        List<Map<String, Object>> countryAreaCodeMap = this.getCountryAndAreaCode();
        ArrayList<TelephoneParseResult> resultList = new ArrayList<TelephoneParseResult>(10);
        for (String telephone : telephoneList) {
            resultList.add(this.parseTelephone(telephone, countryAreaCodeMap));
        }
        return resultList;
    }

    public List<TelephoneVerifyResult> batchVerifyTelephoneNumber(List<String> telephoneNumberVerifyList) {
        ArrayList<TelephoneVerifyResult> resultList = new ArrayList<TelephoneVerifyResult>();
        List<Map<String, Object>> countryAreaCodeMap = this.getCountryAndAreaCode();
        for (String telephoneNumber : telephoneNumberVerifyList) {
            TelephoneParseResult result = this.parseTelephone(telephoneNumber, countryAreaCodeMap);
            if (result.isSuccess()) {
                Map<String, String> verifyMap;
                String[] countryArray = result.getCountryList().toArray(new String[0]);
                if (countryArray.length == 0) {
                    resultList.add(new TelephoneVerifyResult(false, false, String.format(ResManager.loadKDString((String)"\u672a\u5728\u201c\u56fd\u5bb6\u548c\u5730\u533a\u201d\u57fa\u7840\u8d44\u6599\u4e2d\u627e\u5230\u533a\u53f7\u4e3a\u201c%s\u201d\u7684\u56fd\u5bb6\u6216\u5730\u533a,\u8bf7\u68c0\u67e5\u533a\u53f7\u8f93\u5165\u6216\u914d\u7f6e\u3002", (String)"TelephoneServiceImpl_9", (String)SYSTEM_ID, (Object[])new Object[0]), result.getAreaCode()), null));
                }
                if ((verifyMap = this.verifyTelephoneNumberFormat(result.getTelephone(), countryArray)) != null && StringUtils.equals((CharSequence)verifyMap.get(CODE_LABEL), (CharSequence)Boolean.TRUE.toString())) {
                    resultList.add(new TelephoneVerifyResult(true, true, "", verifyMap));
                    continue;
                }
                resultList.add(new TelephoneVerifyResult(true, false, "", verifyMap));
                continue;
            }
            resultList.add(new TelephoneVerifyResult(false, false, result.getErrorMsg(), null));
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TelephoneParseResult parseTelephone(String telephone, List<Map<String, Object>> countryAreaCodeMap) {
        if (telephone == null || StringUtils.isBlank((CharSequence)telephone)) {
            return new TelephoneParseResult(false, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"TelephoneServiceImpl_6", (String)SYSTEM_ID, (Object[])new Object[0]));
        }
        String areaCode = null;
        String telephoneStr = null;
        if (telephone.contains("-")) {
            String[] telephoneArray = telephone.split("-");
            if (telephoneArray.length <= 1) return new TelephoneParseResult(false, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165+\u533a\u53f7-\u624b\u673a\u53f7\u6216\u533a\u53f7-\u624b\u673a\u53f7\u3002", (String)"TelephoneServiceImpl_8", (String)SYSTEM_ID, (Object[])new Object[0]));
            areaCode = telephoneArray[0];
            telephoneStr = telephoneArray[1];
        } else if (telephone.startsWith("+86")) {
            areaCode = "+86";
            telephoneStr = telephone.substring(3);
        } else {
            if (!telephone.startsWith("86")) return new TelephoneParseResult(false, ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165+\u533a\u53f7-\u624b\u673a\u53f7\u6216\u533a\u53f7-\u624b\u673a\u53f7\u3002", (String)"TelephoneServiceImpl_8", (String)SYSTEM_ID, (Object[])new Object[0]));
            areaCode = "86";
            telephoneStr = telephone.substring(2);
        }
        List<String> countryList = this.parseTelephoneCountry(areaCode, telephoneStr, countryAreaCodeMap);
        return new TelephoneParseResult(telephoneStr, areaCode, countryList);
    }

    private List<String> parseTelephoneCountry(String areaCode, String telephone, List<Map<String, Object>> countryAreaCodeMap) {
        String areaCodeWithoutPlus = areaCode.replace("+", "");
        ArrayList<String> matchSegmentCountryList = new ArrayList<String>();
        ArrayList<String> matchAreaCodeCountryList = new ArrayList<String>();
        block0: for (Map<String, Object> countryCheck : countryAreaCodeMap) {
            String countryAreaCode = countryCheck.get(AREACODE) != null ? ((String)countryCheck.get(AREACODE)).replace("+", "") : null;
            if (!areaCodeWithoutPlus.equals(countryAreaCode)) continue;
            matchAreaCodeCountryList.add((String)countryCheck.get(NUMBER));
            HashSet segment = (HashSet)countryCheck.get(SEGMENT);
            if (segment == null || segment.size() <= 0) continue;
            for (String seg : segment) {
                if (!telephone.startsWith(seg)) continue;
                matchSegmentCountryList.add((String)countryCheck.get(NUMBER));
                continue block0;
            }
        }
        if (matchSegmentCountryList.size() != 0) {
            return matchSegmentCountryList;
        }
        return matchAreaCodeCountryList;
    }

    private List<Map<String, Object>> getCountryAndAreaCode() {
        HashMap rules = new HashMap(16);
        ArrayList<Map<String, Object>> countryList = new ArrayList<Map<String, Object>>(16);
        String sql = "select fcountryid, fdigit, fsegment, fischeck from t_cts_telephoneformat ";
        DB.query((DBRoute)DBRoute.base, (String)sql, null, rs -> {
            while (rs.next()) {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
                map.put(SEGMENT, TelephoneServiceImpl.splitSegment(rs.getString(3)));
                rules.put(rs.getString(1), map);
            }
            return rules;
        });
        Map countries = BusinessDataServiceHelper.loadFromCache((String)BD_COUNTRY, (String)"id,number,areacode", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        for (DynamicObject country : countries.values()) {
            String areaCode = country.getString(AREACODE);
            if (null == areaCode || "".equals(areaCode.trim())) continue;
            HashMap<String, String> countryMap = new HashMap<String, String>(16);
            countryMap.put(AREACODE, areaCode);
            countryMap.put(NUMBER, country.getString(NUMBER));
            Map map = (Map)rules.get(country.getString("id"));
            if (map != null && map.size() > 0) {
                countryMap.put(SEGMENT, (String)map.get(SEGMENT));
            }
            countryList.add(countryMap);
        }
        return countryList;
    }

    private static Set<String> splitSegment(String segment) {
        String[] split;
        HashSet<String> set = new HashSet<String>(16);
        for (String s : split = segment.split(",")) {
            if (s.contains("-")) {
                String[] strings = s.split("-");
                String s1 = strings[0];
                String s2 = strings[1];
                for (int i = Integer.parseInt(s1); i <= Integer.parseInt(s2); ++i) {
                    set.add(Integer.toString(i));
                }
                continue;
            }
            set.add(s);
        }
        return set;
    }
}

