/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.i18n.api.IWorkingPlanService;
import kd.bos.i18n.api.workingplan.SpecificDate;
import kd.bos.i18n.api.workingplan.WorkingPlan;
import kd.bos.i18n.api.workingplan.WorkingPlanHoliday;
import kd.bos.i18n.api.workingplan.WorkingTime;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class WorkingPlanServiceImpl
implements IWorkingPlanService {
    public OperationResult add(WorkingPlan workingPlan) {
        List specificDateList;
        List holidayList;
        List workingTimeList;
        if (workingPlan == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkingPlanServiceImpl_1", (String)"bos-mservice-i18n", (Object[])new Object[0]));
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date now = new Date();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"working_plan");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
        if (workingPlan.getHolidayList() == null) {
            workingPlan.setHolidayList(new ArrayList());
        }
        if (workingPlan.getSpecificDateList() == null) {
            workingPlan.setSpecificDateList(new ArrayList());
        }
        if (workingPlan.getOrgIdList() == null) {
            workingPlan.setOrgIdList(new ArrayList());
        }
        dynamicObject.set("number", (Object)workingPlan.getNumber());
        dynamicObject.set("name", (Object)workingPlan.getName());
        this.setOrgColl(workingPlan.getOrgIdList(), dynamicObject);
        dynamicObject.set("description", (Object)workingPlan.getDescription());
        dynamicObject.set("startdate", (Object)workingPlan.getStartDate());
        dynamicObject.set("enddate", (Object)workingPlan.getEndDate());
        dynamicObject.set("countryid", (Object)workingPlan.getCountryId());
        dynamicObject.set("enable", (Object)workingPlan.getEnable());
        dynamicObject.set("status", (Object)workingPlan.getStatus());
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("createtime", (Object)now);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        if ("0".equals(workingPlan.getEnable())) {
            dynamicObject.set("disabler", (Object)userId);
            dynamicObject.set("disabletime", (Object)now);
        }
        if ((workingTimeList = workingPlan.getWorkingTimeList()) != null && workingTimeList.size() > 0) {
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("cardentryentity");
            for (WorkingTime workingTime : workingTimeList) {
                DynamicObject holidayDy = coll.addNew();
                Long workingTimeId = workingTime.getWorkingTimeId();
                holidayDy.set("workingtime", workingTimeId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)workingTimeId, (String)"working_time"));
                holidayDy.set("validity_startdate", (Object)workingTime.getStartDate());
                holidayDy.set("validity_enddate", (Object)workingTime.getEndDate());
            }
        }
        if ((holidayList = workingPlan.getHolidayList()) != null && holidayList.size() > 0) {
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity2");
            for (WorkingPlanHoliday holiday : holidayList) {
                DynamicObject holidayDy = coll.addNew();
                Long holidayId = holiday.getHoliday();
                holidayDy.set("holiday1", holidayId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)holidayId, (String)"public_holiday"));
            }
        }
        if ((specificDateList = workingPlan.getSpecificDateList()) != null && specificDateList.size() > 0) {
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity1");
            for (SpecificDate specificDate : specificDateList) {
                DynamicObject specificDateDy = coll.addNew();
                specificDateDy.set("date1", (Object)specificDate.getDate());
                specificDateDy.set("enddate1", (Object)specificDate.getEndDate());
                specificDateDy.set("datetype1", (Object)specificDate.getDateType());
                Long hoursId = specificDate.getHours();
                specificDateDy.set("hours1", hoursId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)hoursId, (String)"working_hours"));
                specificDateDy.set("specialdesc", (Object)specificDate.getSpecialDesc());
            }
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("workingPlanType", "add");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            operateOption.setVariableValue("workingPlanStr", objectMapper.writeValueAsString((Object)workingPlan));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return OperationServiceHelper.executeOperate((String)"save", (String)"working_plan", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
    }

    public OperationResult update(WorkingPlan workingPlan) {
        List specificDateList;
        List holidayList;
        List workingTimeList;
        if (workingPlan.getId() == null || workingPlan.getId() <= 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8ba1\u5212\u4e0d\u5b58\u5728", (String)"WorkingPlanServiceImpl_0", (String)"bos-mservice-i18n", (Object[])new Object[0]));
        }
        if (!QueryServiceHelper.exists((String)"working_plan", (Object)workingPlan.getId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u8ba1\u5212\u4e0d\u5b58\u5728", (String)"WorkingPlanServiceImpl_0", (String)"bos-mservice-i18n", (Object[])new Object[0]));
        }
        if (workingPlan.getOrgIdList() == null) {
            workingPlan.setOrgIdList(new ArrayList());
        }
        if (workingPlan.getHolidayList() == null) {
            workingPlan.setHolidayList(new ArrayList());
        }
        if (workingPlan.getSpecificDateList() == null) {
            workingPlan.setSpecificDateList(new ArrayList());
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)workingPlan.getId(), (String)"working_plan");
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date now = new Date();
        String originalEnable = dynamicObject.getString("enable");
        dynamicObject.set("number", (Object)workingPlan.getNumber());
        dynamicObject.set("name", (Object)workingPlan.getName());
        this.setOrgColl(workingPlan.getOrgIdList(), dynamicObject);
        dynamicObject.set("description", (Object)workingPlan.getDescription());
        dynamicObject.set("startdate", (Object)workingPlan.getStartDate());
        dynamicObject.set("enddate", (Object)workingPlan.getEndDate());
        dynamicObject.set("countryid", (Object)workingPlan.getCountryId());
        dynamicObject.set("enable", (Object)workingPlan.getEnable());
        dynamicObject.set("status", (Object)workingPlan.getStatus());
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        if (!"0".equals(originalEnable) && "0".equals(workingPlan.getEnable())) {
            dynamicObject.set("disabler", (Object)userId);
            dynamicObject.set("disabletime", (Object)now);
        }
        if ((workingTimeList = workingPlan.getWorkingTimeList()) != null && workingTimeList.size() > 0) {
            Set workingTimeIds = workingTimeList.stream().map(WorkingTime::getWorkingTimeId).filter(Objects::nonNull).collect(Collectors.toSet());
            Set entryIdIds = workingTimeList.stream().map(WorkingTime::getEntryId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map timeMap = BusinessDataServiceHelper.loadFromCache((Object[])workingTimeIds.toArray(), (String)"working_time");
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("cardentryentity");
            Map<Long, DynamicObject> collect = coll.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            coll.removeIf(next -> !entryIdIds.contains(next.getLong("id")));
            for (int i = 0; i < workingTimeList.size(); ++i) {
                WorkingTime workingTime = (WorkingTime)workingTimeList.get(i);
                DynamicObject workingTimeDy = collect.get(workingTime.getEntryId());
                if (workingTimeDy == null) {
                    workingTimeDy = coll.addNew();
                }
                Long workingTimeId = workingTime.getWorkingTimeId();
                workingTimeDy.set("id", (Object)workingTime.getEntryId());
                workingTimeDy.set("workingtime", timeMap.get(workingTimeId));
                workingTimeDy.set("validity_startdate", (Object)workingTime.getStartDate());
                workingTimeDy.set("validity_enddate", (Object)workingTime.getEndDate());
                workingTimeDy.set("seq", (Object)(i + 1));
            }
        }
        if ((holidayList = workingPlan.getHolidayList()) != null && holidayList.size() > 0) {
            Set holidayIds = holidayList.stream().map(WorkingPlanHoliday::getHoliday).filter(Objects::nonNull).collect(Collectors.toSet());
            Set entryIdIds = holidayList.stream().map(WorkingPlanHoliday::getEntryId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map holidayMap = BusinessDataServiceHelper.loadFromCache((Object[])holidayIds.toArray(), (String)"public_holiday");
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity2");
            Map<Long, DynamicObject> collect = coll.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            coll.removeIf(next -> !entryIdIds.contains(next.getLong("id")));
            for (int i = 0; i < holidayList.size(); ++i) {
                WorkingPlanHoliday workingPlanHoliday = (WorkingPlanHoliday)holidayList.get(i);
                DynamicObject holidayDy = collect.get(workingPlanHoliday.getEntryId());
                if (holidayDy == null) {
                    holidayDy = coll.addNew();
                }
                holidayDy.set("id", (Object)workingPlanHoliday.getEntryId());
                Long holidayId = workingPlanHoliday.getHoliday();
                holidayDy.set("holiday1", holidayMap.get(holidayId));
                holidayDy.set("seq", (Object)(i + 1));
            }
        }
        if ((specificDateList = workingPlan.getSpecificDateList()) != null && specificDateList.size() > 0) {
            Set hoursIds = specificDateList.stream().map(SpecificDate::getHours).filter(Objects::nonNull).collect(Collectors.toSet());
            Set entryIdIds = specificDateList.stream().map(SpecificDate::getEntryId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map hoursMap = BusinessDataServiceHelper.loadFromCache((Object[])hoursIds.toArray(), (String)"public_holiday");
            DynamicObjectCollection coll = dynamicObject.getDynamicObjectCollection("entryentity1");
            Map<Long, DynamicObject> collect = coll.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
            coll.removeIf(next -> !entryIdIds.contains(next.getLong("id")));
            for (int i = 0; i < specificDateList.size(); ++i) {
                SpecificDate specificDate = (SpecificDate)specificDateList.get(i);
                DynamicObject specificDateDy = collect.get(specificDate.getEntryId());
                if (specificDateDy == null) {
                    specificDateDy = coll.addNew();
                }
                specificDateDy.set("id", (Object)specificDate.getEntryId());
                specificDateDy.set("date1", (Object)specificDate.getDate());
                specificDateDy.set("enddate1", (Object)specificDate.getEndDate());
                specificDateDy.set("datetype1", (Object)specificDate.getDateType());
                Long hoursId = specificDate.getHours();
                specificDateDy.set("hours1", hoursMap.get(hoursId));
                specificDateDy.set("specialdesc", (Object)specificDate.getSpecialDesc());
                specificDateDy.set("seq", (Object)(i + 1));
            }
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("workingPlanType", "update");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            operateOption.setVariableValue("workingPlanStr", objectMapper.writeValueAsString((Object)workingPlan));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return OperationServiceHelper.executeOperate((String)"save", (String)"working_plan", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)operateOption);
    }

    private void setOrgColl(List<Long> orgIdList, DynamicObject dy) {
        MulBasedataDynamicObjectCollection orgColl = (MulBasedataDynamicObjectCollection)dy.get("orgid");
        orgColl.clear();
        DynamicObjectType type = orgColl.getDynamicObjectType();
        for (Long orgId : orgIdList) {
            DynamicObject orgDy = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            DynamicObject item = new DynamicObject(type);
            item.set("fbasedataid", (Object)orgDy);
            orgColl.add(item);
        }
        dy.set("orgid", (Object)orgColl);
    }

    public OperationResult delete(Long id) {
        return OperationServiceHelper.executeOperate((String)"delete", (String)"working_plan", (Object[])new Object[]{id}, null);
    }

    public WorkingPlan getById(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"working_plan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dy == null) {
            return null;
        }
        WorkingPlan workingPlan = new WorkingPlan();
        workingPlan.setId(Long.valueOf(dy.getLong("id")));
        workingPlan.setNumber(dy.getString("number"));
        workingPlan.setName(dy.getString("name"));
        MulBasedataDynamicObjectCollection coll = (MulBasedataDynamicObjectCollection)dy.getDynamicObjectCollection("orgid");
        List applyOrgIdList = coll.stream().map(i -> (Long)i.get("fbasedataid_id")).collect(Collectors.toList());
        workingPlan.setOrgIdList(applyOrgIdList);
        workingPlan.setDescription(dy.getString("description"));
        workingPlan.setStartDate(dy.getDate("startdate"));
        workingPlan.setEndDate(dy.getDate("enddate"));
        workingPlan.setCountryId(dy.getDynamicObject("countryid") == null ? null : (Long)dy.getDynamicObject("countryid").getPkValue());
        ArrayList<Iterator> workingTimeList = new ArrayList<Iterator>();
        DynamicObjectCollection workingTimeColl = dy.getDynamicObjectCollection("cardentryentity");
        for (DynamicObject workingTimeDy : workingTimeColl) {
            workingTimeDy.getDynamicObject("workingtime").getLong("id");
            Iterator time = new WorkingTime(Long.valueOf(workingTimeDy.getDynamicObject("workingtime").getLong("id")), workingTimeDy.getDate("validity_startdate"), workingTimeDy.getDate("validity_enddate"));
            time.setEntryId(workingTimeDy.getLong("id"));
            workingTimeList.add(time);
        }
        workingPlan.setWorkingTimeList(workingTimeList);
        DynamicObjectCollection holidayColl = dy.getDynamicObjectCollection("entryentity2");
        ArrayList<WorkingPlanHoliday> workingPlanHolidayList = new ArrayList<WorkingPlanHoliday>();
        for (DynamicObject holidayDy : holidayColl) {
            WorkingPlanHoliday workingPlanHoliday = new WorkingPlanHoliday();
            workingPlanHoliday.setEntryId(Long.valueOf(holidayDy.getLong("id")));
            workingPlanHoliday.setHoliday(holidayDy.getDynamicObject("holiday1") == null ? null : (Long)holidayDy.getDynamicObject("holiday1").getPkValue());
            workingPlanHolidayList.add(workingPlanHoliday);
        }
        workingPlan.setHolidayList(workingPlanHolidayList);
        DynamicObjectCollection specificDateColl = dy.getDynamicObjectCollection("entryentity1");
        ArrayList<SpecificDate> specificDateList = new ArrayList<SpecificDate>();
        for (DynamicObject specificDateDy : specificDateColl) {
            SpecificDate specificDate = new SpecificDate();
            specificDate.setEntryId(Long.valueOf(specificDateDy.getLong("id")));
            specificDate.setDate(specificDateDy.getDate("date1"));
            specificDate.setEndDate(specificDateDy.getDate("enddate1"));
            specificDate.setDateType(specificDateDy.getString("datetype1"));
            specificDate.setHours(specificDateDy.getDynamicObject("hours1") == null ? null : (Long)specificDateDy.getDynamicObject("hours1").getPkValue());
            specificDate.setSpecialDesc(specificDateDy.getString("specialdesc"));
            specificDateList.add(specificDate);
        }
        workingPlan.setSpecificDateList(specificDateList);
        workingPlan.setEnable(dy.getString("enable"));
        workingPlan.setStatus(dy.getString("status"));
        workingPlan.setCreator(dy.getDynamicObject("creator") == null ? null : (Long)dy.getDynamicObject("creator").getPkValue());
        workingPlan.setCreateTime(dy.getDate("createtime"));
        workingPlan.setModifier(dy.getDynamicObject("modifier") == null ? null : (Long)dy.getDynamicObject("modifier").getPkValue());
        workingPlan.setModifyTime(dy.getDate("modifytime"));
        workingPlan.setDisabler(dy.getDynamicObject("disabler") == null ? null : (Long)dy.getDynamicObject("modifier").getPkValue());
        workingPlan.setDisableTime(dy.getDate("disabletime"));
        return workingPlan;
    }
}

