/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.math.BigDecimal;
import java.util.Locale;
import kd.bos.util.StringUtils;

public class EnCashTransfer {
    private static final String[] numberStr = new String[]{"zero'", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "", "", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] degratStr = new String[]{"thousand", "million", "billion", "trillion"};
    private static final String SAY = "SAY";
    private static final String BLANK = " ";
    private static final String ONLY = "only";
    private static final String AND = "and";
    private static final String CENT = "cent";
    private static final String CENTS = "cents";
    private static final String HUNDRED = "hundred";
    private static final String GBP = "GBP";
    private static final String USD = "USD";
    private static final String CNY = "CNY";
    private static final String HKD = "HKD";
    private static final String EUR = "EUR";
    private static final String PENNY = "PENNY";
    private static final String PENCE = "PENCE";
    private static final String MINUS = "minus";

    public static String transfer(String currencyNumber, String amount, String isTransCurrNum) {
        int mod;
        if ("false".equals(isTransCurrNum)) {
            currencyNumber = "";
        }
        String intValue = "";
        if (new BigDecimal(amount).compareTo(BigDecimal.ZERO) == 0) {
            intValue = "ZERO";
        }
        String[] numArray = amount.split("\\.");
        String intStr = numArray[0];
        String decStr = numArray[1];
        boolean isMinus = false;
        if (intStr.contains("-")) {
            intStr = intStr.substring(1);
            isMinus = true;
        }
        if ((mod = Math.floorMod(intStr.length(), 3)) == 1) {
            intStr = "00" + intStr;
        } else if (mod == 2) {
            intStr = "0" + intStr;
        }
        int intStrLength = intStr.length();
        int i = 0;
        while (i < intStrLength) {
            String hundredsValue = intStr.substring(intStrLength - (i += 3), intStrLength - i + 1);
            String tensValue = intStr.substring(intStrLength - i + 1, intStrLength - i + 2);
            String onesValue = intStr.substring(intStrLength - i + 2, intStrLength - i + 3);
            String tmpStr = EnCashTransfer.numberConvert(hundredsValue, tensValue, onesValue);
            if (i == 3) {
                intValue = String.join((CharSequence)BLANK, tmpStr, intValue).trim();
                continue;
            }
            if (!StringUtils.isNotEmpty((String)tmpStr)) continue;
            intValue = String.join((CharSequence)BLANK, tmpStr, degratStr[i / 3 - 2], intValue).trim();
        }
        String decValue = EnCashTransfer.decConvert(decStr);
        Long moneyInt = Long.parseLong(intStr);
        int moneyDec = Integer.parseInt(decStr);
        String value = "";
        value = moneyDec == 0 ? intValue : (moneyInt == 0L ? (moneyDec == 1 ? String.join((CharSequence)BLANK, decValue, CENT) : String.join((CharSequence)BLANK, decValue, CENTS)) : String.join((CharSequence)BLANK, intValue, AND, decValue, CENTS));
        if (GBP.equalsIgnoreCase(currencyNumber)) {
            value = value.replaceAll(CENTS, PENCE);
            value = value.replaceAll(CENT, PENNY);
        }
        if (isMinus && (moneyInt != 0L || moneyDec != 0)) {
            value = "minus " + value;
        }
        String currencyInfo = currencyNumber;
        if (CNY.equalsIgnoreCase(currencyNumber)) {
            currencyInfo = "CHINESE YUAN";
        } else if (HKD.equalsIgnoreCase(currencyNumber)) {
            currencyInfo = "HONG KONG DOLLARS";
        } else if (USD.equalsIgnoreCase(currencyNumber)) {
            currencyInfo = "US DOLLARS";
        } else if (EUR.equalsIgnoreCase(currencyNumber)) {
            currencyInfo = "EUROPEAN DOLLARS";
        }
        if ("false".equals(isTransCurrNum)) {
            return (value + BLANK + ONLY).toUpperCase(Locale.ENGLISH);
        }
        return String.join((CharSequence)BLANK, SAY, currencyInfo, value, ONLY).toUpperCase(Locale.ENGLISH);
    }

    private static String decConvert(String decStr) {
        decStr = "0" + decStr;
        String hundredsValue = decStr.substring(0, 1);
        String tensValue = decStr.substring(1, 2);
        String onesValue = decStr.substring(2, 3);
        return EnCashTransfer.numberConvert(hundredsValue, tensValue, onesValue);
    }

    private static String numberConvert(String hundredsValue, String tensValue, String onesValue) {
        String tmpStr = "";
        if (!"0".equals(hundredsValue)) {
            tmpStr = String.join((CharSequence)BLANK, tmpStr, numberStr[Integer.parseInt(hundredsValue)], HUNDRED).trim();
            if (!"0".equals(tensValue) || !"0".equals(onesValue)) {
                tmpStr = String.join((CharSequence)BLANK, tmpStr, AND);
            }
        }
        if ("1".equals(tensValue)) {
            tmpStr = (tmpStr + ' ' + numberStr[Integer.parseInt(onesValue) + 10]).trim();
        } else if (!"0".equals(tensValue)) {
            tmpStr = "0".equals(onesValue) ? (tmpStr + ' ' + numberStr[Integer.parseInt(tensValue) + 20]).trim() : tmpStr + ' ' + numberStr[Integer.parseInt(tensValue) + 20] + ' ' + numberStr[Integer.parseInt(onesValue)];
        } else if (!"0".equals(onesValue)) {
            tmpStr = (tmpStr + ' ' + numberStr[Integer.parseInt(onesValue)]).trim();
        }
        return tmpStr.trim();
    }
}

