/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IDCardCommonUtil {
    private static final String BOS_MSERVICE_I18N = "bos-mservice-i18n";
    private static final String VERIFY_18_PATTERN_STR = "(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})";
    private static final Pattern VERIFY_18_PATTERN = Pattern.compile("(\\d{6})(\\d{8})(\\d{3})([\\d[xX]]{1})");
    private static final String VERIFY_15_PATTERN_STR = "(\\d{6})(\\d{6})(\\d{3})";
    private static final Pattern VERIFY_15_PATTERN = Pattern.compile("(\\d{6})(\\d{6})(\\d{3})");
    private static final int[] VERIFY_18_RIGHTS = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final String[] VERIFY_18_CHECK_DIGIT = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private int[] a = new int[18];
    private String areaNum;
    private String birthdayNum;
    private String seqNum;
    private String check_digit;
    private int length;
    private static Log logger = LogFactory.getLog(IDCardCommonUtil.class);
    private String errorMsg;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public final void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    private String getMsg_IDCARD_NOTNULL() {
        return ResManager.loadKDString((String)"\u201c\u8eab\u4efd\u8bc1\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"IDCardCommonUtil_0", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]);
    }

    private String getMsg_IDCARD_NUMERROR() {
        return ResManager.loadKDString((String)"\u201c\u8eab\u4efd\u8bc1\u53f7\u201d\u4f4d\u6570\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u4e3a15\u4f4d\u6216\u800518\u4f4d\u3002", (String)"IDCardCommonUtil_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]);
    }

    private String getMsg_IDCARD_INVALID() {
        return ResManager.loadKDString((String)"\u201c\u8eab\u4efd\u8bc1\u53f7\u201d\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"IDCardCommonUtil_2", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]);
    }

    public boolean isMan() {
        int num = Integer.parseInt(this.seqNum);
        return num % 2 != 0;
    }

    public String getBirthday() {
        String FullBirthdayNum = null;
        FullBirthdayNum = this.length == 15 ? "19" + this.birthdayNum : this.birthdayNum;
        String year = FullBirthdayNum.substring(0, 4);
        String month = FullBirthdayNum.substring(4, 6);
        String date = FullBirthdayNum.substring(6, 8);
        return year + "-" + month + "-" + date;
    }

    public IDCardCommonUtil(String IDCardNO) {
        if (StringUtils.isBlank((CharSequence)IDCardNO)) {
            this.setErrorMsg(this.getMsg_IDCARD_NOTNULL());
            return;
        }
        this.length = IDCardNO.length();
        switch (this.length) {
            case 15: {
                this.Verifier15(IDCardNO);
                break;
            }
            case 18: {
                this.Verifier18(IDCardNO);
                break;
            }
            default: {
                this.setErrorMsg(this.getMsg_IDCARD_NUMERROR());
            }
        }
    }

    public IDCardCommonUtil(String IDCardNO, boolean isVerify) {
        if (StringUtils.isBlank((CharSequence)IDCardNO)) {
            this.setErrorMsg(this.getMsg_IDCARD_NOTNULL());
            return;
        }
        this.length = IDCardNO.length();
        switch (this.length) {
            case 15: {
                if (!isVerify) break;
                this.Verifier15(IDCardNO);
                break;
            }
            case 18: {
                this.Verifier18(IDCardNO, isVerify);
                break;
            }
            default: {
                if (!isVerify) break;
                this.setErrorMsg(this.getMsg_IDCARD_NUMERROR());
            }
        }
    }

    private void Verifier15(String IDCardNO) {
        Integer day;
        Integer month;
        Matcher m = VERIFY_15_PATTERN.matcher(IDCardNO);
        if (!m.matches()) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        String strMonth = IDCardNO.substring(8, 10);
        String strDay = IDCardNO.substring(10, 12);
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) < 1) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) < 1) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        Integer year = Integer.parseInt("19" + IDCardNO.substring(6, 8));
        boolean checkYearMonthDay = this.checkYearMonthDay(year, month = Integer.valueOf(Integer.parseInt(strMonth)), day = Integer.valueOf(Integer.parseInt(strDay)));
        if (!checkYearMonthDay) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        this.areaNum = m.group(1);
        this.birthdayNum = m.group(2);
        this.seqNum = m.group(3);
    }

    private void Verifier18(String IDCardNO) {
        Integer day;
        Integer month;
        Matcher m = VERIFY_18_PATTERN.matcher(IDCardNO);
        if (!m.matches()) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        this.areaNum = m.group(1);
        this.birthdayNum = m.group(2);
        this.seqNum = m.group(3);
        this.check_digit = m.group(4);
        String expect_check_digit = IDCardCommonUtil.getCheck_digit18(IDCardNO);
        if (!expect_check_digit.equalsIgnoreCase(this.check_digit)) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
            return;
        }
        Integer year = Integer.parseInt(IDCardNO.substring(6, 10));
        boolean checkYearMonthDay = this.checkYearMonthDay(year, month = Integer.valueOf(Integer.parseInt(IDCardNO.substring(10, 12))), day = Integer.valueOf(Integer.parseInt(IDCardNO.substring(12, 14))));
        if (!checkYearMonthDay) {
            this.setErrorMsg(this.getMsg_IDCARD_INVALID());
        }
    }

    private boolean checkYearMonthDay(Integer year, Integer month, Integer day) {
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return day > 0 && day <= 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return day > 0 && day <= 30;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return day > 0 && day <= 29;
        }
        return day > 0 && day <= 28;
    }

    private void Verifier18(String IDCardNO, boolean isVerify) {
        if (isVerify) {
            Matcher m = VERIFY_18_PATTERN.matcher(IDCardNO);
            if (!m.matches()) {
                this.setErrorMsg(this.getMsg_IDCARD_INVALID());
                return;
            }
            this.areaNum = m.group(1);
            this.birthdayNum = m.group(2);
            this.seqNum = m.group(3);
            this.check_digit = m.group(4);
            String expect_check_digit = IDCardCommonUtil.getCheck_digit18(IDCardNO);
            if (!expect_check_digit.equalsIgnoreCase(this.check_digit)) {
                this.setErrorMsg(this.getMsg_IDCARD_INVALID());
                return;
            }
        }
    }

    public static String getCheck_digit18(String IDCardNO) {
        int sum = 0;
        for (int i = 0; i <= 16; ++i) {
            int num = Integer.parseInt(IDCardNO.substring(i, i + 1));
            int right = VERIFY_18_RIGHTS[i];
            sum += num * right;
        }
        int y = sum % 11;
        return VERIFY_18_CHECK_DIGIT[y];
    }

    public static String IDCardNO15To18(String IDCardNO15) {
        Matcher m = VERIFY_15_PATTERN.matcher(IDCardNO15);
        if (!m.matches()) {
            return "none";
        }
        String NO17 = IDCardNO15.substring(0, 6) + "19" + IDCardNO15.substring(6, 15);
        return NO17 + IDCardCommonUtil.getCheck_digit18(NO17);
    }

    public static String IDCardNO18To15(String IDCardNO18) {
        Matcher m = VERIFY_18_PATTERN.matcher(IDCardNO18);
        if (!m.matches()) {
            return "none";
        }
        return IDCardNO18.substring(0, 6) + IDCardNO18.substring(8, 17);
    }

    public String getAreaNum() {
        return this.areaNum;
    }

    public String getBirthdayNum() {
        return this.birthdayNum;
    }

    public String getCheck_digitNum18() {
        return this.check_digit;
    }

    public int getLength() {
        return this.length;
    }

    public String getSeqNum() {
        return this.seqNum;
    }

    public String getVerify(String eightcardid) {
        int remaining = 0;
        if (eightcardid.length() == 18) {
            eightcardid = eightcardid.substring(0, 17);
        }
        if (eightcardid.length() == 17) {
            int i;
            int sum = 0;
            for (i = 0; i < 17; ++i) {
                String k = eightcardid.substring(i, i + 1);
                this.a[i] = Integer.parseInt(k);
            }
            for (i = 0; i < 17; ++i) {
                sum += VERIFY_18_RIGHTS[i] * this.a[i];
            }
            remaining = sum % 11;
        }
        return remaining == 2 ? "X" : String.valueOf(VERIFY_18_CHECK_DIGIT[remaining]);
    }

    public String uptoeighteen(String fifteencardid) {
        String eightcardid = fifteencardid.substring(0, 6);
        eightcardid = eightcardid + "19";
        eightcardid = eightcardid + fifteencardid.substring(6, 15);
        eightcardid = eightcardid + this.getVerify(eightcardid);
        return eightcardid;
    }

    public boolean checkIdCard(String IDCardNO) {
        if (StringUtils.isBlank((CharSequence)IDCardNO)) {
            return false;
        }
        this.length = IDCardNO.length();
        switch (this.length) {
            case 15: {
                try {
                    this.Verifier15(IDCardNO);
                    break;
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                    return false;
                }
            }
            case 18: {
                try {
                    this.Verifier18(IDCardNO);
                    break;
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                    return false;
                }
            }
            default: {
                this.setErrorMsg(this.getMsg_IDCARD_NUMERROR());
                return false;
            }
        }
        return true;
    }
}

