/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

public class NumberTranslate {
    private static final String NULL_STRING = new String(new char[0]);
    private static final char[] numbers = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final char[] units = new char[]{' ', '\u62fe', '\u4f70', '\u4edf'};
    private static final char[] groups = new char[]{' ', '\u4e07', '\u4ebf', '\u5146'};

    private String trans(String source) {
        if (source == null || source.length() == 0) {
            return NULL_STRING;
        }
        StringBuilder result = new StringBuilder();
        char[] src = source.toCharArray();
        int len = src.length;
        int count = 0;
        char zero = numbers[0];
        if ("0".equals(source)) {
            return String.valueOf(zero);
        }
        for (int i = 0; i < len; ++i) {
            int val = Character.digit(src[i], 10);
            if (val == -1) continue;
            if (val == 0) {
                ++count;
                continue;
            }
            if (count > 0) {
                result.append(zero);
                count = 0;
            }
            result.append(numbers[val]);
            result.append(units[len - 1 - i]);
        }
        return result.toString().trim();
    }

    public String toNumber(String intValue) {
        int len = intValue.length();
        String[] ge = new String[]{intValue.substring(Math.max(0, len - 4), len), intValue.substring(Math.max(0, len - 8), Math.max(0, len - 4)), intValue.substring(Math.max(0, len - 12), Math.max(0, len - 8)), intValue.substring(0, Math.max(0, len - 12))};
        StringBuilder sb = new StringBuilder((int)((double)len * 1.5));
        sb.append(this.groupToNumber(ge, 3));
        sb.append(this.groupToNumber(ge, 2));
        sb.append(this.groupToNumber(ge, 1));
        sb.append(this.groupToNumber(ge, 0));
        return sb.toString();
    }

    private String groupToNumber(String[] ge, int groupIndex) {
        String str;
        StringBuilder sb = new StringBuilder();
        if (ge[groupIndex] != null && ge[groupIndex].length() > 0 && (str = this.trans(ge[groupIndex])) != null && str.length() > 0) {
            sb.append(str);
            if (groupIndex != 0) {
                sb.append(groups[groupIndex]);
            }
        }
        return sb.toString();
    }
}

