/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.i18n.api.enums.Week;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PublicHolidayUtils {
    private static final String PUBLIC_HOLIDAY = "public_holiday";
    private static final String PUBLIC_HOLIDAY_FIXEDDATE = "public_holiday_fixeddate";
    private static final String PUBLIC_HOLIDAY_APPOINTDAY = "public_holiday_appointday";
    private static final String PUBLIC_HOLIDAY_FIXEDWEEK = "public_holiday_fixedweek";
    private static final String TYPE = "type";
    private static final String COUNTRYID = "countryid";
    public static final String ALL = "ALL";

    public static Map<String, Object> getPublicHoliday(Collection<Object> countryIds, Date startDate, Date endDate) {
        boolean a;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)PUBLIC_HOLIDAY, (QFilter[])qFilter.toArray());
        Map collect = dynamicObjectMap.values().stream().collect(Collectors.groupingBy(v -> v.getString(TYPE), Collectors.mapping(DataEntityBase::getPkValue, Collectors.toSet())));
        Set fixedDateIds = collect.get("1");
        Set appointDayIds = collect.get("2");
        Set fixedWeekIds = collect.get("3");
        Map fixedDateMap = null;
        Map appointDayMap = null;
        Map fixedWeekMap = null;
        Map<Object, List<DynamicObject>> fixedDateListMap = null;
        Map<Object, List<DynamicObject>> appointDayListMap = null;
        Map<Object, List<DynamicObject>> fixedWeekListMap = null;
        HashSet<Object> countryAllIds = new HashSet<Object>(16);
        if (fixedDateIds != null) {
            fixedDateMap = BusinessDataServiceHelper.loadFromCache((Object[])fixedDateIds.toArray(), (String)PUBLIC_HOLIDAY_FIXEDDATE);
            fixedDateListMap = fixedDateMap.values().stream().collect(Collectors.groupingBy(v -> v.getDynamicObject(COUNTRYID) == null ? ALL : v.getDynamicObject(COUNTRYID).getPkValue()));
            countryAllIds.addAll(fixedDateListMap.keySet());
        }
        if (appointDayIds != null) {
            appointDayMap = BusinessDataServiceHelper.loadFromCache((Object[])appointDayIds.toArray(), (String)PUBLIC_HOLIDAY_APPOINTDAY);
            appointDayListMap = appointDayMap.values().stream().collect(Collectors.groupingBy(v -> v.getDynamicObject(COUNTRYID) == null ? ALL : v.getDynamicObject(COUNTRYID).getPkValue()));
            countryAllIds.addAll(appointDayListMap.keySet());
        }
        if (fixedWeekIds != null) {
            fixedWeekMap = BusinessDataServiceHelper.loadFromCache((Object[])fixedWeekIds.toArray(), (String)PUBLIC_HOLIDAY_FIXEDWEEK);
            fixedWeekListMap = fixedWeekMap.values().stream().collect(Collectors.groupingBy(v -> v.getDynamicObject(COUNTRYID) == null ? ALL : v.getDynamicObject(COUNTRYID).getPkValue()));
            countryAllIds.addAll(fixedWeekListMap.keySet());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean bl = a = countryIds == null;
        if (!a) {
            countryIds.remove(null);
            countryIds = countryIds.stream().map(Object::toString).collect(Collectors.toSet());
        }
        for (Object e : countryAllIds) {
            if (!a && !countryIds.contains(e.toString())) continue;
            Calendar startCalendar = PublicHolidayUtils.dateToCalendar(startDate);
            Calendar endCalendar = PublicHolidayUtils.dateToCalendar(endDate);
            LinkedHashMap<String, Map<String, Object>> dataMap = new LinkedHashMap<String, Map<String, Object>>(16);
            while (!startCalendar.after(endCalendar)) {
                List<DynamicObject> fixedDateList = fixedDateListMap == null ? null : fixedDateListMap.get(e);
                List<DynamicObject> appointDayList = appointDayListMap == null ? null : appointDayListMap.get(e);
                List<DynamicObject> fixedWeekList = fixedWeekListMap == null ? null : fixedWeekListMap.get(e);
                DynamicObject holiday = PublicHolidayUtils.getHoliday(fixedDateList, appointDayList, fixedWeekList, startCalendar);
                if (!a && holiday == null) {
                    fixedDateList = fixedDateListMap == null ? null : fixedDateListMap.get(ALL);
                    appointDayList = appointDayListMap == null ? null : appointDayListMap.get(ALL);
                    fixedWeekList = fixedWeekListMap == null ? null : fixedWeekListMap.get(ALL);
                    holiday = PublicHolidayUtils.getHoliday(fixedDateList, appointDayList, fixedWeekList, startCalendar);
                }
                if (holiday != null) {
                    Map<String, Object> additionalInfo = PublicHolidayUtils.getHolidayAdditionalInfo(holiday);
                    Map oldInfo = (Map)result.get(dateFormat.format(startCalendar.getTime()));
                    if (oldInfo != null) {
                        additionalInfo.forEach(oldInfo::putIfAbsent);
                        dataMap.put(dateFormat.format(startCalendar.getTime()), oldInfo);
                    } else {
                        dataMap.put(dateFormat.format(startCalendar.getTime()), additionalInfo);
                    }
                }
                startCalendar.add(5, 1);
            }
            if (dataMap.isEmpty()) continue;
            result.put(e.toString(), dataMap);
        }
        return result;
    }

    private static Map<String, Object> getHolidayAdditionalInfo(DynamicObject holiday) {
        DynamicObject holidayclass;
        DynamicObject timeperiod;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        boolean holidayType = holiday.getBoolean("holidaytype");
        result.put("halfDayInWorkDay", holidayType);
        if (holidayType && (timeperiod = holiday.getDynamicObject("timeperiod")) != null) {
            timeperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)timeperiod.getPkValue(), (String)"working_hours");
            ArrayList workRangeNewList = new ArrayList(10);
            DynamicObjectCollection workingHoursEntry = timeperiod.getDynamicObjectCollection("entryentity");
            for (DynamicObject hoursEntry : workingHoursEntry) {
                Integer startTime = hoursEntry.getInt("starttime");
                Integer endTime = hoursEntry.getInt("endtime");
                HashMap<String, Object> workRange = new HashMap<String, Object>(16);
                workRange.put("workingHoursId", timeperiod.getString("id"));
                workRange.put("startTime", startTime);
                workRange.put("endTime", endTime);
                workRangeNewList.add(workRange);
            }
            result.put("workRangeList", workRangeNewList);
        }
        if ((holidayclass = holiday.getDynamicObject("holidayclass")) != null) {
            holidayclass = BusinessDataServiceHelper.loadSingleFromCache((Object)holidayclass.getPkValue(), (String)"int_holidayclass");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", holidayclass.get("id"));
            map.put("name", holidayclass.get("name"));
            map.put("number", holidayclass.getString("number"));
            result.put("holidayClass", map);
        }
        result.put("holidayName", holiday.get("name"));
        result.put("holidayNumber", holiday.get("number"));
        result.put("isSystem", holiday.getBoolean("issystem"));
        return result;
    }

    private static DynamicObject getHoliday(Collection<DynamicObject> fixedDateCollection, Collection<DynamicObject> appointDayCollection, Collection<DynamicObject> fixedWeekCollection, Calendar calendar) {
        if (appointDayCollection != null && !appointDayCollection.isEmpty()) {
            for (DynamicObject appointday : appointDayCollection) {
                if (!PublicHolidayUtils.isAppointDateHoliday(appointday, calendar)) continue;
                return appointday;
            }
        }
        if (fixedDateCollection != null && !fixedDateCollection.isEmpty()) {
            for (DynamicObject fixedDateHoliday : fixedDateCollection) {
                if (!PublicHolidayUtils.isFixedDateHoliday(fixedDateHoliday, calendar)) continue;
                return fixedDateHoliday;
            }
        }
        if (fixedWeekCollection != null && !fixedWeekCollection.isEmpty()) {
            for (DynamicObject fixWeekHoliday : fixedWeekCollection) {
                if (!PublicHolidayUtils.isFixWeekHoliday(fixWeekHoliday, calendar)) continue;
                return fixWeekHoliday;
            }
        }
        return null;
    }

    private static boolean isFixWeekHoliday(DynamicObject fixWeekHoliday, Calendar calendar) {
        int holidayMonth = Integer.parseInt(fixWeekHoliday.getString("month"));
        String week = fixWeekHoliday.getString("weekofmonth");
        String dayOfWeekStr = fixWeekHoliday.getString("dayofweek");
        int dayOfWeek = Week.getCodeByName((String)dayOfWeekStr);
        if (holidayMonth == calendar.get(2) + 1) {
            dayOfWeek = dayOfWeek == 7 ? 1 : dayOfWeek + 1;
            Calendar dayByWeek = PublicHolidayUtils.getDayByIndex(calendar, dayOfWeek, week);
            return PublicHolidayUtils.isInSameDay(calendar, dayByWeek);
        }
        return false;
    }

    private static boolean isAppointDateHoliday(DynamicObject appointday, Calendar calendar) {
        DynamicObjectCollection collection = appointday.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : collection) {
            Date startdate = object.getDate("startdate");
            Date enddate = object.getDate("enddate");
            if (calendar.before(PublicHolidayUtils.dateToCalendar(startdate)) || calendar.after(PublicHolidayUtils.dateToCalendar(enddate))) continue;
            return true;
        }
        return false;
    }

    private static boolean isFixedDateHoliday(DynamicObject fixedDateHoliday, Calendar calendar) {
        int holidayMonth = Integer.parseInt(fixedDateHoliday.getString("month"));
        String dayofmonth = fixedDateHoliday.getString("dayofmonth");
        if (StringUtils.isNotBlank((CharSequence)dayofmonth)) {
            String[] split;
            for (String s : split = dayofmonth.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                int holidayDayOfMonth = Integer.parseInt(s);
                if (PublicHolidayUtils.isOnFixDayHoliday(calendar, holidayMonth, holidayDayOfMonth)) {
                    return true;
                }
                if (!PublicHolidayUtils.isInPostponeHoliday(calendar, fixedDateHoliday, holidayMonth, holidayDayOfMonth)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInPostponeHoliday(Calendar calendar, DynamicObject holiday, int holidayMonth, int holidayDayOfMonth) {
        String[] extendRulesStrArr;
        String extendRulesStr = holiday.getString("extendrules");
        if (StringUtils.isBlank((CharSequence)extendRulesStr)) {
            return false;
        }
        HashMap<Integer, Integer> extendRulesMap = new HashMap<Integer, Integer>(16);
        for (String rule : extendRulesStrArr = extendRulesStr.split(",")) {
            int weekIndex = Integer.parseInt(rule.substring(0, 1));
            int postPoneRule = Integer.parseInt(rule.substring(1, 3));
            extendRulesMap.put(weekIndex, postPoneRule);
        }
        int year = calendar.get(1);
        if (extendRulesMap.size() > 0) {
            for (int i = -1; i < 2; ++i) {
                GregorianCalendar postponeCal = new GregorianCalendar();
                postponeCal.set(year + i, holidayMonth - 1, holidayDayOfMonth);
                int weekIndex = postponeCal.get(7) == 1 ? 7 : postponeCal.get(7) - 1;
                Integer postponeRule = (Integer)extendRulesMap.get(weekIndex);
                if (postponeRule == null) continue;
                postponeCal.add(6, postponeRule);
                if (!PublicHolidayUtils.isInSameDay(calendar, postponeCal)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOnFixDayHoliday(Calendar calendar, int holidayMonth, int holidayDayOfMonth) {
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        return month == holidayMonth && dayOfMonth == holidayDayOfMonth;
    }

    private static boolean isInSameDay(Calendar calendar1, Calendar calendar2) {
        int year1 = calendar1.get(1);
        int month1 = calendar1.get(2);
        int day1 = calendar1.get(5);
        int year2 = calendar2.get(1);
        int month2 = calendar2.get(2);
        int day2 = calendar2.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    private static Calendar dateToCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private static Calendar getDayByIndex(Calendar old, int dayOfWeek, String index) {
        Calendar instance = Calendar.getInstance();
        instance.set(1, old.get(1));
        instance.set(2, old.get(2));
        instance.set(5, 1);
        if ("last".equals(index)) {
            instance.add(2, 1);
            instance.add(5, -1);
            int lastDayOfWeek = instance.get(7);
            instance.add(5, dayOfWeek - lastDayOfWeek > 0 ? -lastDayOfWeek - (7 - dayOfWeek) : dayOfWeek - lastDayOfWeek);
        } else {
            int firstDayWeek = instance.get(7);
            int addDay = 0;
            addDay = dayOfWeek - firstDayWeek >= 0 ? dayOfWeek - firstDayWeek + (Integer.parseInt(index) - 1) * 7 : dayOfWeek - firstDayWeek + Integer.parseInt(index) * 7;
            instance.add(5, addDay);
        }
        return instance;
    }
}

